/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.tab;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.swing.RollPane;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.filter.FilterForm;
import biz.netup.utmutils.control.permissions.Permission;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class TabPanelWithTable
extends TabPanel {
    public static final int NORMAL_MODE = 1;
    public static final int REFRESH_MODE = 2;
    public static final int NO_DELETE_MODE = 3;
    public static final int NO_EDIT_MODE = 4;
    public static final int NO_EDIT_MODE_2 = 5;
    public static final int EDIT_MODE = 6;
    protected TablePanelImpl mainTablePanel;
    protected JButton refreshButton;
    protected JButton addButton;
    protected JButton editButton;
    protected JButton deleteButton;
    protected JPanel mainPanel;
    protected JButton readButton;
    private JPanel additionalButtonsPanel;
    private JPanel delPanel;
    private JPanel addPanel;
    private JPanel editPanel;
    Vector<Map<String, Object>> dataTable = new Vector();
    private boolean useThread = true;
    protected JPanel readPanel;
    private JPanel additionalButtonPanel2;
    private JPanel filterPanel;
    private JPanel buttonsPanel;
    private JPanel refPanel;
    private JPanel bottomPanel;
    private JPanel southPanel;
    private JPanel eastPanel;
    private boolean noContextMenu = false;
    Map<String, String> columnNames;
    private int[] addPermission;
    private int[] editPermission;
    private int[] deletePermission;
    private int[] readPermission;
    private int mode;
    private boolean selectMode = false;
    private JButton btn;
    private FilterForm ff;

    public TabPanelWithTable() {
        this.$$$setupUI$$$();
    }

    public void setUseThread(boolean bl) {
        this.useThread = bl;
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    public JPanel getEastPanel() {
        return this.eastPanel;
    }

    protected boolean useFilter() {
        return false;
    }

    protected FilterForm getFilterForm() {
        return this.ff;
    }

    protected JPanel getFilterPanel() {
        return this.filterPanel;
    }

    protected FilterForm setNewFilterForm() {
        return new FilterForm(this.mainTablePanel, this.dataTable);
    }

    public JPanel getReadPanel() {
        return this.readPanel;
    }

    public void setNoContextMenu(boolean bl) {
        this.noContextMenu = bl;
    }

    public JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    @Override
    public abstract String getTabName();

    public abstract int getMode();

    public abstract Map<String, String> getColumnNames();

    public abstract Vector<Map<String, Object>> setTableData() throws UrfaException;

    public abstract void removeItem(Map<String, Object> var1) throws UrfaException;

    @Override
    public JComponent getPanel() {
        if (this.refreshPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.refreshPermission) || !Utils.isAdmin()) {
            if (!this.init) {
                this.log.log(10, "Initializing " + this.getTabName());
                this.init();
                this.log.log(10, "Initializing " + this.getTabName() + " complete");
            }
            return this.mainPanel;
        }
        return new JLabel("");
    }

    @Override
    protected void init() {
        this.applyPermissions();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelWithTable.this.add();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelWithTable.this.edit();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelWithTable.this.delete();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelWithTable.this.refresh();
            }
        });
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelWithTable.this.read();
            }
        });
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                this.addPanel.setVisible(false);
                this.delPanel.setVisible(false);
                this.editPanel.setVisible(false);
                break;
            }
            case 4: {
                this.delPanel.setVisible(false);
                this.editPanel.setVisible(false);
                break;
            }
            case 5: {
                this.editPanel.setVisible(false);
                break;
            }
            case 3: {
                this.delPanel.setVisible(false);
                break;
            }
            case 6: {
                this.addPanel.setVisible(false);
                this.delPanel.setVisible(false);
            }
        }
        if (Utils.isAdmin()) {
            if (this.addPermission != null && !UrfaManagerImpl.getInstance().isPermitted(this.addPermission)) {
                this.addButton.setEnabled(false);
            }
            if ((this.editPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.editPermission)) && (this.readPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.readPermission))) {
                this.mainTablePanel.registerOneRowButton(this.editButton);
                this.mainTablePanel.registerOneRowButton(this.readButton);
                this.readPanel.setVisible(false);
            } else if (this.readPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.readPermission)) {
                this.mainTablePanel.registerOneRowButton(this.readButton);
                this.editPanel.setVisible(false);
            } else {
                this.readPanel.setVisible(false);
                this.editButton.setEnabled(false);
            }
            if (this.deletePermission == null || UrfaManagerImpl.getInstance().isPermitted(this.deletePermission)) {
                this.mainTablePanel.registerMultiRowButton(this.deleteButton);
                this.mainTablePanel.getTable().addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (127 == keyEvent.getKeyCode() && TabPanelWithTable.this.mainTablePanel.getSelectedTableRows().length > 0) {
                            TabPanelWithTable.this.delete();
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                    }
                });
            } else {
                this.deleteButton.setEnabled(false);
            }
        } else {
            this.mainTablePanel.registerOneRowButton(this.editButton);
            this.mainTablePanel.registerMultiRowButton(this.deleteButton);
            this.readPanel.setVisible(false);
        }
        this.refresh();
        this.init = true;
        if (this.useFilter()) {
            this.ff = this.setNewFilterForm();
            RollPane rollPane = new RollPane(this.resource.getString("Filter"), this.ff.$$$getRootComponent$$$(), true);
            this.filterPanel.add(rollPane);
            this.ff.getClearButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabPanelWithTable.this.mainTablePanel.getTableModel().removeAllRows();
                    for (Map<String, Object> map : TabPanelWithTable.this.dataTable) {
                        TabPanelWithTable.this.mainTablePanel.getTableModel().addRow(map);
                    }
                }
            });
        }
    }

    @Override
    protected Component getMainPanel() {
        return null;
    }

    @Override
    public void refresh() {
        if (this.useThread) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TabPanelWithTable.this.log.log(10, "Refresh " + TabPanelWithTable.this.getTabName());
                    UTMTrayIcon.getInstance().addProcess(this, TabPanelWithTable.this.resource.getString(TabPanelWithTable.this.getTabName()), TabPanelWithTable.this.refreshButton);
                    TabPanelWithTable.this.refreshAction();
                    UTMTrayIcon.getInstance().removeProcess(this);
                    TabPanelWithTable.this.log.log(10, "Refresh " + TabPanelWithTable.this.getTabName() + " complete");
                }
            };
            thread.start();
        } else {
            this.log.log(10, "Refresh " + this.getTabName());
            this.refreshAction();
            this.log.log(10, "Refresh " + this.getTabName() + " complete");
        }
    }

    private void refreshAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = TabPanelWithTable.this.mainTablePanel.getTableModel().getSortOrder();
                int n2 = TabPanelWithTable.this.mainTablePanel.getTableModel().getSortedColumn();
                HashSet<Integer> hashSet = new HashSet<Integer>();
                if (TabPanelWithTable.this.getColumnNames().containsKey("id") && TabPanelWithTable.this.mainTablePanel.getSelectedTableRows().length != 0) {
                    for (Map<String, Object> map : TabPanelWithTable.this.mainTablePanel.getSelectedTableRows()) {
                        hashSet.add((Integer)map.get("id"));
                    }
                }
                TabPanelWithTable.this.mainTablePanel.getTableModel().removeAllRows();
                TabPanelWithTable.this.dataTable.clear();
                try {
                    for (Map map : TabPanelWithTable.this.setTableData()) {
                        TabPanelWithTable.this.mainTablePanel.getTableModel().addRow(map);
                        if (!TabPanelWithTable.this.useFilter()) continue;
                        TabPanelWithTable.this.dataTable.add(map);
                    }
                }
                catch (UrfaException urfaException) {
                    TabPanelWithTable.this.log.error(TabPanelWithTable.this.resource.getString(TabPanelWithTable.this.getTabName()) + ": " + TabPanelWithTable.this.resource.getString("Cannot get data list"), urfaException);
                }
                if (TabPanelWithTable.this.useFilter() && TabPanelWithTable.this.ff != null) {
                    TabPanelWithTable.this.ff.filter();
                }
                if (n2 != -1) {
                    TabPanelWithTable.this.mainTablePanel.getTableModel().setColumnSortOrder(n2, n);
                }
                if (hashSet.size() != 0) {
                    for (int i = 0; i < TabPanelWithTable.this.mainTablePanel.getTableModel().getRowCount(); ++i) {
                        if (!hashSet.contains((Integer)TabPanelWithTable.this.mainTablePanel.getTableModel().getRow(i).get("id"))) continue;
                        TabPanelWithTable.this.mainTablePanel.getTable().addRowSelectionInterval(i, i);
                    }
                }
            }
        });
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    protected void delete() {
        if (Dialogs.showYesNoDialog(this.resource.getString("delete_warn") + " \"" + this.resource.getString(this.getTabName()) + "\"?")) {
            this.log.log(10, "Delete element - " + this.getTabName());
            try {
                for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
                    this.removeItem(map);
                }
            }
            catch (UrfaException urfaException) {
                this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete item(s)"), urfaException);
            }
            this.refresh();
            this.log.log(10, "Delete element - " + this.getTabName() + " complete");
        }
    }

    protected void edit() {
        this.log.log(10, "Edit element - " + this.getTabName());
        this.getItemDialog(this.mainTablePanel.getSelectedTableRows()[0]).run(this);
    }

    public abstract DFModel getItemDialog(Map<String, Object> var1);

    protected void add() {
        this.log.log(10, "Add element - " + this.getTabName());
        this.getItemDialog(null).run(this);
    }

    protected void read() {
        this.log.log(10, "Read element - " + this.getTabName());
        DFModel dFModel = this.getItemDialog(this.mainTablePanel.getSelectedTableRows()[0]);
        dFModel.setReadOnly();
        dFModel.run(this);
    }

    protected void doubleClick() {
        if (this.selectMode) {
            this.btn.doClick();
        } else if (!(this.mode != 1 && this.mode != 3 && this.mode != 6 || this.editPermission != null && !UrfaManagerImpl.getInstance().isPermitted(this.editPermission))) {
            this.edit();
        } else if (!(this.mode != 1 && this.mode != 3 || this.readPermission != null && !UrfaManagerImpl.getInstance().isPermitted(this.readPermission))) {
            this.read();
        }
    }

    public void setSelectMode(JButton jButton) {
        this.selectMode = true;
        this.btn = jButton;
    }

    private void createUIComponents() {
        this.mode = this.getMode();
        this.columnNames = this.getColumnNames();
        this.createTable();
    }

    protected void createTable() {
        this.log.log(10, "Create table - " + this.getTabName());
        this.mainTablePanel = new TablePanelImpl(this.getClass().getName() + "_" + this.getTabName(), true);
        MapTableModel mapTableModel = this.mainTablePanel.getTableModel();
        if (this.columnNames != null) {
            for (String string : this.columnNames.keySet()) {
                mapTableModel.addColumn(string, this.columnNames.get(string), true, false);
            }
        } else {
            this.log.log(1, "No column defined");
        }
        this.mainTablePanel.setEditable(false);
        this.mainTablePanel.setAppendable(false);
        this.mainTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                if (TabPanelWithTable.this.noContextMenu) {
                    return new JMenuItem[0];
                }
                JMenuItem jMenuItem = new JMenuItem(Utils.getResource().getString("Edit"));
                JMenuItem jMenuItem2 = new JMenuItem(Utils.getResource().getString("Read"));
                JMenuItem jMenuItem3 = new JMenuItem(Utils.getResource().getString("Refresh"));
                JMenuItem jMenuItem4 = new JMenuItem(Utils.getResource().getString("Delete"));
                TabPanelWithTable.this.isEditVisible(jMenuItem);
                TabPanelWithTable.this.isReadVisible(jMenuItem2);
                TabPanelWithTable.this.isDeleteVisible(jMenuItem4);
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabPanelWithTable.this.refresh();
                    }
                });
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabPanelWithTable.this.edit();
                    }
                });
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabPanelWithTable.this.delete();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabPanelWithTable.this.read();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem3};
                }
                if (mapArray.length > 1) {
                    ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                    if (Utils.isAdmin()) {
                        if (TabPanelWithTable.this.mode == 1 && (TabPanelWithTable.this.deletePermission == null || UrfaManagerImpl.getInstance().isPermitted(TabPanelWithTable.this.deletePermission))) {
                            arrayList.add(jMenuItem4);
                        }
                    } else {
                        arrayList.add(jMenuItem4);
                    }
                    arrayList.add(jMenuItem3);
                    return arrayList.toArray(new JMenuItem[arrayList.size()]);
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                if (Utils.isAdmin()) {
                    if (!(TabPanelWithTable.this.mode != 1 && TabPanelWithTable.this.mode != 3 && TabPanelWithTable.this.mode != 6 || TabPanelWithTable.this.editPermission != null && !UrfaManagerImpl.getInstance().isPermitted(TabPanelWithTable.this.editPermission) || TabPanelWithTable.this.readPermission != null && !UrfaManagerImpl.getInstance().isPermitted(TabPanelWithTable.this.readPermission))) {
                        arrayList.add(jMenuItem);
                    } else if (!(TabPanelWithTable.this.mode != 1 && TabPanelWithTable.this.mode != 3 || TabPanelWithTable.this.readPermission != null && !UrfaManagerImpl.getInstance().isPermitted(TabPanelWithTable.this.readPermission))) {
                        arrayList.add(jMenuItem2);
                    }
                } else {
                    arrayList.add(jMenuItem);
                }
                if (Utils.isAdmin()) {
                    if (TabPanelWithTable.this.mode == 1 && (TabPanelWithTable.this.deletePermission == null || UrfaManagerImpl.getInstance().isPermitted(TabPanelWithTable.this.deletePermission))) {
                        arrayList.add(jMenuItem4);
                    }
                } else {
                    arrayList.add(jMenuItem4);
                }
                arrayList.add(jMenuItem3);
                if (TabPanelWithTable.this.getMenuItems(mapArray) != null) {
                    for (JMenuItem jMenuItem5 : TabPanelWithTable.this.getMenuItems(mapArray)) {
                        arrayList.add(jMenuItem5);
                    }
                }
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                TabPanelWithTable.this.doubleClick();
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.mainTablePanel.applyTableSettings();
        this.log.log(10, "Create table - " + this.getTabName() + " complete");
    }

    protected void isEditVisible(JMenuItem jMenuItem) {
    }

    protected void isReadVisible(JMenuItem jMenuItem) {
    }

    protected void isDeleteVisible(JMenuItem jMenuItem) {
    }

    public int[] getDeletePermission() {
        return this.deletePermission;
    }

    public void setDeletePermission(int[] nArray) {
        this.deletePermission = nArray;
        if (Permissions.getInstance().isAvailable(this.convert(nArray))) {
            Permissions.getInstance().addPerm(new Permission(this.getTabName(), this.getGroupName(), new Integer[0]), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Delete", this.getTabName(), this.convert(nArray)), this.getTabType());
        }
    }

    public int[] getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(int[] nArray) {
        this.editPermission = nArray;
        if (Permissions.getInstance().isAvailable(this.convert(nArray))) {
            Permissions.getInstance().addPerm(new Permission(this.getTabName(), this.getGroupName(), new Integer[0]), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Edit", this.getTabName(), this.convert(nArray)), this.getTabType());
        }
    }

    public int[] getAddPermission() {
        return this.addPermission;
    }

    public void setAddPermission(int[] nArray) {
        this.addPermission = nArray;
        if (Permissions.getInstance().isAvailable(this.convert(nArray))) {
            Permissions.getInstance().addPerm(new Permission(this.getTabName(), this.getGroupName(), new Integer[0]), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Add", this.getTabName(), this.convert(nArray)), this.getTabType());
        }
    }

    public int[] getReadPermission() {
        return this.readPermission;
    }

    public void setReadPermission(int[] nArray) {
        this.readPermission = nArray;
        if (Permissions.getInstance().isAvailable(this.convert(nArray))) {
            Permissions.getInstance().addPerm(new Permission(this.getTabName(), this.getGroupName(), new Integer[0]), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Read", this.getTabName(), this.convert(nArray)), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Edit", this.getTabName(), this.convert(nArray)), this.getTabType());
        }
    }

    public Vector<Map<String, Object>> getTableData() {
        return this.mainTablePanel.getTableModel().data;
    }

    public JPanel getAdditionalButtonsPanel() {
        return this.additionalButtonsPanel;
    }

    public JPanel getAdditionalButtonPanel2() {
        return this.additionalButtonPanel2;
    }

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public TablePanelImpl getMainTablePanel() {
        return this.mainTablePanel;
    }

    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        return null;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        this.additionalButtonsPanel = new JPanel();
        this.additionalButtonsPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.additionalButtonsPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel5, gridBagConstraints);
        this.delPanel = new JPanel();
        this.delPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.delPanel, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.delPanel.add((Component)jPanel6, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.delPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.refPanel = new JPanel();
        this.refPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.refPanel, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.refPanel.add((Component)jPanel7, gridBagConstraints);
        this.refreshButton = new JButton();
        this.refreshButton.setEnabled(true);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
        this.$$$loadButtonText$$$(this.refreshButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Refresh"));
        this.refreshButton.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.refPanel.add((Component)this.refreshButton, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.refPanel.add((Component)jPanel8, gridBagConstraints);
        this.addPanel = new JPanel();
        this.addPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.addPanel, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.addPanel.add((Component)jPanel9, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addPanel.add((Component)this.addButton, gridBagConstraints);
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.editPanel, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.editPanel.add((Component)jPanel10, gridBagConstraints);
        this.editButton = new JButton();
        this.editButton.setEnabled(true);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edit16.png")));
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.editPanel.add((Component)this.editButton, gridBagConstraints);
        this.readPanel = new JPanel();
        this.readPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.readPanel, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.readPanel.add((Component)jPanel11, gridBagConstraints);
        this.readButton = new JButton();
        this.readButton.setEnabled(true);
        this.readButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/find16.png")));
        this.$$$loadButtonText$$$(this.readButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Read"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.readPanel.add((Component)this.readButton, gridBagConstraints);
        this.additionalButtonPanel2 = new JPanel();
        this.additionalButtonPanel2.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.additionalButtonPanel2, gridBagConstraints);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.bottomPanel, gridBagConstraints);
        this.filterPanel = new JPanel();
        this.filterPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.filterPanel, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)jPanel15, "Center");
        jPanel15.add((Component)this.mainTablePanel, "Center");
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new BorderLayout(0, 0));
        jPanel15.add((Component)this.southPanel, "South");
        this.eastPanel = new JPanel();
        this.eastPanel.setLayout(new BorderLayout(0, 0));
        jPanel15.add((Component)this.eastPanel, "East");
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

