/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.hs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetBytesInKb;
import biz.netup.control.transport.urfa.functions.UrfaGetBytesInKb;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Utils;
import javax.swing.JTextField;

public class BytesTextField
extends JTextField {
    private static int b_in_kb = 1024;

    public BytesTextField() {
        this.initBytesInKb();
    }

    private void initBytesInKb() {
        try {
            if (Utils.isAdmin()) {
                UrfaGetBytesInKb urfaGetBytesInKb = new UrfaGetBytesInKb(UrfaManagerImpl.getInstance());
                urfaGetBytesInKb.call();
                b_in_kb = urfaGetBytesInKb.getBytesInKb();
            } else {
                UrfaDealerGetBytesInKb urfaDealerGetBytesInKb = new UrfaDealerGetBytesInKb(UrfaManagerImpl.getInstance());
                urfaDealerGetBytesInKb.call();
                b_in_kb = urfaDealerGetBytesInKb.getBytesInKb();
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    public long getValue() throws IllegalArgumentException {
        try {
            return Long.parseLong(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return BytesTextField.getLong(this.getText());
        }
    }

    public static long getLong(String string) throws IllegalArgumentException {
        long l;
        String string2;
        long l2 = 0L;
        String string3 = string.trim().toLowerCase();
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("String is empty");
        }
        int n = string3.indexOf(" ");
        if (n == -1 && string3.charAt(string3.length() - 1) == 'g') {
            n = string3.length();
        }
        if (n != -1 && (string2 = string3.substring(0, n).trim()).charAt(n - 1) == 'g') {
            try {
                l = Long.parseLong(string2.substring(0, n - 1).trim());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error size format: error in Gb");
            }
            l2 = l * (long)b_in_kb * (long)b_in_kb * (long)b_in_kb;
            string3 = n == string3.length() ? "" : string3.substring(n).trim();
        }
        if (string3.length() == 0) {
            return l2;
        }
        n = string3.indexOf(" ");
        if (n == -1 && string3.charAt(string3.length() - 1) == 'm') {
            n = string3.length();
        }
        if (n != -1 && (string2 = string3.substring(0, n).trim()).charAt(n - 1) == 'm') {
            try {
                l = Long.parseLong(string2.substring(0, n - 1).trim());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error size format: error in Mb");
            }
            l2 += l * (long)b_in_kb * (long)b_in_kb;
            string3 = n == string3.length() ? "" : string3.substring(n).trim();
        }
        if (string3.length() == 0) {
            return l2;
        }
        n = string3.indexOf(" ");
        if (n == -1 && string3.charAt(string3.length() - 1) == 'k') {
            n = string3.length();
        }
        if (n != -1 && (string2 = string3.substring(0, n).trim()).charAt(n - 1) == 'k') {
            try {
                l = Long.parseLong(string2.substring(0, n - 1).trim());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error size format: error in Kb");
            }
            l2 += l * (long)b_in_kb;
            string3 = n == string3.length() ? "" : string3.substring(n).trim();
        }
        if (string3.length() == 0) {
            return l2;
        }
        n = string3.indexOf(" ");
        if (n == -1 && string3.length() != 0) {
            n = string3.length();
        }
        if (n != -1 && (string2 = string3.substring(0, n).trim()).charAt(n - 1) == 'b') {
            try {
                l = Long.parseLong(string2.substring(0, n - 1).trim());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error size format: error in bytes");
            }
            l2 += l;
            string3 = n == string3.length() ? "" : string3.substring(n).trim();
        }
        if (string3.length() != 0) {
            throw new IllegalArgumentException("Error size format");
        }
        return l2;
    }

    public void setValue(String string) {
        try {
            this.setValue(BytesTextField.getLong(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setValue(0L);
        }
    }

    public void setValue(long l) {
        this.setText(BytesTextField.getString(l));
    }

    public static String getString(long l) {
        long l2 = l / (long)(b_in_kb * b_in_kb * b_in_kb);
        long l3 = l % (long)(b_in_kb * b_in_kb * b_in_kb) / (long)(b_in_kb * b_in_kb);
        long l4 = l % (long)(b_in_kb * b_in_kb) / (long)b_in_kb;
        long l5 = l % (long)b_in_kb;
        String string = "";
        if (l2 != 0L) {
            string = "" + l2 + "G";
        }
        if (l3 != 0L) {
            string = l2 != 0L ? string + " " + l3 + "M" : string + l3 + "M";
        }
        if (l4 != 0L) {
            string = l2 != 0L || l3 != 0L ? string + " " + l4 + "K" : string + l4 + "K";
        }
        if (l5 != 0L) {
            string = l2 != 0L || l3 != 0L || l4 != 0L ? string + " " + l5 + "b" : string + l5 + "b";
        }
        if (string.length() == 0) {
            string = "0";
        }
        return string;
    }
}

