/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.importing;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetSysUsersList;
import biz.netup.control.transport.urfa.functions.UrfaGetSysgroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersCount;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersList;
import biz.netup.control.transport.urfa.functions.UrfaTelZonesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.importing.XmlException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlChecker {
    Document doc;
    Set<String> logins = new HashSet<String>();
    Set<Integer> uid = new HashSet<Integer>();
    Set<Integer> aid = new HashSet<Integer>();
    Set<String> dirPrefixes = new HashSet<String>();
    Set<String> zonesLogins = new HashSet<String>();
    Set<Integer> did = new HashSet<Integer>();
    Set<Integer> zid = new HashSet<Integer>();

    public static void main(String[] stringArray) {
        new XmlChecker().test();
    }

    private void test() {
        try {
            this.checkUsers(this.getClass().getResource("/biz/netup/projects/utmadmin/utils/importing/import.xml").toString());
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public void checkUsers(String string) throws XmlException, UrfaException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.newDocument();
        Document document = documentBuilder.parse(new File(string));
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"users".equals(node.getNodeName())) continue;
            this.parseUsers((Element)node);
        }
        this.checkLogins();
    }

    private void checkLogins() throws UrfaException, XmlException {
        for (int i = 0; i <= 1; ++i) {
            UrfaGetUsersCount urfaGetUsersCount = new UrfaGetUsersCount(UrfaManagerImpl.getInstance());
            urfaGetUsersCount.setCardUser(i);
            urfaGetUsersCount.call();
            UrfaGetUsersList urfaGetUsersList = new UrfaGetUsersList(UrfaManagerImpl.getInstance());
            urfaGetUsersList.setCardUser(i);
            urfaGetUsersList.setFrom(0);
            urfaGetUsersList.setTo(urfaGetUsersCount.getCount() + 1);
            urfaGetUsersList.call();
            Vector<Map<String, Object>> vector = urfaGetUsersList.getUsers();
            for (int j = 0; j < vector.size(); ++j) {
                if (!this.logins.contains(((String)vector.get(j).get("login")).toLowerCase())) continue;
                throw new XmlException("User login present in UTM: " + vector.get(j).get("login"));
            }
        }
        UrfaGetSysgroupsList urfaGetSysgroupsList = new UrfaGetSysgroupsList(UrfaManagerImpl.getInstance());
        urfaGetSysgroupsList.call();
        for (int i = 0; i < urfaGetSysgroupsList.getGroupsSize(); ++i) {
            if (!this.logins.contains(urfaGetSysgroupsList.getGroupName1()[i].toLowerCase())) continue;
            throw new XmlException("User login present in UTM: " + urfaGetSysgroupsList.getGroupName1()[i]);
        }
        UrfaGetSysUsersList urfaGetSysUsersList = new UrfaGetSysUsersList(UrfaManagerImpl.getInstance());
        urfaGetSysUsersList.call();
        for (int i = 0; i < urfaGetSysUsersList.getInfoSize(); ++i) {
            if (!this.logins.contains(urfaGetSysUsersList.getLogin1()[i].toLowerCase())) continue;
            throw new XmlException("User login present in UTM: " + urfaGetSysUsersList.getLogin1()[i]);
        }
    }

    private void parseUsers(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"user".equals(node.getNodeName())) continue;
            this.parseUser((Element)node);
        }
    }

    private void parseUser(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ("login".equals(node.getNodeName())) {
                if (this.logins.contains(node.getTextContent())) {
                    throw new XmlException("Duplicate user login in xml: " + node.getTextContent());
                }
                this.logins.add(node.getTextContent().toLowerCase());
                continue;
            }
            if ("id".equals(node.getNodeName())) {
                if (this.uid.contains(Integer.parseInt(node.getTextContent()))) {
                    throw new XmlException("Duplicate user id in xml: " + node.getTextContent());
                }
                this.uid.add(Integer.parseInt(node.getTextContent()));
                continue;
            }
            if (!"accounts".equals(node.getNodeName())) continue;
            this.parseAccounts((Element)node);
        }
    }

    private void parseAccounts(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"account".equals(node.getNodeName())) continue;
            this.parseAccount((Element)node);
        }
    }

    private void parseAccount(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"id".equals(node.getNodeName())) continue;
            if (this.aid.contains(Integer.parseInt(node.getTextContent()))) {
                throw new XmlException("Duplicate account id in xml: " + node.getTextContent());
            }
            this.aid.add(Integer.parseInt(node.getTextContent()));
        }
    }

    public void checkTelZonesDirs(String string) throws XmlException, UrfaException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.newDocument();
        Document document = documentBuilder.parse(new File(string));
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if ("directions".equals(node3.getNodeName())) {
                node = node3;
            }
            if (!"zones".equals(node3.getNodeName())) continue;
            node2 = node3;
        }
        if (node != null) {
            this.parseDirections((Element)node);
        }
        if (node2 != null) {
            this.parseZones((Element)node2);
        }
        this.checkZonesDirectionsNames();
    }

    private void checkZonesDirectionsNames() throws UrfaException, XmlException {
        UrfaTelZonesList urfaTelZonesList = new UrfaTelZonesList(UrfaManagerImpl.getInstance());
        urfaTelZonesList.call();
        for (int i = 0; i < urfaTelZonesList.getZoneCount(); ++i) {
            if (!this.zonesLogins.contains(urfaTelZonesList.getNameArray1()[i].toLowerCase())) continue;
            throw new XmlException("Zone name present in UTM: " + urfaTelZonesList.getNameArray1()[i]);
        }
    }

    private void parseZones(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"zone".equals(node.getNodeName())) continue;
            this.parseZone((Element)node);
        }
    }

    private void parseZone(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ("name".equals(node.getNodeName())) {
                if (this.zonesLogins.contains(node.getTextContent())) {
                    throw new XmlException("Duplicate zone name in xml: " + node.getTextContent());
                }
                this.zonesLogins.add(node.getTextContent().toLowerCase());
                continue;
            }
            if ("id".equals(node.getNodeName())) {
                if (this.zid.contains(Integer.parseInt(node.getTextContent()))) {
                    throw new XmlException("Duplicate zone id in xml: " + node.getTextContent());
                }
                this.zid.add(Integer.parseInt(node.getTextContent()));
                continue;
            }
            if (!"directions".equals(node.getNodeName())) continue;
            this.parseZoneDirections((Element)node);
        }
    }

    private void parseZoneDirections(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"direction".equals(node.getNodeName())) continue;
            this.parseZoneDirection((Element)node);
        }
    }

    private void parseZoneDirection(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"id".equals(node.getNodeName()) || this.did.contains(Integer.parseInt(node.getTextContent()))) continue;
            throw new XmlException("There is no direction: " + node.getTextContent());
        }
    }

    private void parseDirections(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"direction".equals(node.getNodeName())) continue;
            this.parseDirection((Element)node);
        }
    }

    private void parseDirection(Element element) throws XmlException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ("prefix".equals(node.getNodeName())) {
                if (this.dirPrefixes.contains(node.getTextContent())) {
                    throw new XmlException("Duplicate direction prefix in xml: " + node.getTextContent());
                }
                this.dirPrefixes.add(node.getTextContent().toLowerCase());
                continue;
            }
            if (!"id".equals(node.getNodeName())) continue;
            if (this.did.contains(Integer.parseInt(node.getTextContent()))) {
                throw new XmlException("Duplicate direction id in xml: " + node.getTextContent());
            }
            this.did.add(Integer.parseInt(node.getTextContent()));
        }
    }
}

