/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table.impl;

import biz.netup.control.storage.Settings;
import biz.netup.control.storage.Storage;
import biz.netup.control.storage.impl.StorageImpl;
import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.RecordStatus;
import biz.netup.swing.table.TablePanel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.TablePanelListener;
import biz.netup.utmutils.control.export.ExportClass;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TablePanelImpl
extends JPanel
implements TablePanel {
    private ArrayList<CellEditingListener> cellEditListeners = new ArrayList();
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle(TablePanelImpl.class.getName());
    private String stringNew = "";
    private String stringNew0 = "";
    private Set<JButton> checked = new HashSet<JButton>();
    private String tableName;
    private PanelMouseListener panelMouseListener = new PanelMouseListener();
    boolean isSortable = true;
    boolean isColumnsMenuEnabled = true;
    boolean isEditable = false;
    boolean isAppendable = false;
    boolean tableSettingsUsed = false;
    JMenu menuColumns;
    JMenuItem menuExport;
    Storage storage = StorageImpl.getInstance();
    private JTable mainTable;
    JTableHeader tableSummary;
    TablePanelListener listener;
    private JScrollPane scrollPpane = null;
    private Map<String, Object> summaryData = new TreeMap<String, Object>();
    private Map<String, String> summaryTooltips = new TreeMap<String, String>();
    private DefaultCellEditor normalCellEditor = new DefaultCellEditorEx(new JTextField());
    private Map<String, TableCellEditor> cellEditors = new HashMap<String, TableCellEditor>();
    private Map<String, TableCellRenderer> cellRenderers = new HashMap<String, TableCellRenderer>();
    private Map<String, TableCellRenderer> summaryRenderers = new HashMap<String, TableCellRenderer>();
    private JPanel panelTable;
    private JLabel summary;
    private TableSelectionListener tableSelectionListener;
    private TableSelectionListenerNormal tableSelectionListenerNormal;
    private static final Icon upIcon = new ImageIcon(TableHeaderCellRenderer.class.getResource("up.png"));
    private static final Icon downIcon = new ImageIcon(TableHeaderCellRenderer.class.getResource("down.png"));
    private Icon iconEmpty = new ImageIcon(new BufferedImage(20, 20, 6));
    public static Icon iconNew = new ImageIcon(TableHeaderCellRenderer.class.getResource("NewBCard.png"));
    public static Icon iconEdit = new ImageIcon(TableHeaderCellRenderer.class.getResource("EditBCard.png"));
    private static Icon iconEditing = new ImageIcon(TableHeaderCellRenderer.class.getResource("Hourglass.png"));
    public static Icon iconDelete = new ImageIcon(TableHeaderCellRenderer.class.getResource("DelBCard.png"));
    public static Icon iconBlock = new ImageIcon(TableHeaderCellRenderer.class.getResource("lock.png"));
    public static Icon iconUnblock = new ImageIcon(TableHeaderCellRenderer.class.getResource("unlock.png"));
    public static Icon iconLoad = new ImageIcon(TableHeaderCellRenderer.class.getResource("load.png"));
    private Vector<JButton> oneRowButtons;
    private Vector<JButton> multiRowButtons;
    private Vector<JButton> columnButtons;
    private Vector<FieldButton> fieldButtons;
    private Vector<FieldButton> fieldButtonsBlock;

    public void setAppendLabels(String string, String string2) {
        this.stringNew = string;
        this.stringNew0 = string2;
    }

    public void addCellEditListeners(CellEditingListener cellEditingListener) {
        this.cellEditListeners.add(cellEditingListener);
    }

    public void setSummaryRenderer(String string, TableCellRenderer tableCellRenderer) {
        this.summaryRenderers.put(string, tableCellRenderer);
    }

    JMenuItem[] getTableContextMenuItems() {
        if (this.listener == null) {
            return new JMenuItem[0];
        }
        JMenuItem[] jMenuItemArray = this.listener.getTableContextMenuItems(this.getSelectedTableRows());
        if (jMenuItemArray == null) {
            return new JMenuItem[0];
        }
        return jMenuItemArray;
    }

    private void updateCellEditors() {
        int n = this.mainTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.getTableModel().getColumnId(this.mainTable.getColumnName(i));
            DefaultCellEditor defaultCellEditor = this.cellEditors.containsKey(string) ? this.cellEditors.get(string) : this.normalCellEditor;
            this.mainTable.getColumnModel().getColumn(i).setCellEditor(defaultCellEditor);
            this.tableSummary.getColumnModel().getColumn(i).setCellEditor(defaultCellEditor);
        }
    }

    private void updateCellRenderers() {
        int n = this.mainTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.getTableModel().getColumnId(this.mainTable.getColumnName(i));
            TableCellRenderer tableCellRenderer = this.cellRenderers.containsKey(string) ? this.cellRenderers.get(string) : new InternalTableCellRenderer();
            this.mainTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
            this.tableSummary.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
        }
    }

    public void setCellEditor(String string, TableCellEditor tableCellEditor) {
        if (null == tableCellEditor) {
            this.cellEditors.remove(string);
        } else {
            this.cellEditors.put(string, tableCellEditor);
        }
        this.updateCellEditors();
    }

    public void setCellRenderer(String string, TableCellRenderer tableCellRenderer) {
        if (null == tableCellRenderer) {
            this.cellRenderers.remove(string);
        } else {
            this.cellRenderers.put(string, tableCellRenderer);
        }
        this.updateCellRenderers();
    }

    void performTableRowDoubleClicked() {
        if (this.isEnabled() && this.listener != null) {
            Map<String, Object>[] mapArray = this.getSelectedTableRows();
            if (mapArray.length == 0) {
                this.listener.performTableRowDoubleClicked(null);
            } else {
                this.listener.performTableRowDoubleClicked(mapArray[0]);
            }
        }
    }

    void performSelectionChanged() {
        if (this.listener != null) {
            this.listener.performSelectionChanged(this.getSelectedTableRows());
        }
    }

    void performRowModified(Map<String, Object> map) {
        if (this.listener != null) {
            this.listener.performRowModified(map);
        }
    }

    void performColumnVisibilityChanged(String string, boolean bl) {
        if (this.listener != null) {
            this.listener.performColumnVisibilityChanged(string, bl);
        }
    }

    @Override
    public Map<String, Object>[] getSelectedTableRows() {
        int[] nArray = this.mainTable.getSelectedRows();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < nArray.length; ++i) {
            Map<String, Object> map = this.getTableModel().getRow(nArray[i]);
            if (map == null) continue;
            vector.add(map);
        }
        Map[] mapArray = new Map[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            mapArray[i] = (Map)vector.get(i);
        }
        return mapArray;
    }

    public TablePanelImpl() {
        this("", true);
    }

    public TablePanelImpl(String string, boolean bl) {
        this(string, bl, null);
    }

    public TablePanelImpl(String string, boolean bl, MapTableModel mapTableModel) {
        this.tableName = string;
        if (mapTableModel == null) {
            mapTableModel = new TrackingMapTableModel();
        }
        this.mainTable = new JTable(mapTableModel){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        return this.columnModel.getColumn(n).getHeaderValue().toString();
                    }
                };
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Map<String, Object> map;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent && null != (map = TablePanelImpl.this.getTableModel().getRow(n))) {
                    String string = TablePanelImpl.this.getTableModel().getColumnId(TablePanelImpl.this.getTable().getColumnModel().getColumn(n2).getModelIndex());
                    String string2 = (String)map.get(string + "_tooltip");
                    JComponent jComponent = (JComponent)component;
                    if (null != string2) {
                        jComponent.setToolTipText(string2);
                    } else {
                        jComponent.setToolTipText(null);
                    }
                }
                return component;
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                final int n = tableModelEvent.getType();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n == -1) {
                            if (this.isEditing()) {
                                this.removeEditor();
                            }
                            this.clearSelection();
                        }
                        if (tableHeader != null) {
                            tableHeader.resizeAndRepaint();
                        }
                    }
                });
                try {
                    super.tableChanged(tableModelEvent);
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                    // empty catch block
                }
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
            }

            @Override
            @Deprecated
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                Map map;
                int[] nArray = this.getSelectedRows();
                Map<String, Object> map2 = TablePanelImpl.this.getTableModel().getRow(n);
                TableCellEditor tableCellEditor = null;
                if (null != map2 && null != (map = (Map)TablePanelImpl.this.getTableModel().getRow(n).get("X-EDITORS"))) {
                    tableCellEditor = (TableCellEditor)map.get(TablePanelImpl.this.getTableModel().getColumnId(n2));
                }
                if (null == tableCellEditor) {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
                if (!(null == eventObject || tableCellEditor instanceof CheckboxCellEditor || 1 == nArray.length && nArray[0] == n)) {
                    return false;
                }
                boolean bl = super.editCellAt(n, n2, null);
                if (bl && null != this.editorComp) {
                    if (this.editorComp instanceof JComboBox) {
                        JComboBox jComboBox = (JComboBox)this.editorComp;
                        if (jComboBox.isEditable()) {
                            ((JComponent)jComboBox.getEditor().getEditorComponent()).setNextFocusableComponent(TablePanelImpl.this.mainTable);
                            ((JComponent)jComboBox.getEditor().getEditorComponent()).requestFocus();
                        } else {
                            this.editorComp.requestFocus();
                        }
                    } else {
                        this.editorComp.requestFocus();
                    }
                }
                return bl;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                Object object;
                Map<String, Object> map = TablePanelImpl.this.getTableModel().getRow(n);
                TableCellEditor tableCellEditor = null;
                if (null != map && null != (object = (Map)TablePanelImpl.this.getTableModel().getRow(n).get("X-EDITORS"))) {
                    tableCellEditor = (TableCellEditor)object.get(TablePanelImpl.this.getTableModel().getColumnId(this.getColumnModel().getColumn(n2).getModelIndex()));
                }
                if (null == tableCellEditor) {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
                object = tableCellEditor;
                TableCellEditor tableCellEditor2 = new TableCellEditor((TableCellEditor)object){
                    final /* synthetic */ TableCellEditor val$editor;
                    {
                        this.val$editor = tableCellEditor;
                    }

                    @Override
                    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                        Component component = this.val$editor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                        if (null != component && component instanceof JCheckBox) {
                            if (bl) {
                                component.setForeground(jTable.getSelectionForeground());
                                component.setBackground(jTable.getSelectionBackground());
                            } else {
                                Object object2;
                                Object object3 = object2 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-COLOR") : null;
                                if (null == object2) {
                                    component.setBackground(n % 2 == 1 ? new Color(242, 242, 220) : jTable.getBackground());
                                } else {
                                    Color color = (Color)object2;
                                    Color color2 = new Color(Math.min(255, (int)(1.05 * (double)color.getRed())), Math.min(255, (int)(1.05 * (double)color.getGreen())), Math.min(255, (int)(1.05 * (double)color.getBlue())));
                                    component.setBackground(n % 2 == 1 ? (Color)object2 : color2);
                                }
                                Object object4 = object2 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-FONT-COLOR") : null;
                                if (null != object2) {
                                    component.setForeground((Color)object2);
                                }
                            }
                        }
                        return component;
                    }

                    @Override
                    public void addCellEditorListener(CellEditorListener cellEditorListener) {
                        this.val$editor.addCellEditorListener(cellEditorListener);
                    }

                    @Override
                    public void cancelCellEditing() {
                        this.val$editor.cancelCellEditing();
                    }

                    @Override
                    public Object getCellEditorValue() {
                        return this.val$editor.getCellEditorValue();
                    }

                    @Override
                    public boolean isCellEditable(EventObject eventObject) {
                        return this.val$editor.isCellEditable(eventObject);
                    }

                    @Override
                    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
                        this.val$editor.removeCellEditorListener(cellEditorListener);
                    }

                    @Override
                    public boolean shouldSelectCell(EventObject eventObject) {
                        return this.val$editor.shouldSelectCell(eventObject);
                    }

                    @Override
                    public boolean stopCellEditing() {
                        return this.val$editor.stopCellEditing();
                    }
                };
                for (int i = 0; i < TablePanelImpl.this.cellEditListeners.size(); ++i) {
                    ((CellEditingListener)TablePanelImpl.this.cellEditListeners.get(i)).BeginCellEditing(n2, n, tableCellEditor2);
                }
                return tableCellEditor2;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                Object object;
                Map<String, Object> map = TablePanelImpl.this.getTableModel().getRow(n);
                TableCellRenderer tableCellRenderer = null;
                if (null != map) {
                    object = (Map)TablePanelImpl.this.getTableModel().getRow(n).get("X-RENDERERS");
                    if (null != object) {
                        tableCellRenderer = (TableCellRenderer)object.get(TablePanelImpl.this.getTableModel().getColumnId(this.getColumnModel().getColumn(n2).getModelIndex()));
                    } else if (map.get(TablePanelImpl.this.getTableModel().getColumnId(n2)) instanceof Boolean) {
                        tableCellRenderer = TablePanelImpl.this.mainTable.isCellEditable(n, n2) ? new CheckboxCellRenderer() : new CheckboxCellRenderer(false);
                    }
                }
                if (null == tableCellRenderer) {
                    tableCellRenderer = super.getCellRenderer(n, n2);
                }
                object = tableCellRenderer;
                return new DefaultTableCellRenderer((TableCellRenderer)object){
                    final /* synthetic */ TableCellRenderer val$tcr1;
                    {
                        this.val$tcr1 = tableCellRenderer;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        Component component = this.val$tcr1.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        if (null == component) {
                            component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        }
                        if (!bl) {
                            Object object2;
                            if (!(component instanceof JButton)) {
                                component.setForeground(jTable.getForeground());
                            }
                            Object object3 = object2 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-COLOR") : null;
                            if (!(component instanceof JButton)) {
                                if (null == object2) {
                                    component.setBackground(n % 2 == 1 ? new Color(242, 242, 220) : jTable.getBackground());
                                } else {
                                    Color color = (Color)object2;
                                    Color color2 = new Color(Math.min(255, (int)(1.05 * (double)color.getRed())), Math.min(255, (int)(1.05 * (double)color.getGreen())), Math.min(255, (int)(1.05 * (double)color.getBlue())));
                                    component.setBackground(n % 2 == 1 ? (Color)object2 : color2);
                                }
                            }
                            Object object4 = object2 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-FONT-COLOR") : null;
                            if (null != object2) {
                                component.setForeground((Color)object2);
                            }
                        }
                        if (bl && !(component instanceof JButton)) {
                            component.setForeground(jTable.getSelectionForeground());
                            component.setBackground(jTable.getSelectionBackground());
                        }
                        return component;
                    }
                };
            }
        };
        InputMap inputMap = this.mainTable.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        this.mainTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (TablePanelImpl.this.mainTable.getRowCount() <= 0) {
                    Container container = TablePanelImpl.this.getFocusCycleRootAncestor();
                    JComponent jComponent = null;
                    if (container instanceof JComponent) {
                        jComponent = (JComponent)TablePanelImpl.this.getFocusCycleRootAncestor();
                    }
                    if (null == jComponent) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else {
                        FocusTraversalPolicy focusTraversalPolicy = jComponent.getFocusTraversalPolicy();
                        if (focusEvent.getOppositeComponent() == focusTraversalPolicy.getComponentAfter(TablePanelImpl.this.getFocusCycleRootAncestor(), TablePanelImpl.this.mainTable)) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                        } else {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                        }
                    }
                } else if (-1 == TablePanelImpl.this.mainTable.getSelectedRow()) {
                    TablePanelImpl.this.mainTable.getSelectionModel().setSelectionInterval(0, 0);
                    TablePanelImpl.this.mainTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (9 == keyEvent.getKeyCode()) {
                    keyEvent.consume();
                    if (0 != (1 & keyEvent.getModifiers())) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            }
        });
        this.mainTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = TablePanelImpl.this.mainTable.getSelectedRow();
                Rectangle rectangle = TablePanelImpl.this.mainTable.getCellRect(n, 0, true);
                TablePanelImpl.this.mainTable.scrollRectToVisible(rectangle);
            }
        });
        this.mainTable.getTableHeader().setDefaultRenderer(new TableHeaderCellRenderer());
        this.mainTable.setDefaultRenderer(Object.class, new InternalTableCellRenderer());
        this.mainTable.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.mainTable.getTableHeader().addMouseListener(this.panelMouseListener);
        this.tableSelectionListener = new TableSelectionListener();
        this.tableSelectionListenerNormal = new TableSelectionListenerNormal();
        this.mainTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        this.mainTable.addMouseListener(new TableMouseListener());
        this.mainTable.addMouseListener(this.panelMouseListener);
        this.mainTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!TablePanelImpl.this.mainTable.isEditing() && 10 == keyEvent.getKeyCode()) {
                    TablePanelImpl.this.performTableRowDoubleClicked();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.mainTable.setSurrendersFocusOnKeystroke(true);
        this.panelTable = new JPanel(new BorderLayout());
        if (bl) {
            this.scrollPpane = new JScrollPane(this.mainTable);
            this.scrollPpane.addMouseListener(this.panelMouseListener);
            this.panelTable.add((Component)this.scrollPpane, "Center");
        } else {
            this.panelTable.setBorder(new EtchedBorder());
            this.panelTable.add((Component)this.mainTable, "Center");
            this.panelTable.add((Component)this.mainTable.getTableHeader(), "North");
        }
        this.menuColumns = new JMenu(RESOURCE.getString("menu_Columns"));
        this.menuExport = new JMenuItem(RESOURCE.getString("menu_Export"));
        this.menuExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePanelImpl.this.export();
            }
        });
        this.mainTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                this.update();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                this.update();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                this.update();
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                this.update();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            private void update() {
                TableSettings tableSettings;
                if (!TablePanelImpl.this.tableSettingsUsed) {
                    return;
                }
                Iterator<TableSettings> iterator = TablePanelImpl.this.storage.select(TableSettings.class, "tableName='" + TablePanelImpl.this.tableName + "'");
                if (iterator.hasNext()) {
                    tableSettings = iterator.next();
                } else {
                    tableSettings = new TableSettings();
                    tableSettings.tableName = TablePanelImpl.this.tableName;
                    TablePanelImpl.this.storage.add(tableSettings);
                }
                tableSettings.init(TablePanelImpl.this.mainTable);
                tableSettings.modify();
                TablePanelImpl.this.storage.commit();
            }
        });
        this.mainTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TablePanelImpl.this.tableSummary.setVisible(TablePanelImpl.this.tableSummary.isVisible() || TablePanelImpl.this.getTableModel().summaryColumns.size() > 0);
            }
        });
        this.tableSummary = new JTableHeader(this.mainTable.getColumnModel());
        this.tableSummary.setVisible(false);
        this.tableSummary.setPreferredSize(new Dimension(10, 20));
        this.tableSummary.setBorder(new EtchedBorder());
        this.tableSummary.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = ((MapTableModel)TablePanelImpl.this.mainTable.getModel()).getColumnId(n2);
                ((MapTableModel)TablePanelImpl.this.mainTable.getModel()).getSummary();
                TableCellRenderer tableCellRenderer = (TableCellRenderer)TablePanelImpl.this.summaryRenderers.get(string);
                if (null != tableCellRenderer) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(TablePanelImpl.this.mainTable, TablePanelImpl.this.summaryData.get(string), bl, bl2, n, n2);
                    component.setBackground(UIManager.getColor("JButton.background"));
                    if (component instanceof Component) {
                        ((JComponent)component).setToolTipText((String)TablePanelImpl.this.summaryTooltips.get(string));
                    }
                    return component;
                }
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setValue(TablePanelImpl.this.getSummary(string));
                this.setToolTipText((String)TablePanelImpl.this.summaryTooltips.get(string));
                return this;
            }
        });
        this.summary = new JLabel("");
        this.summary.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tableSummary, "North");
        jPanel.add((Component)this.summary, "South");
        this.panelTable.add((Component)jPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTable, "Center");
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    TablePanelImpl.this.deactivateOneRowButtons();
                    TablePanelImpl.this.deactivateMultiRowButtons();
                    TablePanelImpl.this.deactivateFieldButtons();
                    TablePanelImpl.this.deactivateFieldButtonsBlock();
                } else {
                    int n;
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    if (n2 == (n = listSelectionModel.getMaxSelectionIndex()) && n2 != -1) {
                        TablePanelImpl.this.activateOneRowButtons();
                        TablePanelImpl.this.activateMultiRowButtons();
                        if (TablePanelImpl.this.fieldButtons != null) {
                            for (FieldButton fieldButton : TablePanelImpl.this.fieldButtons) {
                                if (TablePanelImpl.this.getSelectedTableRows().length > 0 && TablePanelImpl.this.getSelectedTableRows()[0].get(fieldButton.field) != null && TablePanelImpl.this.getSelectedTableRows()[0].get(fieldButton.field).equals(fieldButton.value)) {
                                    fieldButton.button.setEnabled(true);
                                    continue;
                                }
                                fieldButton.button.setEnabled(false);
                            }
                        }
                        if (TablePanelImpl.this.fieldButtonsBlock != null) {
                            for (FieldButton fieldButton : TablePanelImpl.this.fieldButtonsBlock) {
                                if (TablePanelImpl.this.getSelectedTableRows().length > 0 && TablePanelImpl.this.getSelectedTableRows()[0].get(fieldButton.field) != null && !TablePanelImpl.this.getSelectedTableRows()[0].get(fieldButton.field).equals(fieldButton.value)) {
                                    fieldButton.button.setEnabled(true);
                                    continue;
                                }
                                fieldButton.button.setEnabled(false);
                            }
                        }
                    } else {
                        TablePanelImpl.this.activateMultiRowButtons();
                        TablePanelImpl.this.deactivateOneRowButtons();
                        if (TablePanelImpl.this.fieldButtons != null) {
                            for (FieldButton fieldButton : TablePanelImpl.this.fieldButtons) {
                                for (Map<String, Object> map : TablePanelImpl.this.getSelectedTableRows()) {
                                    if (map.get(fieldButton.field) != null && map.get(fieldButton.field).equals(fieldButton.value)) continue;
                                    fieldButton.button.setEnabled(false);
                                }
                            }
                        }
                        if (TablePanelImpl.this.fieldButtonsBlock != null) {
                            for (FieldButton fieldButton : TablePanelImpl.this.fieldButtonsBlock) {
                                for (Map<String, Object> map : TablePanelImpl.this.getSelectedTableRows()) {
                                    if (map.get(fieldButton.field) != null && !map.get(fieldButton.field).equals(fieldButton.value)) continue;
                                    fieldButton.button.setEnabled(false);
                                }
                            }
                        }
                    }
                }
                if (TablePanelImpl.this.getTable().getSelectedColumnCount() != 1 || TablePanelImpl.this.getTable().getSelectedColumn() == 0) {
                    TablePanelImpl.this.deactivateColumnButtons();
                } else {
                    TablePanelImpl.this.activateColumnButtons();
                }
            }
        });
    }

    public void export() {
        ExportClass.exportToCsv(this);
    }

    public Object getSummary(String string) {
        return this.summaryData.get(string);
    }

    public void putSummary(String string, Object object) {
        this.tableSummary.setVisible(true);
        if (object != null) {
            this.summaryData.put(string, object);
        } else {
            this.summaryData.remove(string);
        }
        this.tableSummary.repaint();
    }

    public void putSummary(String string, Object object, String string2) {
        this.tableSummary.setVisible(true);
        if (object != null) {
            this.summaryData.put(string, object);
        } else {
            this.summaryData.remove(string);
        }
        if (string2 != null) {
            this.summaryTooltips.put(string, string2);
        } else {
            this.summaryTooltips.remove(string);
        }
        this.tableSummary.repaint();
    }

    public void applyTableSettings() {
        Iterator<TableSettings> iterator = this.storage.select(TableSettings.class, "tableName='" + this.tableName + "'");
        if (!iterator.hasNext()) {
            this.tableSettingsUsed = true;
            return;
        }
        TableSettings tableSettings = iterator.next();
        this.tableSettingsUsed = false;
        tableSettings.initTable(this.mainTable);
        this.tableSettingsUsed = true;
        this.updateCellEditors();
        this.updateCellRenderers();
    }

    public void configureTable() {
        this.tableSettingsUsed = true;
        this.updateCellEditors();
        this.updateCellRenderers();
    }

    @Override
    public MapTableModel getTableModel() {
        return (MapTableModel)this.mainTable.getModel();
    }

    public void setupTableSelectionListenerNormal() {
        if (this.tableSelectionListener != null) {
            this.mainTable.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        } else {
            this.tableSelectionListener = new TableSelectionListener();
        }
        if (this.tableSelectionListenerNormal == null) {
            this.tableSelectionListenerNormal = new TableSelectionListenerNormal();
        }
        this.mainTable.getSelectionModel().addListSelectionListener(this.tableSelectionListenerNormal);
    }

    public void setupTableSelectionListener() {
        if (this.tableSelectionListenerNormal != null) {
            this.mainTable.getSelectionModel().removeListSelectionListener(this.tableSelectionListenerNormal);
        } else {
            this.tableSelectionListenerNormal = new TableSelectionListenerNormal();
        }
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new TableSelectionListener();
        }
        this.mainTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.mainTable.getMinimumSize();
        dimension.height = null == this.scrollPpane ? this.mainTable.getPreferredSize().height + this.mainTable.getTableHeader().getPreferredSize().height + 4 + (this.tableSummary.isVisible() ? this.tableSummary.getPreferredSize().height : 0) : this.mainTable.getRowHeight() * 4 + 2;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setTablePanelListener(TablePanelListener tablePanelListener) {
        this.listener = tablePanelListener;
    }

    @Override
    public void setTableModel(MapTableModel mapTableModel) {
        this.mainTable.setModel(mapTableModel);
    }

    public void setSortingEnabled(boolean bl) {
        this.isSortable = bl;
    }

    public boolean isSortingEnabled() {
        return this.isSortable;
    }

    public void setColumnsMenuEnabled(boolean bl) {
        this.isColumnsMenuEnabled = bl;
    }

    @Override
    public void setEditable(boolean bl) {
        this.isEditable = bl;
        this.isAppendable = bl;
        this.getTableModel().setEditable(bl);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setAppendable(boolean bl) {
        this.isAppendable = bl;
        this.getTableModel().fireTableDataChanged();
    }

    public boolean isAppendable() {
        return this.isAppendable;
    }

    public void setDefaultCellEditor(Class clazz, TableCellEditor tableCellEditor) {
        this.mainTable.setDefaultEditor(clazz, tableCellEditor);
    }

    public void setDefaultRenderer(Class clazz, InternalTableCellRenderer internalTableCellRenderer) {
        this.mainTable.setDefaultRenderer(clazz, internalTableCellRenderer);
    }

    @Override
    public JTable getTable() {
        return this.mainTable;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEditable(bl);
        if (!bl) {
            this.unregisterAllButtons();
            this.listener = new TablePanelAdapter(){};
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mainTable.isEnabled();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPpane;
    }

    private void deactivateOneRowButtons() {
        if (this.oneRowButtons != null) {
            for (JButton jButton : this.oneRowButtons) {
                jButton.setEnabled(false);
            }
        }
    }

    private void activateOneRowButtons() {
        if (this.oneRowButtons != null) {
            for (JButton jButton : this.oneRowButtons) {
                jButton.setEnabled(true);
            }
        }
    }

    private void deactivateMultiRowButtons() {
        if (this.multiRowButtons != null) {
            for (JButton jButton : this.multiRowButtons) {
                jButton.setEnabled(false);
            }
        }
    }

    private void activateMultiRowButtons() {
        if (this.multiRowButtons != null) {
            for (JButton jButton : this.multiRowButtons) {
                jButton.setEnabled(true);
            }
        }
    }

    private void deactivateColumnButtons() {
        if (this.columnButtons != null) {
            for (JButton jButton : this.columnButtons) {
                jButton.setEnabled(false);
            }
        }
    }

    private void activateColumnButtons() {
        if (this.columnButtons != null) {
            for (JButton jButton : this.columnButtons) {
                jButton.setEnabled(true);
            }
        }
    }

    private void deactivateFieldButtons() {
        if (this.fieldButtons != null) {
            for (FieldButton fieldButton : this.fieldButtons) {
                fieldButton.button.setEnabled(false);
            }
        }
    }

    private void activateFieldButtons() {
        if (this.fieldButtons != null) {
            for (FieldButton fieldButton : this.fieldButtons) {
                fieldButton.button.setEnabled(true);
            }
        }
    }

    private void deactivateFieldButtonsBlock() {
        if (this.fieldButtonsBlock != null) {
            for (FieldButton fieldButton : this.fieldButtonsBlock) {
                fieldButton.button.setEnabled(false);
            }
        }
    }

    private void activateFieldButtonsBlock() {
        if (this.fieldButtonsBlock != null) {
            for (FieldButton fieldButton : this.fieldButtonsBlock) {
                fieldButton.button.setEnabled(true);
            }
        }
    }

    public void unregisterAllButtons() {
        this.oneRowButtons = null;
        this.multiRowButtons = null;
        this.columnButtons = null;
        this.fieldButtons = null;
        this.fieldButtonsBlock = null;
    }

    public void registerOneRowButton(JButton jButton) {
        if (this.checkButton(jButton)) {
            if (this.oneRowButtons == null) {
                this.oneRowButtons = new Vector();
            }
            if (!this.oneRowButtons.contains(jButton)) {
                this.oneRowButtons.add(jButton);
                if (jButton != null) {
                    jButton.setEnabled(false);
                }
            }
        }
    }

    private boolean checkButton(JButton jButton) {
        if (jButton != null && !jButton.isEnabled() && !this.checked.contains(jButton)) {
            return false;
        }
        this.checked.add(jButton);
        return true;
    }

    public void registerFieldButton(JButton jButton, String string, Object object) {
        if (this.checkButton(jButton)) {
            FieldButton fieldButton;
            if (this.fieldButtons == null) {
                this.fieldButtons = new Vector();
            }
            if (!this.fieldButtons.contains(fieldButton = new FieldButton(jButton, string, object))) {
                this.fieldButtons.add(fieldButton);
                if (fieldButton.button != null) {
                    fieldButton.button.setEnabled(false);
                }
            }
        }
    }

    public void registerFieldButtonBlock(JButton jButton, String string, Object object) {
        if (this.checkButton(jButton)) {
            FieldButton fieldButton;
            if (this.fieldButtonsBlock == null) {
                this.fieldButtonsBlock = new Vector();
            }
            if (!this.fieldButtonsBlock.contains(fieldButton = new FieldButton(jButton, string, object))) {
                this.fieldButtonsBlock.add(fieldButton);
                if (fieldButton.button != null) {
                    fieldButton.button.setEnabled(false);
                }
            }
        }
    }

    public void registerMultiRowButton(JButton jButton) {
        if (this.checkButton(jButton)) {
            if (this.multiRowButtons == null) {
                this.multiRowButtons = new Vector();
            }
            if (!this.multiRowButtons.contains(jButton)) {
                this.multiRowButtons.add(jButton);
                if (jButton != null) {
                    jButton.setEnabled(false);
                }
            }
        }
    }

    public void registerColumnButton(JButton jButton) {
        if (this.checkButton(jButton)) {
            if (this.columnButtons == null) {
                this.columnButtons = new Vector();
            }
            if (!this.columnButtons.contains(jButton)) {
                this.columnButtons.add(jButton);
                if (jButton != null) {
                    jButton.setEnabled(false);
                }
            }
        }
    }

    public void setSummaryVisible(boolean bl) {
        this.summary.setVisible(bl);
    }

    public void setSummaryText(String string) {
        this.summary.setText(string);
    }

    class FieldButton {
        String field;
        Object value;
        JButton button;

        FieldButton(JButton jButton, String string, Object object) {
            this.field = string;
            this.value = object;
            this.button = jButton;
        }
    }

    public static class DefaultCellEditorEx
    extends DefaultCellEditor {
        public DefaultCellEditorEx(JTextField jTextField) {
            super(jTextField);
            jTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DefaultCellEditorEx.this.stopCellEditing();
                }
            });
        }

        public DefaultCellEditorEx(JComboBox jComboBox) {
            super(jComboBox);
            jComboBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DefaultCellEditorEx.this.stopCellEditing();
                }
            });
        }
    }

    private class PanelMouseListener
    extends MouseAdapter {
        JPopupMenu menu = new JPopupMenu();
        Map<String, JCheckBoxMenuItem> columnItems = new TreeMap<String, JCheckBoxMenuItem>();

        private PanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.menu.isPopupTrigger(mouseEvent)) {
                this.popup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.menu.isPopupTrigger(mouseEvent)) {
                this.popup(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.menu.isPopupTrigger(mouseEvent)) {
                this.popup(mouseEvent);
            }
        }

        private void popup(MouseEvent mouseEvent) {
            if (!TablePanelImpl.this.isEnabled()) {
                return;
            }
            this.menu.removeAll();
            if (mouseEvent.getSource() == TablePanelImpl.this.mainTable || mouseEvent.getSource() == TablePanelImpl.this.scrollPpane || mouseEvent.getSource() == TablePanelImpl.this.mainTable.getTableHeader()) {
                TablePanelImpl.this.menuColumns.removeAll();
                if (TablePanelImpl.this.isColumnsMenuEnabled) {
                    this.menu.add(TablePanelImpl.this.menuColumns);
                }
                this.menu.add(TablePanelImpl.this.menuExport);
                MapTableModel mapTableModel = (MapTableModel)TablePanelImpl.this.mainTable.getModel();
                final Map<String, String> map = mapTableModel.getAllColumns();
                TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String string, String string2) {
                        return ((String)map.get(string)).compareTo((String)map.get(string2));
                    }
                });
                treeSet.addAll(map.keySet());
                for (String string : treeSet) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = null;
                    if (this.columnItems.containsKey(string)) {
                        jCheckBoxMenuItem = this.columnItems.get(string);
                    } else {
                        jCheckBoxMenuItem = new JCheckBoxMenuItem(map.get(string));
                        jCheckBoxMenuItem.addActionListener(new ColumnChoiceListener(string));
                        this.columnItems.put(string, jCheckBoxMenuItem);
                    }
                    jCheckBoxMenuItem.setSelected(mapTableModel.isColumnVisible(string));
                    TablePanelImpl.this.menuColumns.add(jCheckBoxMenuItem);
                }
                JMenuItem[] jMenuItemArray = TablePanelImpl.this.getTableContextMenuItems();
                if (jMenuItemArray.length > 0) {
                    this.menu.add(new JPopupMenu.Separator());
                }
                for (int i = 0; i < jMenuItemArray.length; ++i) {
                    if (jMenuItemArray[i] == null) {
                        this.menu.add(new JPopupMenu.Separator());
                        continue;
                    }
                    this.menu.add(jMenuItemArray[i]);
                }
            }
            if (this.menu.getSubElements().length > 0) {
                this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private class ColumnChoiceListener
        implements ActionListener {
            String columnId;

            public ColumnChoiceListener(String string) {
                this.columnId = string;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapTableModel mapTableModel;
                mapTableModel.setColumnVisible(this.columnId, !(mapTableModel = (MapTableModel)TablePanelImpl.this.mainTable.getModel()).isColumnVisible(this.columnId));
                TablePanelImpl.this.updateCellEditors();
                TablePanelImpl.this.updateCellRenderers();
                TablePanelImpl.this.performColumnVisibilityChanged(this.columnId, mapTableModel.isColumnVisible(this.columnId));
            }
        }
    }

    public class PasswordCellRenderer
    extends InternalTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object.toString();
            int n3 = string.length();
            char[] cArray = new char[n3];
            for (int i = 0; i < n3; ++i) {
                cArray[i] = 42;
            }
            object = new String(cArray);
            this.setValue(object);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public class InternalTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (object instanceof Double) {
                object2 = "";
                if (!biz.netup.utmutils.control.Settings.getValueFromPerst("DoubleRounding").isEmpty()) {
                    object2 = "0.";
                    try {
                        for (int i = 0; i < Integer.parseInt(biz.netup.utmutils.control.Settings.getValueFromPerst("DoubleRounding")); ++i) {
                            object2 = (String)object2 + "0";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2 = "0.000";
                    }
                } else {
                    object2 = "0.000";
                }
                object = new DecimalFormat((String)object2).format(object).replaceAll(",", ".");
                this.setValue(object);
            }
            if (object instanceof Date) {
                if (((Date)object).getTime() == 2000000000000L) {
                    object = RESOURCE.getString("Infinity");
                    this.setValue(object);
                } else if (((Date)object).getTime() == 0L) {
                    object = RESOURCE.getString("Not defined");
                    this.setValue(object);
                } else {
                    object2 = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    object = ((Format)object2).format(object);
                    this.setValue(object);
                }
            }
            if (TablePanelImpl.this.isAppendable && n == TablePanelImpl.this.getTable().getRowCount() - 1 && n2 == 0) {
                object = n == 0 ? TablePanelImpl.this.stringNew0 : TablePanelImpl.this.stringNew;
                this.setValue(object);
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(new CompoundBorder(this.getBorder(), new EmptyBorder(new Insets(1, 2, 1, 2))));
            object2 = (MapTableModel)jTable.getModel();
            Map<String, Object> map = ((MapTableModel)object2).getRow(n);
            RecordStatus recordStatus = map != null ? (RecordStatus)map.get("X-STATUS") : null;
            Icon icon = null;
            Font font = jTable.getFont();
            if (recordStatus != null) {
                switch (recordStatus.getStatus()) {
                    case 2: {
                        if (n2 != 0) break;
                        icon = iconNew;
                        break;
                    }
                    case 1: {
                        if (n2 != 0) break;
                        icon = iconEdit;
                        break;
                    }
                    case 4: {
                        if (n2 != 0) break;
                        icon = iconDelete;
                        break;
                    }
                    case 5: {
                        if (n2 != 0) break;
                        icon = iconLoad;
                        break;
                    }
                    default: {
                        if (n2 != 0) break;
                        icon = TablePanelImpl.this.iconEmpty;
                    }
                }
                if (recordStatus.isEditing()) {
                    if (n2 == 0) {
                        icon = iconEditing;
                    }
                    font = font.deriveFont(2);
                }
            }
            if (n2 == 0 && map != null && map.get("X-ICON") != null && map.get("X-ICON") instanceof Icon) {
                icon = (Icon)map.get("X-ICON");
            }
            if (map != null && map.get("X-FONT") != null && map.get("X-FONT") instanceof Font) {
                font = (Font)map.get("X-FONT");
            }
            this.setIcon(icon);
            this.setFont(font);
            if (TablePanelImpl.this.isAppendable && n == jTable.getRowCount() - 1) {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            if (!bl && !bl2) {
                Object object3;
                Object object4 = object3 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-COLOR") : null;
                if (null == object3) {
                    this.setBackground(n % 2 == 1 ? new Color(242, 242, 220) : jTable.getBackground());
                } else {
                    Color color = (Color)object3;
                    Color color2 = new Color(Math.min(255, (int)(1.05 * (double)color.getRed())), Math.min(255, (int)(1.05 * (double)color.getGreen())), Math.min(255, (int)(1.05 * (double)color.getBlue())));
                    this.setBackground(n % 2 == 1 ? (Color)object3 : color2);
                }
                Object object5 = object3 = ((MapTableModel)jTable.getModel()).getRow(n) != null ? ((MapTableModel)jTable.getModel()).getRow(n).get("X-FONT-COLOR") : null;
                if (null != object3) {
                    this.setForeground((Color)object3);
                }
            }
            return this;
        }
    }

    private class TableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private TableHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = 0;
            if (jTable != null) {
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                MapTableModel mapTableModel = (MapTableModel)TablePanelImpl.this.mainTable.getModel();
                n3 = mapTableModel.getColumnSortOrder(jTable.convertColumnIndexToModel(n2));
            }
            if (n3 == 1) {
                this.setIcon(upIcon);
            } else if (n3 == 2) {
                this.setIcon(downIcon);
            } else {
                this.setIcon(null);
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(new CompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), new EmptyBorder(new Insets(1, 2, 1, 2))));
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TablePanelImpl.this.isEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 3) {
                int n = TablePanelImpl.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = TablePanelImpl.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 >= 0) {
                    TablePanelImpl.this.mainTable.requestFocus();
                    TableCellEditor tableCellEditor = TablePanelImpl.this.mainTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.cancelCellEditing();
                    }
                    if (!TablePanelImpl.this.mainTable.isRowSelected(n)) {
                        TablePanelImpl.this.mainTable.changeSelection(n, n2, false, false);
                    }
                }
            } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                int n = TablePanelImpl.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n3 = TablePanelImpl.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (!TablePanelImpl.this.mainTable.isCellEditable(n, n3)) {
                    TablePanelImpl.this.performTableRowDoubleClicked();
                }
            }
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!TablePanelImpl.this.isEnabled()) {
                return;
            }
            if (!TablePanelImpl.this.isSortingEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                Rectangle rectangle = jTableHeader.getHeaderRect(n);
                if (rectangle.x + 2 < mouseEvent.getPoint().x && rectangle.x + rectangle.width - 3 > mouseEvent.getPoint().x) {
                    int n2;
                    int n3 = jTableHeader.getTable().convertColumnIndexToModel(n);
                    MapTableModel mapTableModel = (MapTableModel)TablePanelImpl.this.mainTable.getModel();
                    switch (mapTableModel.getColumnSortOrder(n3)) {
                        case 0: {
                            n2 = 1;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                        default: {
                            n2 = 0;
                        }
                    }
                    mapTableModel.setColumnSortOrder(n3, n2);
                }
            }
        }
    }

    private class TableSelectionListenerNormal
    implements ListSelectionListener {
        private TableSelectionListenerNormal() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                TablePanelImpl.this.performSelectionChanged();
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                TablePanelImpl.this.performSelectionChanged();
            }
        }
    }

    private class TrackingMapTableModel
    extends MapTableModel {
        private TrackingMapTableModel() {
        }

        @Override
        public synchronized void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (!(object == object2 || null != object && object.equals(object2))) {
                RecordStatus recordStatus;
                boolean bl = TablePanelImpl.this.isAppendable && n == this.getRowCount() - 1;
                Map<String, Object> map = this.getRow(n);
                RecordStatus recordStatus2 = recordStatus = map != null ? (RecordStatus)map.get("X-STATUS") : null;
                if (map == null) {
                    map = new TreeMap<String, Object>();
                    this.addRow(map);
                }
                super.setValueAt(object, n, n2);
                for (int i = 0; i < TablePanelImpl.this.cellEditListeners.size(); ++i) {
                    ((CellEditingListener)TablePanelImpl.this.cellEditListeners.get(i)).EndCellEditing(n2, n, object);
                }
                if (recordStatus != null) {
                    switch (recordStatus.getStatus()) {
                        case 2: {
                            TablePanelImpl.this.performRowModified(map);
                            break;
                        }
                        default: {
                            recordStatus.setStatus(1);
                            TablePanelImpl.this.performRowModified(map);
                        }
                    }
                }
                if (recordStatus == null && map != null) {
                    recordStatus = new RecordStatus(bl ? 2 : 1);
                    TablePanelImpl.this.performRowModified(map);
                }
                if (n2 != 0) {
                    this.fireTableCellUpdated(n, n2);
                }
            }
        }

        @Override
        public int getRowCount() {
            if (TablePanelImpl.this.isAppendable) {
                return super.getRowCount();
            }
            return super.getRowCount() - 1;
        }
    }

    private static class TableSettings
    extends Settings {
        public String tableName;
        public String ids;
        public String width;

        public void init(JTable jTable) {
            this.ids = "";
            this.width = "";
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.width = this.width + "" + tableColumnModel.getColumn(i).getWidth() + ";";
                this.ids = this.ids + ((MapTableModel)jTable.getModel()).getColumnId((String)tableColumnModel.getColumn(i).getIdentifier()) + ";";
            }
        }

        public void initTable(JTable jTable) {
            String[] stringArray = this.ids.split(";");
            ((MapTableModel)jTable.getModel()).setVisibleColumns(stringArray);
            String[] stringArray2 = this.width.split(";");
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i >= jTable.getColumnModel().getColumnCount()) continue;
                jTable.getColumnModel().getColumn(i).setPreferredWidth(Integer.parseInt(stringArray2[i]));
            }
        }
    }

    public static interface CellEditingListener {
        public void BeginCellEditing(int var1, int var2, TableCellEditor var3);

        public void EndCellEditing(int var1, int var2, Object var3);
    }
}

