/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanel;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.Format;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableColumnModel;

public class TableExportManager {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle(TableExportManager.class.getName());

    private static final String readFileAsString(String string) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        char[] cArray = new char[131072];
        while ((n = bufferedReader.read(cArray)) != -1) {
            String string2 = String.valueOf(cArray, 0, n);
            stringBuffer.append(string2);
            cArray = new char[131072];
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private static final String[] splitTemplate(String string, String string2) {
        Pattern pattern = Pattern.compile("^(.*?)[ \t]*<!--BEGIN_" + string2 + "-->[ \t]*[\r\n]*(.*?)[ \t]*<!--END_" + string2 + "-->[ \t]*[\r\n]*(.*)$", 40);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return new String[]{string};
        }
        return new String[]{string.substring(matcher.start(1), matcher.end(1)), string.substring(matcher.start(2), matcher.end(2)), string.substring(matcher.start(3), matcher.end(3))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportToHtml(TablePanel tablePanel, String string, Map<String, Format> map) {
        String string2 = "export_template.html";
        MapTableModel mapTableModel = tablePanel.getTableModel();
        String string3 = "";
        try {
            string3 = TableExportManager.readFileAsString(string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(RESOURCE.getString("error_template_loading").replace("{template}", string2), iOException);
        }
        String[] stringArray = TableExportManager.splitTemplate(string3, "DETAILS");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            try {
                String[] stringArray2 = TableExportManager.splitTemplate(stringArray[0], "HEADER");
                fileOutputStream.write(stringArray2[0].getBytes("utf8"));
                TableColumnModel tableColumnModel = tablePanel.getTable().getColumnModel();
                if (stringArray2.length > 1) {
                    for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                        fileOutputStream.write(stringArray2[1].replace("{COLUMN}", tableColumnModel.getColumn(i).getHeaderValue().toString()).getBytes("utf8"));
                    }
                    fileOutputStream.write(stringArray2[2].getBytes("utf8"));
                }
                if (stringArray.length > 1) {
                    String[] stringArray3 = TableExportManager.splitTemplate(stringArray[1], "COLUMNS");
                    for (int i = 0; i < mapTableModel.getRowCount(); ++i) {
                        fileOutputStream.write(stringArray3[0].getBytes("utf8"));
                        if (stringArray3.length <= 1) continue;
                        for (int j = 0; j < tableColumnModel.getColumnCount(); ++j) {
                            String string4 = mapTableModel.getColumnId(j);
                            Object object = mapTableModel.getValueAt(i, j);
                            if (map.containsKey(string4)) {
                                object = map.get(string4).format(object);
                            }
                            fileOutputStream.write(stringArray3[1].replace("{COLUMN}", null == object ? "&nbsp;" : object.toString()).getBytes("utf8"));
                        }
                        fileOutputStream.write(stringArray3[2].getBytes("utf8"));
                    }
                    fileOutputStream.write(stringArray[2].getBytes("utf8"));
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(RESOURCE.getString("error_saving").replace("{file}", string), exception);
        }
    }

    private static final String escapeCsv(Object object) {
        String string;
        String string2 = string = null == object ? "" : object.toString();
        if (string.length() > 0 && (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(string.length() - 1)) || -1 != string.indexOf(34) || -1 != string.indexOf(44) || -1 != string.indexOf(59) || -1 != string.indexOf(13) || -1 != string.indexOf(10) || -1 != string.indexOf(9))) {
            string = '\"' + string.replace("\"", "\"\"") + '\"';
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportToCsv(TablePanel tablePanel, String string, Map<String, Format> map) {
        String string2 = "windows-1251";
        MapTableModel mapTableModel = tablePanel.getTableModel();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            try {
                int n;
                TableColumnModel tableColumnModel = tablePanel.getTable().getColumnModel();
                for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
                    if (n > 0) {
                        fileOutputStream.write(";".getBytes(string2));
                    }
                    fileOutputStream.write(TableExportManager.escapeCsv(tableColumnModel.getColumn(n).getHeaderValue().toString()).getBytes(string2));
                }
                fileOutputStream.write("\n".getBytes(string2));
                for (n = 0; n < mapTableModel.getRowCount(); ++n) {
                    for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                        if (i > 0) {
                            fileOutputStream.write(";".getBytes(string2));
                        }
                        String string3 = mapTableModel.getColumnId(i);
                        Object object = mapTableModel.getValueAt(n, i);
                        if (map.containsKey(string3)) {
                            object = map.get(string3).format(object);
                        }
                        fileOutputStream.write(TableExportManager.escapeCsv(object).getBytes(string2));
                    }
                    fileOutputStream.write("\n".getBytes(string2));
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(RESOURCE.getString("error_saving").replace("{file}", string), exception);
        }
    }
}

