/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class IconTableCellRenderer
extends DefaultTableCellRenderer {
    Icon on = new ImageIcon(this.getClass().getResource("add.png"));
    Icon off = new ImageIcon(this.getClass().getResource("sub.png"));
    Icon defaultIcon;
    static AbstractButton button = new AbstractButton(){};

    public IconTableCellRenderer() {
    }

    public IconTableCellRenderer(Icon icon, Icon icon2) {
        this.on = icon;
        this.off = icon2;
    }

    public IconTableCellRenderer(Icon icon) {
        this.defaultIcon = icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!(object instanceof Integer)) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Icon icon = (Integer)object == 1 ? this.on : this.off;
        this.setIcon(null);
        this.setText("");
        this.setBackground(this.getCorrectBackground(jTable, bl));
        try {
            this.paintIcon(jTable, n, icon, this);
        }
        catch (ClassCastException classCastException) {
            try {
                String string = classCastException.getMessage();
                string = string.substring(string.lastIndexOf(" ") + 1);
                Class<?> clazz = Class.forName(string);
                this.paintIcon(jTable, n, icon, (JComponent)clazz.newInstance());
            }
            catch (InstantiationException instantiationException) {
                try {
                    this.paintIcon(jTable, n, icon, button);
                }
                catch (ClassCastException classCastException2) {
                }
                catch (InstantiationException instantiationException2) {
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (this.getIcon() == null) {
            try {
                this.paintIcon(jTable, n, this.defaultIcon == null ? new XIcon(icon.getIconWidth(), icon.getIconHeight()) : this.defaultIcon, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setBackground(this.getCorrectBackground(jTable, bl));
        return this;
    }

    private void paintIcon(JTable jTable, int n, Icon icon, JComponent jComponent) throws ClassCastException, InstantiationException {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(jComponent, graphics2D, 2, 0);
        this.setIcon(new ImageIcon(bufferedImage));
        jTable.setRowHeight(n, Math.max(jTable.getRowHeight(), icon.getIconHeight() + 2));
    }

    private Color getCorrectBackground(JTable jTable, boolean bl) {
        return bl ? jTable.getSelectionBackground() : jTable.getBackground();
    }

    static {
        button.setModel(new DefaultButtonModel());
    }

    class XIcon
    implements Icon {
        int width;
        int height;

        XIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawRect(n, n2, this.width, this.height);
            graphics.drawLine(n, n2, n + this.width, n2 + this.height);
            graphics.drawLine(n + this.width, n2, n, n2 + this.height);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

