/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;

public class DoubleCellEditor
extends DefaultCellEditor {
    public DoubleCellEditor() {
        this(4);
    }

    public DoubleCellEditor(int n) {
        super(new JTextField());
        final DecimalFormat decimalFormat = new DecimalFormat("0." + "00000000000000000000".substring(0, n));
        NumberFormatter numberFormatter = new NumberFormatter(decimalFormat);
        numberFormatter.setAllowsInvalid(false);
        final JTextField jTextField = new JTextField();
        jTextField.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(0);
            }
        });
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DoubleCellEditor.this.stopCellEditing();
            }
        });
        this.editorComponent = jTextField;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                jTextField.requestFocus();
                jTextField.setText(object == null ? "" : (object instanceof Double ? decimalFormat.format((Double)object) : object.toString()));
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    return decimalFormat.parse(jTextField.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    return 0.0;
                }
            }
        };
        jTextField.addActionListener(this.delegate);
    }
}

