/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import biz.netup.swing.datetime.JDateTime;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

public class DateTimeCellEditor
extends DefaultCellEditor {
    private JDateTime datetime;

    public DateTimeCellEditor(String string) {
        this(string, true);
    }

    public DateTimeCellEditor(String string, boolean bl) {
        super(new JTextField());
        this.clickCountToStart = 2;
        this.datetime = new JDateTime(bl);
        this.datetime.setNullDateValue(string);
        this.editorComponent = this.datetime;
        this.datetime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeCellEditor.this.stopCellEditing();
            }
        });
        this.datetime.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                DateTimeCellEditor.this.datetime.repaint();
            }
        });
        this.datetime.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DateTimeCellEditor.this.stopCellEditing();
            }
        });
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                if (object instanceof Date) {
                    DateTimeCellEditor.this.datetime.setDate((Date)object);
                } else {
                    DateTimeCellEditor.this.datetime.setDate(new Date());
                }
            }

            @Override
            public Object getCellEditorValue() {
                return DateTimeCellEditor.this.datetime.getDate();
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                return super.stopCellEditing();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
    }
}

