/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.utm;

import biz.netup.swing.JSideMenu;
import biz.netup.swing.JSideMenuGroup;
import biz.netup.swing.JSideMenuItem;
import biz.netup.swing.plaf.SideMenuItemUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class UtmSideMenuItemUI
extends SideMenuItemUI {
    protected JSideMenuItem sideMenuItem;
    protected SideMenuItemMouseListener mouseListener;
    protected SideMenuItemFocusListener focusListener;
    protected SideMenuItemKeyListener keyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new UtmSideMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.sideMenuItem = (JSideMenuItem)jComponent;
        this.installDefaults();
        this.installListeners();
        this.sideMenuItem.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.sideMenuItem.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.sideMenuItem = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.sideMenuItem, "SideMenuItem.background", "SideMenuItem.foreground", "SideMenuItem.font");
        LookAndFeel.installBorder(this.sideMenuItem, "SideMenuItem.border");
        LookAndFeel.installProperty(this.sideMenuItem, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.sideMenuItem, "SideMenuItem.background", "SideMenuItem.foreground", "SideMenuItem.font");
        LookAndFeel.uninstallBorder(this.sideMenuItem);
    }

    protected void installListeners() {
        this.mouseListener = new SideMenuItemMouseListener();
        this.focusListener = new SideMenuItemFocusListener();
        this.keyListener = new SideMenuItemKeyListener();
        this.sideMenuItem.addMouseListener(this.mouseListener);
        this.sideMenuItem.addMouseMotionListener(this.mouseListener);
        this.sideMenuItem.addFocusListener(this.focusListener);
        this.sideMenuItem.addKeyListener(this.keyListener);
    }

    protected void uninstallListeners() {
        this.sideMenuItem.removeKeyListener(this.keyListener);
        this.sideMenuItem.removeFocusListener(this.focusListener);
        this.sideMenuItem.removeMouseMotionListener(this.mouseListener);
        this.sideMenuItem.removeMouseListener(this.mouseListener);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JSideMenuItem jSideMenuItem = (JSideMenuItem)jComponent;
        Icon icon = jSideMenuItem.getIcon();
        String string = jSideMenuItem.getText();
        Font font = jSideMenuItem.getFont();
        FontMetrics fontMetrics = jSideMenuItem.getFontMetrics(font);
        Dimension dimension = new Dimension();
        int n = (icon == null ? 0 : icon.getIconWidth()) + jSideMenuItem.getIconTextGap() + fontMetrics.stringWidth(string) + 5;
        int n2 = Math.max(icon == null ? 0 : icon.getIconHeight() + 2, fontMetrics.getHeight() + 4);
        dimension.setSize(n, n2);
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JSideMenuItem jSideMenuItem = (JSideMenuItem)jComponent;
        String string = jSideMenuItem.getText();
        Icon icon = jSideMenuItem.getIcon();
        Font font = jSideMenuItem.getFont();
        FontMetrics fontMetrics = jSideMenuItem.getFontMetrics(font);
        Color color = graphics.getColor();
        Rectangle rectangle = new Rectangle(jSideMenuItem.getBounds());
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(jSideMenuItem, fontMetrics, string, icon, jSideMenuItem.getVerticalAlignment(), jSideMenuItem.getHorizontalAlignment(), jSideMenuItem.getVerticalTextPosition(), jSideMenuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jSideMenuItem.getIconTextGap());
        if (icon != null) {
            icon.paintIcon(jSideMenuItem, graphics, rectangle2.x, rectangle2.y);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(jSideMenuItem.getForeground());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Map<TextAttribute, ?> map = font.getAttributes();
        ButtonModel buttonModel = jSideMenuItem.getModel();
        if (buttonModel != null && buttonModel.isArmed()) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        TextLayout textLayout = new TextLayout(string, map, fontRenderContext);
        textLayout.draw(graphics2D, rectangle3.x, rectangle3.y + fontMetrics.getAscent());
        if (jSideMenuItem.isFocusOwner()) {
            graphics.setColor(UIManager.getColor("SideMenuItem.focus"));
            Rectangle rectangle4 = jComponent.getBounds();
            graphics.drawRect(0, 0, rectangle4.width - 2, rectangle4.height - 2);
        }
        graphics.setColor(color);
    }

    public class SideMenuItemKeyListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            Object object;
            Container container;
            Object object2;
            if (keyEvent.getKeyCode() == 38) {
                object2 = null;
                container = UtmSideMenuItemUI.this.sideMenuItem.getParent();
                if (container != null && container instanceof JSideMenuGroup) {
                    object = container.getComponents();
                    for (n = 0; n < ((Component[])object).length && object[n] != UtmSideMenuItemUI.this.sideMenuItem; ++n) {
                    }
                    --n;
                    while (n >= 0 && object2 == null) {
                        if (((Component)object[n]).isFocusable()) {
                            object2 = object[n];
                        }
                        --n;
                    }
                    if (object2 == null && container.isFocusable()) {
                        object2 = container;
                    }
                }
                if (object2 != null) {
                    ((Component)object2).requestFocusInWindow();
                }
            }
            if (keyEvent.getKeyCode() == 40) {
                object2 = null;
                container = UtmSideMenuItemUI.this.sideMenuItem.getParent();
                if (container != null && container instanceof JSideMenuGroup) {
                    object = container.getComponents();
                    for (n = 0; n < ((Component[])object).length && object[n] != UtmSideMenuItemUI.this.sideMenuItem; ++n) {
                    }
                    ++n;
                    while (n < ((Object)object).length && object2 == null) {
                        if (((Component)object[n]).isFocusable()) {
                            object2 = object[n];
                        }
                        ++n;
                    }
                }
                if (container != null && object2 == null && (object = container.getParent()) != null && object instanceof JSideMenu) {
                    int n2;
                    Component[] componentArray = ((Container)object).getComponents();
                    for (n2 = 0; n2 < componentArray.length && componentArray[n2] != container; ++n2) {
                    }
                    ++n2;
                    while (n2 < componentArray.length && object2 == null) {
                        if (componentArray[n2].isFocusable()) {
                            object2 = componentArray[n2];
                        }
                        ++n2;
                    }
                }
                if (object2 != null) {
                    ((Component)object2).requestFocusInWindow();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class SideMenuItemFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            UtmSideMenuItemUI.this.sideMenuItem.revalidate();
            UtmSideMenuItemUI.this.sideMenuItem.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            UtmSideMenuItemUI.this.sideMenuItem.revalidate();
            UtmSideMenuItemUI.this.sideMenuItem.repaint();
        }
    }

    public class SideMenuItemMouseListener
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

