/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollPaneUI;

public final class PlasticScrollPaneUI
extends MetalScrollPaneUI {
    private PropertyChangeListener borderStyleChangeHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticScrollPaneUI();
    }

    @Override
    protected void installDefaults(JScrollPane jScrollPane) {
        super.installDefaults(jScrollPane);
        this.installEtchedBorder(jScrollPane);
    }

    @Override
    public void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.borderStyleChangeHandler = new BorderStyleChangeHandler();
        jScrollPane.addPropertyChangeListener("jgoodies.isEtched", this.borderStyleChangeHandler);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        ((JScrollPane)jComponent).removePropertyChangeListener("jgoodies.isEtched", this.borderStyleChangeHandler);
        super.uninstallListeners(jComponent);
    }

    protected void installEtchedBorder(JScrollPane jScrollPane) {
        Object object = jScrollPane.getClientProperty("jgoodies.isEtched");
        boolean bl = Boolean.TRUE.equals(object);
        LookAndFeel.installBorder(jScrollPane, bl ? "ScrollPane.etchedBorder" : "ScrollPane.border");
    }

    private class BorderStyleChangeHandler
    implements PropertyChangeListener {
        private BorderStyleChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JScrollPane jScrollPane = (JScrollPane)propertyChangeEvent.getSource();
            PlasticScrollPaneUI.this.installEtchedBorder(jScrollPane);
        }
    }
}

