/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.looks.plastic.PlasticComboBoxButton;
import biz.netup.swing.plaf.looks.plastic.PlasticComboBoxEditor;
import biz.netup.swing.plaf.looks.plastic.PlasticIconFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public final class PlasticComboBoxUI
extends MetalComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticComboBoxUI();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new PlasticComboBoxEditor.UIResource();
    }

    @Override
    protected ComboPopup createPopup() {
        return new PlasticComboPopup(this.comboBox);
    }

    private Insets getEditorInsets() {
        if (this.editor instanceof JComponent) {
            return ((JComponent)this.editor).getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    private int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof PlasticComboBoxButton) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)this.arrowButton;
            Insets insets = plasticComboBoxButton.getInsets();
            Insets insets2 = plasticComboBoxButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.height += 2;
            dimension.width += insets3.left + insets3.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets2.left + insets2.right;
            dimension.width += plasticComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets3.top + insets3.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = this.getDisplaySize();
            Insets insets = this.comboBox.getInsets();
            Insets insets4 = this.getEditorInsets();
            int n = this.getEditableButtonWidth();
            dimension.width += insets.left + insets.right;
            dimension.width += insets4.left + insets4.right - 1;
            dimension.width += n;
            dimension.height += insets.top + insets.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected JButton createArrowButton() {
        return new PlasticComboBoxButton(this.comboBox, PlasticIconFactory.getComboBoxButtonIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new PlasticComboBoxLayoutManager();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.isToolBarComboBox(jComponent)) {
                jComponent.setOpaque(false);
            }
        }
        this.paint(graphics, jComponent);
    }

    protected boolean isToolBarComboBox(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new PlasticPropertyChangeListener();
    }

    private class PlasticComboPopup
    extends MetalComboBoxUI.MetalComboPopup {
        private PlasticComboPopup(JComboBox jComboBox) {
            super(PlasticComboBoxUI.this, jComboBox);
        }

        @Override
        public void show() {
            Dimension dimension = this.comboBox.getPreferredSize();
            dimension.setSize(Math.max(Math.min(600.0, dimension.getWidth()), this.comboBox.getSize().getWidth()), dimension.getHeight());
            dimension.setSize(dimension.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
            this.scroller.setMaximumSize(rectangle.getSize());
            this.scroller.setPreferredSize(rectangle.getSize());
            this.scroller.setMinimumSize(rectangle.getSize());
            this.list.invalidate();
            int n = this.comboBox.getSelectedIndex();
            if (n == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(n);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            this.show(this.comboBox, rectangle.x, rectangle.y);
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
    }

    private class PlasticPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private PlasticPropertyChangeListener() {
            super(PlasticComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)PlasticComboBoxUI.this.arrowButton;
                plasticComboBoxButton.setIconOnly(PlasticComboBoxUI.this.comboBox.isEditable());
                PlasticComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setBackground(color);
                PlasticComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setForeground(color);
                PlasticComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    private class PlasticComboBoxLayoutManager
    extends MetalComboBoxUI.MetalComboBoxLayoutManager {
        private PlasticComboBoxLayoutManager() {
            super(PlasticComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            if (!jComboBox.isEditable()) {
                super.layoutContainer(container);
                return;
            }
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = PlasticComboBoxUI.this.getInsets();
            int n3 = PlasticComboBoxUI.this.getEditableButtonWidth();
            int n4 = n2 - (insets.top + insets.bottom);
            if (PlasticComboBoxUI.this.arrowButton != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    PlasticComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                } else {
                    PlasticComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n4);
                }
            }
            if (PlasticComboBoxUI.this.editor != null) {
                PlasticComboBoxUI.this.editor.setBounds(PlasticComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

