/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.looks.LookUtils;
import biz.netup.swing.plaf.looks.common.ButtonMarginListener;
import biz.netup.swing.plaf.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;
    private PropertyChangeListener buttonMarginListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookUtils.installNarrowMargin(abstractButton, this.getPropertyPrefix());
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("Button.borderPaintsFocus"));
    }

    @Override
    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        if (this.buttonMarginListener == null) {
            this.buttonMarginListener = new ButtonMarginListener(this.getPropertyPrefix());
        }
        abstractButton.addPropertyChangeListener("jgoodies.isNarrow", this.buttonMarginListener);
    }

    @Override
    public void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.buttonMarginListener);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (this.isToolBarButton(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.is3D(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    PlasticUtils.add3DEffekt(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.borderPaintsFocus) {
            return;
        }
        boolean bl = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
        int n = bl ? 3 : 2;
        int n2 = abstractButton.getWidth() - 1 - n * 2;
        int n3 = abstractButton.getHeight() - 1 - n * 2;
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(n, n, n2 - 1, n3 - 1);
    }

    protected boolean isToolBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton abstractButton) {
        if (PlasticUtils.force3D(abstractButton)) {
            return true;
        }
        if (PlasticUtils.forceFlat(abstractButton)) {
            return false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        return PlasticUtils.is3D("Button.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && (!buttonModel.isPressed() || !buttonModel.isArmed()) && !(abstractButton.getBorder() instanceof EmptyBorder);
    }
}

