/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.datetime.Manual;
import biz.netup.swing.datetime.TimeSpan;
import biz.netup.swing.filter.TimeFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeFilter2Impl
extends JPanel
implements TimeFilter {
    private JComboBox jComboBoxTimeSpan;
    private JDateTime jDateTimeFrom;
    private JDateTime jDateTimeTo;
    private JLabel jLabel;
    private GridBagConstraints gbc_cb = null;
    private Manual manualItem = null;
    private static final ResourceBundle resource_ = ResourceBundle.getBundle(TimeFilter2Impl.class.getName());
    private boolean update = false;
    private boolean showTime = true;
    private boolean showLabel = true;
    private boolean updating_ = false;

    public TimeFilter2Impl() {
        this(true);
    }

    public TimeFilter2Impl(boolean bl) {
        this.showTime = bl;
        this.initComponents();
        this.update();
    }

    public TimeFilter2Impl(boolean bl, boolean bl2, GridBagConstraints gridBagConstraints) {
        this.showTime = bl;
        this.showLabel = bl2;
        this.gbc_cb = gridBagConstraints;
        this.initComponents();
        this.update();
    }

    private void initComponents() {
        this.jLabel = new JLabel(resource_.getString("timespan"));
        this.jComboBoxTimeSpan = new JComboBox();
        this.jDateTimeFrom = new JDateTime(this.showTime);
        this.jDateTimeTo = new JDateTime(this.showTime);
        this.setLayout(new GridBagLayout());
        this.jComboBoxTimeSpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeFilter2Impl.this.update = true;
                TimeFilter2Impl.this.update();
                TimeFilter2Impl.this.update = false;
            }
        });
        this.jDateTimeFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TimeFilter2Impl.this.update) {
                    TimeFilter2Impl.this.clearTimeSpan();
                }
            }
        });
        this.jDateTimeTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TimeFilter2Impl.this.update) {
                    TimeFilter2Impl.this.clearTimeSpan();
                }
            }
        });
        this.jDateTimeFrom.getButton().setText("");
        this.jDateTimeFrom.getButton().setIcon(JDateTime.fromIcon);
        this.jDateTimeTo.getButton().setText("");
        this.jDateTimeTo.getButton().setIcon(JDateTime.toIcon);
        if (this.showLabel) {
            this.add((Component)this.jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(1, 1, 0, 0), 0, 0));
        }
        this.add((Component)this.jDateTimeFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 5, 0, 1), 0, 0));
        if (null != this.gbc_cb) {
            this.add((Component)this.jComboBoxTimeSpan, this.gbc_cb);
        } else {
            this.add((Component)this.jComboBoxTimeSpan, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 1, 1, 0), 0, 0));
        }
        this.add((Component)this.jDateTimeTo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 5, 1, 1), 0, 0));
    }

    private void clearTimeSpan() {
        if (this.jComboBoxTimeSpan != null && this.jComboBoxTimeSpan.getItemCount() > 0) {
            this.jComboBoxTimeSpan.setSelectedIndex(this.jComboBoxTimeSpan.getItemCount() - 1);
        }
    }

    private void update() {
        if (this.updating_) {
            return;
        }
        this.updating_ = true;
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (timeSpan != null) {
            Date date = timeSpan.from(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            Date date2 = timeSpan.to(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            if (!timeSpan.fromEnabled()) {
                this.jDateTimeFrom.setDate(date);
            }
            if (!timeSpan.toEnabled()) {
                this.jDateTimeTo.setDate(date2);
            }
        }
        this.updating_ = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.jComboBoxTimeSpan.setEnabled(bl);
        this.jDateTimeFrom.setEnabled(bl);
        this.jDateTimeTo.setEnabled(bl);
    }

    @Override
    public void addTimeSpan(TimeSpan timeSpan) {
        this.jComboBoxTimeSpan.addItem(timeSpan);
        this.update();
        if (timeSpan instanceof Manual) {
            this.manualItem = (Manual)timeSpan;
        }
    }

    @Override
    public void setDate(Date date, Date date2) {
        if (this.manualItem == null) {
            throw new IllegalStateException("TimeFilter2Impl: Manual item is not added by addTimeSpan(...)");
        }
        this.jComboBoxTimeSpan.setSelectedItem(this.manualItem);
        this.jDateTimeFrom.setDate(date);
        this.jDateTimeTo.setDate(date2);
    }

    @Override
    public Date getBeginDate() {
        return this.jDateTimeFrom.getDate();
    }

    @Override
    public Date getEndDate() {
        return this.jDateTimeTo.getDate();
    }

    @Override
    public ActionListener[] getActionListeners() {
        return null;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }
}

