/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.datetime;

import biz.netup.swing.datetime.JDateTime;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;

public class JDatePopup
extends JPopupMenu {
    ResourceBundle resource = ResourceBundle.getBundle(JDateTime.class.getName());
    ChangeListener cl = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length == 1 && menuElementArray[0] == JDatePopup.this) {
                return;
            }
            if (menuElementArray.length == 1 && menuElementArray[0] instanceof ComboPopup && ((ComboPopup)((Object)menuElementArray[0])).getList().getModel().getSize() > 0 && ((ComboPopup)((Object)menuElementArray[0])).getList().getModel().getElementAt(0).equals(JDatePopup.this.firstMonthName) || JDatePopup.this.cbElement != null && !JDatePopup.this.cbMonth.isPopupVisible()) {
                if (menuElementArray.length > 0) {
                    JDatePopup.this.cbElement = menuElementArray[0];
                }
                MenuElement[] menuElementArray2 = new MenuElement[]{JDatePopup.this};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(JDatePopup.this.cl);
            JDatePopup.this.isIncluded1 = false;
            JDatePopup.this.setInvoker(null);
            JDatePopup.this.performCancel();
        }
    };
    boolean isIncluded1 = false;
    private JComboBox cbMonth;
    Calendar calendar = (Calendar)Calendar.getInstance().clone();
    private JSpinner spYear;
    private JSpinner spDay;
    private String firstMonthName;
    private JSpinner spTime;
    private JTable table;
    private boolean showTime;
    private ActionListener listener;
    private boolean showYear = true;
    Object[][] calendarData = new Object[7][7];
    JTable calendarTable;
    int dayIndex;
    boolean isCurrentMonth = false;
    MenuElement cbElement;
    private static Icon iconEmpty = new ImageIcon(new BufferedImage(16, 16, 6));

    public JDatePopup(boolean bl) {
        this.showTime = bl;
        this.initMenu();
    }

    public JDatePopup(boolean bl, boolean bl2) {
        this.showTime = bl;
        this.showYear = bl2;
        this.initMenu();
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
    }

    public Date getDate() {
        if (!this.showTime) {
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
        }
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void showPopup(Component component, Date date) {
        this.setDate(date);
        this.updateCalendarData();
        this.show(component, 0, component.getHeight());
        this.spYear.requestFocus();
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
        if (bl) {
            if (!this.isIncluded1) {
                MenuSelectionManager.defaultManager().addChangeListener(this.cl);
            }
            this.isIncluded1 = true;
        }
    }

    private void initMenu() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.setBackground(UIManager.getColor("ComboBox.background"));
        this.add("West", this.createLeftPanel());
        this.add("Center", this.createCalendarPanel());
        this.add("South", this.createBtnPanel());
        this.pack();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (JDatePopup.this.cbElement != null) {
                    JDatePopup.this.cbElement.menuSelectionChanged(false);
                    JDatePopup.this.cbElement = null;
                }
            }
        });
    }

    JPanel createBtnPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 6, 6));
        JButton jButton = new JButton("    OK    ");
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.resource.getString("Cancel"));
        jButton2.setMargin(new Insets(1, 1, 1, 1));
        jPanel.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDatePopup.this.performOK();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDatePopup.this.performCancel();
            }
        });
        return jPanel;
    }

    JPanel createLeftPanel() {
        this.cbMonth = new JComboBox<String>(new DateFormatSymbols().getMonths());
        this.firstMonthName = (String)this.cbMonth.getItemAt(0);
        this.cbMonth.removeItemAt(12);
        this.cbMonth.setMaximumRowCount(12);
        this.cbMonth.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (JDatePopup.this.cbElement != null) {
                    JDatePopup.this.cbElement.menuSelectionChanged(false);
                    JDatePopup.this.cbElement = null;
                }
                JDatePopup.this.updateCalendarData();
            }
        });
        this.cbMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getModifiers() != 16) {
                    return;
                }
                if (JDatePopup.this.cbElement != null) {
                    JDatePopup.this.cbElement.menuSelectionChanged(false);
                    JDatePopup.this.cbElement = null;
                }
                JDatePopup.this.calendar.set(2, JDatePopup.this.cbMonth.getSelectedIndex());
                JDatePopup.this.updateCalendarData();
            }
        });
        this.cbMonth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 != keyEvent.getKeyCode()) {
                    return;
                }
                if (JDatePopup.this.cbElement != null) {
                    JDatePopup.this.cbElement.menuSelectionChanged(false);
                    JDatePopup.this.cbElement = null;
                }
                JDatePopup.this.calendar.set(2, JDatePopup.this.cbMonth.getSelectedIndex());
                JDatePopup.this.updateCalendarData();
            }
        });
        this.cbMonth.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (JDatePopup.this.cbElement != null) {
                    JDatePopup.this.cbElement.menuSelectionChanged(false);
                    JDatePopup.this.cbElement = null;
                }
                JDatePopup.this.updateCalendarData();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        this.spYear = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.spYear, "yyyy");
        ((DefaultFormatter)dateEditor.getTextField().getFormatter()).setAllowsInvalid(false);
        ((DefaultFormatter)dateEditor.getTextField().getFormatter()).setOverwriteMode(true);
        ((DateFormat)((DateFormatter)((DefaultFormatter)dateEditor.getTextField().getFormatter())).getFormat()).setLenient(false);
        this.spYear.setEditor(dateEditor);
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Calendar calendar = (Calendar)Calendar.getInstance().clone();
                calendar.setTime((Date)JDatePopup.this.spYear.getValue());
                JDatePopup.this.calendar.set(1, calendar.get(1));
                JDatePopup.this.updateCalendarData();
            }
        });
        this.spDay = new JSpinner(new SpinnerNumberModel(1, 1, 31, 1));
        this.spDay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JDatePopup.this.calendar.set(5, (Integer)JDatePopup.this.spDay.getValue());
                JDatePopup.this.updateCalendarData();
            }
        });
        JButton jButton = new JButton(this.loadIcon("today.png"));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDatePopup.this.calendar = (Calendar)Calendar.getInstance().clone();
                JDatePopup.this.updateCalendarData();
            }
        });
        jButton.setToolTipText(this.resource.getString("Today"));
        if (this.showTime) {
            this.spTime = new JSpinner(new SpinnerDateModel());
            JSpinner.DateEditor dateEditor2 = new JSpinner.DateEditor(this.spTime, "HH:mm:ss");
            ((DefaultFormatter)dateEditor2.getTextField().getFormatter()).setAllowsInvalid(false);
            ((DefaultFormatter)dateEditor2.getTextField().getFormatter()).setOverwriteMode(true);
            ((DateFormat)((DateFormatter)((DefaultFormatter)dateEditor2.getTextField().getFormatter())).getFormat()).setLenient(false);
            this.spTime.setEditor(dateEditor2);
            this.spTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Calendar calendar = (Calendar)JDatePopup.this.calendar.clone();
                    calendar.setTime((Date)JDatePopup.this.spTime.getValue());
                    JDatePopup.this.calendar.set(11, calendar.get(11));
                    JDatePopup.this.calendar.set(12, calendar.get(12));
                    JDatePopup.this.calendar.set(13, calendar.get(13));
                    JDatePopup.this.updateCalendarData();
                }
            });
            JButton jButton2 = new JButton(this.loadIcon("00.png"));
            jButton2.setMargin(new Insets(0, 0, 0, 0));
            jButton2.setToolTipText(this.resource.getString("00"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Calendar calendar = (Calendar)JDatePopup.this.calendar.clone();
                    calendar.setTime((Date)JDatePopup.this.spTime.getValue());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    JDatePopup.this.spTime.setValue(calendar.getTime());
                }
            });
            JButton jButton3 = new JButton(this.loadIcon("24.png"));
            jButton3.setMargin(new Insets(0, 0, 0, 0));
            jButton3.setToolTipText(this.resource.getString("24"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Calendar calendar = (Calendar)JDatePopup.this.calendar.clone();
                    calendar.setTime((Date)JDatePopup.this.spTime.getValue());
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    JDatePopup.this.spTime.setValue(calendar.getTime());
                }
            });
            JButton jButton4 = new JButton(this.loadIcon("sharp_time.png"));
            jButton4.setMargin(new Insets(0, 0, 0, 0));
            jButton4.setToolTipText(this.resource.getString("Current"));
            jButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JDatePopup.this.spTime.setValue(Calendar.getInstance().getTime());
                }
            });
            jPanel.add((Component)new JSeparator(0), new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
            jPanel.add((Component)this.spTime, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
            jPanel.add((Component)jButton2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            jPanel.add((Component)jButton4, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            jPanel.add((Component)jButton3, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        }
        if (this.showYear) {
            jPanel.add((Component)this.spYear, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        }
        jPanel.add((Component)this.cbMonth, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this.spDay, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 0, insets, 0, 0));
        jPanel.setBorder(new EmptyBorder(3, 4, 6, 2));
        return jPanel;
    }

    void updateCalendarData() {
        int n;
        this.isCurrentMonth = this.calendar.get(1) == Calendar.getInstance().get(1) && this.calendar.get(2) == Calendar.getInstance().get(2);
        this.spYear.setValue(this.calendar.getTime());
        this.spDay.setValue(this.calendar.get(5));
        ((SpinnerNumberModel)this.spDay.getModel()).setMaximum(Integer.valueOf(this.calendar.getActualMaximum(5) + 1));
        ((SpinnerNumberModel)this.spDay.getModel()).setMinimum(Integer.valueOf(0));
        if (this.cbMonth.getSelectedIndex() != this.calendar.get(2)) {
            this.cbMonth.setSelectedIndex(this.calendar.get(2));
        }
        if (this.spTime != null) {
            this.spTime.getModel().setValue(this.calendar.getTime());
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        int n2 = (calendar.get(7) + 5) % 7;
        for (n = 0; n < 42; ++n) {
            this.calendarData[1 + n / 7][n % 7] = "";
        }
        for (n = 0; n < calendar.getActualMaximum(5); ++n) {
            int n3 = n2 + n + 7;
            this.calendarData[n3 / 7][n3 % 7] = n + 1;
        }
        this.dayIndex = n2 + this.calendar.get(5) - 1;
        if (null != this.calendarTable) {
            this.table.getSelectionModel().setLeadSelectionIndex(1 + this.dayIndex / 7);
            this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(this.dayIndex % 7);
            this.calendarTable.repaint();
        }
    }

    JComponent createCalendarPanel() {
        int n;
        String[] stringArray = new DateFormatSymbols().getShortWeekdays();
        for (n = 1; n < 8; ++n) {
            this.calendarData[0][n - 1] = stringArray[n % 7 + 1];
        }
        this.updateCalendarData();
        this.table = new JTable(new TableModel(){

            @Override
            public int getRowCount() {
                return 7;
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public String getColumnName(int n) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return JDatePopup.this.calendarData[n][n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }

            @Override
            public void addTableModelListener(TableModelListener tableModelListener) {
            }

            @Override
            public void removeTableModelListener(TableModelListener tableModelListener) {
            }
        });
        this.table.setGridColor(Color.GRAY);
        this.table.setBorder(new EtchedBorder());
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setFont(jTable.getFont());
                this.setValue(object);
                if (n == 0) {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                } else if (n % 2 == 1) {
                    this.setBackground(Color.WHITE);
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                }
                this.setForeground(Color.BLACK);
                if (n > 0 && object != null && JDatePopup.this.isCurrentMonth && object.equals(Calendar.getInstance().get(5))) {
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
                if (JDatePopup.this.dayIndex == n * 7 + n2 - 7) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else if (bl2 && object instanceof Integer) {
                    JDatePopup.this.dayIndex = n * 7 + n2 - 7;
                    JDatePopup.this.calendar.set(5, (Integer)object);
                    JDatePopup.this.updateCalendarData();
                } else if (bl2) {
                    if (n > 3) {
                        JDatePopup.this.calendar.set(5, JDatePopup.this.calendar.getActualMaximum(5) + 1);
                    } else {
                        JDatePopup.this.calendar.set(5, 0);
                    }
                    JDatePopup.this.updateCalendarData();
                }
                this.setHorizontalAlignment(0);
                this.setVerticalAlignment(0);
                return this;
            }
        });
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39 && 6 == JDatePopup.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()) {
                    JDatePopup.this.calendar.set(5, JDatePopup.this.calendar.get(5) + 1);
                    JDatePopup.this.updateCalendarData();
                } else if (keyEvent.getKeyCode() == 37 && 0 == JDatePopup.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()) {
                    JDatePopup.this.calendar.set(5, JDatePopup.this.calendar.get(5) - 1);
                    JDatePopup.this.updateCalendarData();
                } else if (keyEvent.getKeyCode() == 38 && 1 == JDatePopup.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()) {
                    JDatePopup.this.calendar.set(5, 0);
                    JDatePopup.this.updateCalendarData();
                } else if (keyEvent.getKeyCode() == 40 && 7 == JDatePopup.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()) {
                    JDatePopup.this.calendar.set(5, JDatePopup.this.calendar.getActualMaximum(5) + 1);
                    JDatePopup.this.updateCalendarData();
                } else {
                    return;
                }
                keyEvent.setKeyCode(0);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    JDatePopup.this.performOK();
                }
            }
        });
        for (n = 0; n < 7; ++n) {
            this.table.getColumnModel().getColumn(n).setPreferredWidth(25);
        }
        this.table.setRowHeight(18);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add(this.table);
        this.calendarTable = this.table;
        return jPanel;
    }

    JComponent createCalendatPanel0() {
        Object object;
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(6, 0, 6, 6));
        jPanel.setLayout(new GridLayout(6, 7, 4, 4));
        for (n = 1; n < 8; ++n) {
            object = new DateFormatSymbols().getShortWeekdays();
            JLabel jLabel = new JLabel(object[n % 7 + 1], 0);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setBackground(Color.BLUE);
            jPanel.add(jLabel);
        }
        for (n = 0; n < 35; ++n) {
            object = new JLabel("" + n, 0);
            jPanel.add((Component)object);
        }
        return jPanel;
    }

    void performOK() {
        this.setVisible(false);
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 1, ""));
        }
    }

    void performCancel() {
        this.setVisible(false);
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    Icon loadIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        Logger.getRootLogger().error("" + this.getClass() + ": cannot find resource " + string);
        return iconEmpty;
    }
}

