/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing;

import biz.netup.swing.event.TabEvent;
import biz.netup.swing.event.TabListener;
import biz.netup.swing.plaf.AdvancedTabbedPaneUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class JAdvancedTabbedPane
extends JTabbedPane {
    private static final String uiClassID = "AdvancedTabbedPaneUI";
    Vector<Component> mruTabs = new Vector();
    private CloseButtonListener closeButtonListener = new CloseButtonListener();
    private HashMap<Component, Vector<TabListener>> listeners = new HashMap();

    public JAdvancedTabbedPane() {
    }

    public JAdvancedTabbedPane(int n) {
        super(n);
    }

    public JAdvancedTabbedPane(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void updateUI() {
        this.setUI((AdvancedTabbedPaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public AdvancedTabbedPaneUI getUI() {
        return (AdvancedTabbedPaneUI)this.ui;
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.addCloseButton(component);
        this.fireTabOpened(component);
    }

    @Override
    public void removeTabAt(int n) {
        Component component = this.getComponentAt(n);
        this.removeCloseButton(component);
        super.removeTabAt(n);
        this.fireTabClosed(component);
        this.mruTabs.remove(component);
        if (this.mruTabs.size() > 0) {
            Component component2 = this.mruTabs.get(0);
            this.setSelectedComponent(component2);
        }
        this.fireTabActivated(this.getSelectedComponent());
    }

    @Override
    public void setSelectedIndex(int n) {
        int n2 = this.getSelectedIndex();
        if (n2 != n) {
            this.fireTabDeactivated(this.getSelectedComponent());
        }
        super.setSelectedIndex(n);
        if (n2 != n) {
            this.fireTabActivated(this.getSelectedComponent());
        }
        if (this.mruTabs.contains(this.getSelectedComponent())) {
            this.mruTabs.remove(this.getSelectedComponent());
        }
        this.mruTabs.insertElementAt(this.getSelectedComponent(), 0);
    }

    protected void addCloseButton(Component component) {
        AdvancedTabbedPaneUI.CloseButton closeButton = this.getUI().createCloseButton(component);
        closeButton.addActionListener(this.closeButtonListener);
        super.add((Component)closeButton, 0);
    }

    protected void removeCloseButton(Component component) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            AdvancedTabbedPaneUI.CloseButton closeButton;
            Component component2 = this.getComponent(i);
            if (!(component2 instanceof AdvancedTabbedPaneUI.CloseButton) || (closeButton = (AdvancedTabbedPaneUI.CloseButton)component2).getAssociatedComponent() != component) continue;
            closeButton.removeActionListener(this.closeButtonListener);
            this.remove(closeButton);
            break;
        }
    }

    public synchronized void addTabListener(Component component, TabListener tabListener) {
        Vector<TabListener> vector = this.listeners.get(component);
        if (vector == null) {
            vector = new Vector();
            this.listeners.put(component, vector);
        }
        if (!vector.contains(tabListener)) {
            vector.add(tabListener);
        }
    }

    public synchronized void removeTabListener(Component component, TabListener tabListener) {
        Vector<TabListener> vector = this.listeners.get(component);
        if (vector != null) {
            vector.remove(tabListener);
        }
    }

    protected void fireTabActivated(Component component) {
        if (!this.listeners.containsKey(component)) {
            return;
        }
        Vector vector = new Vector(this.listeners.get(component));
        TabEvent tabEvent = new TabEvent(this, component, 205);
        tabEvent.setSource(component);
        if (vector != null) {
            for (TabListener tabListener : vector) {
                tabListener.tabActivated(tabEvent);
            }
        }
    }

    protected void fireTabClosing(Component component) {
        if (!this.listeners.containsKey(component)) {
            return;
        }
        Vector vector = new Vector(this.listeners.get(component));
        TabEvent tabEvent = new TabEvent(this, component, 201);
        tabEvent.setSource(component);
        if (vector != null) {
            for (TabListener tabListener : vector) {
                tabListener.tabClosing(tabEvent);
            }
        }
    }

    protected void fireTabClosed(Component component) {
        if (!this.listeners.containsKey(component)) {
            return;
        }
        Vector vector = new Vector(this.listeners.get(component));
        TabEvent tabEvent = new TabEvent(this, component, 202);
        tabEvent.setSource(component);
        if (vector != null) {
            for (TabListener tabListener : vector) {
                tabListener.tabClosed(tabEvent);
            }
        }
    }

    protected void fireTabDeactivated(Component component) {
        if (!this.listeners.containsKey(component)) {
            return;
        }
        Vector vector = new Vector(this.listeners.get(component));
        TabEvent tabEvent = new TabEvent(this, component, 206);
        tabEvent.setSource(component);
        if (vector != null) {
            for (TabListener tabListener : vector) {
                tabListener.tabDeactivated(tabEvent);
            }
        }
    }

    protected void fireTabOpened(Component component) {
        if (!this.listeners.containsKey(component)) {
            return;
        }
        Vector vector = new Vector(this.listeners.get(component));
        TabEvent tabEvent = new TabEvent(this, component, 200);
        tabEvent.setSource(component);
        if (vector != null) {
            for (TabListener tabListener : vector) {
                tabListener.tabOpened(tabEvent);
            }
        }
    }

    protected class CloseButtonListener
    implements ActionListener {
        protected CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof AdvancedTabbedPaneUI.CloseButton) {
                AdvancedTabbedPaneUI.CloseButton closeButton = (AdvancedTabbedPaneUI.CloseButton)object;
                Component component = closeButton.getAssociatedComponent();
                JAdvancedTabbedPane.this.fireTabClosing(component);
            }
        }
    }
}

