/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.user.contact;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaCreateContract;
import biz.netup.control.transport.urfa.functions.UrfaGetDocumentTemplatesList;
import biz.netup.control.transport.urfa.functions.UrfaUploadContract;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class UserDocumentDialog
extends DialogModel
implements ActionListener {
    private JComboBox templateIdCb;
    private JTextField fileField;
    private JTextField nameField;
    private JButton chooseButton;
    private JPanel mainPanel;
    private Map<String, Integer> docList;
    private byte[] odtData;
    private int uid;

    public UserDocumentDialog() {
        this.$$$setupUI$$$();
    }

    public UserDocumentDialog(Map<String, Object> map, int n) {
        super(map);
        this.uid = n;
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.mainPanel.setPreferredSize(new Dimension(450, 100));
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "New contract";
    }

    private int getSelectedTemlate() {
        Integer n = this.docList.get(this.templateIdCb.getSelectedItem());
        return n == null ? 0 : n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.templateIdCb) {
            this.chooseButton.setEnabled(this.getSelectedTemlate() == 0);
            this.nameField.setEnabled(this.getSelectedTemlate() == 0);
        } else if (actionEvent.getSource() == this.chooseButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    return file.canRead() && file.length() > 0L && string.length() > 4 && string.substring(string.length() - 4, string.length()).toLowerCase().compareTo(".odt") == 0;
                }

                @Override
                public String getDescription() {
                    return "*.odt";
                }
            });
            if (jFileChooser.showOpenDialog(this.mainPanel) == 0) {
                File file = jFileChooser.getSelectedFile();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.error(fileNotFoundException);
                }
                try {
                    this.odtData = new byte[fileInputStream.available()];
                    fileInputStream.read(this.odtData);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.log.error(iOException);
                    this.odtData = null;
                    return;
                }
                if (this.nameField.getText().length() == 0) {
                    this.nameField.setText(jFileChooser.getSelectedFile().getName());
                }
                this.fileField.setText(jFileChooser.getSelectedFile().getName() + " (" + this.odtData.length + ")");
            }
        }
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.templateIdCb.addActionListener(this);
        this.chooseButton.addActionListener(this);
        this.docList = new HashMap<String, Integer>();
        this.templateIdCb.addItem("[" + this.resource.getString("Load from file") + "]");
        UrfaGetDocumentTemplatesList urfaGetDocumentTemplatesList = new UrfaGetDocumentTemplatesList(UrfaManagerImpl.getInstance());
        urfaGetDocumentTemplatesList.call();
        for (int i = 0; i < urfaGetDocumentTemplatesList.getCnt(); ++i) {
            if (urfaGetDocumentTemplatesList.getDocTypeArray1()[i] != 6) continue;
            String string = this.resource.getString("Template") + ": " + urfaGetDocumentTemplatesList.getNameArray1()[i] + " (" + urfaGetDocumentTemplatesList.getTemplateIdArray1()[i] + ")";
            this.docList.put(string, urfaGetDocumentTemplatesList.getTemplateIdArray1()[i]);
            this.templateIdCb.addItem(string);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.getSelectedTemlate() != 0) {
            UrfaCreateContract urfaCreateContract = new UrfaCreateContract(UrfaManagerImpl.getInstance());
            urfaCreateContract.setUserId(this.uid);
            urfaCreateContract.setTemplateId(this.getSelectedTemlate());
            urfaCreateContract.call();
        } else {
            UrfaUploadContract urfaUploadContract = new UrfaUploadContract(UrfaManagerImpl.getInstance());
            urfaUploadContract.setData(this.odtData);
            urfaUploadContract.setUserId(this.uid);
            urfaUploadContract.setName(this.nameField.getText());
            urfaUploadContract.call();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (this.getSelectedTemlate() == 0) {
            this.checkName(this.nameField, "Name");
        }
        if (!this.settingListeners && this.getSelectedTemlate() == 0) {
            if (this.odtData == null) {
                this.log.log(1, this.resource.getString("Contract file not specified"));
                throw new IllegalArgumentException("Contract file not specified");
            }
            if (this.odtData.length < 16 || this.odtData[0] != 80 || this.odtData[1] != 75) {
                this.log.log(1, this.resource.getString("Invalid file format"));
                throw new IllegalArgumentException("Invalid file format");
            }
        }
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Reason of creation"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        this.templateIdCb = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.templateIdCb.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.templateIdCb, gridBagConstraints);
        this.fileField = new JTextField();
        this.fileField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.fileField, gridBagConstraints);
        this.nameField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameField, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        this.chooseButton = new JButton();
        this.$$$loadButtonText$$$(this.chooseButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Choose"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.chooseButton, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

