/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.user;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDelDoc;
import biz.netup.control.transport.urfa.functions.UrfaGenerateDocForUserNew;
import biz.netup.control.transport.urfa.functions.UrfaGetDocsList;
import biz.netup.control.transport.urfa.functions.UrfaSignDoc;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.MainTemplatesTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.templates.PrintEditDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class UserContractsTab
extends TabPanelWithTable {
    private int uid;

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public String getGroupName() {
        return "User";
    }

    public UserContractsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/contracts_24.png")));
        this.setRefreshPermission(new int[]{28726});
        this.setAddPermission(new int[]{28708, 28706, 28729});
        this.setEditPermission(new int[]{28722, 28721});
        this.setReadPermission(new int[]{28722});
        this.setDeletePermission(new int[]{28725});
        this.uid = n;
    }

    @Override
    public String getTabName() {
        return "Contracts";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("system_id", "System ID");
        linkedHashMap.put("template_id", "Template ID");
        linkedHashMap.put("date_of_creation", "Date of creation");
        linkedHashMap.put("signed", "Signed");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        UrfaGetDocsList urfaGetDocsList = new UrfaGetDocsList(UrfaManagerImpl.getInstance());
        urfaGetDocsList.setDocType(3);
        urfaGetDocsList.setGround(this.uid);
        urfaGetDocsList.call();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetDocsList.getRetCodeCount(); ++i) {
            HashMap<String, Comparable<Integer>> hashMap = new HashMap<String, Comparable<Integer>>();
            hashMap.put("system_id", Integer.valueOf(urfaGetDocsList.getId1()[i]));
            hashMap.put("template_id", Integer.valueOf(urfaGetDocsList.getDocTemplateId1()[i]));
            hashMap.put("date_of_creation", new Date((long)urfaGetDocsList.getGenDate1()[i] * 1000L));
            hashMap.put("signed", Integer.valueOf(urfaGetDocsList.getIsSign1()[i]));
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDelDoc urfaDelDoc = new UrfaDelDoc(UrfaManagerImpl.getInstance());
        urfaDelDoc.setDocId((Integer)map.get("system_id"));
        urfaDelDoc.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected void init() {
        super.init();
        this.addButton.setText(this.resource.getString("Generate"));
        JButton jButton = new JButton(this.resource.getString("Sign"));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edit16.png")));
        Permissions.apply((JComponent)jButton, "contract_sign");
        this.getAdditionalButtonPanel2().add(jButton);
        this.mainTablePanel.registerOneRowButton(jButton);
        this.mainTablePanel.registerFieldButton(this.deleteButton, "signed", 0);
        this.mainTablePanel.registerFieldButton(this.editButton, "signed", 0);
        this.mainTablePanel.registerFieldButton(jButton, "signed", 0);
        this.getReadPanel().setVisible(true);
        this.getMainTablePanel().setCellRenderer("signed", new CheckboxCellRenderer());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UrfaSignDoc urfaSignDoc = new UrfaSignDoc(UrfaManagerImpl.getInstance());
                urfaSignDoc.setDocId((Integer)UserContractsTab.this.mainTablePanel.getSelectedTableRows()[0].get("system_id"));
                try {
                    urfaSignDoc.call();
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                }
                UserContractsTab.this.refresh();
            }
        });
    }

    @Override
    protected void add() {
        MainTemplatesTab mainTemplatesTab = new MainTemplatesTab();
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(mainTemplatesTab);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(3);
        selectFromTableDialogModel.filterInverse(hashSet, "type_id");
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            UrfaGenerateDocForUserNew urfaGenerateDocForUserNew = new UrfaGenerateDocForUserNew(UrfaManagerImpl.getInstance());
            urfaGenerateDocForUserNew.setBaseId(this.uid);
            urfaGenerateDocForUserNew.setDocTemplateId((Integer)selectFromTableDialogModel.getItem().get("template_id"));
            urfaGenerateDocForUserNew.setDocTypeId(3);
            urfaGenerateDocForUserNew.setUserId(this.uid);
            try {
                urfaGenerateDocForUserNew.call();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
            this.refresh();
        }
    }

    @Override
    protected void edit() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("system_id", this.mainTablePanel.getSelectedTableRows()[0].get("system_id"));
        hashMap.put("template_id", this.mainTablePanel.getSelectedTableRows()[0].get("template_id"));
        hashMap.put("edit", "edit");
        if (new PrintEditDialog(hashMap).runEdit()) {
            this.refresh();
        }
    }

    @Override
    protected void read() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("system_id", this.mainTablePanel.getSelectedTableRows()[0].get("system_id"));
        hashMap.put("template_id", this.mainTablePanel.getSelectedTableRows()[0].get("template_id"));
        hashMap.put("edit", "edit");
        PrintEditDialog printEditDialog = new PrintEditDialog(hashMap);
        printEditDialog.setReadMode();
        printEditDialog.run();
    }

    @Override
    protected void isEditVisible(JMenuItem jMenuItem) {
        if ((Integer)this.mainTablePanel.getSelectedTableRows()[0].get("signed") == 1) {
            jMenuItem.setVisible(false);
        }
    }

    @Override
    protected void isDeleteVisible(JMenuItem jMenuItem) {
        for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
            if ((Integer)map.get("signed") != 1) continue;
            jMenuItem.setVisible(false);
        }
    }

    @Override
    protected void doubleClick() {
        this.read();
    }
}

