/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tp;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.GetTechParamByUidInt;
import biz.netup.control.transport.urfa.functions.UrfaDealerDelTechParam;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetTechParamByUid;
import biz.netup.control.transport.urfa.functions.UrfaDelTechParam;
import biz.netup.control.transport.urfa.functions.UrfaGetTechParamByUid;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.accountpanel.AccountComboBox;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.tp.tpdialogs.TPDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class UserTechParamsTab
extends TabPanelWithTable {
    private int uid;
    AccountComboBox acb;

    public UserTechParamsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/tech_parameters_24.png")));
        if (Utils.isAdmin()) {
            this.setRefreshPermission(new int[]{8243, 36864});
            this.setAddPermission(new int[]{36866, 36867, 36868});
            this.setEditPermission(new int[]{36869, 36867, 36868});
            this.setDeletePermission(new int[]{36865});
        } else {
            this.setRefreshPermission(new int[]{0x70000075});
            this.setAddPermission(new int[]{0x70000073});
            this.setEditPermission(new int[]{0x70000074});
            this.setDeletePermission(new int[]{0x70000076});
        }
        this.uid = n;
        this.acb = new AccountComboBox(n, this);
        this.acb.refresh();
        this.getBottomPanel().add((Component)this.acb.getPanel(), "South");
    }

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public JComponent getPanel() {
        if (this.init) {
            this.acb.refresh();
        }
        return super.getPanel();
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public String getTabName() {
        return "Technical parameters";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("value", "Value");
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("link_id", "Link ID");
        linkedHashMap.put("service_name", "Service name");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        GetTechParamByUidInt getTechParamByUidInt = Utils.isAdmin() ? new UrfaGetTechParamByUid(UrfaManagerImpl.getInstance()) : new UrfaDealerGetTechParamByUid(UrfaManagerImpl.getInstance());
        getTechParamByUidInt.setAccountId(this.acb.getAid());
        getTechParamByUidInt.setUserId(this.uid);
        getTechParamByUidInt.call();
        boolean bl = false;
        for (int i = 0; i < getTechParamByUidInt.getSlinksCount(); ++i) {
            for (int j = 0; j < getTechParamByUidInt.getParamsCount1()[i]; ++j) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", getTechParamByUidInt.getId2()[i][j]);
                hashMap.put("value", getTechParamByUidInt.getParam2()[i][j]);
                hashMap.put("type", getTechParamByUidInt.getTypeName2()[i][j]);
                hashMap.put("type_id", getTechParamByUidInt.getTypeId2()[i][j]);
                hashMap.put("link_id", getTechParamByUidInt.getSlinkId2()[i][j]);
                hashMap.put("service_name", getTechParamByUidInt.getServiceName2()[i][j]);
                hashMap.put("password", getTechParamByUidInt.getPassword2()[i][j]);
                hashMap.put("date", new Date((long)getTechParamByUidInt.getRegDate2()[i][j] * 1000L));
                vector.add(hashMap);
            }
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaDelTechParam urfaDelTechParam = new UrfaDelTechParam(UrfaManagerImpl.getInstance());
            urfaDelTechParam.setSlink((Integer)map.get("link_id"));
            urfaDelTechParam.setTpid((Integer)map.get("id"));
            try {
                urfaDelTechParam.call();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        } else {
            UrfaDealerDelTechParam urfaDealerDelTechParam = new UrfaDealerDelTechParam(UrfaManagerImpl.getInstance());
            urfaDealerDelTechParam.setSlinkId((Integer)map.get("link_id"));
            urfaDealerDelTechParam.setTpId((Integer)map.get("id"));
            try {
                urfaDealerDelTechParam.call();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        map.put("uid", this.uid);
        map.put("aid", this.acb.getAid());
        return new TPDialog(map);
    }

    @Override
    protected void add() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("uid", this.uid);
        hashMap.put("aid", this.acb.getAid());
        new TPDialog(hashMap).run(this);
    }

    @Override
    protected void init() {
        super.init();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserTechParamsTab.this.acb.refresh();
            }
        });
    }
}

