/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaAddCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheme;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetPeriodicServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheme;
import biz.netup.control.transport.urfa.functions.UrfaGetPeriodicServiceEx;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.coeff.MainCoeffSchemeTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;

public class SchemeComboBoxWrapper {
    private JDateTime startScheduleDateDateTime;
    private JComboBox schemeCB;
    private Map<String, Integer> schemeMap;
    private boolean isEnabled;
    private static final Logger logger = Utils.getLogger();

    SchemeComboBoxWrapper(JDateTime jDateTime, JComboBox jComboBox) {
        this.startScheduleDateDateTime = jDateTime;
        this.schemeCB = jComboBox;
        this.schemeMap = new HashMap<String, Integer>();
        this.isEnabled = true;
        MainCoeffSchemeTab mainCoeffSchemeTab = new MainCoeffSchemeTab();
        try {
            this.loadSchemes(mainCoeffSchemeTab.setTableData());
        }
        catch (UrfaException urfaException) {
            logger.error("Cannot load TC", urfaException);
            return;
        }
    }

    public void loadSchemes(Vector<Map<String, Object>> vector) {
        this.schemeMap.put("", 0);
        this.schemeCB.addItem("");
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            this.schemeMap.put((String)map.get("name"), (Integer)map.get("id"));
            this.schemeCB.addItem((String)map.get("name"));
        }
    }

    public void setScheme(int n) {
        for (String string : this.schemeMap.keySet()) {
            if (this.schemeMap.get(string) != n) continue;
            this.schemeCB.setSelectedItem(string);
            return;
        }
        this.schemeCB.setSelectedIndex(0);
    }

    public int getSchemeId() {
        for (String string : this.schemeMap.keySet()) {
            if (string != this.schemeCB.getSelectedItem()) continue;
            return this.schemeMap.get(string);
        }
        return 0;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setSchemeIdByServiceId(int n) {
        if (!this.isEnabled) {
            return;
        }
        try {
            if (Utils.isAdmin()) {
                UrfaGetPeriodicServiceEx urfaGetPeriodicServiceEx = new UrfaGetPeriodicServiceEx(UrfaManagerImpl.getInstance());
                urfaGetPeriodicServiceEx.setSid(n);
                urfaGetPeriodicServiceEx.call();
                int n2 = urfaGetPeriodicServiceEx.getSchemeId();
                this.setScheme(n2);
            } else {
                UrfaDealerGetPeriodicServiceEx urfaDealerGetPeriodicServiceEx = new UrfaDealerGetPeriodicServiceEx(UrfaManagerImpl.getInstance());
                urfaDealerGetPeriodicServiceEx.setSid(n);
                urfaDealerGetPeriodicServiceEx.call();
                int n3 = urfaDealerGetPeriodicServiceEx.getSchemeId();
                this.setScheme(n3);
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public void setSchemeIdBySlinkId(int n) {
        try {
            if (Utils.isAdmin()) {
                UrfaGetCoeffScheduleLinkList urfaGetCoeffScheduleLinkList = new UrfaGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                urfaGetCoeffScheduleLinkList.call();
                int n2 = 0;
                for (int i = 0; i < urfaGetCoeffScheduleLinkList.getListSize(); ++i) {
                    if (urfaGetCoeffScheduleLinkList.getSlinkId1()[i] != n) continue;
                    n2 = urfaGetCoeffScheduleLinkList.getSchemeId1()[i];
                    break;
                }
                this.setScheme(n2);
            } else {
                UrfaDealerGetCoeffScheduleLinkList urfaDealerGetCoeffScheduleLinkList = new UrfaDealerGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                urfaDealerGetCoeffScheduleLinkList.call();
                int n3 = 0;
                for (int i = 0; i < urfaDealerGetCoeffScheduleLinkList.getListSize(); ++i) {
                    if (urfaDealerGetCoeffScheduleLinkList.getSlinkId1()[i] != n) continue;
                    n3 = urfaDealerGetCoeffScheduleLinkList.getSchemeId1()[i];
                    break;
                }
                this.setScheme(n3);
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
        this.setEnabled(false);
    }

    private int createScheduleByScheme() {
        if (this.getSchemeId() == 0) {
            return 0;
        }
        try {
            if (Utils.isAdmin()) {
                UrfaGetCoeffScheme urfaGetCoeffScheme = new UrfaGetCoeffScheme(UrfaManagerImpl.getInstance());
                urfaGetCoeffScheme.setSchemeId(this.getSchemeId());
                urfaGetCoeffScheme.call();
                if (urfaGetCoeffScheme.getId() == 0) {
                    return 0;
                }
                int[] nArray = new int[urfaGetCoeffScheme.getItemsSize()];
                int[] nArray2 = new int[urfaGetCoeffScheme.getItemsSize()];
                int[] nArray3 = new int[urfaGetCoeffScheme.getItemsSize()];
                for (int i = 0; i < urfaGetCoeffScheme.getItemsSize(); ++i) {
                    nArray2[i] = urfaGetCoeffScheme.getDelay1()[i];
                    nArray3[i] = urfaGetCoeffScheme.getDuration1()[i];
                    nArray[i] = 0;
                }
                UrfaAddCoeffSchedule urfaAddCoeffSchedule = new UrfaAddCoeffSchedule(UrfaManagerImpl.getInstance());
                urfaAddCoeffSchedule.setId(0);
                urfaAddCoeffSchedule.setItemsSize(urfaGetCoeffScheme.getItemsSize());
                urfaAddCoeffSchedule.setScheduleId1(nArray);
                urfaAddCoeffSchedule.setStartDate1(nArray2);
                urfaAddCoeffSchedule.setEndDate1(nArray3);
                urfaAddCoeffSchedule.setCoeff1(urfaGetCoeffScheme.getCoeff1());
                urfaAddCoeffSchedule.call();
                return urfaAddCoeffSchedule.getId();
            }
            UrfaDealerGetCoeffScheme urfaDealerGetCoeffScheme = new UrfaDealerGetCoeffScheme(UrfaManagerImpl.getInstance());
            urfaDealerGetCoeffScheme.setSchemeId(this.getSchemeId());
            urfaDealerGetCoeffScheme.call();
            if (urfaDealerGetCoeffScheme.getId() == 0) {
                return 0;
            }
            int[] nArray = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            int[] nArray4 = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            int[] nArray5 = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            for (int i = 0; i < urfaDealerGetCoeffScheme.getItemsSize(); ++i) {
                nArray4[i] = urfaDealerGetCoeffScheme.getDelay1()[i];
                nArray5[i] = urfaDealerGetCoeffScheme.getDuration1()[i];
                nArray[i] = 0;
            }
            UrfaDealerAddCoeffSchedule urfaDealerAddCoeffSchedule = new UrfaDealerAddCoeffSchedule(UrfaManagerImpl.getInstance());
            urfaDealerAddCoeffSchedule.setId(0);
            urfaDealerAddCoeffSchedule.setItemsSize(urfaDealerGetCoeffScheme.getItemsSize());
            urfaDealerAddCoeffSchedule.setScheduleId1(nArray);
            urfaDealerAddCoeffSchedule.setStartDate1(nArray4);
            urfaDealerAddCoeffSchedule.setEndDate1(nArray5);
            urfaDealerAddCoeffSchedule.setCoeff1(urfaDealerGetCoeffScheme.getCoeff1());
            urfaDealerAddCoeffSchedule.call();
            return urfaDealerAddCoeffSchedule.getId();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
            return 0;
        }
    }

    public double getCostCoefficient() {
        if (this.getSchemeId() == 0) {
            return -1.0;
        }
        try {
            if (Utils.isAdmin()) {
                UrfaGetCoeffScheme urfaGetCoeffScheme = new UrfaGetCoeffScheme(UrfaManagerImpl.getInstance());
                urfaGetCoeffScheme.setSchemeId(this.getSchemeId());
                urfaGetCoeffScheme.call();
                if (urfaGetCoeffScheme.getId() == 0) {
                    return -1.0;
                }
                for (int i = urfaGetCoeffScheme.getItemsSize() - 1; i >= 0; --i) {
                    if (urfaGetCoeffScheme.getDelay1()[i] != 0) continue;
                    return urfaGetCoeffScheme.getCoeff1()[i];
                }
            } else {
                UrfaDealerGetCoeffScheme urfaDealerGetCoeffScheme = new UrfaDealerGetCoeffScheme(UrfaManagerImpl.getInstance());
                urfaDealerGetCoeffScheme.setSchemeId(this.getSchemeId());
                urfaDealerGetCoeffScheme.call();
                if (urfaDealerGetCoeffScheme.getId() == 0) {
                    return -1.0;
                }
                for (int i = urfaDealerGetCoeffScheme.getItemsSize() - 1; i >= 0; --i) {
                    if (urfaDealerGetCoeffScheme.getDelay1()[i] != 0) continue;
                    return urfaDealerGetCoeffScheme.getCoeff1()[i];
                }
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
        return -1.0;
    }

    public void CreateScheduleLink(int n) {
        if (!this.isEnabled) {
            return;
        }
        try {
            if (n == 0) {
                Dialogs.showErrorDialog(Utils.getResource().getString("SlinkId undefined"));
                return;
            }
            int n2 = this.createScheduleByScheme();
            if (n2 != 0) {
                if (Utils.isAdmin()) {
                    UrfaAddCoeffScheduleLink urfaAddCoeffScheduleLink = new UrfaAddCoeffScheduleLink(UrfaManagerImpl.getInstance());
                    urfaAddCoeffScheduleLink.setId(0);
                    urfaAddCoeffScheduleLink.setSlinkId(n);
                    urfaAddCoeffScheduleLink.setSchemeId(this.getSchemeId());
                    urfaAddCoeffScheduleLink.setScheduleId(n2);
                    urfaAddCoeffScheduleLink.setChangePolicy(0);
                    urfaAddCoeffScheduleLink.call();
                } else {
                    UrfaDealerAddCoeffScheduleLink urfaDealerAddCoeffScheduleLink = new UrfaDealerAddCoeffScheduleLink(UrfaManagerImpl.getInstance());
                    urfaDealerAddCoeffScheduleLink.setId(0);
                    urfaDealerAddCoeffScheduleLink.setSlinkId(n);
                    urfaDealerAddCoeffScheduleLink.setSchemeId(this.getSchemeId());
                    urfaDealerAddCoeffScheduleLink.setScheduleId(n2);
                    urfaDealerAddCoeffScheduleLink.setChangePolicy(0);
                    urfaDealerAddCoeffScheduleLink.call();
                }
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }
}

