/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ScheduleLink;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaAddCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheme;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetPeriodicServiceEx;
import biz.netup.control.transport.urfa.functions.UrfaEditCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaEditCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffSchedule;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheme;
import biz.netup.control.transport.urfa.functions.UrfaGetPeriodicServiceEx;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.coeff.MainCoeffScheduleTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.coeff.MainCoeffSchemeTab;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.table.DateTimeCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddScheduleLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JComboBox changePolicyCB;
    private JButton addSchemeButton;
    private JButton addScheduleButton;
    private JTextField schemeIdTextField;
    private JTextField scheduleIdTextField;
    private TablePanelImpl itemsTablePanel;
    private JDateTime startScheduleDateDateTime;
    private int scheduleLinkId = 0;
    private int slinkId = 0;
    private int scheduleId = 0;
    private int schemeId = 0;
    private int changePolicy = 0;
    private int serviceId;
    private static final Logger logger = Utils.getLogger();
    private ResourceBundleWrapper resource = Utils.getResource();
    private boolean okPressed = false;

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public AddScheduleLinkDialog(int n, int n2) {
        this();
        this.slinkId = n;
        this.serviceId = n2;
        this.LoadData();
    }

    private void setSchemeIdByServiceId(int n) {
        try {
            if (Utils.isAdmin()) {
                UrfaGetPeriodicServiceEx urfaGetPeriodicServiceEx = new UrfaGetPeriodicServiceEx(UrfaManagerImpl.getInstance());
                urfaGetPeriodicServiceEx.setSid(n);
                urfaGetPeriodicServiceEx.call();
                this.schemeId = urfaGetPeriodicServiceEx.getSchemeId();
            } else {
                UrfaDealerGetPeriodicServiceEx urfaDealerGetPeriodicServiceEx = new UrfaDealerGetPeriodicServiceEx(UrfaManagerImpl.getInstance());
                urfaDealerGetPeriodicServiceEx.setSid(n);
                urfaDealerGetPeriodicServiceEx.call();
                this.schemeId = urfaDealerGetPeriodicServiceEx.getSchemeId();
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddScheduleLinkDialog() {
        this.$$$setupUI$$$();
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(400, 400);
        this.setResizable(false);
        Dimension dimension = new Dimension(400, 400);
        this.setPreferredSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        this.setTitle(Utils.getResource().getString("Schedule link"));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddScheduleLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.addSchemeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog.this.onAddScheme();
            }
        });
        this.addScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog.this.onAddSchedule();
            }
        });
        this.changePolicyCB.addItem(Utils.getResource().getString("Create"));
        this.changePolicyCB.addItem(Utils.getResource().getString("Follow"));
        this.changePolicyCB.setSelectedIndex(this.changePolicy);
        this.scheduleIdTextField.setText(String.valueOf(this.scheduleId));
        this.schemeIdTextField.setText(String.valueOf(this.schemeId));
        this.startScheduleDateDateTime.setDate(TZ.getCoreTime());
    }

    private void createItemsTable() {
        this.itemsTablePanel = new TablePanelImpl(this.getClass().getName() + "_items", true);
        MapTableModel mapTableModel = this.itemsTablePanel.getTableModel();
        mapTableModel.addColumn("start_date", "Start date", true, true);
        mapTableModel.addColumn("end_date", "End date", true, true);
        mapTableModel.addColumn("coefficient", "Coefficient", true, true);
        this.itemsTablePanel.setEditable(true);
        this.itemsTablePanel.setAppendable(false);
        this.itemsTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(AddScheduleLinkDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(AddScheduleLinkDialog.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddScheduleLinkDialog.this.deleteItem();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddScheduleLinkDialog.this.addItem();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
            }
        });
        this.itemsTablePanel.setCellEditor("start_date", new DateTimeCellEditor(""));
        this.itemsTablePanel.setCellEditor("end_date", new DateTimeCellEditor(""));
    }

    private void addItem() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("start_date", TZ.getCoreTime());
        hashMap.put("end_date", new Date(2000000000000L));
        hashMap.put("coefficient", 1.0);
        this.itemsTablePanel.getTableModel().addRow(hashMap);
        this.schemeId = 0;
        this.schemeIdTextField.setText(String.valueOf(this.schemeId));
    }

    private void deleteItem() {
        for (Map<String, Object> map : this.itemsTablePanel.getSelectedTableRows()) {
            this.itemsTablePanel.getTableModel().removeRow(map);
        }
    }

    private void loadItemsTablePanel(int n) throws UrfaException {
        UrfaGetCoeffSchedule urfaGetCoeffSchedule = new UrfaGetCoeffSchedule(UrfaManagerImpl.getInstance());
        urfaGetCoeffSchedule.setId(n);
        urfaGetCoeffSchedule.call();
        this.itemsTablePanel.getTableModel().removeAllRows();
        for (int i = 0; i < urfaGetCoeffSchedule.getItemsSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("start_date", new Date((long)urfaGetCoeffSchedule.getStartDate1()[i] * 1000L));
            hashMap.put("end_date", new Date((long)urfaGetCoeffSchedule.getEndDate1()[i] * 1000L));
            hashMap.put("coefficient", urfaGetCoeffSchedule.getCoeff1()[i]);
            this.itemsTablePanel.getTableModel().addRow(hashMap);
        }
    }

    protected int saveSchedule() throws UrfaException {
        int[] nArray = new int[this.itemsTablePanel.getTable().getRowCount()];
        int[] nArray2 = new int[this.itemsTablePanel.getTable().getRowCount()];
        int[] nArray3 = new int[this.itemsTablePanel.getTable().getRowCount()];
        double[] dArray = new double[this.itemsTablePanel.getTable().getRowCount()];
        for (int i = 0; i < this.itemsTablePanel.getTable().getRowCount(); ++i) {
            nArray2[i] = Integer.valueOf(this.itemsTablePanel.getTableModel().data.get(i).get("start_date").toString());
            nArray3[i] = Integer.valueOf(this.itemsTablePanel.getTableModel().data.get(i).get("end_date").toString());
            dArray[i] = Double.valueOf(this.itemsTablePanel.getTableModel().data.get(i).get("coefficient").toString());
            nArray[i] = this.scheduleId;
        }
        if (this.scheduleId == 0) {
            if (Utils.isAdmin()) {
                UrfaAddCoeffSchedule urfaAddCoeffSchedule = new UrfaAddCoeffSchedule(UrfaManagerImpl.getInstance());
                urfaAddCoeffSchedule.setId(0);
                urfaAddCoeffSchedule.setItemsSize(this.itemsTablePanel.getTable().getRowCount());
                urfaAddCoeffSchedule.setScheduleId1(nArray);
                urfaAddCoeffSchedule.setStartDate1(nArray2);
                urfaAddCoeffSchedule.setEndDate1(nArray3);
                urfaAddCoeffSchedule.setCoeff1(dArray);
                urfaAddCoeffSchedule.call();
                this.scheduleId = urfaAddCoeffSchedule.getId();
            } else {
                UrfaDealerAddCoeffSchedule urfaDealerAddCoeffSchedule = new UrfaDealerAddCoeffSchedule(UrfaManagerImpl.getInstance());
                urfaDealerAddCoeffSchedule.setId(0);
                urfaDealerAddCoeffSchedule.setItemsSize(this.itemsTablePanel.getTable().getRowCount());
                urfaDealerAddCoeffSchedule.setScheduleId1(nArray);
                urfaDealerAddCoeffSchedule.setStartDate1(nArray2);
                urfaDealerAddCoeffSchedule.setEndDate1(nArray3);
                urfaDealerAddCoeffSchedule.setCoeff1(dArray);
                urfaDealerAddCoeffSchedule.call();
                this.scheduleId = urfaDealerAddCoeffSchedule.getId();
            }
        } else {
            UrfaEditCoeffSchedule urfaEditCoeffSchedule = new UrfaEditCoeffSchedule(UrfaManagerImpl.getInstance());
            urfaEditCoeffSchedule.setId(this.scheduleId);
            urfaEditCoeffSchedule.setItemsSize(this.itemsTablePanel.getTable().getRowCount());
            urfaEditCoeffSchedule.setScheduleId1(nArray);
            urfaEditCoeffSchedule.setStartDate1(nArray2);
            urfaEditCoeffSchedule.setEndDate1(nArray3);
            urfaEditCoeffSchedule.setCoeff1(dArray);
            urfaEditCoeffSchedule.call();
            this.scheduleId = urfaEditCoeffSchedule.getId();
        }
        this.scheduleIdTextField.setText(String.valueOf(this.scheduleId));
        return this.scheduleId;
    }

    private void onOK() {
        try {
            if (this.slinkId == 0) {
                Dialogs.showErrorDialog(Utils.getResource().getString("SlinkId undefined"));
                this.dispose();
                return;
            }
            this.saveSchedule();
            if (this.scheduleLinkId == 0) {
                UrfaAddCoeffScheduleLink urfaAddCoeffScheduleLink = new UrfaAddCoeffScheduleLink(UrfaManagerImpl.getInstance());
                urfaAddCoeffScheduleLink.setId(0);
                urfaAddCoeffScheduleLink.setSlinkId(this.slinkId);
                urfaAddCoeffScheduleLink.setSchemeId(Integer.valueOf(this.schemeIdTextField.getText()));
                urfaAddCoeffScheduleLink.setScheduleId(Integer.valueOf(this.scheduleIdTextField.getText()));
                urfaAddCoeffScheduleLink.setChangePolicy(this.changePolicyCB.getSelectedIndex());
                urfaAddCoeffScheduleLink.call();
            } else {
                UrfaEditCoeffScheduleLink urfaEditCoeffScheduleLink = new UrfaEditCoeffScheduleLink(UrfaManagerImpl.getInstance());
                urfaEditCoeffScheduleLink.setId(this.scheduleLinkId);
                urfaEditCoeffScheduleLink.setSlinkId(this.slinkId);
                urfaEditCoeffScheduleLink.setSchemeId(Integer.valueOf(this.schemeIdTextField.getText()));
                urfaEditCoeffScheduleLink.setScheduleId(Integer.valueOf(this.scheduleIdTextField.getText()));
                urfaEditCoeffScheduleLink.setChangePolicy(this.changePolicyCB.getSelectedIndex());
                urfaEditCoeffScheduleLink.call();
            }
            this.okPressed = true;
            this.dispose();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    private void LoadData() {
        try {
            if (Utils.isAdmin()) {
                UrfaGetCoeffScheduleLinkList urfaGetCoeffScheduleLinkList = new UrfaGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                urfaGetCoeffScheduleLinkList.call();
                for (int i = 0; i < urfaGetCoeffScheduleLinkList.getListSize(); ++i) {
                    if (urfaGetCoeffScheduleLinkList.getSlinkId1()[i] != this.slinkId) continue;
                    this.scheduleId = urfaGetCoeffScheduleLinkList.getScheduleId1()[i];
                    this.schemeId = urfaGetCoeffScheduleLinkList.getSchemeId1()[i];
                    this.scheduleLinkId = urfaGetCoeffScheduleLinkList.getId1()[i];
                    this.changePolicy = urfaGetCoeffScheduleLinkList.getChangePolicy1()[i];
                    break;
                }
                if (this.scheduleId != 0) {
                    this.loadItemsTablePanel(this.scheduleId);
                }
            } else {
                UrfaDealerGetCoeffScheduleLinkList urfaDealerGetCoeffScheduleLinkList = new UrfaDealerGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                urfaDealerGetCoeffScheduleLinkList.call();
                for (int i = 0; i < urfaDealerGetCoeffScheduleLinkList.getListSize(); ++i) {
                    if (urfaDealerGetCoeffScheduleLinkList.getSlinkId1()[i] != this.slinkId) continue;
                    this.scheduleId = urfaDealerGetCoeffScheduleLinkList.getScheduleId1()[i];
                    this.schemeId = urfaDealerGetCoeffScheduleLinkList.getSchemeId1()[i];
                    this.scheduleLinkId = urfaDealerGetCoeffScheduleLinkList.getId1()[i];
                    this.changePolicy = urfaDealerGetCoeffScheduleLinkList.getChangePolicy1()[i];
                    break;
                }
                if (this.scheduleId != 0) {
                    this.loadItemsTablePanel(this.scheduleId);
                }
            }
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
        this.changePolicyCB.setSelectedIndex(this.changePolicy);
        this.scheduleIdTextField.setText(String.valueOf(this.scheduleId));
        this.schemeIdTextField.setText(String.valueOf(this.schemeId));
    }

    private void onCancel() {
        this.dispose();
    }

    private void onAddSchedule() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainCoeffScheduleTab());
        Dimension dimension = new Dimension(600, 500);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        selectFromTableDialogModel.setSize(dimension);
        selectFromTableDialogModel.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.scheduleId = (Integer)selectFromTableDialogModel.getItem().get("id");
            this.schemeId = 0;
            this.scheduleIdTextField.setText(String.valueOf(this.scheduleId));
            this.schemeIdTextField.setText(String.valueOf(this.schemeId));
            try {
                this.loadItemsTablePanel(this.scheduleId);
            }
            catch (UrfaException urfaException) {
                logger.error(urfaException);
            }
        }
    }

    private void onAddScheme() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainCoeffSchemeTab());
        Dimension dimension = new Dimension(600, 500);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        selectFromTableDialogModel.setSize(dimension);
        selectFromTableDialogModel.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.schemeId = (Integer)selectFromTableDialogModel.getItem().get("id");
            this.scheduleId = this.createScheduleByScheme(this.schemeId);
            if (this.scheduleId == 0) {
                this.schemeId = 0;
                Dialogs.showErrorDialog(Utils.getResource().getString("Can't create schedule"));
            } else {
                try {
                    this.loadItemsTablePanel(this.scheduleId);
                }
                catch (UrfaException urfaException) {
                    logger.error(urfaException);
                }
            }
            this.scheduleIdTextField.setText(String.valueOf(this.scheduleId));
            this.schemeIdTextField.setText(String.valueOf(this.schemeId));
        }
    }

    private int createScheduleByScheme(int n) {
        try {
            if (Utils.isAdmin()) {
                UrfaGetCoeffScheme urfaGetCoeffScheme = new UrfaGetCoeffScheme(UrfaManagerImpl.getInstance());
                urfaGetCoeffScheme.setSchemeId(n);
                urfaGetCoeffScheme.call();
                if (urfaGetCoeffScheme.getId() == 0) {
                    return 0;
                }
                int[] nArray = new int[urfaGetCoeffScheme.getItemsSize()];
                int[] nArray2 = new int[urfaGetCoeffScheme.getItemsSize()];
                int[] nArray3 = new int[urfaGetCoeffScheme.getItemsSize()];
                for (int i = 0; i < urfaGetCoeffScheme.getItemsSize(); ++i) {
                    nArray2[i] = urfaGetCoeffScheme.getDelay1()[i];
                    nArray3[i] = urfaGetCoeffScheme.getDuration1()[i];
                    nArray[i] = 0;
                }
                UrfaAddCoeffSchedule urfaAddCoeffSchedule = new UrfaAddCoeffSchedule(UrfaManagerImpl.getInstance());
                urfaAddCoeffSchedule.setId(0);
                urfaAddCoeffSchedule.setItemsSize(urfaGetCoeffScheme.getItemsSize());
                urfaAddCoeffSchedule.setScheduleId1(nArray);
                urfaAddCoeffSchedule.setStartDate1(nArray2);
                urfaAddCoeffSchedule.setEndDate1(nArray3);
                urfaAddCoeffSchedule.setCoeff1(urfaGetCoeffScheme.getCoeff1());
                urfaAddCoeffSchedule.call();
                return urfaAddCoeffSchedule.getId();
            }
            UrfaDealerGetCoeffScheme urfaDealerGetCoeffScheme = new UrfaDealerGetCoeffScheme(UrfaManagerImpl.getInstance());
            urfaDealerGetCoeffScheme.setSchemeId(n);
            urfaDealerGetCoeffScheme.call();
            if (urfaDealerGetCoeffScheme.getId() == 0) {
                return 0;
            }
            int[] nArray = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            int[] nArray4 = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            int[] nArray5 = new int[urfaDealerGetCoeffScheme.getItemsSize()];
            int n2 = (int)(this.startScheduleDateDateTime.getDate().getTime() / 1000L);
            for (int i = 0; i < urfaDealerGetCoeffScheme.getItemsSize(); ++i) {
                nArray4[i] = n2 + urfaDealerGetCoeffScheme.getDelay1()[i];
                nArray5[i] = nArray4[i] + urfaDealerGetCoeffScheme.getDuration1()[i];
                nArray[i] = 0;
            }
            UrfaDealerAddCoeffSchedule urfaDealerAddCoeffSchedule = new UrfaDealerAddCoeffSchedule(UrfaManagerImpl.getInstance());
            urfaDealerAddCoeffSchedule.setId(0);
            urfaDealerAddCoeffSchedule.setItemsSize(urfaDealerGetCoeffScheme.getItemsSize());
            urfaDealerAddCoeffSchedule.setScheduleId1(nArray);
            urfaDealerAddCoeffSchedule.setStartDate1(nArray4);
            urfaDealerAddCoeffSchedule.setEndDate1(nArray5);
            urfaDealerAddCoeffSchedule.setCoeff1(urfaDealerGetCoeffScheme.getCoeff1());
            urfaDealerAddCoeffSchedule.call();
            return urfaDealerAddCoeffSchedule.getId();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
            return 0;
        }
    }

    private void createUIComponents() {
        this.createItemsTable();
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
        this.addSchemeButton.setEnabled(false);
        this.addScheduleButton.setEnabled(false);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel8, gridBagConstraints);
        jPanel8.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service link parameters")));
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Change policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jLabel, gridBagConstraints);
        this.changePolicyCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.changePolicyCB, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel10, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Scheme id"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        jPanel8.add((Component)jLabel2, gridBagConstraints);
        this.schemeIdTextField = new JTextField();
        this.schemeIdTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.schemeIdTextField, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel12, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Schedule id"));
        jLabel3.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        jPanel8.add((Component)jLabel3, gridBagConstraints);
        this.scheduleIdTextField = new JTextField();
        this.scheduleIdTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.scheduleIdTextField, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel8.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)jPanel18, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start schedule date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel8.add((Component)jLabel4, gridBagConstraints);
        this.addSchemeButton = new JButton();
        this.$$$loadButtonText$$$(this.addSchemeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add scheme"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.addSchemeButton, gridBagConstraints);
        this.startScheduleDateDateTime = new JDateTime();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        jPanel8.add((Component)this.startScheduleDateDateTime, gridBagConstraints);
        this.addScheduleButton = new JButton();
        this.addScheduleButton.setActionCommand("Add schedule");
        this.$$$loadButtonText$$$(this.addScheduleButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add schedule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel8.add((Component)this.addScheduleButton, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel19, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel20, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel22, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel22.add((Component)this.itemsTablePanel, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel23, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

