/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetIpMac;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.IpGroupDialogTabs.IpGroupDhcpTab;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IpGroupIpSettingsTab
extends TabPanel {
    private JComboBox IP4ComboBox;
    private JComboBox IP6ComboBox;
    private Map<String, String> macMap = new HashMap<String, String>();
    private IpGroupDhcpTab dhcpTab;
    private JPanel mainPanel;
    private JCheckBox isDynamicCheckBox;

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return "Ip group";
    }

    @Override
    public String getTabName() {
        return "IP settings";
    }

    public IpGroupIpSettingsTab() {
        this.$$$setupUI$$$();
    }

    public void init(IpGroupDhcpTab ipGroupDhcpTab) {
        this.dhcpTab = ipGroupDhcpTab;
    }

    public void load(int n, int n2) throws UrfaException {
        for (Map<String, Object> map : HouseFunctions.getFreeIps(n2 == 0 ? UserFunctions.getUser(n).getHouseId() : n2)) {
            InetAddress object = (InetAddress)map.get("ip");
            if (object instanceof Inet4Address) {
                this.IP4ComboBox.addItem(Resolve.IpAddressToView(object) + "/32 [" + map.get("zone") + "]");
                continue;
            }
            Integer n3 = map.get("bits") == null ? 64 : (Integer)map.get("bits");
            this.IP6ComboBox.addItem(Resolve.IpAddressToView(object) + "/" + n3 + " [" + map.get("zone") + "]");
        }
        if (Utils.isAdmin()) {
            this.macMap.clear();
            UrfaGetIpMac urfaGetIpMac = new UrfaGetIpMac(UrfaManagerImpl.getInstance());
            urfaGetIpMac.call();
            for (int i = 0; i < urfaGetIpMac.getIpsSize(); ++i) {
                this.macMap.put(Resolve.ip_toString(urfaGetIpMac.getIpsIp1()[i]), urfaGetIpMac.getName1()[i]);
            }
            for (Map.Entry<String, String> entry : this.macMap.entrySet()) {
                this.IP4ComboBox.addItem(entry.getKey());
                if (!this.dhcpTab.getMACAddress().isEmpty()) continue;
                this.dhcpTab.setMACAddress(entry.getValue());
            }
            this.IP4ComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = IpGroupIpSettingsTab.this.IP4ComboBox.getSelectedItem().toString();
                    if (IpGroupIpSettingsTab.this.macMap.containsKey(string)) {
                        IpGroupIpSettingsTab.this.dhcpTab.setMACAddress((String)IpGroupIpSettingsTab.this.macMap.get(string));
                    }
                }
            });
        }
        this.IP4ComboBox.setSelectedItem("");
        this.IP6ComboBox.setSelectedItem("");
    }

    public void setIpEnabled(boolean bl) {
        this.IP4ComboBox.setEnabled(bl);
        this.IP6ComboBox.setEnabled(bl);
        if (!bl) {
            this.IP4ComboBox.setSelectedItem("");
            this.IP6ComboBox.setSelectedItem("");
        }
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public AddressWithMask getIPv4Subnet() {
        String string = (String)this.IP4ComboBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.isEmpty()) {
            return null;
        }
        return Resolve.getIpAddressWithMask(string);
    }

    public void setIPv4Subnet(AddressWithMask addressWithMask) {
        this.IP4ComboBox.setSelectedItem(addressWithMask.toString());
    }

    public AddressWithMask getIPv6Subnet() {
        String string = (String)this.IP6ComboBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.isEmpty()) {
            return null;
        }
        return Resolve.getIpAddressWithMask(string);
    }

    public void setIPv6Subnet(AddressWithMask addressWithMask) {
        this.IP6ComboBox.setSelectedItem(addressWithMask.toString());
    }

    public boolean getIsDynamic() {
        return this.isDynamicCheckBox.isSelected();
    }

    public void setIsDynamic(boolean bl) {
        this.isDynamicCheckBox.setSelected(bl);
    }

    public void checkNotEmpty() throws IllegalArgumentException {
        String string = (String)this.IP4ComboBox.getSelectedItem();
        String string2 = (String)this.IP6ComboBox.getSelectedItem();
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty())) {
            throw new IllegalArgumentException(this.resource.getString("You must specify at least one of subnets"));
        }
    }

    public void checkData() throws IllegalArgumentException {
        InetAddress inetAddress;
        String string = (String)this.IP4ComboBox.getSelectedItem();
        String string2 = (String)this.IP6ComboBox.getSelectedItem();
        if (!string.isEmpty()) {
            if (string.indexOf(32) != -1) {
                string = string.substring(0, string.indexOf(32));
            }
            try {
                inetAddress = Resolve.getIpAddressWithMask((String)string).address;
                if (inetAddress instanceof Inet6Address) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(this.resource.getString("IP4 Subnet") + " " + this.resource.getString("field is invalid"));
            }
        }
        if (!string2.isEmpty()) {
            if (string2.indexOf(32) != -1) {
                string2 = string2.substring(0, string2.indexOf(32));
            }
            try {
                inetAddress = Resolve.getIpAddressWithMask((String)string2).address;
                if (inetAddress instanceof Inet4Address) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(this.resource.getString("IP6 Subnet") + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.IP4ComboBox = new JComboBox();
        this.IP4ComboBox.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IP4ComboBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP4 Subnet"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        this.IP6ComboBox = new JComboBox();
        this.IP6ComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IP6ComboBox, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP6 Subnet"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        this.isDynamicCheckBox = new JCheckBox();
        this.isDynamicCheckBox.setEnabled(false);
        this.isDynamicCheckBox.setSelected(false);
        this.isDynamicCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.isDynamicCheckBox, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Dynamic"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

