/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.functions.UrfaDelCoeffScheduleLink;
import biz.netup.control.transport.urfa.functions.UrfaGetCoeffScheduleLinkList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.PeriodicSL;
import biz.netup.projects.utmadmin.functions.objects.Tel;
import biz.netup.projects.utmadmin.functions.objects.TelSL;
import biz.netup.projects.utmadmin.gui.custom.tel.TelDialog;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.MainBuildingsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ChargePolicyElements;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStats;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStatsDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ScheduleLink.AddScheduleLinkDialog;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.SchemeComboBoxWrapper;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddTelServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JButton deleteTelButton;
    private JButton addTelButton;
    private JButton editTelButton;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private TablePanelImpl telTablePanel;
    private JTextField costCoefTextField;
    private JComboBox chargePolicyCB;
    private JButton detailsButton;
    private JTextField chargedTB;
    private JButton periodicStatsButton;
    private JLabel buildingIDLabel;
    private JTextField buildingIDTextField;
    private JButton selectBuildingIDButton;
    private JButton clearButton;
    private JTextField commentTextField;
    private JComboBox schemeCB;
    private JLabel schemeForScheduleLabel = new JLabel();
    private JButton selectScheduleButton;
    private JDateTime startScheduleDateDateTime;
    private JLabel startScheduleDateLabel = new JLabel();
    private JButton clearScheduleButton;
    private JTextField houseCommentTextField;
    private SchemeComboBoxWrapper schemeCBWrapper;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    private int slinkId;
    private int tariffLinkId;
    private int buildingId;
    private TelSL telSL;
    private Vector<Tel> tels;
    private ChargePolicyElements chargePolicy;
    private PeriodicStats periodicStats;
    private static final Logger logger = Utils.getLogger();
    ResourceBundleWrapper resource = Utils.getResource();
    private String[] telsColumnNames = new String[]{"Number", "Login", "Password", "Allowed CID"};

    public AddTelServiceLinkDialog(int n, int n2, final int n3, String string, final int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.periodicStats.Attach(this.chargedTB, this.periodicStatsButton, n4, PeriodicStatsDialog.SlinkType.Telephony);
        this.chargePolicy.setDefaultPolicy(n3);
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.telSL = new TelSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
            this.setBuildingIDTextField(0);
            this.selectScheduleButton.setEnabled(false);
            this.clearScheduleButton.setEnabled(false);
            this.startScheduleDateDateTime.setDate(TZ.getCoreTime());
            this.schemeCBWrapper.setSchemeIdByServiceId(n3);
        } else {
            this.loadTelSL();
            this.schemeCBWrapper.setSchemeIdBySlinkId(n4);
            this.disableSelectElements();
        }
        if (n5 != 0) {
            this.discountPeriod = n6;
            this.disableDiscountElements();
        }
        this.selectBuildingIDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainBuildingsTab());
                Dimension dimension = new Dimension(600, 500);
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                selectFromTableDialogModel.setSize(dimension);
                selectFromTableDialogModel.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    AddTelServiceLinkDialog.this.buildingId = (Integer)selectFromTableDialogModel.getItem().get("id");
                    AddTelServiceLinkDialog.this.setBuildingId(AddTelServiceLinkDialog.this.buildingId);
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.setBuildingIDTextField(0);
            }
        });
        this.selectScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddScheduleLinkDialog addScheduleLinkDialog = new AddScheduleLinkDialog(n4, n3);
                addScheduleLinkDialog.setVisible(true);
                if (addScheduleLinkDialog.isOkPressed()) {
                    try {
                        AddTelServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddTelServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                    }
                    catch (UrfaException urfaException) {
                        logger.error(urfaException);
                    }
                }
            }
        });
        this.clearScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    try {
                        if (Utils.isAdmin()) {
                            UrfaGetCoeffScheduleLinkList urfaGetCoeffScheduleLinkList = new UrfaGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                            urfaGetCoeffScheduleLinkList.call();
                            for (int i = 0; i < urfaGetCoeffScheduleLinkList.getListSize(); ++i) {
                                if (urfaGetCoeffScheduleLinkList.getSlinkId1()[i] != n4) continue;
                                UrfaDelCoeffScheduleLink urfaDelCoeffScheduleLink = new UrfaDelCoeffScheduleLink(UrfaManagerImpl.getInstance());
                                urfaDelCoeffScheduleLink.setId(urfaGetCoeffScheduleLinkList.getId1()[i]);
                                urfaDelCoeffScheduleLink.call();
                                AddTelServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddTelServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                                break block5;
                            }
                            break block5;
                        }
                        UrfaDealerGetCoeffScheduleLinkList urfaDealerGetCoeffScheduleLinkList = new UrfaDealerGetCoeffScheduleLinkList(UrfaManagerImpl.getInstance());
                        urfaDealerGetCoeffScheduleLinkList.call();
                        for (int i = 0; i < urfaDealerGetCoeffScheduleLinkList.getListSize(); ++i) {
                            if (urfaDealerGetCoeffScheduleLinkList.getSlinkId1()[i] != n4) continue;
                            UrfaDelCoeffScheduleLink urfaDelCoeffScheduleLink = new UrfaDelCoeffScheduleLink(UrfaManagerImpl.getInstance());
                            urfaDelCoeffScheduleLink.setId(urfaDealerGetCoeffScheduleLinkList.getId1()[i]);
                            urfaDelCoeffScheduleLink.call();
                            AddTelServiceLinkDialog.this.costCoefTextField.setText(String.valueOf(AddTelServiceLinkDialog.this.loadData().getCostCoef() * 100.0));
                            break;
                        }
                    }
                    catch (UrfaException urfaException) {
                        logger.error(urfaException);
                    }
                }
            }
        });
    }

    private void setBuildingId(int n) {
        if (n != 0) {
            this.buildingIDTextField.setText(HouseFunctions.getHouseName(n) + " (" + n + ")");
        } else {
            this.buildingIDTextField.setText("");
        }
    }

    public void setBuildingIDTextField(int n) {
        this.buildingId = n;
        this.setBuildingId(n);
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
        this.startScheduleDateDateTime.setEnabled(false);
        this.startScheduleDateDateTime.setVisible(false);
        this.startScheduleDateLabel.setVisible(false);
        this.schemeCB.setEnabled(false);
        this.schemeCBWrapper.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    protected PeriodicSL loadData() throws UrfaException {
        return SLFunctions.getPeriodicSL(this.slinkId);
    }

    private void loadTelSL() {
        try {
            this.telSL = SLFunctions.getTelSL(this.slinkId);
            this.startDateDateTime.setDate(new Date((long)this.telSL.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.telSL.getExpireDate() * 1000L));
            this.discountPeriod = this.telSL.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.costCoefTextField.setText(String.valueOf(this.telSL.getCostCoef() * 100.0));
            this.buildingId = this.telSL.getHouseId();
            this.setBuildingId(this.buildingId);
            this.houseCommentTextField.setText(this.telSL.getHouseComment());
            this.commentTextField.setText(this.telSL.getComment());
            Tel[] telArray = this.telSL.getTels();
            for (int i = 0; i < telArray.length; ++i) {
                this.tels.add(telArray[i]);
            }
            this.chargePolicy.setPolicy(this.telSL.getPolicyId());
            this.startScheduleDateDateTime.setDate(new Date((long)this.telSL.getStartDate() * 1000L));
            this.refreshTelTable();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddTelServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public AddTelServiceLinkDialog() {
        this.tels = new Vector();
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.telTablePanel.registerOneRowButton(this.editTelButton);
        this.telTablePanel.registerOneRowButton(this.deleteTelButton);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(520, this.getPreferredSize().height);
        this.setMinimumSize(new Dimension(520, this.getPreferredSize().height));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Telephony service link"));
        this.setIconImage(imageIcon.getImage());
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddTelServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
        this.addTelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.addTel();
            }
        });
        this.editTelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.editTel();
            }
        });
        this.deleteTelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTelServiceLinkDialog.this.deleteTel();
            }
        });
        this.chargePolicy = new ChargePolicyElements(this.chargePolicyCB, this.detailsButton);
        this.periodicStats = new PeriodicStats();
        this.schemeCBWrapper = new SchemeComboBoxWrapper(this.startScheduleDateDateTime, this.schemeCB);
    }

    private int getColumnByName(JTable jTable, String string) {
        string = this.resource.getString("Telephone");
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            if (!jTable.getColumnName(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedIndex() {
        JTable jTable = this.telTablePanel.getTable();
        String string = (String)jTable.getValueAt(jTable.getSelectedRow(), this.getColumnByName(jTable, "number"));
        int n = 0;
        for (Tel tel : this.tels) {
            if (tel.getNumber() == string) break;
            ++n;
        }
        return n;
    }

    private void deleteTel() {
        int n = this.getSelectedIndex();
        if (Dialogs.showYesNoDialog(this.resource.getString("Do you wish to continue?"))) {
            this.tels.remove(n);
            this.refreshTelTable();
        }
    }

    private void editTel() {
        int n = this.getSelectedIndex();
        TelDialog telDialog = new TelDialog(this.tels.get(n));
        telDialog.setVisible(true);
        if (telDialog.isOkPressed()) {
            this.tels.set(n, telDialog.getTel());
            this.refreshTelTable();
        }
    }

    private void addTel() {
        TelDialog telDialog = new TelDialog(null);
        telDialog.setVisible(true);
        if (telDialog.isOkPressed()) {
            if (!telDialog.getTel().getNumber().isEmpty()) {
                for (Tel tel : this.tels) {
                    if (!tel.getNumber().equals(telDialog.getTel().getNumber())) continue;
                    Dialogs.showErrorDialog("Attempt to add one more number item");
                    return;
                }
            }
            this.tels.add(telDialog.getTel());
            this.refreshTelTable();
        }
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.buttonOK.setEnabled(true);
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        }
    }

    private void onOK() {
        int n;
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog(this.resource.getString("Discount period doesn't selected"));
            return;
        }
        if (this.telTablePanel.getTable().getRowCount() == 0) {
            Dialogs.showErrorDialog(this.resource.getString("Telephony numbers table is empty"));
            return;
        }
        int n2 = this.chargePolicy.getPolicy();
        if (n2 == -1) {
            n2 = this.telSL.getPolicyId();
        }
        this.telSL.setAccountId(this.aid);
        this.telSL.setUserId(this.uid);
        this.telSL.setDiscountPeriodId(this.discountPeriod);
        this.telSL.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.telSL.setPolicyId(n2);
        this.telSL.setServiceId(this.serviceId);
        this.telSL.setServiceType(6);
        this.telSL.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        double d = this.schemeCBWrapper.getCostCoefficient();
        if (d != -1.0) {
            this.telSL.setCostCoef(d);
        } else {
            this.telSL.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        }
        try {
            if (UserFunctions.getUser((int)this.uid).houseId == this.buildingId) {
                this.setBuildingIDTextField(0);
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        this.telSL.setHouseId(this.buildingId);
        this.telSL.setHouseComment(this.houseCommentTextField.getText());
        this.telSL.setComment(this.commentTextField.getText());
        int n3 = this.tels.size();
        Tel[] telArray = new Tel[n3];
        for (n = 0; n < n3; ++n) {
            telArray[n] = this.tels.get(n);
        }
        this.telSL.setTels(telArray);
        this.telSL.setTariffLinkId(this.tariffLinkId);
        this.telSL.setSlinkId(this.slinkId);
        this.telSL.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        for (n = 0; n < n3; ++n) {
            Tel.NumberPresenceState numberPresenceState;
            try {
                numberPresenceState = telArray[n].CheckPresence(this.slinkId);
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog(urfaException.getMessage());
                return;
            }
            if (numberPresenceState == Tel.NumberPresenceState.LoginUsedByAnotherService || numberPresenceState == Tel.NumberPresenceState.LoginUsedByAnotherNumber) {
                String string = this.resource.getString("Login <%login%> already used");
                string = string.replaceAll("<%login%>", "\"" + telArray[n].getLogin() + "\"");
                Dialogs.showErrorDialog(string);
                return;
            }
            if (numberPresenceState != Tel.NumberPresenceState.NumberUsedByAnotherNumber) continue;
            String string = this.resource.getString("Number <%number%> already used");
            string = string.replaceAll("<%number%>", "\"" + telArray[n].getNumber() + "\"");
            Dialogs.showErrorDialog(string);
            return;
        }
        try {
            if (this.slinkId == 0) {
                this.slinkId = SLFunctions.addTelSL(this.telSL);
                if (this.schemeCBWrapper.isEnabled()) {
                    this.schemeCBWrapper.CreateScheduleLink(this.slinkId);
                }
            } else {
                SLFunctions.editTelSL(this.telSL);
            }
            this.dispose();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog(urfaException.getMessage());
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.createTable();
        this.refreshTelTable();
        this.startDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime = new JDateTime();
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
        this.startScheduleDateDateTime = new JDateTime();
        this.startScheduleDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startScheduleDateDateTime.getButton().setText("");
    }

    private void createTable() {
        this.telTablePanel = new TablePanelImpl(this.getClass().getName() + "_tels", true);
        MapTableModel mapTableModel = this.telTablePanel.getTableModel();
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("number", "Telephone", true, false);
        mapTableModel.addColumn("allowed_cid", "Allowed CID", true, false);
        this.telTablePanel.setEditable(false);
        this.telTablePanel.setAppendable(false);
        this.telTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(AddTelServiceLinkDialog.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(AddTelServiceLinkDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem3 = new JMenuItem(AddTelServiceLinkDialog.this.resource.getString("Edit"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddTelServiceLinkDialog.this.refreshTelTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddTelServiceLinkDialog.this.deleteTel();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddTelServiceLinkDialog.this.editTel();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem3);
                arrayList.add(jMenuItem2);
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                AddTelServiceLinkDialog.this.editTel();
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
    }

    private void refreshTelTable() {
        this.telTablePanel.getTableModel().removeAllRows();
        for (int i = 0; i < this.tels.size(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", this.tels.get(i).getId());
            hashMap.put("number", this.tels.get(i).getNumber());
            hashMap.put("login", this.tels.get(i).getLogin());
            hashMap.put("allowed_cid", this.tels.get(i).getAllowedCID());
            this.telTablePanel.getTableModel().addRow(hashMap);
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel7, gridBagConstraints);
        jPanel7.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Telephony service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Expire date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.expireDateDateTime, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel7.add((Component)jPanel16, gridBagConstraints);
        this.costCoefTextField = new JTextField();
        this.costCoefTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.costCoefTextField, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel17, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cost_%"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel4, gridBagConstraints);
        this.chargePolicyCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.chargePolicyCB, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charge policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel18, gridBagConstraints);
        this.detailsButton = new JButton();
        this.$$$loadButtonText$$$(this.detailsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.detailsButton, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel19, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charged"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel6, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel20, gridBagConstraints);
        this.chargedTB = new JTextField();
        this.chargedTB.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.chargedTB, gridBagConstraints);
        this.periodicStatsButton = new JButton();
        this.$$$loadButtonText$$$(this.periodicStatsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.periodicStatsButton, gridBagConstraints);
        this.buildingIDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.buildingIDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("House"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)this.buildingIDLabel, gridBagConstraints);
        this.buildingIDTextField = new JTextField();
        this.buildingIDTextField.setEditable(false);
        this.buildingIDTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.buildingIDTextField, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel21, gridBagConstraints);
        this.selectBuildingIDButton = new JButton();
        this.selectBuildingIDButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectBuildingIDButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.selectBuildingIDButton, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.clearButton, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel22, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel7, gridBagConstraints);
        this.commentTextField = new JTextField();
        this.commentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.commentTextField, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel23, gridBagConstraints);
        this.schemeCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.schemeCB, gridBagConstraints);
        this.$$$loadLabelText$$$(this.schemeForScheduleLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Scheme for schedule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)this.schemeForScheduleLabel, gridBagConstraints);
        this.startScheduleDateDateTime.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.startScheduleDateDateTime, gridBagConstraints);
        this.$$$loadLabelText$$$(this.startScheduleDateLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start schedule date"));
        this.startScheduleDateLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)this.startScheduleDateLabel, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel24, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel25, gridBagConstraints);
        this.selectScheduleButton = new JButton();
        this.selectScheduleButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectScheduleButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        this.selectScheduleButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.selectScheduleButton, gridBagConstraints);
        this.clearScheduleButton = new JButton();
        this.clearScheduleButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearScheduleButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        this.clearScheduleButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.clearScheduleButton, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel26, gridBagConstraints);
        this.houseCommentTextField = new JTextField();
        this.houseCommentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.houseCommentTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Address comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel7.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel27, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel28, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel29, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel30, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel31, gridBagConstraints);
        jPanel31.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Telephone numbers")));
        this.deleteTelButton = new JButton();
        this.deleteTelButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteTelButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)this.deleteTelButton, gridBagConstraints);
        this.addTelButton = new JButton();
        this.addTelButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addTelButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)this.addTelButton, gridBagConstraints);
        this.editTelButton = new JButton();
        this.editTelButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edit16.png")));
        this.$$$loadButtonText$$$(this.editTelButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)this.editTelButton, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel31.add((Component)jPanel32, gridBagConstraints);
        this.telTablePanel.setAppendable(false);
        this.telTablePanel.setEditable(false);
        jPanel32.add((Component)this.telTablePanel, "Center");
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)jPanel33, gridBagConstraints);
        JPanel jPanel34 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)jPanel34, gridBagConstraints);
        JPanel jPanel35 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)jPanel35, gridBagConstraints);
        JPanel jPanel36 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel31.add((Component)jPanel36, gridBagConstraints);
        JPanel jPanel37 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel31.add((Component)jPanel37, gridBagConstraints);
        JPanel jPanel38 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel38, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

