/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.objects.OnceSL;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddOnceServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JDateTime startDateDateTime;
    private JTextField costCoefTextField;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    private int slinkId = 0;
    private int tariffLinkId = 0;
    OnceSL osl;
    private static final Logger logger = Utils.getLogger();

    public AddOnceServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
    }

    public AddOnceServiceLinkDialog(int n, int n2, int n3, String string, int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.discountPeriod = n6;
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.osl = new OnceSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
        } else {
            this.loadPSL();
        }
        if (n5 != 0) {
            this.disableDiscountElements();
        }
    }

    private void disableSelectElements() {
        this.startDateDateTime.setEnabled(false);
    }

    private void disableDiscountElements() {
    }

    private void loadPSL() {
        try {
            this.osl = SLFunctions.getOnceSL(this.slinkId);
            this.startDateDateTime.setDate(new Date((long)this.osl.getDiscountDate() * 1000L));
            this.costCoefTextField.setText(String.valueOf(this.osl.getCostCoef() * 100.0));
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddOnceServiceLinkDialog() {
        this.$$$setupUI$$$();
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(400, 190);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Once service link"));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddOnceServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddOnceServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddOnceServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddOnceServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        OnceSL onceSL = new OnceSL();
        onceSL.setSlinkId(this.slinkId);
        onceSL.setAccountId(this.aid);
        onceSL.setUserId(this.uid);
        onceSL.setServiceId(this.serviceId);
        onceSL.setTariffLinkId(this.tariffLinkId);
        onceSL.setServiceType(1);
        onceSL.setDiscountDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        onceSL.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        try {
            if (this.slinkId == 0) {
                SLFunctions.addOnceSL(onceSL);
            } else {
                SLFunctions.editOnceSL(onceSL);
            }
            this.dispose();
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel6, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charge time"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.serviceNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.startDateDateTime, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel12, gridBagConstraints);
        this.costCoefTextField = new JTextField();
        this.costCoefTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.costCoefTextField, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cost_%"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel15, gridBagConstraints);
        jLabel.setLabelFor(this.serviceNameTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

