/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.sl.SLFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.projects.utmadmin.functions.objects.DialupSL;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.MainBuildingsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.ChargePolicyElements;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStats;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.PeriodicStatsDialog;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddDialupServiceLinkDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField serviceNameTextField;
    private JTextField accountingPeriodTextField;
    private JButton selectDiscountPeriodButton;
    private JTextField loginTextField;
    private JPasswordField passwordTextField;
    private JCheckBox callbackIsAllowedCheckBox;
    private JCheckBox ringdownIsAllowedCheckBox;
    private JTextField allowedCIDTextField;
    private JTextField allowedCSIDTextField;
    private JLabel accountingPeriodLabel;
    private JDateTime startDateDateTime;
    private JDateTime expireDateDateTime;
    private JTextField costCoefTextField;
    private JComboBox chargePolicyCB;
    private JButton policyDetailsButton;
    private JTextField discountedCB;
    private JButton periodicStatsButton;
    private JLabel buildingIDLabel;
    private JTextField buildingIDTextField;
    private JButton selectBuildingIDButton;
    private JButton clearButton;
    private JTextField commentTextField;
    private JPasswordField confirmPasswordTextField;
    private JLabel lbConfirmPassword;
    private JTextField houseCommentTextField;
    private int discountPeriod;
    private int uid;
    private int aid;
    private int serviceId;
    private int slinkId;
    private int tariffLinkId;
    private int buildingId;
    DialupSL dialupSL;
    ChargePolicyElements chargePolicy;
    PeriodicStats periodicStats;
    private Integer isHidePass = 0;
    private static final Logger logger = Utils.getLogger();

    private void checkPasswordHide() {
        if (UrfaManagerImpl.getInstance().isPermitted(17412)) {
            UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
            urfaGetSetting.setVariable("hide_password_in_service_link");
            try {
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() > 0) {
                    this.isHidePass = Integer.parseInt(urfaGetSetting.getValue()[0]);
                    if (this.isHidePass == 1) {
                        this.confirmPasswordTextField.setEnabled(true);
                        this.lbConfirmPassword.setEnabled(true);
                        this.passwordTextField.setEchoChar('\u2022');
                        this.confirmPasswordTextField.setEchoChar('\u2022');
                    } else {
                        this.passwordTextField.setEchoChar('\u0000');
                        this.confirmPasswordTextField.setEnabled(false);
                        this.lbConfirmPassword.setEnabled(false);
                    }
                }
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
        }
    }

    public void setReadOnly() {
        DialogModel.setReadOnlyForComponent(this.contentPane);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(Utils.getResource().getString("Close"));
        this.buttonCancel.setEnabled(true);
    }

    private void createUIComponents() {
        this.startDateDateTime = new JDateTime();
        this.startDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/down16.png")));
        this.startDateDateTime.getButton().setText("");
        this.expireDateDateTime = new JDateTime();
        this.expireDateDateTime.getButton().setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/up16.png")));
        this.expireDateDateTime.getButton().setText("");
        this.expireDateDateTime.setInfinity(true);
    }

    public AddDialupServiceLinkDialog(int n, int n2, int n3, String string, int n4, int n5, int n6) {
        this();
        this.uid = n;
        this.aid = n2;
        this.serviceId = n3;
        this.tariffLinkId = n5;
        this.slinkId = n4;
        this.periodicStats.Attach(this.discountedCB, this.periodicStatsButton, n4, PeriodicStatsDialog.SlinkType.Dialup);
        this.chargePolicy.setDefaultPolicy(n3);
        this.serviceNameTextField.setText(string);
        if (n4 == 0) {
            this.dialupSL = new DialupSL();
            this.startDateDateTime.setDate(TZ.getCoreTime());
            this.expireDateDateTime.setDate(new Date(2000000000000L));
            this.setBuildingIDTextField(0);
        } else {
            this.loadDialupSL();
            this.disableSelectElements();
            this.loginTextField.setEditable(false);
        }
        if (n5 != 0) {
            this.discountPeriod = n6;
            this.disableDiscountElements();
        }
        this.selectBuildingIDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainBuildingsTab());
                Dimension dimension = new Dimension(600, 500);
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                selectFromTableDialogModel.setSize(dimension);
                selectFromTableDialogModel.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    AddDialupServiceLinkDialog.this.buildingId = (Integer)selectFromTableDialogModel.getItem().get("id");
                    AddDialupServiceLinkDialog.this.setBuildingId(AddDialupServiceLinkDialog.this.buildingId);
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDialupServiceLinkDialog.this.setBuildingIDTextField(0);
            }
        });
        this.checkPasswordHide();
    }

    private void setBuildingId(int n) {
        if (n != 0) {
            this.buildingIDTextField.setText(HouseFunctions.getHouseName(n) + " (" + n + ")");
        } else {
            this.buildingIDTextField.setText("");
        }
    }

    public void setBuildingIDTextField(int n) {
        this.buildingId = n;
        this.setBuildingId(n);
    }

    private void disableSelectElements() {
        this.selectDiscountPeriodButton.setEnabled(false);
        this.startDateDateTime.setEnabled(false);
    }

    private void disableDiscountElements() {
        this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
        this.selectDiscountPeriodButton.setEnabled(false);
    }

    private void loadDialupSL() {
        try {
            this.dialupSL = SLFunctions.getDialupSL(this.slinkId);
            this.startDateDateTime.setDate(new Date((long)this.dialupSL.getStartDate() * 1000L));
            this.expireDateDateTime.setDate(new Date((long)this.dialupSL.getExpireDate() * 1000L));
            this.discountPeriod = this.dialupSL.getDiscountPeriodId();
            this.accountingPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            this.loginTextField.setText(this.dialupSL.getDialupLogin());
            this.passwordTextField.setText(this.dialupSL.getDialupPassword());
            this.confirmPasswordTextField.setText(this.dialupSL.getDialupPassword());
            this.allowedCIDTextField.setText(this.dialupSL.getDialupAllowedCid());
            this.allowedCSIDTextField.setText(this.dialupSL.getDialupAllowedCsid());
            this.callbackIsAllowedCheckBox.setSelected(this.dialupSL.isCallbackIsAllowed());
            this.ringdownIsAllowedCheckBox.setSelected(this.dialupSL.isRingdownIsAllowed());
            this.chargePolicy.setPolicy(this.dialupSL.getPolicyId());
            this.costCoefTextField.setText(String.valueOf(this.dialupSL.getCostCoef() * 100.0));
            this.buildingId = this.dialupSL.getHouseId();
            this.setBuildingId(this.buildingId);
            this.houseCommentTextField.setText(this.dialupSL.getHouseComment());
            this.commentTextField.setText(this.dialupSL.getComment());
        }
        catch (UrfaException urfaException) {
            logger.error(urfaException);
        }
    }

    public AddDialupServiceLinkDialog(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 0, 0, 0);
        this.checkPasswordHide();
    }

    public AddDialupServiceLinkDialog() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(430, this.getPreferredSize().height);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Dial-up service link"));
        this.setIconImage(imageIcon.getImage());
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDialupServiceLinkDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDialupServiceLinkDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddDialupServiceLinkDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDialupServiceLinkDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.selectDiscountPeriodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDialupServiceLinkDialog.this.selectDiscountPeriod();
            }
        });
        this.chargePolicy = new ChargePolicyElements(this.chargePolicyCB, this.policyDetailsButton);
        this.periodicStats = new PeriodicStats();
        this.checkPasswordHide();
    }

    private void selectDiscountPeriod() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            this.buttonOK.setEnabled(true);
            this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
            this.accountingPeriodTextField.setText("" + selectFromTableDialogModel.getItem().get("name"));
        }
    }

    private void onOK() {
        if (this.isHidePass == 1 && !Arrays.equals(this.passwordTextField.getPassword(), this.confirmPasswordTextField.getPassword())) {
            Dialogs.showErrorDialog("Password doesn't match");
            return;
        }
        if (this.discountPeriod == 0) {
            Dialogs.showErrorDialog("Discount period doesn't selected");
            return;
        }
        if (!Checkers.loginSLOk(this.loginTextField.getText())) {
            Dialogs.showErrorDialog("Login is incorrect");
            return;
        }
        if (!this.ringdownIsAllowedCheckBox.isSelected() && !this.callbackIsAllowedCheckBox.isSelected()) {
            Dialogs.showErrorDialog("Select ringdown or callback allowing");
            return;
        }
        int n = this.chargePolicy.getPolicy();
        if (n == -1) {
            n = this.dialupSL.getPolicyId();
        }
        this.dialupSL.setAccountId(this.aid);
        this.dialupSL.setUserId(this.uid);
        this.dialupSL.setDiscountPeriodId(this.discountPeriod);
        this.dialupSL.setExpireDate((int)(this.expireDateDateTime.getDate().getTime() / 1000L));
        this.dialupSL.setServiceId(this.serviceId);
        this.dialupSL.setServiceType(5);
        this.dialupSL.setStartDate((int)(this.startDateDateTime.getDate().getTime() / 1000L));
        this.dialupSL.setDialupLogin(this.loginTextField.getText());
        this.dialupSL.setDialupPassword(new String(this.passwordTextField.getText()));
        this.dialupSL.setCallbackIsAllowed(this.callbackIsAllowedCheckBox.isSelected());
        this.dialupSL.setRingdownIsAllowed(this.ringdownIsAllowedCheckBox.isSelected());
        this.dialupSL.setDialupAllowedCid(this.allowedCIDTextField.getText());
        this.dialupSL.setDialupAllowedCsid(this.allowedCSIDTextField.getText());
        this.dialupSL.setPolicyId(n);
        this.dialupSL.setCostCoef(Double.valueOf(this.costCoefTextField.getText()) / 100.0);
        try {
            if (UserFunctions.getUser((int)this.uid).houseId == this.buildingId) {
                this.setBuildingIDTextField(0);
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
        this.dialupSL.setHouseId(this.buildingId);
        this.dialupSL.setHouseComment(this.houseCommentTextField.getText());
        this.dialupSL.setComment(this.commentTextField.getText());
        this.dialupSL.setTariffLinkId(this.tariffLinkId);
        this.dialupSL.setSlinkId(this.slinkId);
        try {
            if (this.slinkId == 0) {
                SLFunctions.addDialupSL(this.dialupSL);
            } else {
                SLFunctions.editDialupSL(this.dialupSL);
            }
            this.dispose();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog(urfaException.getMessage());
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ok"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel6, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Dial-up service link parameters")));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Expire date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Start date"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel3, gridBagConstraints);
        this.accountingPeriodLabel = new JLabel();
        this.$$$loadLabelText$$$(this.accountingPeriodLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)this.accountingPeriodLabel, gridBagConstraints);
        this.serviceNameTextField = new JTextField();
        this.serviceNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.serviceNameTextField, gridBagConstraints);
        this.accountingPeriodTextField = new JTextField();
        this.accountingPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.accountingPeriodTextField, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.loginTextField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel5, gridBagConstraints);
        this.callbackIsAllowedCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.callbackIsAllowedCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Callback is allowed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 33;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.callbackIsAllowedCheckBox, gridBagConstraints);
        this.ringdownIsAllowedCheckBox = new JCheckBox();
        this.ringdownIsAllowedCheckBox.setEnabled(true);
        this.$$$loadButtonText$$$(this.ringdownIsAllowedCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ringdown is allowed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 33;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.ringdownIsAllowedCheckBox, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Allowed CID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel6, gridBagConstraints);
        this.allowedCIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.allowedCIDTextField, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Allowed CSID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel7, gridBagConstraints);
        this.allowedCSIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.allowedCSIDTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.startDateDateTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.expireDateDateTime, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 33;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel19, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cost_%"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel8, gridBagConstraints);
        this.costCoefTextField = new JTextField();
        this.costCoefTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.costCoefTextField, gridBagConstraints);
        this.passwordTextField = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.passwordTextField, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 32;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel20, gridBagConstraints);
        this.chargePolicyCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.chargePolicyCB, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel21, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charge policy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel9, gridBagConstraints);
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Charged"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel10, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel22, gridBagConstraints);
        this.discountedCB = new JTextField();
        this.discountedCB.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.discountedCB, gridBagConstraints);
        this.periodicStatsButton = new JButton();
        this.$$$loadButtonText$$$(this.periodicStatsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.periodicStatsButton, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel23, gridBagConstraints);
        this.policyDetailsButton = new JButton();
        this.$$$loadButtonText$$$(this.policyDetailsButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.policyDetailsButton, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel24, gridBagConstraints);
        this.selectDiscountPeriodButton = new JButton();
        this.selectDiscountPeriodButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectDiscountPeriodButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.selectDiscountPeriodButton, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel25, gridBagConstraints);
        this.buildingIDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.buildingIDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("House"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)this.buildingIDLabel, gridBagConstraints);
        this.buildingIDTextField = new JTextField();
        this.buildingIDTextField.setEditable(false);
        this.buildingIDTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.buildingIDTextField, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel26, gridBagConstraints);
        this.selectBuildingIDButton = new JButton();
        this.selectBuildingIDButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/configure16.png")));
        this.$$$loadButtonText$$$(this.selectBuildingIDButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.selectBuildingIDButton, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.clearButton, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel27, gridBagConstraints);
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel11, gridBagConstraints);
        this.commentTextField = new JTextField();
        this.commentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.commentTextField, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel28, gridBagConstraints);
        this.lbConfirmPassword = new JLabel();
        this.$$$loadLabelText$$$(this.lbConfirmPassword, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password confirm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)this.lbConfirmPassword, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel29, gridBagConstraints);
        this.confirmPasswordTextField = new JPasswordField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.confirmPasswordTextField, gridBagConstraints);
        this.houseCommentTextField = new JTextField();
        this.houseCommentTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.houseCommentTextField, gridBagConstraints);
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Address comment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel12, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel30, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel31, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel32, gridBagConstraints);
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel33, gridBagConstraints);
        jLabel6.setLabelFor(this.allowedCIDTextField);
        jLabel7.setLabelFor(this.allowedCSIDTextField);
        jLabel9.setLabelFor(this.allowedCSIDTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

