/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.iptv;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetActivationCodes;
import biz.netup.control.transport.urfa.functions.UrfaNewActivationCode;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.accountpanel.AccountComboBox;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ActivationCodesTab
extends TabPanelWithTable {
    AccountComboBox acb;
    private int uid;
    ResourceBundleWrapper resource = Utils.getResource();
    static final int STATE_ACTIVE = 32768006;

    @Override
    public JComponent getPanel() {
        if (this.init) {
            this.acb.refresh();
        }
        return super.getPanel();
    }

    public ActivationCodesTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/user/activation_codes.png")));
        this.setRefreshPermission(new int[]{8243, 17675});
        this.setAddPermission(new int[]{17676});
        this.uid = n;
        this.acb = new AccountComboBox(n, this);
        this.acb.refresh();
        this.getBottomPanel().add((Component)this.acb.getPanel(), "South");
    }

    @Override
    public int getTabType() {
        return 2;
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public String getTabName() {
        return "IPTV activation codes";
    }

    @Override
    public int getMode() {
        return 4;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("access_card_number", "Access card");
        linkedHashMap.put("part_1", "Part 1");
        linkedHashMap.put("part_2", "Part 2");
        linkedHashMap.put("part_3", "Part 3");
        linkedHashMap.put("part_4", "Part 4");
        linkedHashMap.put("part_5", "Part 5");
        linkedHashMap.put("part_6", "Part 6");
        linkedHashMap.put("status", "Status");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        UrfaGetActivationCodes urfaGetActivationCodes = new UrfaGetActivationCodes(UrfaManagerImpl.getInstance());
        urfaGetActivationCodes.setAccountId(this.acb.getAid());
        urfaGetActivationCodes.call();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (int i = 0; i < urfaGetActivationCodes.getAcCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("status", urfaGetActivationCodes.getStatusArray1()[i] == 32768006 ? this.resource.getString("Active code") : this.resource.getString("Used code"));
            hashMap.put("part_1", this.padPart(urfaGetActivationCodes.getPart1Array1()[i]));
            hashMap.put("part_2", this.padPart(urfaGetActivationCodes.getPart2Array1()[i]));
            hashMap.put("part_3", this.padPart(urfaGetActivationCodes.getPart3Array1()[i]));
            hashMap.put("part_4", this.padPart(urfaGetActivationCodes.getPart4Array1()[i]));
            hashMap.put("part_5", this.padPart(urfaGetActivationCodes.getPart5Array1()[i]));
            hashMap.put("part_6", this.padPart(urfaGetActivationCodes.getPart6Array1()[i]));
            hashMap.put("access_card_number", urfaGetActivationCodes.getAccessCardNumberArray1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    private String padPart(int n) {
        return String.format("%05d", n);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected void add() {
        UrfaNewActivationCode urfaNewActivationCode = new UrfaNewActivationCode(UrfaManagerImpl.getInstance());
        urfaNewActivationCode.setAccountId(this.acb.getAid());
        try {
            urfaNewActivationCode.call();
        }
        catch (UrfaException urfaException) {
            return;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.refresh();
    }

    @Override
    protected void init() {
        super.init();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivationCodesTab.this.acb.refresh();
            }
        });
    }
}

