/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.searchframe;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddUsersToGroup;
import biz.netup.control.transport.urfa.functions.UrfaChangeIntstatForUser;
import biz.netup.control.transport.urfa.functions.UrfaGetDiscountPeriods;
import biz.netup.control.transport.urfa.functions.UrfaGetGroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetHousesList;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.functions.UrfaGetSysUsersList;
import biz.netup.control.transport.urfa.functions.UrfaGetTariffsList;
import biz.netup.control.transport.urfa.functions.UrfaGetUaparamList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.dealer.permissions.PermissionFunctions;
import biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users.UsersFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.tarification.accounts.AccountFunctions;
import biz.netup.projects.utmadmin.functions.objects.Account;
import biz.netup.projects.utmadmin.functions.objects.SearchConditions;
import biz.netup.projects.utmadmin.gui.custom.newpayment.NewPaymentDialog;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.dealers.MainDealersTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersandgroups.groups.MainGroupsTab;
import biz.netup.projects.utmadmin.gui.userframe.UserFrame;
import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.DateTimeCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.export.ExportClass;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.types.SearchSetting;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SearchFrame
extends JFrame {
    private JPanel contentPane;
    private JButton buttonOK;
    private JTabbedPane tabbedPane1;
    private JComboBox ballanceComboBox;
    private JTextField ballanceTextField;
    private JTextField fullNameTextField;
    private JTextField loginTextField;
    private JButton deleteButton;
    private JButton addButton;
    private JComboBox andOrComboBox;
    private JButton findNowButton;
    private JButton clearButton;
    private TablePanelImpl usersTablePanel;
    private TablePanelImpl customSearchTablePanel;
    private JTextField UIDTextField;
    private JTextField basicAccountTextField;
    private JTextField textFieldIpAddress;
    private JButton newPaymentButton;
    private JButton editButton;
    private JPanel buttonsPanel;
    private JButton addToGroupButton;
    private JButton linkToDealerButton;
    private JButton exportButton;
    private JButton OKButton;
    private ResourceBundleWrapper resource = Utils.getResource();
    private Map<String, Integer> whatData;
    private Map<String, Integer> criteriaData;
    private Map<String, Integer> criteriaDataDate;
    private Map<String, Integer> criteriaDataBoolean;
    private Map<String, Integer> systemUserIdMap;
    private Map<String, Integer> groupIdMap;
    private Map<String, Integer> tariffIdMap;
    private Map<String, Integer> serviceIdMap;
    private Map<String, Integer> houseIdMap;
    private Map<String, Integer> apMap;
    private Map<String, Integer> blockIdMap;
    private boolean selectMode = false;
    private DFModel df = null;
    private Logger log = Utils.getLogger();
    private boolean updatingTable = false;
    private boolean delSchCritRow = false;
    private int rowId = 0;

    public SearchFrame() {
        this.$$$setupUI$$$();
        if (!Utils.isAdmin()) {
            this.addToGroupButton.setVisible(false);
            this.linkToDealerButton.setVisible(false);
        } else {
            Permissions.apply((JComponent)this.linkToDealerButton, "link_to_dealer");
            Permissions.apply((JComponent)this.editButton, "view_user");
            if (!Permissions.isPermitted("edit_user")) {
                this.editButton.setText(this.resource.getString("Read"));
            }
            Permissions.apply((JComponent)this.addToGroupButton, "add_to_group");
            Permissions.apply((JComponent)this.newPaymentButton, "new_payment");
        }
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.findNowButton);
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString("Search"));
        this.setIconImage(imageIcon.getImage());
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.onOK();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SearchFrame.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.findNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.refreshTable();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.addSearchCriteria();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.deleteSearchCriteria();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.clearAll();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.editUser();
            }
        });
        this.addToGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.addToGroup();
            }
        });
        this.newPaymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.newPayment();
            }
        });
        this.linkToDealerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.linkToDealer();
            }
        });
        this.usersTablePanel.registerOneRowButton(this.editButton);
        this.usersTablePanel.registerOneRowButton(this.OKButton);
        this.usersTablePanel.registerOneRowButton(this.newPaymentButton);
        this.usersTablePanel.registerMultiRowButton(this.addToGroupButton);
        this.usersTablePanel.registerMultiRowButton(this.linkToDealerButton);
        this.usersTablePanel.setSummaryVisible(true);
        this.usersTablePanel.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SearchFrame.this.usersTablePanel.setSummaryText(SearchFrame.this.resource.getString("Row count") + ": " + SearchFrame.this.usersTablePanel.getTable().getRowCount());
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportClass.exportToCsv(SearchFrame.this.usersTablePanel);
            }
        });
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.df.actionFinished(SearchFrame.this.usersTablePanel.getSelectedTableRows()[0]);
                SearchFrame.this.setVisible(false);
            }
        });
        for (SearchSetting searchSetting : Settings.getSearchValueFromPerst()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("field", searchSetting.getField());
            hashMap.put("condition", searchSetting.getCondition());
            hashMap.put("value", "");
            this.customSearchTablePanel.getTableModel().addRow(hashMap);
        }
        if (this.customSearchTablePanel.getTableModel().data.size() == 0) {
            this.addSearchCriteria();
        }
    }

    private void linkToDealer() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainDealersTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            for (Map<String, Object> map : this.usersTablePanel.getSelectedTableRows()) {
                PermissionFunctions.changePerm((Integer)selectFromTableDialogModel.getItem().get("id"), 1, new int[]{(Integer)map.get("uid")}, 1);
            }
        }
    }

    private void addToGroup() {
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainGroupsTab());
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            try {
                UrfaAddUsersToGroup urfaAddUsersToGroup = new UrfaAddUsersToGroup(UrfaManagerImpl.getInstance());
                urfaAddUsersToGroup.setUserId1(ArrayFromVector.getIntArrayFromData(new Vector<Map<String, Object>>(Arrays.asList(this.usersTablePanel.getSelectedTableRows())), "uid"));
                urfaAddUsersToGroup.setGroupId((Integer)selectFromTableDialogModel.getItem().get("id"));
                urfaAddUsersToGroup.call();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().error("Cannot complete operation", urfaException);
            }
        }
    }

    private void clearAll() {
        if (this.tabbedPane1.getSelectedIndex() == 0) {
            this.ballanceTextField.setText("");
            this.loginTextField.setText("");
            this.fullNameTextField.setText("");
            this.textFieldIpAddress.setText("");
            this.UIDTextField.setText("");
            this.basicAccountTextField.setText("");
        } else {
            this.customSearchTablePanel.getTableModel().removeAllRows();
        }
        this.usersTablePanel.getTableModel().removeAllRows();
    }

    private void onOK() {
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void createUIComponents() {
        this.createUsersTable();
        this.createCustomSearchTable();
        this.andOrComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.resource.getString("All conditions"));
        defaultComboBoxModel.addElement(this.resource.getString("All conditions for single account"));
        defaultComboBoxModel.addElement(this.resource.getString("At least one condition"));
        this.andOrComboBox.setModel(defaultComboBoxModel);
    }

    void fillCombo() {
        this.whatData = new TreeMap<String, Integer>();
        this.whatData.put(this.resource.getString("ID"), 1);
        this.whatData.put(this.resource.getString("Login"), 2);
        this.whatData.put(this.resource.getString("Basic account"), 3);
        this.whatData.put(this.resource.getString("Accounting period"), 4);
        this.whatData.put(this.resource.getString("Accounting period ID"), 104);
        this.whatData.put(this.resource.getString("Name"), 5);
        this.whatData.put(this.resource.getString("Created on"), 6);
        this.whatData.put(this.resource.getString("Modified last time on"), 7);
        this.whatData.put(this.resource.getString("Created by"), 8);
        this.whatData.put(this.resource.getString("Modified by"), 9);
        this.whatData.put(this.resource.getString("Created by") + " ID", 108);
        this.whatData.put(this.resource.getString("Modified by") + " ID", 109);
        this.whatData.put(this.resource.getString("Juridical"), 10);
        this.whatData.put(this.resource.getString("Juridical address"), 11);
        this.whatData.put(this.resource.getString("Actual address"), 12);
        this.whatData.put(this.resource.getString("Work phone"), 13);
        this.whatData.put(this.resource.getString("Home phone"), 14);
        this.whatData.put(this.resource.getString("Mobile phone"), 15);
        this.whatData.put(this.resource.getString("Web page"), 16);
        this.whatData.put(this.resource.getString("ICQ number"), 17);
        this.whatData.put(this.resource.getString("TAX number"), 18);
        this.whatData.put(this.resource.getString("KPP number"), 19);
        this.whatData.put(this.resource.getString("Building"), 21);
        this.whatData.put(this.resource.getString("Building ID"), 121);
        this.whatData.put(this.resource.getString("Apartment #"), 22);
        this.whatData.put(this.resource.getString("Porch"), 23);
        this.whatData.put(this.resource.getString("Floor"), 24);
        this.whatData.put(this.resource.getString("E-mail"), 25);
        this.whatData.put(this.resource.getString("Person's ID"), 26);
        this.whatData.put(this.resource.getString("IP-address"), 28);
        this.whatData.put(this.resource.getString("Contract"), 29);
        this.whatData.put(this.resource.getString("Group"), 30);
        this.whatData.put(this.resource.getString("Group ID"), 130);
        this.whatData.put(this.resource.getString("Balance"), 31);
        this.whatData.put(this.resource.getString("Personal manager"), 32);
        this.whatData.put(this.resource.getString("Connect date"), 33);
        this.whatData.put(this.resource.getString("Comments"), 34);
        this.whatData.put(this.resource.getString("Internet status"), 35);
        this.whatData.put(this.resource.getString("Tariff"), 36);
        this.whatData.put(this.resource.getString("Service"), 37);
        this.whatData.put(this.resource.getString("Tariff ID"), 136);
        this.whatData.put(this.resource.getString("Service ID"), 137);
        this.whatData.put(this.resource.getString("Service link ID"), 38);
        this.whatData.put(this.resource.getString("Tariff link ID"), 39);
        this.whatData.put(this.resource.getString("District"), 40);
        this.whatData.put(this.resource.getString("Building"), 41);
        this.whatData.put(this.resource.getString("MAC addr"), 42);
        this.whatData.put(this.resource.getString("Login in service links"), 43);
        this.whatData.put(this.resource.getString("Incoming trunk"), 45);
        this.whatData.put(this.resource.getString("Outgoing trunk"), 46);
        this.whatData.put(this.resource.getString("VLAN id"), 47);
        this.whatData.put(this.resource.getString("Switch"), 48);
        this.whatData.put(this.resource.getString("Switch port"), 49);
        this.whatData.put(this.resource.getString("DHCP pool id"), 50);
        this.whatData.put(this.resource.getString("External account ID"), 44);
        this.whatData.put(this.resource.getString("Accounts"), 51);
        this.whatData.put(this.resource.getString("Tel numbers"), 52);
        this.whatData.put(this.resource.getString("Credit"), 53);
        this.whatData.put(this.resource.getString("Balance plus credit"), 54);
        this.whatData.put(this.resource.getString("Next TP name"), 55);
        this.whatData.put(this.resource.getString("Block type"), 56);
        this.criteriaData = new LinkedHashMap<String, Integer>();
        this.criteriaData.put(this.resource.getString("contains"), 1);
        this.criteriaData.put(this.resource.getString("not contains"), 11);
        this.criteriaData.put(this.resource.getString("equals"), 3);
        this.criteriaData.put(this.resource.getString("not equals"), 4);
        this.criteriaData.put(this.resource.getString("higher"), 7);
        this.criteriaData.put(this.resource.getString("lower"), 8);
        this.criteriaData.put(this.resource.getString("higher or equals"), 9);
        this.criteriaData.put(this.resource.getString("lower or equals"), 10);
        this.criteriaDataDate = new LinkedHashMap<String, Integer>();
        this.criteriaDataDate.put(this.resource.getString("equals"), 3);
        this.criteriaDataDate.put(this.resource.getString("not equals"), 4);
        this.criteriaDataDate.put(this.resource.getString("higher"), 7);
        this.criteriaDataDate.put(this.resource.getString("lower"), 8);
        this.criteriaDataDate.put(this.resource.getString("higher or equals"), 9);
        this.criteriaDataDate.put(this.resource.getString("lower or equals"), 10);
        this.criteriaDataBoolean = new LinkedHashMap<String, Integer>();
        this.criteriaDataBoolean.put(this.resource.getString("equals"), 3);
        this.criteriaDataBoolean.put(this.resource.getString("not equals"), 4);
        if (Utils.isAdmin()) {
            try {
                int n;
                Object object;
                if (UrfaManagerImpl.getInstance().isPermitted(17427)) {
                    this.systemUserIdMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetSysUsersList(UrfaManagerImpl.getInstance());
                    ((UrfaGetSysUsersList)object).call();
                    for (n = 0; n < ((UrfaGetSysUsersList)object).getInfoSize(); ++n) {
                        this.systemUserIdMap.put(((UrfaGetSysUsersList)object).getLogin1()[n] + " (" + ((UrfaGetSysUsersList)object).getUserId1()[n] + ")", ((UrfaGetSysUsersList)object).getUserId1()[n]);
                    }
                }
                if (UrfaManagerImpl.getInstance().isPermitted(10256)) {
                    this.houseIdMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetHousesList(UrfaManagerImpl.getInstance());
                    ((UrfaGetHousesList)object).call();
                    for (n = 0; n < ((UrfaGetHousesList)object).getHousesSize(); ++n) {
                        this.houseIdMap.put(((UrfaGetHousesList)object).getStreet1()[n] + " " + ((UrfaGetHousesList)object).getNumber1()[n] + " " + ((UrfaGetHousesList)object).getBuilding1()[n] + " (" + ((UrfaGetHousesList)object).getHouseId1()[n] + ")", ((UrfaGetHousesList)object).getHouseId1()[n]);
                    }
                }
                if (UrfaManagerImpl.getInstance().isPermitted(9216)) {
                    this.groupIdMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetGroupsList(UrfaManagerImpl.getInstance());
                    ((UrfaGetGroupsList)object).call();
                    for (n = 0; n < ((UrfaGetGroupsList)object).getGroupsCount(); ++n) {
                        this.groupIdMap.put(((UrfaGetGroupsList)object).getGroupName1()[n] + " (" + ((UrfaGetGroupsList)object).getGroupId1()[n] + ")", ((UrfaGetGroupsList)object).getGroupId1()[n]);
                    }
                }
                if (UrfaManagerImpl.getInstance().isPermitted(12324)) {
                    this.tariffIdMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetTariffsList(UrfaManagerImpl.getInstance());
                    ((UrfaGetTariffsList)object).call();
                    for (n = 0; n < ((UrfaGetTariffsList)object).getTariffsCount(); ++n) {
                        this.tariffIdMap.put(((UrfaGetTariffsList)object).getName1()[n] + " (" + ((UrfaGetTariffsList)object).getId1()[n] + ")", ((UrfaGetTariffsList)object).getId1()[n]);
                    }
                }
                if (UrfaManagerImpl.getInstance().isPermitted(8449)) {
                    this.serviceIdMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
                    ((UrfaGetServicesList)object).call();
                    for (n = 0; n < ((UrfaGetServicesList)object).getServicesCount(); ++n) {
                        this.serviceIdMap.put(((UrfaGetServicesList)object).getServiceNameArray1()[n] + " (" + ((UrfaGetServicesList)object).getServiceIdArray1()[n] + ")", ((UrfaGetServicesList)object).getServiceIdArray1()[n]);
                    }
                }
                if (UrfaManagerImpl.getInstance().isPermitted(9728)) {
                    this.apMap = new LinkedHashMap<String, Integer>();
                    object = new UrfaGetDiscountPeriods(UrfaManagerImpl.getInstance());
                    ((UrfaGetDiscountPeriods)object).call();
                    for (n = 0; n < ((UrfaGetDiscountPeriods)object).getDiscountPeriodsCount(); ++n) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                        this.apMap.put(simpleDateFormat.format(new Date((long)((UrfaGetDiscountPeriods)object).getStartDate1()[n] * 1000L)) + " - " + simpleDateFormat.format(new Date((long)((UrfaGetDiscountPeriods)object).getEndDate1()[n] * 1000L)) + " (" + ((UrfaGetDiscountPeriods)object).getDiscountPeriodId1()[n] + ")", ((UrfaGetDiscountPeriods)object).getDiscountPeriodId1()[n]);
                    }
                }
                this.blockIdMap = new LinkedHashMap<String, Integer>();
                this.blockIdMap.put(this.resource.getString("User block"), 3);
                this.blockIdMap.put(this.resource.getString("System block"), 1);
                this.blockIdMap.put(this.resource.getString("Admin block"), 2);
                this.blockIdMap.put(this.resource.getString("Not blocked"), -1);
                this.blockIdMap.put(this.resource.getString("Blocked"), 0);
                if (UrfaManagerImpl.getInstance().isPermitted(17419)) {
                    object = new UrfaGetUaparamList(UrfaManagerImpl.getInstance());
                    ((UrfaGetUaparamList)object).call();
                    for (n = 0; n < ((UrfaGetUaparamList)object).getUparamSize(); ++n) {
                        int n2 = ((UrfaGetUaparamList)object).getId1()[n];
                        int n3 = n2 | Integer.MIN_VALUE;
                        String string = this.resource.getString("Additional prefix");
                        string = ((UrfaGetUaparamList)object).getVisible1()[n] != 0 ? string + ((UrfaGetUaparamList)object).getDisplayName1()[n] : string + ((UrfaGetUaparamList)object).getName1()[n];
                        this.whatData.put(string, n3);
                    }
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
    }

    private void createCustomSearchTable() {
        this.customSearchTablePanel = new TablePanelImpl(this.getClass().getName() + "_customSearch", true);
        MapTableModel mapTableModel = this.customSearchTablePanel.getTableModel();
        mapTableModel.addColumn("field", "Field:", true, true);
        mapTableModel.addColumn("condition", "Condition:", true, true);
        mapTableModel.addColumn("value", "Value:", true, true);
        this.customSearchTablePanel.setEditable(true);
        this.customSearchTablePanel.setAppendable(false);
        this.customSearchTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(SearchFrame.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(SearchFrame.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.deleteSearchCriteria();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.addSearchCriteria();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.customSearchTablePanel.applyTableSettings();
        this.customSearchTablePanel.getTable().setSelectionMode(2);
        this.customSearchTablePanel.getTable().setColumnSelectionAllowed(true);
        this.fillCombo();
        JComboBox<String> jComboBox = new JComboBox<String>();
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        final JComboBox<String> jComboBox3 = new JComboBox<String>();
        final JComboBox<String> jComboBox4 = new JComboBox<String>();
        final JComboBox<String> jComboBox5 = new JComboBox<String>();
        final JComboBox<String> jComboBox6 = new JComboBox<String>();
        final JComboBox<String> jComboBox7 = new JComboBox<String>();
        final JComboBox<String> jComboBox8 = new JComboBox<String>();
        final JComboBox<String> jComboBox9 = new JComboBox<String>();
        final JComboBox<String> jComboBox10 = new JComboBox<String>();
        final JComboBox<String> jComboBox11 = new JComboBox<String>();
        if (Utils.isAdmin()) {
            if (this.systemUserIdMap != null) {
                for (String string : this.systemUserIdMap.keySet()) {
                    jComboBox5.addItem(string);
                }
            } else {
                jComboBox5.setEditable(true);
            }
            if (this.groupIdMap != null) {
                for (String string : this.groupIdMap.keySet()) {
                    jComboBox6.addItem(string);
                }
            } else {
                jComboBox6.setEditable(true);
            }
            if (this.houseIdMap != null) {
                for (String string : this.houseIdMap.keySet()) {
                    jComboBox7.addItem(string);
                }
            } else {
                jComboBox7.setEditable(true);
            }
            if (this.tariffIdMap != null) {
                for (String string : this.tariffIdMap.keySet()) {
                    jComboBox8.addItem(string);
                }
            } else {
                jComboBox8.setEditable(true);
            }
            if (this.serviceIdMap != null) {
                for (String string : this.serviceIdMap.keySet()) {
                    jComboBox9.addItem(string);
                }
            } else {
                jComboBox9.setEditable(true);
            }
            if (this.apMap != null) {
                for (String string : this.apMap.keySet()) {
                    jComboBox10.addItem(string);
                }
            } else {
                jComboBox10.setEditable(true);
            }
            if (this.blockIdMap != null) {
                for (String string : this.blockIdMap.keySet()) {
                    jComboBox11.addItem(string);
                }
            } else {
                jComboBox11.setEditable(true);
            }
        }
        for (String string : this.whatData.keySet()) {
            jComboBox2.addItem(string);
        }
        for (String string : this.criteriaData.keySet()) {
            jComboBox.addItem(string);
        }
        for (String string : this.criteriaDataDate.keySet()) {
            jComboBox3.addItem(string);
        }
        for (String string : this.criteriaDataBoolean.keySet()) {
            jComboBox4.addItem(string);
        }
        this.customSearchTablePanel.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.isEmpty() && (tableModelEvent.getColumn() == -1 && !SearchFrame.this.delSchCritRow || tableModelEvent.getColumn() == 0 && tableModelEvent.getFirstRow() >= 0 && !((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field").equals(((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("old_field"))) && !SearchFrame.this.updatingTable) {
                    SearchFrame.this.updatingTable = true;
                    ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("old_field", ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field"));
                    int n = (Integer)SearchFrame.this.whatData.get(((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field"));
                    ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-RENDERERS", null);
                    ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", null);
                    if (n == 33 || n == 6 || n == 7) {
                        HashMap<String, DefaultCellEditor> hashMap = new HashMap<String, DefaultCellEditor>();
                        hashMap.put("value", new DateTimeCellEditor("Not defined", true));
                        hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                    } else if (n == 10) {
                        HashMap<String, DefaultCellEditor> hashMap = new HashMap<String, DefaultCellEditor>();
                        hashMap.put("value", new CheckboxCellEditor("", ""));
                        hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox4), true, false));
                        HashMap<String, CheckboxCellRenderer> hashMap2 = new HashMap<String, CheckboxCellRenderer>();
                        hashMap2.put("value", new CheckboxCellRenderer(false));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-RENDERERS", hashMap2);
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                    } else if (n >= 22 && n <= 24) {
                        HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                        hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox4), true, false));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                    } else if (Utils.isAdmin()) {
                        if (n == 8 || n == 9) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox5), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else if (n == 30) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox6), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else if (n == 36 || n == 55) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox8), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else if (n == 37) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox9), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else if (n == 21) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox7), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else if (n == 4) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox10), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                        } else if (n == 56) {
                            HashMap<String, ComboBoxCellEditor> hashMap = new HashMap<String, ComboBoxCellEditor>();
                            hashMap.put("value", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox11), true, false));
                            hashMap.put("condition", new ComboBoxCellEditor(SearchFrame.this.getCopy(jComboBox3), true, false));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("condition", SearchFrame.this.resource.getString("equals"));
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", hashMap);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        } else {
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", null);
                            ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                        }
                    } else {
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("X-EDITORS", null);
                        ((SearchFrame)SearchFrame.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).put("value", "");
                    }
                    SearchFrame.this.customSearchTablePanel.getTableModel().fireTableDataChanged();
                    SearchFrame.this.customSearchTablePanel.getTable().clearSelection();
                    SearchFrame.this.customSearchTablePanel.getTable().addRowSelectionInterval(tableModelEvent.getFirstRow(), tableModelEvent.getFirstRow());
                    SearchFrame.this.updatingTable = false;
                }
            }
        });
        this.customSearchTablePanel.setCellEditor("field", new ComboBoxCellEditor(jComboBox2, true, false));
        this.customSearchTablePanel.setCellEditor("condition", new ComboBoxCellEditor(jComboBox, true, false));
    }

    private void addSearchCriteria() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("condition", this.resource.getString("contains"));
        hashMap.put("field", this.resource.getString("Name"));
        hashMap.put("value", "");
        this.customSearchTablePanel.getTableModel().addRow(hashMap);
    }

    private void deleteSearchCriteria() {
        this.delSchCritRow = true;
        for (Map<String, Object> map : this.customSearchTablePanel.getSelectedTableRows()) {
            this.customSearchTablePanel.getTableModel().removeRow(map);
        }
        this.delSchCritRow = false;
    }

    private void createUsersTable() {
        this.usersTablePanel = new TablePanelImpl(this.getClass().getName() + "_sr", true);
        MapTableModel mapTableModel = this.usersTablePanel.getTableModel();
        mapTableModel.addColumn("uid", "UID", true, false);
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("master_account", "Master account", true, false);
        mapTableModel.addColumn("full_name", "Full name", true, false);
        mapTableModel.addColumn("status", "Status", true, false);
        mapTableModel.addColumn("ballance", "Ballance", true, false);
        mapTableModel.addColumn("ip_vpn", "IP (VPN)", true, false);
        mapTableModel.addColumn("ip_not_vpn", "IP (not VPN)", true, false);
        mapTableModel.addColumn("Actual address", "Actual address", false, false);
        mapTableModel.addColumn("Building", "Building", false, false);
        mapTableModel.addColumn("Created on", "Created on", false, false);
        mapTableModel.addColumn("District", "District", false, false);
        mapTableModel.addColumn("E-mail", "E-mail", false, false);
        mapTableModel.addColumn("Porch", "Porch", false, false);
        mapTableModel.addColumn("Apartment #", "Apartment #", false, false);
        mapTableModel.addColumn("Floor", "Floor", false, false);
        mapTableModel.addColumn("Home phone", "Home phone", false, false);
        mapTableModel.addColumn("Building ID", "Building ID", false, false);
        mapTableModel.addColumn("ICQ number", "ICQ number", false, false);
        mapTableModel.addColumn("Juridical", "Juridical", false, false);
        mapTableModel.addColumn("Juridical address", "Juridical address", false, false);
        mapTableModel.addColumn("KPP number", "KPP number", false, false);
        mapTableModel.addColumn("Modified last time on", "Modified last time on", false, false);
        mapTableModel.addColumn("Mobile phone", "Mobile phone", false, false);
        mapTableModel.addColumn("Person's ID", "Person's ID", false, false);
        mapTableModel.addColumn("TAX number", "TAX number", false, false);
        mapTableModel.addColumn("Web page", "Web page", false, false);
        mapTableModel.addColumn("Modified by", "Modified by", false, false);
        mapTableModel.addColumn("Created by", "Created by", false, false);
        mapTableModel.addColumn("Work phone", "Work phone", false, false);
        mapTableModel.addColumn("External account ID", "External account ID", false, false);
        this.usersTablePanel.setEditable(false);
        this.usersTablePanel.setAppendable(false);
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer(false);
        this.usersTablePanel.setCellRenderer("Juridical", checkboxCellRenderer);
        this.usersTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(SearchFrame.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(SearchFrame.this.resource.getString("Remove"));
                JMenuItem jMenuItem3 = new JMenuItem(SearchFrame.this.resource.getString("Edit"));
                JMenuItem jMenuItem4 = new JMenuItem(SearchFrame.this.resource.getString("New payment"));
                JMenuItem jMenuItem5 = new JMenuItem(SearchFrame.this.resource.getString("Turn Internet on"));
                JMenuItem jMenuItem6 = new JMenuItem(SearchFrame.this.resource.getString("Turn Internet off"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.refreshTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.deleteUser();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.editUser();
                    }
                });
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.newPayment();
                    }
                });
                jMenuItem6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.turnInternetOff();
                    }
                });
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchFrame.this.turnInternetOn();
                    }
                });
                jMenuItem2.setVisible(Permissions.isPermitted("delete_user"));
                jMenuItem3.setVisible(Permissions.isPermitted("view_user"));
                jMenuItem4.setVisible(Permissions.isPermitted("new_payment"));
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem2, jMenuItem5, jMenuItem6, jMenuItem};
                }
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem3);
                arrayList.add(jMenuItem2);
                arrayList.add(jMenuItem5);
                arrayList.add(jMenuItem6);
                arrayList.add(jMenuItem4);
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                if (SearchFrame.this.selectMode) {
                    SearchFrame.this.df.actionFinished(SearchFrame.this.usersTablePanel.getSelectedTableRows()[0]);
                    SearchFrame.this.setVisible(false);
                } else if (Permissions.isPermitted("view_user")) {
                    SearchFrame.this.editUser();
                }
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.usersTablePanel.applyTableSettings();
    }

    public void refreshTable() {
        this.usersTablePanel.getTableModel().removeAllRows();
        for (Map<String, Object> map : UsersFunctions.searchUsers(this.getSearchCriteria())) {
            this.usersTablePanel.getTableModel().addRow(map);
        }
    }

    public void setSelectMode(DFModel dFModel) {
        if (dFModel == null) {
            this.selectMode = false;
            this.df = null;
            this.OKButton.setVisible(false);
        } else {
            this.selectMode = true;
            this.df = dFModel;
            this.OKButton.setVisible(true);
        }
    }

    private SearchConditions getSearchCriteria() {
        SearchConditions searchConditions = new SearchConditions();
        if (this.tabbedPane1.getSelectedIndex() == 0) {
            searchConditions.selectType = 0;
            if (!this.loginTextField.getText().isEmpty()) {
                searchConditions.addCondition(2, 1, this.loginTextField.getText());
            }
            if (!this.fullNameTextField.getText().isEmpty()) {
                searchConditions.addCondition(5, 1, this.fullNameTextField.getText());
            }
            if (!this.ballanceTextField.getText().isEmpty()) {
                if (this.ballanceComboBox.getSelectedIndex() == 0) {
                    searchConditions.addCondition(31, 3, this.ballanceTextField.getText());
                } else if (this.ballanceComboBox.getSelectedIndex() == 1) {
                    searchConditions.addCondition(31, 7, this.ballanceTextField.getText());
                } else if (this.ballanceComboBox.getSelectedIndex() == 2) {
                    searchConditions.addCondition(31, 8, this.ballanceTextField.getText());
                }
            }
            if (!this.UIDTextField.getText().isEmpty()) {
                searchConditions.addCondition(1, 1, this.UIDTextField.getText());
            }
            if (!this.basicAccountTextField.getText().isEmpty()) {
                searchConditions.addCondition(3, 1, this.basicAccountTextField.getText());
            }
            if (!this.textFieldIpAddress.getText().isEmpty()) {
                searchConditions.addCondition(28, 1, this.textFieldIpAddress.getText());
            }
        } else {
            Vector<SearchSetting> vector = new Vector<SearchSetting>();
            switch (this.andOrComboBox.getSelectedIndex()) {
                case 1: {
                    searchConditions.selectType = 2;
                    break;
                }
                case 2: {
                    searchConditions.selectType = 1;
                    break;
                }
                default: {
                    searchConditions.selectType = 0;
                }
            }
            for (Map<String, Object> map : this.customSearchTablePanel.getTableModel().data) {
                int n = this.whatData.get(map.get("field"));
                String string = map.get("value").toString();
                int n2 = this.criteriaData.get(map.get("condition"));
                String string2 = string;
                if (Utils.isAdmin() && !string.equals("")) {
                    int[] nArray = new int[]{4, 21, 30, 36, 37, 55, 56};
                    Vector<Map<String, Integer>> vector2 = new Vector<Map<String, Integer>>();
                    vector2.add(this.apMap);
                    vector2.add(this.houseIdMap);
                    vector2.add(this.groupIdMap);
                    vector2.add(this.tariffIdMap);
                    vector2.add(this.serviceIdMap);
                    vector2.add(this.tariffIdMap);
                    vector2.add(this.blockIdMap);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (n != nArray[i]) continue;
                        string2 = "" + (vector2.get(i) != null ? ((Integer)((Map)vector2.get(i)).get(string)).intValue() : this.getValue(string));
                    }
                    if (n == 8 | n == 9) {
                        string2 = this.systemUserIdMap != null ? String.valueOf(this.systemUserIdMap.get(string)) : string;
                    }
                }
                searchConditions.addCondition(n > 100 ? n - 100 : n, n2, string2);
                vector.add(new SearchSetting("" + map.get("field"), "" + map.get("condition")));
            }
            Settings.writeSearchValueToPerst(vector);
        }
        for (int i = 0; i < this.usersTablePanel.getTableModel().getColumnCount(); ++i) {
            searchConditions.addPole(this.usersTablePanel.getTableModel().getColumnName(i));
        }
        return searchConditions;
    }

    private int getValue(Object object) {
        if (object != null) {
            try {
                return Integer.parseInt("" + object);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    private void deleteUser() {
        if (Dialogs.showYesNoDialog("Delete user(s)?")) {
            for (Map<String, Object> map : this.usersTablePanel.getSelectedTableRows()) {
                int n = (Integer)map.get("uid");
                try {
                    UsersFunctions.deleteUser(n);
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog(urfaException.getMessage());
                }
            }
            this.refreshTable();
        }
    }

    private void newPayment() {
        NewPaymentDialog newPaymentDialog = new NewPaymentDialog((Integer)this.usersTablePanel.getSelectedTableRows()[0].get("uid"), 0);
        newPaymentDialog.setVisible(true);
        if (newPaymentDialog.isOkPressed()) {
            this.refreshTable();
        }
    }

    private void editUser() {
        UserFrame userFrame = new UserFrame((Integer)this.usersTablePanel.getSelectedTableRows()[0].get("uid"));
        userFrame.setVisible(true);
    }

    private void turnInternetOn() {
        for (Map<String, Object> map : this.usersTablePanel.getSelectedTableRows()) {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaChangeIntstatForUser(UrfaManagerImpl.getInstance());
                ((UrfaChangeIntstatForUser)object).setUserId((Integer)map.get("uid"));
                ((UrfaChangeIntstatForUser)object).setNeedBlock(0);
                try {
                    ((UrfaChangeIntstatForUser)object).call();
                }
                catch (UrfaException urfaException) {
                    this.log.error("Error updating accounts list", urfaException);
                }
                continue;
            }
            try {
                object = AccountFunctions.getAccount((Integer)map.get("master_account"));
                ((Account)object).setIntStatus(1);
                AccountFunctions.editAccount((Account)object);
            }
            catch (UrfaException urfaException) {
                this.log.error("Error updating accounts list", urfaException);
            }
        }
        this.refreshTable();
    }

    private void turnInternetOff() {
        for (Map<String, Object> map : this.usersTablePanel.getSelectedTableRows()) {
            Object object;
            if (Utils.isAdmin()) {
                object = new UrfaChangeIntstatForUser(UrfaManagerImpl.getInstance());
                ((UrfaChangeIntstatForUser)object).setUserId((Integer)map.get("uid"));
                ((UrfaChangeIntstatForUser)object).setNeedBlock(1);
                try {
                    ((UrfaChangeIntstatForUser)object).call();
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                }
                continue;
            }
            try {
                object = AccountFunctions.getAccount((Integer)map.get("master_account"));
                ((Account)object).setIntStatus(0);
                AccountFunctions.editAccount((Account)object);
            }
            catch (UrfaException urfaException) {
                this.log.error("Error updating accounts list", urfaException);
            }
        }
        this.refreshTable();
    }

    private JComboBox getCopy(JComboBox jComboBox) {
        JComboBox jComboBox2 = new JComboBox();
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            jComboBox2.addItem(jComboBox.getItemAt(i));
        }
        return jComboBox2;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.buttonOK, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Close"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.OKButton = new JButton();
        this.OKButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.$$$loadButtonText$$$(this.OKButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("OK"));
        this.OKButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.OKButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        this.tabbedPane1 = new JTabbedPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)this.tabbedPane1, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Simple"), jPanel10);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Full name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Ballance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel3, gridBagConstraints);
        this.ballanceComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("=");
        defaultComboBoxModel.addElement(">");
        defaultComboBoxModel.addElement("<");
        this.ballanceComboBox.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.ballanceComboBox, gridBagConstraints);
        this.fullNameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.fullNameTextField, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.loginTextField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("UID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel4, gridBagConstraints);
        this.UIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.UIDTextField, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Basic account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel5, gridBagConstraints);
        this.basicAccountTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.basicAccountTextField, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        jPanel10.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel18, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel19, gridBagConstraints);
        this.ballanceTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.ballanceTextField, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel20, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP-address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        jPanel10.add((Component)jLabel6, gridBagConstraints);
        this.textFieldIpAddress = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)this.textFieldIpAddress, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel10.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout(new GridBagLayout());
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Custom"), jPanel22);
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel22.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel23.add((Component)jPanel24, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel24.add((Component)this.andOrComboBox, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 4, 0);
        jPanel24.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel24.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel24.add((Component)jPanel25, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel24.add((Component)jPanel26, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel24.add((Component)jPanel27, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel24.add((Component)jPanel28, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        jPanel29.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel23.add((Component)jPanel29, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel29.add((Component)this.customSearchTablePanel, gridBagConstraints);
        JPanel jPanel30 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel29.add((Component)jPanel30, gridBagConstraints);
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)jPanel31, gridBagConstraints);
        jPanel31.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        this.findNowButton = new JButton();
        this.findNowButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/find16.png")));
        this.$$$loadButtonText$$$(this.findNowButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Find now"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)this.findNowButton, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)this.clearButton, gridBagConstraints);
        JPanel jPanel32 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel31.add((Component)jPanel32, gridBagConstraints);
        JPanel jPanel33 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel31.add((Component)jPanel33, gridBagConstraints);
        JPanel jPanel34 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        jPanel9.add((Component)jPanel34, gridBagConstraints);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)this.buttonsPanel, gridBagConstraints);
        this.newPaymentButton = new JButton();
        this.newPaymentButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/money16.png")));
        this.$$$loadButtonText$$$(this.newPaymentButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("New payment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)this.newPaymentButton, gridBagConstraints);
        this.editButton = new JButton();
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/edituser16.png")));
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)this.editButton, gridBagConstraints);
        this.addToGroupButton = new JButton();
        this.addToGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/groups16.png")));
        this.$$$loadButtonText$$$(this.addToGroupButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add to group"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)this.addToGroupButton, gridBagConstraints);
        JPanel jPanel35 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel35, gridBagConstraints);
        JPanel jPanel36 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)jPanel36, gridBagConstraints);
        JPanel jPanel37 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.buttonsPanel.add((Component)jPanel37, gridBagConstraints);
        JPanel jPanel38 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.buttonsPanel.add((Component)jPanel38, gridBagConstraints);
        JPanel jPanel39 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.buttonsPanel.add((Component)jPanel39, gridBagConstraints);
        this.linkToDealerButton = new JButton();
        this.linkToDealerButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/dealers16.png")));
        this.$$$loadButtonText$$$(this.linkToDealerButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Link to dealer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)this.linkToDealerButton, gridBagConstraints);
        this.exportButton = new JButton();
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/export16.png")));
        this.$$$loadButtonText$$$(this.exportButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Export"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.buttonsPanel.add((Component)this.exportButton, gridBagConstraints);
        JPanel jPanel40 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.buttonsPanel.add((Component)jPanel40, gridBagConstraints);
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel41, gridBagConstraints);
        jPanel41.add((Component)this.usersTablePanel, "Center");
        JPanel jPanel42 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel42, gridBagConstraints);
        jLabel.setLabelFor(this.loginTextField);
        jLabel2.setLabelFor(this.fullNameTextField);
        jLabel3.setLabelFor(this.ballanceComboBox);
        jLabel4.setLabelFor(this.UIDTextField);
        jLabel5.setLabelFor(this.basicAccountTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

