/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.promisedpayment;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeletePromisedPaymentSettings;
import biz.netup.control.transport.urfa.functions.UrfaEditPromisedPaymentSettings;
import biz.netup.control.transport.urfa.functions.UrfaGetPromisedPaymentSettings;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.UpDownButtons;
import biz.netup.projects.utmadmin.gui.mainframe.forms.usersettings.promisedpayment.PromisedPaymentDialog;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PromisedPaymentTab
extends TabPanelWithTable {
    private int priority = 0;
    private Set<Integer> groups;

    public PromisedPaymentTab() {
        this.setRefreshPermission(new int[]{86068});
        this.setAddPermission(new int[]{86069, 9216});
        this.setEditPermission(new int[]{86070});
        this.setDeletePermission(new int[]{86051});
    }

    @Override
    public String getTabName() {
        return "Promised payments";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "User settings";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "ID");
        hashMap.put("group_id", "Group ID");
        hashMap.put("group_name", "Group name");
        hashMap.put("priority", "Priority");
        hashMap.put("is_enabled", "Is enabled");
        hashMap.put("max_value", "Max value");
        hashMap.put("max_duration", "Max duration");
        hashMap.put("interval_duration", "Interval duration");
        hashMap.put("min_balance", "Min balance");
        hashMap.put("use_min_balance", "Use min balance");
        hashMap.put("free_balance", "Free balance");
        hashMap.put("use_free_balance", "Use free balance");
        hashMap.put("service_name", "Service");
        return hashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        this.priority = 0;
        UrfaGetPromisedPaymentSettings urfaGetPromisedPaymentSettings = new UrfaGetPromisedPaymentSettings(UrfaManagerImpl.getInstance());
        urfaGetPromisedPaymentSettings.call();
        this.groups = new HashSet<Integer>();
        for (int n : urfaGetPromisedPaymentSettings.getGroupId1()) {
            this.groups.add(n);
        }
        for (int i = 0; i < urfaGetPromisedPaymentSettings.getCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetPromisedPaymentSettings.getId1()[i]);
            hashMap.put("group_id", urfaGetPromisedPaymentSettings.getGroupId1()[i]);
            if (urfaGetPromisedPaymentSettings.getGroupId1()[i] != 0) {
                hashMap.put("group_name", Resolve.getGroupName(urfaGetPromisedPaymentSettings.getGroupId1()[i]));
                hashMap.put("delete", 1);
            } else {
                hashMap.put("group_name", this.resource.getString("All"));
                hashMap.put("delete", 0);
            }
            hashMap.put("is_enabled", urfaGetPromisedPaymentSettings.getIsEnabled1()[i]);
            hashMap.put("priority", urfaGetPromisedPaymentSettings.getPriopity1()[i]);
            if (i < urfaGetPromisedPaymentSettings.getCount() - 2) {
                hashMap.put("down", 1);
            } else {
                hashMap.put("down", 0);
            }
            if (i < urfaGetPromisedPaymentSettings.getCount() - 1 && i != 0) {
                hashMap.put("up", 1);
            } else {
                hashMap.put("up", 0);
            }
            hashMap.put("max_duration", urfaGetPromisedPaymentSettings.getMaxDuration1()[i] / 86400);
            hashMap.put("interval_duration", urfaGetPromisedPaymentSettings.getIntervalDuration1()[i] / 86400);
            hashMap.put("max_value", urfaGetPromisedPaymentSettings.getMaxValue1()[i]);
            hashMap.put("min_balance", urfaGetPromisedPaymentSettings.getMinBalance1()[i]);
            hashMap.put("use_min_balance", urfaGetPromisedPaymentSettings.getUseMinBalance1()[i]);
            hashMap.put("free_balance", urfaGetPromisedPaymentSettings.getFreeBalance1()[i]);
            hashMap.put("use_free_balance", urfaGetPromisedPaymentSettings.getUseFreeBalance1()[i]);
            hashMap.put("service_id", urfaGetPromisedPaymentSettings.getServiceId1()[i]);
            hashMap.put("service_name", Resolve.getServiceName(urfaGetPromisedPaymentSettings.getServiceId1()[i]));
            hashMap.put("flags", urfaGetPromisedPaymentSettings.getFlags1()[i]);
            if (this.priority < urfaGetPromisedPaymentSettings.getPriopity1()[i] + 1) {
                this.priority = urfaGetPromisedPaymentSettings.getPriopity1()[i] + 1;
            }
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        UpDownButtons upDownButtons = new UpDownButtons();
        this.getAdditionalButtonPanel2().add(upDownButtons.getButtonPanel());
        this.mainTablePanel.registerFieldButtonBlock(this.deleteButton, "delete", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getUpButton(), "up", 0);
        this.mainTablePanel.registerFieldButtonBlock(upDownButtons.getDownButton(), "down", 0);
        this.mainTablePanel.registerOneRowButton(upDownButtons.getUpButton());
        this.mainTablePanel.registerOneRowButton(upDownButtons.getDownButton());
        upDownButtons.getUpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PromisedPaymentTab.this.up();
            }
        });
        upDownButtons.getDownButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PromisedPaymentTab.this.down();
            }
        });
    }

    private void change(Map<String, Object> map, Map<String, Object> map2) {
        try {
            UrfaEditPromisedPaymentSettings urfaEditPromisedPaymentSettings = new UrfaEditPromisedPaymentSettings(UrfaManagerImpl.getInstance());
            urfaEditPromisedPaymentSettings.setId((Integer)map.get("id"));
            urfaEditPromisedPaymentSettings.setGroupId((Integer)map.get("group_id"));
            urfaEditPromisedPaymentSettings.setIsEnabled((Integer)map.get("is_enabled"));
            urfaEditPromisedPaymentSettings.setIntervalDuration((Integer)map.get("interval_duration"));
            urfaEditPromisedPaymentSettings.setMaxDuration((Integer)map.get("max_duration"));
            urfaEditPromisedPaymentSettings.setMinBalance((Double)map.get("min_balance"));
            urfaEditPromisedPaymentSettings.setFreeBalance((Double)map.get("free_balance"));
            urfaEditPromisedPaymentSettings.setUseMinBalance((Integer)map.get("use_min_balance"));
            urfaEditPromisedPaymentSettings.setUseFreeBalance((Integer)map.get("use_free_balance"));
            urfaEditPromisedPaymentSettings.setMaxValue((Double)map.get("max_value"));
            urfaEditPromisedPaymentSettings.setServiceId((Integer)map.get("service_id"));
            urfaEditPromisedPaymentSettings.setPriopity((Integer)map2.get("priority"));
            urfaEditPromisedPaymentSettings.call();
            urfaEditPromisedPaymentSettings = new UrfaEditPromisedPaymentSettings(UrfaManagerImpl.getInstance());
            urfaEditPromisedPaymentSettings.setId((Integer)map2.get("id"));
            urfaEditPromisedPaymentSettings.setGroupId((Integer)map2.get("group_id"));
            urfaEditPromisedPaymentSettings.setIsEnabled((Integer)map2.get("is_enabled"));
            urfaEditPromisedPaymentSettings.setIntervalDuration((Integer)map2.get("interval_duration"));
            urfaEditPromisedPaymentSettings.setMaxDuration((Integer)map2.get("max_duration"));
            urfaEditPromisedPaymentSettings.setMinBalance((Double)map2.get("min_balance"));
            urfaEditPromisedPaymentSettings.setFreeBalance((Double)map2.get("free_balance"));
            urfaEditPromisedPaymentSettings.setUseMinBalance((Integer)map2.get("use_min_balance"));
            urfaEditPromisedPaymentSettings.setUseFreeBalance((Integer)map2.get("use_free_balance"));
            urfaEditPromisedPaymentSettings.setMaxValue((Double)map2.get("max_value"));
            urfaEditPromisedPaymentSettings.setServiceId((Integer)map2.get("service_id"));
            urfaEditPromisedPaymentSettings.setPriopity((Integer)map.get("priority"));
            urfaEditPromisedPaymentSettings.call();
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private void up() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i <= 0) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i - 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    private void down() {
        Map<String, Object> map = this.mainTablePanel.getSelectedTableRows()[0];
        Map<String, Object> map2 = null;
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            if (this.mainTablePanel.getTableModel().data.get(i) != map || i >= this.mainTablePanel.getTableModel().data.size() - 2) continue;
            map2 = this.mainTablePanel.getTableModel().data.get(i + 1);
        }
        if (map2 == null) {
            return;
        }
        this.change(map, map2);
        this.refresh();
    }

    @Override
    protected void add() {
        this.log.log(10, "Add element - " + this.getTabName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groups", this.groups);
        hashMap.put("priority", this.priority);
        this.getItemDialog(hashMap).run(this);
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDeletePromisedPaymentSettings urfaDeletePromisedPaymentSettings = new UrfaDeletePromisedPaymentSettings(UrfaManagerImpl.getInstance());
        urfaDeletePromisedPaymentSettings.setId((Integer)map.get("id"));
        urfaDeletePromisedPaymentSettings.call();
        if (urfaDeletePromisedPaymentSettings.getResult() == -1) {
            throw new UrfaException(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete item(s)"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new PromisedPaymentDialog(map);
    }
}

