/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.tp;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddTariffNew;
import biz.netup.control.transport.urfa.functions.UrfaDelServiceFromTariff;
import biz.netup.control.transport.urfa.functions.UrfaEditTariffNew;
import biz.netup.control.transport.urfa.functions.UrfaGetTariffNew;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.fictiveservices.MainFictiveServicesTab;
import biz.netup.projects.utmadmin.gui.serviceframe.ServiceFrame;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.permissions.PermissionTextField;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.FrameModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TPDialog
extends FrameModel {
    private JPanel mainPanel;
    private JTextField tariffIDTextField;
    private JTextField tariffNameTextField;
    private JCheckBox resetBallanceAtTheCheckBox;
    private JTextField createdOnTextField;
    private JTextField createdByTextField;
    private JTextField modifiedOnTextField;
    private JTextField modifiedByTextField;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private TablePanelImpl servicesTablePanel;
    private JPanel createModifyPanel;
    private JPanel servicesPanel;
    private JLabel tariffIDLabel;
    private PermissionTextField commentsPermissionTextField;
    private JPanel tidPanel;

    public TPDialog() {
        this.$$$setupUI$$$();
    }

    public TPDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    protected boolean isModalDialog() {
        return false;
    }

    private void createUIComponents() {
        this.createTable();
        this.commentsPermissionTextField = new PermissionTextField(new int[]{12354, 12353});
    }

    private void createTable() {
        this.servicesTablePanel = new TablePanelImpl(this.getClass().getName() + "_services", true);
        MapTableModel mapTableModel = this.servicesTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, false);
        mapTableModel.addColumn("type", "Type", true, false);
        mapTableModel.addColumn("name", "Name", true, false);
        mapTableModel.addColumn("comment", "Comment", true, false);
        this.servicesTablePanel.setEditable(false);
        this.servicesTablePanel.setAppendable(false);
        this.servicesTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                TPDialog.this.editService();
            }
        });
        this.servicesTablePanel.applyTableSettings();
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Tariff plan";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        Dimension dimension;
        if (!this.isAddMode()) {
            dimension = new Dimension(400, 450);
            this.refreshDetails();
        } else {
            dimension = new Dimension(400, 120);
            this.createModifyPanel.setVisible(false);
            this.servicesPanel.setVisible(false);
            this.tariffIDLabel.setVisible(false);
            this.tariffIDTextField.setVisible(false);
        }
        this.mainPanel.setMinimumSize(dimension);
        this.mainPanel.setPreferredSize(dimension);
        this.servicesTablePanel.registerOneRowButton(this.editButton);
        this.servicesTablePanel.registerOneRowButton(this.deleteButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TPDialog.this.addService();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TPDialog.this.deleteService();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TPDialog.this.editService();
            }
        });
        this.resetBallanceAtTheCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TPDialog.this.resetBallanceAtTheCheckBox.isSelected() && !Dialogs.showYesNoDialog(TPDialog.this.resource.getString("Reset balance warning"))) {
                    TPDialog.this.resetBallanceAtTheCheckBox.setSelected(false);
                }
            }
        });
    }

    public void refreshDetails() throws UrfaException {
        UrfaGetTariffNew urfaGetTariffNew = new UrfaGetTariffNew(UrfaManagerImpl.getInstance());
        urfaGetTariffNew.setTariffId((Integer)this.item.get("id"));
        urfaGetTariffNew.call();
        if (UrfaManagerImpl.getInstance().isPermitted(12352)) {
            this.commentsPermissionTextField.setText(urfaGetTariffNew.getComments());
        }
        this.tariffNameTextField.setText(urfaGetTariffNew.getTariffName());
        this.tariffIDTextField.setText("" + this.item.get("id"));
        this.resetBallanceAtTheCheckBox.setSelected(urfaGetTariffNew.getTariffBalanceRollover() == 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        this.createdByTextField.setText(urfaGetTariffNew.getWhoCreateLogin());
        this.createdOnTextField.setText(simpleDateFormat.format(new Date((long)urfaGetTariffNew.getTariffCreateDate() * 1000L)));
        this.modifiedByTextField.setText(urfaGetTariffNew.getWhoChangeLogin());
        this.modifiedOnTextField.setText(simpleDateFormat.format(new Date((long)urfaGetTariffNew.getTariffChangeDate() * 1000L)));
        this.servicesTablePanel.getTableModel().removeAllRows();
        for (int i = 0; i < urfaGetTariffNew.getServicesCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetTariffNew.getServiceIdArray1()[i]);
            hashMap.put("type", Resolve.getServiceTypeName(urfaGetTariffNew.getServiceTypeArray1()[i]));
            hashMap.put("type_id", urfaGetTariffNew.getServiceTypeArray1()[i]);
            hashMap.put("name", urfaGetTariffNew.getServiceNameArray1()[i]);
            hashMap.put("comment", urfaGetTariffNew.getCommentArray1()[i]);
            this.servicesTablePanel.getTableModel().addRow(hashMap);
        }
    }

    private void addService() {
        MainFictiveServicesTab mainFictiveServicesTab = new MainFictiveServicesTab();
        SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(mainFictiveServicesTab);
        selectFromTableDialogModel.setTitle(this.resource.getString("Choose parent service"));
        selectFromTableDialogModel.setVisible(true);
        if (selectFromTableDialogModel.isOkPressed()) {
            ServiceFrame serviceFrame = new ServiceFrame((Integer)selectFromTableDialogModel.getItem().get("id"), (Integer)this.item.get("id"), (Integer)selectFromTableDialogModel.getItem().get("type_id"), true, this);
            serviceFrame.setVisible(true);
        }
    }

    private void deleteService() {
        for (Map<String, Object> map : this.servicesTablePanel.getSelectedTableRows()) {
            UrfaDelServiceFromTariff urfaDelServiceFromTariff = new UrfaDelServiceFromTariff(UrfaManagerImpl.getInstance());
            urfaDelServiceFromTariff.setSid((Integer)map.get("id"));
            urfaDelServiceFromTariff.setTpId((Integer)this.item.get("id"));
            try {
                urfaDelServiceFromTariff.call();
            }
            catch (UrfaException urfaException) {
                this.log.error("Cannot delete service", urfaException);
            }
        }
        try {
            this.refreshDetails();
        }
        catch (UrfaException urfaException) {
            this.log.error("Error", urfaException);
        }
    }

    private void editService() {
        ServiceFrame serviceFrame = new ServiceFrame((Integer)this.servicesTablePanel.getSelectedTableRows()[0].get("id"), (Integer)this.item.get("id"), (Integer)this.servicesTablePanel.getSelectedTableRows()[0].get("type_id"), false, this);
        serviceFrame.setVisible(true);
        serviceFrame.requestFocus();
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.isAddMode()) {
            UrfaAddTariffNew urfaAddTariffNew = new UrfaAddTariffNew(UrfaManagerImpl.getInstance());
            urfaAddTariffNew.setName(this.tariffNameTextField.getText());
            urfaAddTariffNew.setBalanceRollover(this.resetBallanceAtTheCheckBox.isSelected() ? 1 : 0);
            urfaAddTariffNew.setComments(this.commentsPermissionTextField.getText());
            urfaAddTariffNew.call();
            this.item.put("id", urfaAddTariffNew.getTpId());
        } else {
            UrfaEditTariffNew urfaEditTariffNew = new UrfaEditTariffNew(UrfaManagerImpl.getInstance());
            urfaEditTariffNew.setName(this.tariffNameTextField.getText());
            urfaEditTariffNew.setTpId((Integer)this.item.get("id"));
            urfaEditTariffNew.setBalanceRollover(this.resetBallanceAtTheCheckBox.isSelected() ? 1 : 0);
            urfaEditTariffNew.setComments(this.commentsPermissionTextField.getText());
            urfaEditTariffNew.call();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.tariffNameTextField, "Name");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(330, 400));
        this.mainPanel.setPreferredSize(new Dimension(330, 400));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Tariff name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.tariffNameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.tariffNameTextField, gridBagConstraints);
        this.resetBallanceAtTheCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.resetBallanceAtTheCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Reset ballance at the accounting period end"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.resetBallanceAtTheCheckBox, gridBagConstraints);
        this.createModifyPanel = new JPanel();
        this.createModifyPanel.setLayout(new GridBagLayout());
        this.createModifyPanel.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.createModifyPanel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Created on"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.createModifyPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Created by"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.createModifyPanel.add((Component)jLabel3, gridBagConstraints);
        this.createdOnTextField = new JTextField();
        this.createdOnTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)this.createdOnTextField, gridBagConstraints);
        this.createdByTextField = new JTextField();
        this.createdByTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)this.createdByTextField, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Modified last time on"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.createModifyPanel.add((Component)jLabel4, gridBagConstraints);
        this.modifiedOnTextField = new JTextField();
        this.modifiedOnTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)this.modifiedOnTextField, gridBagConstraints);
        this.modifiedByTextField = new JTextField();
        this.modifiedByTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)this.modifiedByTextField, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Modified by"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.createModifyPanel.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.createModifyPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.createModifyPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.createModifyPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.createModifyPanel.add((Component)jPanel5, gridBagConstraints);
        this.servicesPanel = new JPanel();
        this.servicesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.servicesPanel, gridBagConstraints);
        this.servicesPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Services")));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.servicesPanel.add((Component)jPanel6, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.addButton, gridBagConstraints);
        this.editButton = new JButton();
        this.editButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        this.editButton.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.editButton, gridBagConstraints);
        this.deleteButton = new JButton();
        this.deleteButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.deleteButton, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.servicesPanel.add((Component)jPanel11, gridBagConstraints);
        jPanel11.add((Component)this.servicesTablePanel, "Center");
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel12, gridBagConstraints);
        this.tariffIDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.tariffIDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Tariff ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.tariffIDLabel, gridBagConstraints);
        this.tariffIDTextField = new JTextField();
        this.tariffIDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.tariffIDTextField, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel15, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.commentsPermissionTextField, gridBagConstraints);
        jLabel2.setLabelFor(this.createdOnTextField);
        jLabel3.setLabelFor(this.createdByTextField);
        jLabel4.setLabelFor(this.modifiedOnTextField);
        jLabel5.setLabelFor(this.modifiedByTextField);
        this.tariffIDLabel.setLabelFor(this.tariffIDTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

