/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.timeranges;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddTimeRange;
import biz.netup.control.transport.urfa.functions.UrfaSaveTimeRange;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TRDialog
extends DialogModel {
    private JTabbedPane tabbedPane1;
    private JPanel weekTimePanel;
    private JTable table;
    private JPanel mainPanel;
    private JButton deleteDayButton;
    private JButton addDayButton;
    private TablePanelImpl daysTablePanel;
    private JButton deleteTimeButton;
    private TablePanelImpl timesTablePanel;
    private JButton addTimeButton;
    private JTextField nameTextField;
    private JTextField priorityTextField;
    private Map<String, Integer> dayData;
    private Map<String, Integer> monthData;
    private Map<String, Integer> weekDayData;
    private Map<String, Integer> hourData;
    private Map<String, Integer> minuteData;
    Object[][] data;
    int[][] data_model;
    String[] columnNames;

    public TRDialog() {
        this.$$$setupUI$$$();
    }

    public TRDialog(Map<String, Object> map) {
        super(map);
    }

    private void initData() {
        this.columnNames = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
        this.data = new Object[7][];
        this.data_model = new int[7][];
        for (int i = 0; i < 7; ++i) {
            this.data[i] = new Object[24];
            this.data_model[i] = new int[24];
            for (int j = 0; j < 24; ++j) {
                this.data[i][j] = false;
                this.data_model[i][j] = 0;
            }
        }
    }

    private void createTable() {
        this.initData();
        this.table = new JTable(new TableModel(){

            @Override
            public int getRowCount() {
                return 7;
            }

            @Override
            public int getColumnCount() {
                return 24;
            }

            @Override
            public String getColumnName(int n) {
                return TRDialog.this.columnNames[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return Boolean.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return TRDialog.this.data[n][n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                for (int n3 : TRDialog.this.table.getSelectedRows()) {
                    for (int n4 : TRDialog.this.table.getSelectedColumns()) {
                        TRDialog.this.data[n3][n4] = object;
                        TRDialog.this.data_model[n3][n4] = (Boolean)object != false ? 1 : 0;
                        TRDialog.this.fillTimeTable();
                    }
                }
                TRDialog.this.table.repaint();
            }

            @Override
            public void addTableModelListener(TableModelListener tableModelListener) {
            }

            @Override
            public void removeTableModelListener(TableModelListener tableModelListener) {
            }
        });
        this.table.setColumnSelectionAllowed(true);
        this.table.setDefaultRenderer(Boolean.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JPanel jPanel = new JPanel();
                if (TRDialog.this.data_model[n][n2] == 1) {
                    ((Component)jPanel).setBackground(new Color(0, 204, 204));
                } else if (TRDialog.this.data_model[n][n2] == 0) {
                    ((Component)jPanel).setBackground(Color.WHITE);
                } else {
                    ((Component)jPanel).setBackground(Color.MAGENTA);
                }
                return jPanel;
            }
        });
    }

    private void createUIComponents() {
        this.createTable();
        this.createDaysTable();
        this.createWeekTable();
    }

    private void createWeekTable() {
        this.timesTablePanel = new TablePanelImpl(this.getClass().getName() + "_times", true);
        MapTableModel mapTableModel = this.timesTablePanel.getTableModel();
        mapTableModel.addColumn("day_from", "From day", true, true);
        mapTableModel.addColumn("hour_from", "From hour", true, true);
        mapTableModel.addColumn("minute_from", "From minute", true, true);
        mapTableModel.addColumn("second_from", "From second", true, true);
        mapTableModel.addColumn("day_to", "To day", true, true);
        mapTableModel.addColumn("hour_to", "To hour", true, true);
        mapTableModel.addColumn("minute_to", "To minute", true, true);
        mapTableModel.addColumn("second_to", "To second", true, true);
        this.timesTablePanel.setEditable(true);
        this.timesTablePanel.setAppendable(false);
        this.timesTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(TRDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(TRDialog.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TRDialog.this.deleteTime();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TRDialog.this.addTime();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
            }
        });
        this.fillCombo();
        JComboBox<String> jComboBox = new JComboBox<String>();
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        JComboBox<String> jComboBox4 = new JComboBox<String>();
        for (String string : this.weekDayData.keySet()) {
            jComboBox.addItem(string);
        }
        for (String string : this.hourData.keySet()) {
            jComboBox2.addItem(string);
        }
        for (String string : this.minuteData.keySet()) {
            jComboBox3.addItem(string);
            jComboBox4.addItem(string);
        }
        this.timesTablePanel.applyTableSettings();
        this.timesTablePanel.setCellEditor("day_to", new ComboBoxCellEditor(jComboBox, true, false));
        this.timesTablePanel.setCellEditor("hour_to", new ComboBoxCellEditor(jComboBox2, true, false));
        this.timesTablePanel.setCellEditor("minute_to", new ComboBoxCellEditor(jComboBox3, true, false));
        this.timesTablePanel.setCellEditor("second_to", new ComboBoxCellEditor(jComboBox4, true, false));
        this.timesTablePanel.setCellEditor("day_from", new ComboBoxCellEditor(jComboBox, true, false));
        this.timesTablePanel.setCellEditor("hour_from", new ComboBoxCellEditor(jComboBox2, true, false));
        this.timesTablePanel.setCellEditor("minute_from", new ComboBoxCellEditor(jComboBox3, true, false));
        this.timesTablePanel.setCellEditor("second_from", new ComboBoxCellEditor(jComboBox4, true, false));
    }

    private void createDaysTable() {
        this.daysTablePanel = new TablePanelImpl(this.getClass().getName() + "_days", true);
        MapTableModel mapTableModel = this.daysTablePanel.getTableModel();
        mapTableModel.addColumn("day", "Day", true, true);
        mapTableModel.addColumn("month", "Month", true, true);
        this.daysTablePanel.setEditable(true);
        this.daysTablePanel.setAppendable(false);
        this.daysTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(TRDialog.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(TRDialog.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TRDialog.this.deleteDay();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TRDialog.this.addDay();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
            }
        });
        this.fillCombo();
        JComboBox<String> jComboBox = new JComboBox<String>();
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (String string : this.dayData.keySet()) {
            jComboBox.addItem(string);
        }
        for (String string : this.monthData.keySet()) {
            jComboBox2.addItem(string);
        }
        this.daysTablePanel.applyTableSettings();
        this.daysTablePanel.setCellEditor("day", new ComboBoxCellEditor(jComboBox, true, false));
        this.daysTablePanel.setCellEditor("month", new ComboBoxCellEditor(jComboBox2, true, false));
    }

    private void fillCombo() {
        int n;
        this.dayData = new LinkedHashMap<String, Integer>();
        for (n = 1; n <= 31; ++n) {
            this.dayData.put("" + n, n);
        }
        this.weekDayData = new LinkedHashMap<String, Integer>();
        this.hourData = new LinkedHashMap<String, Integer>();
        this.minuteData = new LinkedHashMap<String, Integer>();
        for (n = 0; n <= 23; ++n) {
            this.hourData.put("" + n, n);
        }
        for (n = 0; n <= 59; ++n) {
            this.minuteData.put("" + n, n);
        }
        this.weekDayData.put(this.resource.getString("Sunday"), 0);
        this.weekDayData.put(this.resource.getString("Monday"), 1);
        this.weekDayData.put(this.resource.getString("Tuesday"), 2);
        this.weekDayData.put(this.resource.getString("Wednesday"), 3);
        this.weekDayData.put(this.resource.getString("Thursday"), 4);
        this.weekDayData.put(this.resource.getString("Friday"), 5);
        this.weekDayData.put(this.resource.getString("Saturday"), 6);
        this.monthData = new LinkedHashMap<String, Integer>();
        this.monthData.put(this.resource.getString("January"), 0);
        this.monthData.put(this.resource.getString("February"), 1);
        this.monthData.put(this.resource.getString("March"), 2);
        this.monthData.put(this.resource.getString("April"), 3);
        this.monthData.put(this.resource.getString("May"), 4);
        this.monthData.put(this.resource.getString("June"), 5);
        this.monthData.put(this.resource.getString("July"), 6);
        this.monthData.put(this.resource.getString("August"), 7);
        this.monthData.put(this.resource.getString("September"), 8);
        this.monthData.put(this.resource.getString("October"), 9);
        this.monthData.put(this.resource.getString("November"), 10);
        this.monthData.put(this.resource.getString("December"), 11);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Time range";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.addDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TRDialog.this.addDay();
            }
        });
        this.deleteDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TRDialog.this.deleteDay();
            }
        });
        this.addTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TRDialog.this.addTime();
            }
        });
        this.deleteTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TRDialog.this.deleteTime();
            }
        });
        this.tabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (TRDialog.this.tabbedPane1.getSelectedIndex() == 0) {
                    TRDialog.this.fillSmartTable();
                }
            }
        });
        this.daysTablePanel.registerMultiRowButton(this.deleteDayButton);
        this.timesTablePanel.registerMultiRowButton(this.deleteTimeButton);
        if (!this.isAddMode()) {
            this.fillDaysTablePanel();
            this.fillTimesTablePanel();
            this.fillSmartTable();
            this.nameTextField.setText("" + this.item.get("name"));
            this.priorityTextField.setText("" + this.item.get("priority"));
        } else {
            this.priorityTextField.setText("0");
        }
    }

    private void fillSmartTable() {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 24; ++j) {
                this.data_model[i][j] = 0;
                this.data[i][j] = false;
            }
        }
        this.setSimpleParseMode(true);
        for (Map<String, Object> map : this.timesTablePanel.getTableModel().data) {
            int n;
            for (n = this.weekDayData.get(map.get("day_from")).intValue(); n <= this.weekDayData.get(map.get("day_to")); ++n) {
                for (int i = this.hourData.get(map.get("hour_from")).intValue(); i <= this.hourData.get(map.get("hour_to")); ++i) {
                    this.data_model[n][i] = 1;
                    this.data[n][i] = true;
                }
            }
            if (this.minuteData.get(map.get("minute_from")) != 0 || this.minuteData.get(map.get("second_from")) != 0) {
                for (n = this.weekDayData.get(map.get("day_from")).intValue(); n <= this.weekDayData.get(map.get("day_to")); ++n) {
                    this.data_model[n][this.hourData.get((Object)map.get((Object)"hour_from")).intValue()] = 2;
                }
                this.setSimpleParseMode(false);
            }
            if (this.minuteData.get(map.get("minute_to")) == 59 && this.minuteData.get(map.get("second_to")) == 59) continue;
            for (n = this.weekDayData.get(map.get("day_from")).intValue(); n <= this.weekDayData.get(map.get("day_to")); ++n) {
                this.data_model[n][this.hourData.get((Object)map.get((Object)"hour_to")).intValue()] = 2;
            }
            this.setSimpleParseMode(false);
        }
        this.table.repaint();
    }

    private void fillTimeTable() {
        this.timesTablePanel.getTableModel().removeAllRows();
        boolean bl = false;
        HashMap<String, Object> hashMap = null;
        for (int i = 0; i < 169; ++i) {
            if (i == 168) {
                if (bl) {
                    if (hashMap != null) {
                        for (String string : this.weekDayData.keySet()) {
                            if (this.weekDayData.get(string) != (int)Math.floor((float)(i - 1) / 24.0f)) continue;
                            hashMap.put("day_to", string);
                            hashMap.put("day_to_id", (int)Math.floor((float)(i - 1) / 24.0f));
                        }
                        hashMap.put("hour_to", i - 1 - 24 * (int)Math.floor((float)(i - 1) / 24.0f));
                        this.timesTablePanel.getTableModel().addRow(hashMap);
                    }
                    bl = false;
                }
            } else if (((Boolean)this.data[(int)Math.floor((float)i / 24.0f)][i - 24 * (int)Math.floor((float)i / 24.0f)]).booleanValue()) {
                if (!bl) {
                    hashMap = new HashMap<String, Object>();
                    for (String string : this.weekDayData.keySet()) {
                        if (this.weekDayData.get(string) != (int)Math.floor((float)i / 24.0f)) continue;
                        hashMap.put("day_from_id", (int)Math.floor((float)i / 24.0f));
                        hashMap.put("day_from", string);
                    }
                    hashMap.put("hour_from", "" + (i - 24 * (int)Math.floor((float)i / 24.0f)));
                    hashMap.put("minute_from", "0");
                    hashMap.put("second_from", "0");
                    hashMap.put("minute_to", "59");
                    hashMap.put("second_to", "59");
                    bl = true;
                }
            } else if (bl) {
                if (hashMap != null) {
                    for (String string : this.weekDayData.keySet()) {
                        if (this.weekDayData.get(string) != (int)Math.floor((float)(i - 1) / 24.0f)) continue;
                        hashMap.put("day_to", string);
                        hashMap.put("day_to_id", (int)Math.floor((float)(i - 1) / 24.0f));
                    }
                    hashMap.put("hour_to", "" + (i - 1 - 24 * (int)Math.floor((float)(i - 1) / 24.0f)));
                    this.timesTablePanel.getTableModel().addRow(hashMap);
                }
                bl = false;
            }
            if ((i + 1) % 24 != 0 || !bl) continue;
            for (String string : this.weekDayData.keySet()) {
                if (this.weekDayData.get(string) != (int)Math.floor((float)(i - 1) / 24.0f)) continue;
                hashMap.put("day_to", string);
                hashMap.put("day_to_id", (int)Math.floor((float)(i - 1) / 24.0f));
            }
            hashMap.put("hour_to", "" + (i - 24 * (int)Math.floor((float)(i - 1) / 24.0f)));
            this.timesTablePanel.getTableModel().addRow(hashMap);
            bl = false;
        }
    }

    private void setSimpleParseMode(boolean bl) {
        this.table.setEnabled(bl);
    }

    private void fillTimesTablePanel() {
        for (Map map : (Vector)this.item.get("times")) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", map.get("id"));
            hashMap.put("hour_to", "" + map.get("hour_to"));
            hashMap.put("minute_to", "" + map.get("minute_to"));
            hashMap.put("second_to", "" + map.get("second_to"));
            hashMap.put("hour_from", "" + map.get("hour_from"));
            hashMap.put("minute_from", "" + map.get("minute_from"));
            hashMap.put("second_from", "" + map.get("second_from"));
            for (String string : this.weekDayData.keySet()) {
                if (this.weekDayData.get(string) == map.get("day_to")) {
                    hashMap.put("day_to", string);
                    hashMap.put("day_to_id", map.get("day_to"));
                }
                if (this.weekDayData.get(string) != map.get("day_from")) continue;
                hashMap.put("day_from", string);
                hashMap.put("day_from_id", map.get("day_from"));
            }
            this.timesTablePanel.getTableModel().addRow(hashMap);
        }
    }

    private void fillDaysTablePanel() {
        for (Map map : (Vector)this.item.get("days")) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", map.get("id"));
            hashMap.put("day", map.get("day").toString());
            for (String string : this.monthData.keySet()) {
                if (this.monthData.get(string) != map.get("month")) continue;
                hashMap.put("month", string);
                hashMap.put("month_id", map.get("month"));
            }
            this.daysTablePanel.getTableModel().addRow(hashMap);
        }
    }

    private void addDay() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("day", "1");
        hashMap.put("month", this.resource.getString("January"));
        hashMap.put("month_id", 0);
        this.daysTablePanel.getTableModel().addRow(hashMap);
    }

    private void deleteDay() {
        for (Map<String, Object> map : this.daysTablePanel.getSelectedTableRows()) {
            this.daysTablePanel.getTableModel().removeRow(map);
        }
    }

    private void addTime() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("day_to", this.resource.getString("Sunday"));
        hashMap.put("day_to_id", 0);
        hashMap.put("hour_to", "0");
        hashMap.put("minute_to", "0");
        hashMap.put("second_to", "0");
        hashMap.put("day_from", this.resource.getString("Sunday"));
        hashMap.put("day_from_id", 0);
        hashMap.put("hour_from", "0");
        hashMap.put("minute_from", "0");
        hashMap.put("second_from", "0");
        this.timesTablePanel.getTableModel().addRow(hashMap);
    }

    private void deleteTime() {
        for (Map<String, Object> map : this.timesTablePanel.getSelectedTableRows()) {
            this.timesTablePanel.getTableModel().removeRow(map);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.isAddMode()) {
            UrfaAddTimeRange urfaAddTimeRange = new UrfaAddTimeRange(UrfaManagerImpl.getInstance());
            urfaAddTimeRange.setTrName(this.nameTextField.getText());
            urfaAddTimeRange.setPriority(Integer.parseInt(this.priorityTextField.getText()));
            urfaAddTimeRange.setSizeTrd(this.timesTablePanel.getTable().getRowCount());
            urfaAddTimeRange.setHourStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "hour_from"));
            urfaAddTimeRange.setHourStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "hour_to"));
            urfaAddTimeRange.setMinStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "minute_from"));
            urfaAddTimeRange.setMinStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "minute_to"));
            urfaAddTimeRange.setSecStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "second_from"));
            urfaAddTimeRange.setSecStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "second_to"));
            int[] nArray = new int[this.timesTablePanel.getTable().getRowCount()];
            int[] nArray2 = new int[this.timesTablePanel.getTable().getRowCount()];
            for (int i = 0; i < this.timesTablePanel.getTable().getRowCount(); ++i) {
                nArray[i] = this.weekDayData.get(this.timesTablePanel.getTableModel().data.get(i).get("day_from"));
                nArray2[i] = this.weekDayData.get(this.timesTablePanel.getTableModel().data.get(i).get("day_to"));
            }
            urfaAddTimeRange.setWdayStart1(nArray);
            urfaAddTimeRange.setWdayStop1(nArray2);
            urfaAddTimeRange.setDaysSize(this.daysTablePanel.getTable().getRowCount());
            urfaAddTimeRange.setMday1(ArrayFromVector.getIntArrayFromData(this.daysTablePanel.getTableModel().data, "day"));
            int[] nArray3 = new int[this.daysTablePanel.getTable().getRowCount()];
            int[] nArray4 = new int[this.daysTablePanel.getTable().getRowCount()];
            for (int i = 0; i < this.daysTablePanel.getTable().getRowCount(); ++i) {
                nArray3[i] = this.monthData.get(this.daysTablePanel.getTableModel().data.get(i).get("month"));
                nArray4[i] = i;
            }
            urfaAddTimeRange.setMonth1(nArray3);
            urfaAddTimeRange.setInternalId1(nArray4);
            urfaAddTimeRange.call();
        } else {
            UrfaSaveTimeRange urfaSaveTimeRange = new UrfaSaveTimeRange(UrfaManagerImpl.getInstance());
            urfaSaveTimeRange.setTrId((Integer)this.item.get("id"));
            urfaSaveTimeRange.setTrName(this.nameTextField.getText());
            urfaSaveTimeRange.setPriority(Integer.parseInt(this.priorityTextField.getText()));
            urfaSaveTimeRange.setSizeTrd(this.timesTablePanel.getTable().getRowCount());
            urfaSaveTimeRange.setHourStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "hour_from"));
            urfaSaveTimeRange.setHourStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "hour_to"));
            urfaSaveTimeRange.setMinStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "minute_from"));
            urfaSaveTimeRange.setMinStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "minute_to"));
            urfaSaveTimeRange.setSecStart1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "second_from"));
            urfaSaveTimeRange.setSecStop1(ArrayFromVector.getIntArrayFromData(this.timesTablePanel.getTableModel().data, "second_to"));
            int[] nArray = new int[this.timesTablePanel.getTable().getRowCount()];
            int[] nArray5 = new int[this.timesTablePanel.getTable().getRowCount()];
            int[] nArray6 = new int[this.timesTablePanel.getTable().getRowCount()];
            for (int i = 0; i < this.timesTablePanel.getTable().getRowCount(); ++i) {
                nArray[i] = this.weekDayData.get(this.timesTablePanel.getTableModel().data.get(i).get("day_from"));
                nArray5[i] = this.weekDayData.get(this.timesTablePanel.getTableModel().data.get(i).get("day_to"));
                nArray6[i] = 0;
            }
            urfaSaveTimeRange.setWdayStart1(nArray);
            urfaSaveTimeRange.setWdayStop1(nArray5);
            urfaSaveTimeRange.setTrEntryId1(nArray6);
            urfaSaveTimeRange.setDaysSize(this.daysTablePanel.getTable().getRowCount());
            urfaSaveTimeRange.setMday1(ArrayFromVector.getIntArrayFromData(this.daysTablePanel.getTableModel().data, "day"));
            int[] nArray7 = new int[this.daysTablePanel.getTable().getRowCount()];
            int[] nArray8 = new int[this.daysTablePanel.getTable().getRowCount()];
            for (int i = 0; i < this.daysTablePanel.getTable().getRowCount(); ++i) {
                nArray7[i] = this.monthData.get(this.daysTablePanel.getTableModel().data.get(i).get("month"));
                nArray8[i] = i;
            }
            urfaSaveTimeRange.setMonth1(nArray7);
            urfaSaveTimeRange.setInternalId1(nArray8);
            urfaSaveTimeRange.call();
        }
    }

    private void checkDaysValid() throws IllegalArgumentException {
        for (int i = 0; i < this.daysTablePanel.getTable().getRowCount(); ++i) {
            int n = this.monthData.get(this.daysTablePanel.getTableModel().data.get(i).get("month"));
            if (n == 1) {
                if (this.dayData.get(this.daysTablePanel.getTableModel().data.get(i).get("day")) <= 29) continue;
                Dialogs.showErrorDialog(this.resource.getString("No day") + " " + this.daysTablePanel.getTableModel().data.get(i).get("month"));
                throw new IllegalArgumentException();
            }
            if (n != 3 && n != 5 && n != 8 && n != 10 || this.dayData.get(this.daysTablePanel.getTableModel().data.get(i).get("day")) <= 30) continue;
            Dialogs.showErrorDialog(this.resource.getString("No day") + " " + this.daysTablePanel.getTableModel().data.get(i).get("month"));
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameTextField, "Name");
        this.checkName(this.priorityTextField, "Priority");
        if (!this.settingListeners) {
            this.checkDaysValid();
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.tabbedPane1 = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.tabbedPane1, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Visual"), jPanel);
        this.weekTimePanel = new JPanel();
        this.weekTimePanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.weekTimePanel, "North");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Saturday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Friday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Thursday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Wednesday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Tuesday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Monday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Sunday"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.weekTimePanel.add((Component)jLabel7, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.weekTimePanel.add((Component)jScrollPane, gridBagConstraints);
        this.table.setMaximumSize(new Dimension(450, 140));
        this.table.setOpaque(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 140));
        this.table.setPreferredSize(new Dimension(450, 140));
        jScrollPane.setViewportView(this.table);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipady = 3;
        this.weekTimePanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Simple"), jPanel3);
        this.deleteTimeButton = new JButton();
        this.deleteTimeButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteTimeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.deleteTimeButton, gridBagConstraints);
        this.addTimeButton = new JButton();
        this.$$$loadButtonText$$$(this.addTimeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.addTimeButton, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        jPanel4.add((Component)this.timesTablePanel, "Center");
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        jPanel9.setMinimumSize(new Dimension(171, 350));
        jPanel9.setPreferredSize(new Dimension(171, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
        jPanel9.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Days")));
        this.deleteDayButton = new JButton();
        this.deleteDayButton.setEnabled(true);
        this.$$$loadButtonText$$$(this.deleteDayButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)this.deleteDayButton, gridBagConstraints);
        this.addDayButton = new JButton();
        this.$$$loadButtonText$$$(this.addDayButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)this.addDayButton, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel9.add((Component)jPanel10, gridBagConstraints);
        jPanel10.add((Component)this.daysTablePanel, "Center");
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel9.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel13, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)jLabel8, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel15, gridBagConstraints);
        this.priorityTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.priorityTextField, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Priority"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)jLabel9, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel16, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel17, gridBagConstraints);
        jLabel8.setLabelFor(this.nameTextField);
        jLabel9.setLabelFor(this.nameTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

