/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.telzones;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaRemoveTelZone;
import biz.netup.control.transport.urfa.functions.UrfaTelZonesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.IdFilter;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.telzones.ZoneForm;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainTZTab
extends TabPanelWithTable {
    private IdFilter idFilter;

    public MainTZTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/telephone_zones_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/tariff/telephone_zones.png")));
        this.setRefreshPermission(new int[]{66311, 66313});
        this.setAddPermission(new int[]{66307});
        this.setReadPermission(new int[]{66313});
        this.setEditPermission(new int[]{66308});
        this.setDeletePermission(new int[]{66309});
        this.idFilter = null;
    }

    public void setIdFilter(IdFilter idFilter) {
        this.idFilter = idFilter;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    public String getHelpTarget() {
        return "zone";
    }

    @Override
    public String getTabName() {
        return "Telephone Zones";
    }

    @Override
    public String getGroupName() {
        return "Tariffication";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("created_on", "Created on");
        linkedHashMap.put("updated_on", "Updated on");
        linkedHashMap.put("supplier_id", "Supplier id");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaTelZonesList urfaTelZonesList = new UrfaTelZonesList(UrfaManagerImpl.getInstance());
        urfaTelZonesList.call();
        for (int i = 0; i < urfaTelZonesList.getZoneCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (this.idFilter != null && this.idFilter.skip(urfaTelZonesList.getZoneIdArray1()[i])) continue;
            hashMap.put("id", urfaTelZonesList.getZoneIdArray1()[i]);
            hashMap.put("name", urfaTelZonesList.getNameArray1()[i]);
            hashMap.put("created_on", new Date((long)urfaTelZonesList.getCreateDateArray1()[i] * 1000L));
            hashMap.put("update_on", new Date((long)urfaTelZonesList.getUpdateDateArray1()[i] * 1000L));
            hashMap.put("supplier_id", urfaTelZonesList.getSupplierIdArray1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveTelZone urfaRemoveTelZone = new UrfaRemoveTelZone(UrfaManagerImpl.getInstance());
        urfaRemoveTelZone.setZoneId((Integer)map.get("id"));
        urfaRemoveTelZone.call();
        if (urfaRemoveTelZone.getZoneId() < 0) {
            this.log.log(1, this.resource.getString("Telephone zone") + " " + map.get("name") + " " + this.resource.getString("is used"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new ZoneForm(map);
    }
}

