/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.currency;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddCurrency;
import biz.netup.control.transport.urfa.functions.UrfaEditCurrency;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyRateHistory;
import biz.netup.control.transport.urfa.functions.UrfaGetCurrencyRateRbc;
import biz.netup.control.transport.urfa.functions.UrfaGetSetting;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.TZ;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CurrencyForm
extends DialogModel {
    private JTextField IDTextField;
    private JButton onlineUpdateButton;
    private TablePanelImpl currencyRateHistoryTablePanel;
    private JTextField exchangeRateTextField;
    private JTextField abbreviationTextField;
    private JTextField nameTextField;
    private JPanel mainPanel;
    private JTextField percentTextField;
    private JLabel percentLabel;

    public CurrencyForm() {
        this.$$$setupUI$$$();
    }

    public CurrencyForm(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Currency";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            this.IDTextField.setEditable(false);
            this.IDTextField.setText("" + this.getItem().get("id"));
            this.abbreviationTextField.setText("" + this.getItem().get("abbreviation"));
            this.nameTextField.setText("" + this.getItem().get("name"));
            this.exchangeRateTextField.setText("" + this.getItem().get("rate"));
            this.percentTextField.setText("" + this.getItem().get("percent"));
            UrfaGetCurrencyRateHistory urfaGetCurrencyRateHistory = new UrfaGetCurrencyRateHistory(UrfaManagerImpl.getInstance());
            urfaGetCurrencyRateHistory.setId((Integer)this.getItem().get("id"));
            urfaGetCurrencyRateHistory.call();
            if ((Integer)this.getItem().get("id") == 810) {
                this.disableOnlineUpdate();
            }
            try {
                UrfaGetSetting urfaGetSetting = new UrfaGetSetting(UrfaManagerImpl.getInstance());
                urfaGetSetting.setVariable("system_currency");
                urfaGetSetting.call();
                if (urfaGetSetting.getValuesCount() <= 0 || !"810".equals(urfaGetSetting.getValue()[0])) {
                    this.disableOnlineUpdate();
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
                this.disableOnlineUpdate();
            }
            for (int i = 0; i < urfaGetCurrencyRateHistory.getContractsSize(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("date", new Date((long)urfaGetCurrencyRateHistory.getTime1()[i] * 1000L));
                hashMap.put("rate", urfaGetCurrencyRateHistory.getValue1()[i]);
                this.currencyRateHistoryTablePanel.getTableModel().addRow(hashMap);
            }
        }
        this.onlineUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CurrencyForm.this.onlineUpdate();
            }
        });
    }

    private void disableOnlineUpdate() {
        this.percentTextField.setEnabled(false);
        this.onlineUpdateButton.setEnabled(false);
        this.percentLabel.setEnabled(false);
    }

    private void onlineUpdate() {
        try {
            this.checkInt(this.IDTextField, "ID");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        try {
            UrfaGetCurrencyRateRbc urfaGetCurrencyRateRbc = new UrfaGetCurrencyRateRbc(UrfaManagerImpl.getInstance());
            urfaGetCurrencyRateRbc.setId(Integer.parseInt(this.IDTextField.getText()));
            urfaGetCurrencyRateRbc.call();
            try {
                this.checkDouble(this.percentTextField, "Percent");
                this.exchangeRateTextField.setText("" + (1.0 + Double.parseDouble(this.percentTextField.getText()) / 100.0) * urfaGetCurrencyRateRbc.getRate());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.exchangeRateTextField.setText("" + urfaGetCurrencyRateRbc.getRate());
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (this.isAddMode()) {
            UrfaAddCurrency urfaAddCurrency = new UrfaAddCurrency(UrfaManagerImpl.getInstance());
            urfaAddCurrency.setId(Integer.parseInt(this.IDTextField.getText()));
            urfaAddCurrency.setPercent(Double.parseDouble(this.percentTextField.getText()));
            urfaAddCurrency.setRate(Double.parseDouble(this.exchangeRateTextField.getText()));
            urfaAddCurrency.setDate((int)(TZ.getCoreTime().getTime() / 1000L));
            urfaAddCurrency.setCurrencyFullName(this.nameTextField.getText());
            urfaAddCurrency.setCurrencyBriefName(this.abbreviationTextField.getText());
            urfaAddCurrency.call();
        } else {
            UrfaEditCurrency urfaEditCurrency = new UrfaEditCurrency(UrfaManagerImpl.getInstance());
            urfaEditCurrency.setId(Integer.parseInt(this.IDTextField.getText()));
            urfaEditCurrency.setPercent(Double.parseDouble(this.percentTextField.getText()));
            urfaEditCurrency.setRate(Double.parseDouble(this.exchangeRateTextField.getText()));
            urfaEditCurrency.setDate((int)(TZ.getCoreTime().getTime() / 1000L));
            urfaEditCurrency.setCurrencyFullName(this.nameTextField.getText());
            urfaEditCurrency.setCurrencyBriefName(this.abbreviationTextField.getText());
            urfaEditCurrency.call();
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkInt(this.IDTextField, "ID");
        this.checkName(this.abbreviationTextField, "Abbreviation");
        this.checkName(this.nameTextField, "Name");
        this.checkDouble(this.percentTextField, "Percent");
        this.checkDouble(this.exchangeRateTextField, "Exchange rate");
    }

    protected void createUIComponents() {
        this.createHistoryTable();
    }

    private void createHistoryTable() {
        this.currencyRateHistoryTablePanel = new TablePanelImpl(this.getClass().getName() + "_history", true);
        MapTableModel mapTableModel = this.currencyRateHistoryTablePanel.getTableModel();
        mapTableModel.addColumn("date", "Date", true, false);
        mapTableModel.addColumn("rate", "Rate", true, false);
        this.currencyRateHistoryTablePanel.setEditable(false);
        this.currencyRateHistoryTablePanel.setAppendable(false);
        this.currencyRateHistoryTablePanel.applyTableSettings();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(350, 450));
        this.mainPanel.setPreferredSize(new Dimension(350, 450));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Exchange rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.percentLabel = new JLabel();
        this.$$$loadLabelText$$$(this.percentLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Percent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.percentLabel, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Abbreviation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.IDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        this.onlineUpdateButton = new JButton();
        this.$$$loadButtonText$$$(this.onlineUpdateButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Online update"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.onlineUpdateButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Currency rate history")));
        jPanel.add((Component)this.currencyRateHistoryTablePanel, "Center");
        this.exchangeRateTextField = new JTextField();
        this.exchangeRateTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.exchangeRateTextField, gridBagConstraints);
        this.abbreviationTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.abbreviationTextField, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.percentTextField = new JTextField();
        this.percentTextField.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.percentTextField, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        jLabel.setLabelFor(this.IDTextField);
        jLabel2.setLabelFor(this.exchangeRateTextField);
        this.percentLabel.setLabelFor(this.percentTextField);
        jLabel3.setLabelFor(this.nameTextField);
        jLabel4.setLabelFor(this.abbreviationTextField);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

