/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.reports;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteInvoice;
import biz.netup.control.transport.urfa.functions.UrfaGetInvoicesDocList;
import biz.netup.control.transport.urfa.functions.UrfaInvoicesListForDealer;
import biz.netup.control.transport.urfa.functions.UrfaRevertDocument;
import biz.netup.control.transport.urfa.functions.UrfaSendDocument2mail;
import biz.netup.control.transport.urfa.functions.UrfaUploadDocument;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.gui.custom.invoice.InvoiceDialog;
import biz.netup.projects.utmadmin.gui.custom.invoice.ReversingDialog;
import biz.netup.projects.utmadmin.gui.custom.newpayment.NewPaymentDialog;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class InvoiceDocumentsTab
extends ReportTab {
    int docType;

    public InvoiceDocumentsTab(int n, boolean bl) {
        super(n, bl);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769, 32833});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    public void setDocType(int n) {
        this.docType = n;
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        if (this.uid != 0) {
            this.accountComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if ((Integer)InvoiceDocumentsTab.this.accountMap.get(InvoiceDocumentsTab.this.accountComboBox.getSelectedItem()) != 0) {
                        InvoiceDocumentsTab.this.newInvoiceButton.setEnabled(true);
                    } else {
                        InvoiceDocumentsTab.this.newInvoiceButton.setEnabled(false);
                    }
                }
            });
            if (this.docType == 1) {
                this.newInvoiceButton.setVisible(true);
                this.newInvoiceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("uid", InvoiceDocumentsTab.this.uid);
                        hashMap.put("aid", InvoiceDocumentsTab.this.aid);
                        new InvoiceDialog(hashMap).load();
                    }
                });
            }
            Permissions.apply((JComponent)this.newInvoiceButton, "new_invoice");
            this.accountComboBox.removeItem("---");
        }
        this.getReportTablePanel().setCellRenderer("is_payed", new CheckboxCellRenderer(false));
        this.getReportTablePanel().setCellRenderer("is_mailed", new CheckboxCellRenderer(false));
    }

    public InvoiceDocumentsTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769, 32833});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    public InvoiceDocumentsTab(int n) {
        super(n);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/invoices.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9216, 32769, 32833});
        } else {
            this.setRefreshPermission(new int[]{77862});
        }
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("internal_number", "Internal number");
        linkedHashMap.put("alt_num", "Alternative number");
        linkedHashMap.put("external_number", "External number");
        linkedHashMap.put("account_id", "Account ID");
        linkedHashMap.put("full_name", "Full name");
        linkedHashMap.put("kpp_number", "KPP number");
        linkedHashMap.put("tax_number", "TAX number");
        linkedHashMap.put("year", "Year");
        linkedHashMap.put("month", "Month");
        linkedHashMap.put("date", "Time");
        linkedHashMap.put("is_payed", "Is payed");
        linkedHashMap.put("sum", "Charges total");
        linkedHashMap.put("sum_without_tax", "Charges without tax total");
        linkedHashMap.put("sum_tax", "Tax total");
        linkedHashMap.put("odt_created", "Creation date");
        linkedHashMap.put("odt_modified", "Modification date");
        linkedHashMap.put("odt_status", "Status");
        linkedHashMap.put("is_mailed", "Mailed");
        return linkedHashMap;
    }

    @Override
    protected JMenuItem[] getMenuItems(final Map<String, Object>[] mapArray) {
        JMenuItem jMenuItem = new JMenuItem(this.resource.getString("Edit"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resource.getString("View"));
        JMenuItem jMenuItem3 = new JMenuItem(this.resource.getString("Remove"));
        JMenuItem jMenuItem4 = new JMenuItem(this.resource.getString("Upload edited"));
        JMenuItem jMenuItem5 = new JMenuItem(this.resource.getString("Rebuild"));
        JMenuItem jMenuItem6 = new JMenuItem(this.resource.getString("Save as odt"));
        JMenuItem jMenuItem7 = new JMenuItem(this.resource.getString("Save as pdf"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.viewDocument(mapArray, InvoiceDocumentsTab.this.docType, 0);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.viewDocument(mapArray, InvoiceDocumentsTab.this.docType, 1);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.deleteDocument(mapArray, InvoiceDocumentsTab.this.docType);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.uploadDocument(mapArray, InvoiceDocumentsTab.this.docType);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.rebuild(mapArray);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.saveDocument(mapArray, 0);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.saveDocument(mapArray, 1);
            }
        });
        JMenuItem jMenuItem8 = new JMenuItem(this.resource.getString("Send to email"));
        JMenuItem jMenuItem9 = new JMenuItem(this.resource.getString("Pay"));
        JMenuItem jMenuItem10 = new JMenuItem(this.resource.getString("Correction of invoice positions"));
        JMenuItem jMenuItem11 = new JMenuItem(this.resource.getString("Delete invoice"));
        Permissions.apply(jMenuItem8, "send_to_email");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.send(mapArray);
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvoiceDocumentsTab.this.pay(mapArray);
            }
        });
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReversingDialog reversingDialog = new ReversingDialog(mapArray[0]);
                try {
                    reversingDialog.load();
                }
                catch (UrfaException urfaException) {
                    Dialogs.showErrorDialog("cant get invoices data");
                    return;
                }
                reversingDialog.setVisible(true);
            }
        });
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Dialogs.showYesNoDialog("Are you sure you want to delete invoice(s)?")) {
                    return;
                }
                for (int i = 0; i < mapArray.length; ++i) {
                    int n = (Integer)mapArray[i].get("id");
                    UrfaDeleteInvoice urfaDeleteInvoice = new UrfaDeleteInvoice(UrfaManagerImpl.getInstance());
                    urfaDeleteInvoice.setInvoiceId(n);
                    try {
                        urfaDeleteInvoice.call();
                    }
                    catch (UrfaException urfaException) {
                        Dialogs.showErrorDialog("cant delete invoice");
                        return;
                    }
                    if (urfaDeleteInvoice.getResult() != 0) {
                        Dialogs.showErrorDialog("cant delete invoice " + n);
                        return;
                    }
                    InvoiceDocumentsTab.this.refresh();
                }
            }
        });
        if (mapArray.length == 1) {
            if (this.docType == 1) {
                if ((Integer)mapArray[0].get("is_payed") == 0) {
                    return new JMenuItem[]{jMenuItem9, jMenuItem, jMenuItem2, jMenuItem4, jMenuItem3, jMenuItem5, jMenuItem6, jMenuItem7, jMenuItem8, jMenuItem10, jMenuItem11};
                }
                return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem4, jMenuItem3, jMenuItem5, jMenuItem6, jMenuItem7, jMenuItem8, jMenuItem10, jMenuItem11};
            }
            return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem4, jMenuItem3, jMenuItem5, jMenuItem6, jMenuItem7, jMenuItem8};
        }
        if (mapArray.length > 1) {
            if (this.docType == 1) {
                return new JMenuItem[]{jMenuItem8, jMenuItem5, jMenuItem6, jMenuItem7, jMenuItem11};
            }
            return new JMenuItem[]{jMenuItem8, jMenuItem5, jMenuItem6, jMenuItem7};
        }
        return new JMenuItem[0];
    }

    private void pay(Map<String, Object>[] mapArray) {
        NewPaymentDialog newPaymentDialog = new NewPaymentDialog((Integer)mapArray[0].get("uid"), (Integer)mapArray[0].get("account_id"));
        newPaymentDialog.setPaidToInvoice((Integer)mapArray[0].get("id"));
        newPaymentDialog.setVisible(true);
        if (newPaymentDialog.isOkPressed()) {
            this.refresh();
        }
    }

    private void send(final Map<String, Object>[] mapArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(true);
                try {
                    for (Map map : mapArray) {
                        UrfaSendDocument2mail urfaSendDocument2mail = new UrfaSendDocument2mail(UrfaManagerImpl.getInstance());
                        urfaSendDocument2mail.setAid((Integer)map.get("account_id"));
                        urfaSendDocument2mail.setInvcId((Integer)map.get("id"));
                        urfaSendDocument2mail.setDocType(InvoiceDocumentsTab.this.docType);
                        urfaSendDocument2mail.call();
                    }
                }
                catch (UrfaException urfaException) {
                    InvoiceDocumentsTab.this.log.error("Cannot send e-mail", urfaException);
                }
                InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(false);
                InvoiceDocumentsTab.this.refresh();
            }
        };
        thread.start();
    }

    private void rebuild(final Map<String, Object>[] mapArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(true);
                try {
                    for (Map map : mapArray) {
                        UrfaRevertDocument urfaRevertDocument = new UrfaRevertDocument(UrfaManagerImpl.getInstance());
                        urfaRevertDocument.setUserId((Integer)map.get("uid"));
                        urfaRevertDocument.setBaseId((Integer)map.get("id"));
                        urfaRevertDocument.setDocType(InvoiceDocumentsTab.this.docType);
                        urfaRevertDocument.call();
                    }
                }
                catch (UrfaException urfaException) {
                    InvoiceDocumentsTab.this.log.error("Cannot rebuild document", urfaException);
                }
                InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(false);
                InvoiceDocumentsTab.this.refresh();
            }
        };
        thread.start();
    }

    private void viewDocument(Map<String, Object>[] mapArray, int n, int n2) {
        try {
            DocFunctions.openDocument((Integer)mapArray[0].get("uid"), n, (Integer)mapArray[0].get("id"), n2);
            this.refresh();
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString("Cannot open document"), urfaException);
        }
    }

    private void saveDocument(final Map<String, Object>[] mapArray, final int n) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showSaveDialog(null) == 0) {
            final File file = jFileChooser.getSelectedFile();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(true);
                    for (Map map : mapArray) {
                        try {
                            DocFunctions.saveDocument(file, (Integer)map.get("uid"), InvoiceDocumentsTab.this.docType, (Integer)map.get("id"), n);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(false);
                    InvoiceDocumentsTab.this.refresh();
                }
            };
            thread.start();
        }
    }

    private void deleteDocument(Map<String, Object>[] mapArray, int n) {
        try {
            DocFunctions.deleteDocument((Integer)mapArray[0].get("uid"), n, (Integer)mapArray[0].get("id"));
            this.refresh();
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString("Cannot delete document"), urfaException);
        }
    }

    private void uploadDocument(Map<String, Object>[] mapArray, int n) {
        if (Utils.isAdmin() && this.did == 0) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    return file.canRead() && file.length() > 0L && string.length() > 4 && string.substring(string.length() - 4, string.length()).toLowerCase().compareTo(".odt") == 0;
                }

                @Override
                public String getDescription() {
                    return "*.odt";
                }
            });
            if (jFileChooser.showOpenDialog(null) == 0) {
                final File file = jFileChooser.getSelectedFile();
                final Integer n2 = (Integer)mapArray[0].get("id");
                final int n3 = n;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(true);
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(file);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            InvoiceDocumentsTab.this.log.error(fileNotFoundException);
                        }
                        try {
                            byte[] byArray = new byte[fileInputStream.available()];
                            fileInputStream.read(byArray);
                            fileInputStream.close();
                            UrfaUploadDocument urfaUploadDocument = new UrfaUploadDocument(UrfaManagerImpl.getInstance());
                            urfaUploadDocument.setBaseId(n2);
                            urfaUploadDocument.setDocType(n3);
                            urfaUploadDocument.setOdtData(byArray);
                            urfaUploadDocument.call();
                            if (urfaUploadDocument.getResult() != 0) {
                                throw new UrfaException(InvoiceDocumentsTab.this.resource.getString("Unable to upload document"));
                            }
                            InvoiceDocumentsTab.this.refresh();
                        }
                        catch (IOException iOException) {
                            InvoiceDocumentsTab.this.log.error(iOException);
                        }
                        catch (UrfaException urfaException) {
                            InvoiceDocumentsTab.this.log.error(InvoiceDocumentsTab.this.resource.getString("Cannot upload document"), urfaException);
                        }
                        InvoiceDocumentsTab.this.getProgressBar().setIndeterminate(false);
                    }
                };
                thread.start();
            }
        }
    }

    @Override
    public void setTableData() throws UrfaException {
        if (Utils.isAdmin() && this.did == 0) {
            UrfaGetInvoicesDocList urfaGetInvoicesDocList = new UrfaGetInvoicesDocList(UrfaManagerImpl.getInstance(), this);
            urfaGetInvoicesDocList.setTimeEnd(this.getEndTime());
            urfaGetInvoicesDocList.setTimeStart(this.getStartTime());
            urfaGetInvoicesDocList.setAid(this.aid);
            urfaGetInvoicesDocList.setDocType(this.docType);
            urfaGetInvoicesDocList.setGid(this.getGroupId());
            urfaGetInvoicesDocList.call();
        } else {
            UrfaInvoicesListForDealer urfaInvoicesListForDealer = new UrfaInvoicesListForDealer(UrfaManagerImpl.getInstance(), this);
            urfaInvoicesListForDealer.setEndDate(this.getEndTime());
            urfaInvoicesListForDealer.setStartDate(this.getStartTime());
            urfaInvoicesListForDealer.setDealerId(this.did);
            urfaInvoicesListForDealer.call();
        }
    }

    @Override
    public String getTabName() {
        return "Invoices";
    }
}

