/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.reports;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerDhsReport;
import biz.netup.control.transport.urfa.functions.UrfaGetDhsReport;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DHSReportAdmin
extends ReportTab {
    private Map<String, String> cn;
    private Map<Integer, Boolean> statuses;

    @Override
    public int getMode() {
        return 2;
    }

    public DHSReportAdmin() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9728, 10512, 20505});
        } else {
            this.setRefreshPermission(new int[]{10512, 77861});
        }
    }

    public DHSReportAdmin(int n) {
        super(n);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9728, 10512, 20505});
        } else {
            this.setRefreshPermission(new int[]{10512, 77861});
        }
    }

    public DHSReportAdmin(int n, boolean bl) {
        super(n, bl);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/dial-up_report.png")));
        if (this.did == 0) {
            this.setRefreshPermission(new int[]{9728, 10512, 20505});
        } else {
            this.setRefreshPermission(new int[]{10512, 77861});
        }
    }

    @Override
    public Map<String, String> getColumnNames() {
        this.cn = new LinkedHashMap<String, String>();
        this.cn.put("session_id", "Session ID");
        this.cn.put("account_id", "Account ID");
        this.cn.put("start_date", "Start date");
        this.cn.put("end_date", "End date");
        this.cn.put("called_station", "Called station");
        this.cn.put("calling_station", "Calling station");
        this.cn.put("ip-address", "IP-address");
        this.cn.put("ip-address6", "IP-address v6");
        this.cn.put("nas-port", "NAS-Port");
        this.cn.put("nas_session_id", "NAS Session ID");
        this.cn.put("username", "Username");
        this.cn.put("nas_ip", "NAS IP");
        this.cn.put("status", "Status");
        this.cn.put("input_bytes", "Input bytes");
        this.cn.put("input_gigawords", "Input gigawords");
        this.cn.put("output_bytes", "Output bytes");
        this.cn.put("output_gigawords", "Output gigawords");
        this.cn.put("session_time", "Session time");
        this.cn.put("terminate_cause", "Terminate cause");
        this.cn.put("total_cost", "Total cost");
        this.cn.put("flags", "Telephony Dialup/VPN Flags");
        return this.cn;
    }

    @Override
    public void setTableData() throws UrfaException {
        Object object;
        Resolve.updateCurList();
        for (String object2 : this.cn.keySet()) {
            this.getReportTablePanel().setCellRenderer(object2, null);
        }
        if (Utils.isAdmin() && this.did == 0) {
            object = new UrfaGetDhsReport(UrfaManagerImpl.getInstance(), this);
            ((UrfaGetDhsReport)object).setUserId(this.uid);
            ((UrfaGetDhsReport)object).setTStart(this.getStartTime());
            ((UrfaGetDhsReport)object).setTEnd(this.getEndTime());
            ((UrfaGetDhsReport)object).setAccountId(this.aid);
            ((UrfaGetDhsReport)object).setApid(this.getDiscountPeriodID());
            ((UrfaGetDhsReport)object).call();
            this.statuses = ((UrfaGetDhsReport)object).getStatuses();
        } else {
            object = new UrfaDealerDhsReport(UrfaManagerImpl.getInstance(), this);
            ((UrfaDealerDhsReport)object).setUserId(this.uid);
            ((UrfaDealerDhsReport)object).setTimeStart(this.getStartTime());
            ((UrfaDealerDhsReport)object).setTimeEnd(this.getEndTime());
            ((UrfaDealerDhsReport)object).setApid(this.getDiscountPeriodID());
            ((UrfaDealerDhsReport)object).setAccountId(this.aid);
            ((UrfaDealerDhsReport)object).setDid(this.did);
            ((UrfaDealerDhsReport)object).call();
            this.statuses = ((UrfaDealerDhsReport)object).getStatuses();
        }
        object = new CustomCellRenderer();
        for (String string : this.cn.keySet()) {
            this.getReportTablePanel().setCellRenderer(string, (TableCellRenderer)object);
        }
    }

    @Override
    public void addSummaryRows() {
        double d = 0.0;
        Long l = 0L;
        Long l2 = 0L;
        Long l3 = 0L;
        Long l4 = 0L;
        Long l5 = 0L;
        for (Map<String, Object> map : this.getReportTablePanel().getTableModel().data) {
            d += ((Double)map.get("total_cost")).doubleValue();
            l = l + (Long)map.get("session_time");
            l2 = l2 + (Long)map.get("input_bytes");
            l3 = l3 + (Long)map.get("input_gigawords");
            l4 = l4 + (Long)map.get("output_bytes");
            l5 = l5 + (Long)map.get("output_gigawords");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("account_id", this.resource.getString("Summary"));
        hashMap.put("total_cost", d);
        hashMap.put("session_time", l);
        hashMap.put("input_bytes", l2);
        hashMap.put("input_gigawords", l3);
        hashMap.put("output_bytes", l4);
        hashMap.put("output_gigawords", l5);
        hashMap.put("X-SORT", "NO_SORT");
        this.getReportTablePanel().getTableModel().addRow(hashMap);
    }

    @Override
    public String getTabName() {
        return "Dial-up and VPN Report";
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = DHSReportAdmin.this.getReportTablePanel().getTableModel().getRow(n).get("session_id");
            super.setForeground(Color.BLACK);
            if (object2 != null && DHSReportAdmin.this.statuses != null && ((Boolean)DHSReportAdmin.this.statuses.get(object2)).booleanValue()) {
                super.setBackground(new Color(153, 255, 153));
            } else {
                super.setBackground(n % 2 == 1 ? new Color(242, 242, 220) : Color.WHITE);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }
}

