/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.streets;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetStreetsList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveStreet;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.custom.PagesPanel;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.streets.StreetDialog;
import biz.netup.utmutils.control.filter.FilterForm;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainStreetsTab
extends TabPanelWithTable {
    private PagesPanel pages;
    private Vector<Map<String, Object>> localData;

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    public String getTabName() {
        return "Streets";
    }

    @Override
    public String getGroupName() {
        return "Reference book";
    }

    @Override
    public int getMode() {
        return 1;
    }

    public MainStreetsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/streets.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/streets_24.png")));
        this.setRefreshPermission(new int[]{10262});
        this.setAddPermission(new int[]{10263});
        this.setReadPermission(new int[]{10264});
        this.setEditPermission(new int[]{10264});
        this.setDeletePermission(new int[]{10265});
        final MainStreetsTab mainStreetsTab = this;
        this.pages = new PagesPanel(100, "Streets per page");
        this.pages.addListener(new PagesPanel.PageChangeListener(){

            @Override
            public void onPageChange(int n) {
                mainStreetsTab.refresh();
            }
        });
        this.getPanel().add((Component)this.pages.getPanel(), "South");
        FilterForm filterForm = this.getFilterForm();
        if (filterForm != null) {
            filterForm.getClearButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mainStreetsTab.refresh();
                }
            });
            filterForm.addListener(new FilterForm.FilterListener(){

                @Override
                public void onFilterBegin() {
                    MainStreetsTab.this.localData = new Vector();
                }

                @Override
                public void onRowPass(Map<String, Object> map) {
                    MainStreetsTab.this.localData.add(map);
                }

                @Override
                public void onRowFail(Map<String, Object> map) {
                }

                @Override
                public void onFilterEnd() {
                    MainStreetsTab.this.pages.updateCount(MainStreetsTab.this.localData.size());
                }
            });
        }
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("country", "Country");
        linkedHashMap.put("province/state", "Province/State");
        linkedHashMap.put("city", "City");
        linkedHashMap.put("street", "Street");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        int n;
        Object object;
        this.localData = new Vector();
        if (UrfaManagerImpl.getInstance().isPermitted(10262)) {
            object = new UrfaGetStreetsList(UrfaManagerImpl.getInstance());
            try {
                ((UrfaGetStreetsList)object).call();
                for (n = 0; n < ((UrfaGetStreetsList)object).getStreetsSize(); ++n) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("id", ((UrfaGetStreetsList)object).getStreetId1()[n]);
                    hashMap.put("country", ((UrfaGetStreetsList)object).getCountry1()[n]);
                    hashMap.put("province/state", ((UrfaGetStreetsList)object).getRegion1()[n]);
                    hashMap.put("city", ((UrfaGetStreetsList)object).getCity1()[n]);
                    hashMap.put("street", ((UrfaGetStreetsList)object).getStreet1()[n]);
                    this.localData.add(hashMap);
                }
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
        if (this.pages.getCount() != this.localData.size()) {
            this.pages.updateCount(this.localData.size());
        }
        object = new Vector();
        n = this.pages.getPerPageCount();
        int n2 = this.pages.getPage() * n;
        int n3 = this.localData.size() - n2;
        int n4 = n3 > n ? n : n3;
        for (int i = n2; i < n2 + n4; ++i) {
            ((Vector)object).add(this.localData.get(i));
        }
        return object;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveStreet urfaRemoveStreet = new UrfaRemoveStreet(UrfaManagerImpl.getInstance());
        urfaRemoveStreet.setStreetId((Integer)map.get("id"));
        urfaRemoveStreet.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new StreetDialog(map);
    }
}

