/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.shaping;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetBytesInKb;
import biz.netup.control.transport.urfa.functions.UrfaGetOnceService;
import biz.netup.control.transport.urfa.functions.UrfaGetServicesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.shaping.DurationValidator;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.shaping.LimitValidator;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.shaping.RateValidator;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.shaping.ShapingDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.types.InformationVolume;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

public class TurboModeSettingsDialog
extends DialogModel {
    private JComboBox turboModeServiceCombo;
    private JTextField turboModeIncomingRateField;
    private JTextField turboModeOutgoingRateField;
    private JSpinner turboModeDaysSpinner;
    private JSpinner turboModeHoursSpinner;
    private JSpinner turboModeMinSpinner;
    private JPanel durationPanel;
    private JTextField incomingLimitTb;
    private JRadioButton durationRb;
    private JRadioButton limitsRb;
    private JPanel limitsPanel;
    private JPanel panel;
    private JPanel durationTimePanel;
    private JCheckBox untilApCheckBox;
    private JTextField nameTextField;
    private JTextField outgoingLimitTb;
    private JCheckBox IncomingRateUnlimitedCheckBox;
    private JCheckBox OutgoingRateUnlimitedCheckBox;
    LimitValidator incomingLimitValidator;
    LimitValidator outgoingLimitValidator;
    DurationValidator durationValidator;
    RateValidator incomingRateValidator;
    RateValidator outgoingRateValidator;
    ShapingDialog owner;
    boolean incomingRateInactive;
    boolean outgoingRateInactive;

    public TurboModeSettingsDialog() {
        this.$$$setupUI$$$();
    }

    public TurboModeSettingsDialog(Map<String, Object> map, ShapingDialog shapingDialog) {
        super(map);
        this.owner = shapingDialog;
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel;
    }

    @Override
    public String getItemName() {
        return "Dynamic shaping";
    }

    private void $$$setupUI$$$() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.panel, "Center");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Once service"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Incoming shaping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel4, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Outgoing shaping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel8, gridBagConstraints);
        this.turboModeIncomingRateField = new JTextField();
        this.turboModeIncomingRateField.setEnabled(true);
        this.turboModeIncomingRateField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.turboModeIncomingRateField, gridBagConstraints);
        this.turboModeOutgoingRateField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.turboModeOutgoingRateField, gridBagConstraints);
        this.turboModeServiceCombo = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.turboModeServiceCombo.setModel(defaultComboBoxModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.turboModeServiceCombo, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel9, gridBagConstraints);
        this.nameTextField = new JTextField();
        this.nameTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel10, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.panel.add((Component)jLabel4, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)jPanel11, gridBagConstraints);
        this.durationRb = new JRadioButton();
        this.durationRb.setHorizontalAlignment(10);
        this.durationRb.setHorizontalTextPosition(2);
        this.$$$loadButtonText$$$(this.durationRb, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Duration"));
        this.durationRb.setVerticalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        jPanel11.add((Component)this.durationRb, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel11.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel11.add((Component)jPanel13, gridBagConstraints);
        this.limitsRb = new JRadioButton();
        this.limitsRb.setHorizontalAlignment(10);
        this.limitsRb.setHorizontalTextPosition(2);
        this.limitsRb.setSelected(false);
        this.$$$loadButtonText$$$(this.limitsRb, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Traffic volume"));
        this.limitsRb.setVerticalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        jPanel11.add((Component)this.limitsRb, gridBagConstraints);
        this.durationPanel = new JPanel();
        this.durationPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel11.add((Component)this.durationPanel, gridBagConstraints);
        this.untilApCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.untilApCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Until the End of Accounting Period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.durationPanel.add((Component)this.untilApCheckBox, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.durationPanel.add((Component)jPanel14, gridBagConstraints);
        this.durationTimePanel = new JPanel();
        this.durationTimePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.durationPanel.add((Component)this.durationTimePanel, gridBagConstraints);
        this.turboModeDaysSpinner = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.durationTimePanel.add((Component)this.turboModeDaysSpinner, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Days"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.durationTimePanel.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.durationTimePanel.add((Component)jPanel15, gridBagConstraints);
        this.turboModeHoursSpinner = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.durationTimePanel.add((Component)this.turboModeHoursSpinner, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Hours"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.durationTimePanel.add((Component)jLabel6, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.durationTimePanel.add((Component)jPanel16, gridBagConstraints);
        this.turboModeMinSpinner = new JSpinner();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.durationTimePanel.add((Component)this.turboModeMinSpinner, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Minutes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.durationTimePanel.add((Component)jLabel7, gridBagConstraints);
        this.limitsPanel = new JPanel();
        this.limitsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel11.add((Component)this.limitsPanel, gridBagConstraints);
        this.incomingLimitTb = new JTextField();
        this.incomingLimitTb.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.limitsPanel.add((Component)this.incomingLimitTb, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Incoming shaping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.limitsPanel.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.limitsPanel.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.limitsPanel.add((Component)jPanel18, gridBagConstraints);
        this.outgoingLimitTb = new JTextField();
        this.outgoingLimitTb.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.limitsPanel.add((Component)this.outgoingLimitTb, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Outgoing shaping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.limitsPanel.add((Component)jLabel9, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel19, gridBagConstraints);
        this.IncomingRateUnlimitedCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.IncomingRateUnlimitedCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("unlimited"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.IncomingRateUnlimitedCheckBox, gridBagConstraints);
        this.OutgoingRateUnlimitedCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.OutgoingRateUnlimitedCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("unlimited"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.OutgoingRateUnlimitedCheckBox, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.limitsRb);
        buttonGroup.add(this.durationRb);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private void setEnabledStateForContainer(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof JPanel) {
                if (component == this.durationTimePanel && bl && this.untilApCheckBox.isSelected()) continue;
                this.setEnabledStateForContainer((Container)component, bl);
                continue;
            }
            if (component instanceof JLabel) continue;
            if (component instanceof JButton) {
                component.setEnabled(bl);
                continue;
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEnabled(bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    @Override
    public void loadInfo() throws UrfaException {
        Object object;
        Object object2;
        UrfaGetServicesList urfaGetServicesList = new UrfaGetServicesList(UrfaManagerImpl.getInstance());
        urfaGetServicesList.call();
        int[] nArray = urfaGetServicesList.getServiceTypeArray1();
        int[] nArray2 = urfaGetServicesList.getServiceStatusArray1();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            object2 = new UrfaGetOnceService(UrfaManagerImpl.getInstance());
            ((UrfaGetOnceService)object2).setSid(urfaGetServicesList.getServiceIdArray1()[i]);
            ((UrfaGetOnceService)object2).call();
            object = urfaGetServicesList.getServiceNameArray1()[i];
            int n = urfaGetServicesList.getServiceIdArray1()[i];
            double d = ((UrfaGetOnceService)object2).getCost();
            this.turboModeServiceCombo.addItem(new ServiceDescription((String)object, n, d));
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(0), new Integer(0), new Integer(31), new Integer(1));
        this.turboModeDaysSpinner.setModel(spinnerNumberModel);
        object2 = new SpinnerNumberModel(new Integer(0), new Integer(0), new Integer(24), new Integer(1));
        this.turboModeHoursSpinner.setModel((SpinnerModel)object2);
        object = new SpinnerNumberModel(new Integer(0), new Integer(0), new Integer(60), new Integer(5));
        this.turboModeMinSpinner.setModel((SpinnerModel)object);
        JComponent jComponent = this.turboModeDaysSpinner.getEditor();
        JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent.getComponent(0);
        jComponent = this.turboModeHoursSpinner.getEditor();
        JFormattedTextField jFormattedTextField2 = (JFormattedTextField)jComponent.getComponent(0);
        jComponent = this.turboModeMinSpinner.getEditor();
        JFormattedTextField jFormattedTextField3 = (JFormattedTextField)jComponent.getComponent(0);
        this.durationValidator = new DurationValidator(jFormattedTextField3, jFormattedTextField2, jFormattedTextField);
        jFormattedTextField3.getDocument().addDocumentListener(this.durationValidator);
        jFormattedTextField2.getDocument().addDocumentListener(this.durationValidator);
        jFormattedTextField.getDocument().addDocumentListener(this.durationValidator);
        this.incomingRateValidator = new RateValidator(this.turboModeIncomingRateField);
        this.turboModeIncomingRateField.getDocument().addDocumentListener(this.incomingRateValidator);
        this.outgoingRateValidator = new RateValidator(this.turboModeOutgoingRateField);
        this.turboModeOutgoingRateField.getDocument().addDocumentListener(this.outgoingRateValidator);
        this.turboModeServiceCombo.setSelectedIndex(0);
        this.turboModeIncomingRateField.setEnabled(false);
        this.turboModeOutgoingRateField.setEnabled(false);
        this.turboModeDaysSpinner.setEnabled(false);
        this.turboModeHoursSpinner.setEnabled(false);
        this.turboModeMinSpinner.setEnabled(false);
        this.untilApCheckBox.setEnabled(false);
        this.IncomingRateUnlimitedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TurboModeSettingsDialog.this.IncomingRateUnlimitedCheckBox.isSelected();
                if (bl) {
                    TurboModeSettingsDialog.this.turboModeIncomingRateField.setEnabled(false);
                } else {
                    TurboModeSettingsDialog.this.turboModeIncomingRateField.setEnabled(true);
                }
                TurboModeSettingsDialog.this.incomingRateValidator.setEnabled(!bl);
            }
        });
        this.OutgoingRateUnlimitedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TurboModeSettingsDialog.this.OutgoingRateUnlimitedCheckBox.isSelected();
                if (bl) {
                    TurboModeSettingsDialog.this.turboModeOutgoingRateField.setEnabled(false);
                } else {
                    TurboModeSettingsDialog.this.turboModeOutgoingRateField.setEnabled(true);
                }
                TurboModeSettingsDialog.this.outgoingRateValidator.setEnabled(!bl);
            }
        });
        this.durationRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TurboModeSettingsDialog.this.durationRb.isSelected()) {
                    TurboModeSettingsDialog.this.setEnabledStateForContainer(TurboModeSettingsDialog.this.durationPanel, true);
                    TurboModeSettingsDialog.this.setEnabledStateForContainer(TurboModeSettingsDialog.this.limitsPanel, false);
                    TurboModeSettingsDialog.this.incomingLimitValidator.setEnabledState(false);
                    TurboModeSettingsDialog.this.outgoingLimitValidator.setEnabledState(false);
                    if (!TurboModeSettingsDialog.this.untilApCheckBox.isSelected()) {
                        TurboModeSettingsDialog.this.durationValidator.setEnabledState(true);
                    }
                }
            }
        });
        this.limitsRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TurboModeSettingsDialog.this.limitsRb.isSelected()) {
                    TurboModeSettingsDialog.this.setEnabledStateForContainer(TurboModeSettingsDialog.this.durationPanel, false);
                    TurboModeSettingsDialog.this.setEnabledStateForContainer(TurboModeSettingsDialog.this.limitsPanel, true);
                    TurboModeSettingsDialog.this.incomingLimitValidator.setEnabledState(true);
                    TurboModeSettingsDialog.this.outgoingLimitValidator.setEnabledState(true);
                    TurboModeSettingsDialog.this.durationValidator.setEnabledState(false);
                    TurboModeSettingsDialog.this.incomingLimitTb.setEnabled(!TurboModeSettingsDialog.this.incomingRateInactive);
                    TurboModeSettingsDialog.this.outgoingLimitTb.setEnabled(!TurboModeSettingsDialog.this.outgoingRateInactive);
                }
            }
        });
        this.untilApCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !TurboModeSettingsDialog.this.untilApCheckBox.isSelected();
                TurboModeSettingsDialog.this.setEnabledStateForContainer(TurboModeSettingsDialog.this.durationTimePanel, bl);
                TurboModeSettingsDialog.this.durationValidator.setEnabledState(bl);
            }
        });
        this.durationRb.setSelected(true);
        this.setEnabledStateForContainer(this.durationPanel, true);
        this.setEnabledStateForContainer(this.limitsPanel, false);
        this.turboModeIncomingRateField.setEnabled(true);
        this.turboModeOutgoingRateField.setEnabled(true);
        this.incomingLimitValidator = new LimitValidator(this.incomingLimitTb, true);
        this.outgoingLimitValidator = new LimitValidator(this.outgoingLimitTb, true);
        this.incomingLimitTb.getDocument().addDocumentListener(this.incomingLimitValidator);
        this.outgoingLimitTb.getDocument().addDocumentListener(this.outgoingLimitValidator);
        this.incomingRateInactive = this.owner.getIncomingShaping().getShapingData().limits == null;
        boolean bl = this.outgoingRateInactive = this.owner.getOutgoingShaping().getShapingData().limits == null;
        if (this.item != null && this.item.size() != 0) {
            this.setData();
        } else {
            this.incomingLimitTb.setText("");
            this.outgoingLimitTb.setText("");
            String string = "0";
            if (this.incomingRateInactive) {
                this.setRate(string, this.IncomingRateUnlimitedCheckBox, this.turboModeIncomingRateField, true);
            }
            if (this.outgoingRateInactive) {
                this.setRate(string, this.OutgoingRateUnlimitedCheckBox, this.turboModeOutgoingRateField, true);
            }
        }
        if (this.limitsRb.isSelected()) {
            this.setEnabledStateForContainer(this.durationPanel, false);
            this.setEnabledStateForContainer(this.limitsPanel, true);
            this.incomingLimitTb.setEnabled(!this.incomingRateInactive);
            this.outgoingLimitTb.setEnabled(!this.outgoingRateInactive);
            this.incomingLimitValidator.setEnabledState(true);
            this.outgoingLimitValidator.setEnabledState(true);
            this.durationValidator.setEnabledState(false);
        } else {
            this.setEnabledStateForContainer(this.durationPanel, true);
            this.setEnabledStateForContainer(this.limitsPanel, false);
            this.incomingLimitValidator.setEnabledState(false);
            this.outgoingLimitValidator.setEnabledState(false);
            if (this.untilApCheckBox.isSelected()) {
                this.durationValidator.setEnabledState(false);
            }
        }
        this.incomingLimitValidator.setUsingState(!this.incomingRateInactive);
        this.outgoingLimitValidator.setUsingState(!this.outgoingRateInactive);
    }

    private int getTurboModeDuration() {
        Integer n = (Integer)this.turboModeDaysSpinner.getValue() * 86400;
        n = n + (Integer)this.turboModeHoursSpinner.getValue() * 3600;
        n = n + (Integer)this.turboModeMinSpinner.getValue() * 60;
        return n;
    }

    @Override
    protected void saveInfo() throws UrfaException {
        if (!this.item.containsKey("id")) {
            this.item.put("id", new Integer(0));
        }
        ServiceDescription serviceDescription = (ServiceDescription)this.turboModeServiceCombo.getSelectedItem();
        this.item.put("incoming_rate", this.getRate(this.turboModeIncomingRateField.getText(), this.IncomingRateUnlimitedCheckBox));
        this.item.put("outgoing_rate", this.getRate(this.turboModeOutgoingRateField.getText(), this.OutgoingRateUnlimitedCheckBox));
        String string = this.incomingLimitTb.getText();
        String string2 = this.outgoingLimitTb.getText();
        if (this.durationRb.isSelected()) {
            string = "";
            string2 = "";
        }
        UrfaGetBytesInKb urfaGetBytesInKb = new UrfaGetBytesInKb(UrfaManagerImpl.getInstance());
        urfaGetBytesInKb.call();
        InformationVolume informationVolume = new InformationVolume(string, urfaGetBytesInKb.getBytesInKb());
        InformationVolume informationVolume2 = new InformationVolume(string2, urfaGetBytesInKb.getBytesInKb());
        this.item.put("incoming_limit", informationVolume);
        this.item.put("outgoing_limit", informationVolume2);
        this.item.put("name", this.nameTextField.getText());
        this.item.put("once_service_id", serviceDescription.getId());
        this.item.put("duration", !this.untilApCheckBox.isSelected() ? this.getTurboModeDuration() : 0);
        this.item.put("untill_ap", this.untilApCheckBox.isSelected());
        this.item.put("speed", this.item.get("incoming_rate") + "/" + this.item.get("outgoing_rate"));
        this.item.put("price", serviceDescription.getCost());
        if (this.durationRb.isSelected()) {
            if (this.untilApCheckBox.isSelected()) {
                this.item.put("work_until", Utils.getResource().getString("until aggregation period end"));
            } else {
                this.item.put("work_until", Resolve.getDurationString(this.getTurboModeDuration()));
            }
        } else {
            this.item.put("work_until", informationVolume.toString() + "/" + informationVolume2.toString());
        }
    }

    private ShapingDialog.RateValue getRate(String string, JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            return new ShapingDialog.RateValue("-1");
        }
        if (string.equals("")) {
            return new ShapingDialog.RateValue("0");
        }
        return new ShapingDialog.RateValue(string);
    }

    private void setRate(String string, JCheckBox jCheckBox, JTextField jTextField, boolean bl) {
        if (string.equals("-1") || bl) {
            jTextField.setText("");
            jTextField.setEnabled(false);
            if (bl) {
                jCheckBox.setEnabled(false);
            }
            if (string.equals("-1")) {
                jCheckBox.setSelected(true);
            }
        } else {
            jTextField.setEnabled(true);
            if (!string.equals("0")) {
                jTextField.setText("" + string);
            }
        }
    }

    private void setRateFromData(String string, JCheckBox jCheckBox, JTextField jTextField, boolean bl) {
        String string2 = ((ShapingDialog.RateValue)this.item.get(string)).getValue();
        this.setRate(string2, jCheckBox, jTextField, bl);
    }

    private void setData() {
        Object object;
        this.nameTextField.setText((String)this.item.get("name"));
        int n = (Integer)this.item.get("once_service_id");
        int n2 = this.turboModeServiceCombo.getItemCount();
        for (int i = 0; i < n2; ++i) {
            object = (ServiceDescription)this.turboModeServiceCombo.getItemAt(i);
            if (((ServiceDescription)object).getId() != n) continue;
            this.turboModeServiceCombo.setSelectedIndex(i);
            break;
        }
        this.setRateFromData("incoming_rate", this.IncomingRateUnlimitedCheckBox, this.turboModeIncomingRateField, this.incomingRateInactive);
        this.setRateFromData("outgoing_rate", this.OutgoingRateUnlimitedCheckBox, this.turboModeOutgoingRateField, this.outgoingRateInactive);
        InformationVolume informationVolume = (InformationVolume)this.item.get("incoming_limit");
        object = (InformationVolume)this.item.get("outgoing_limit");
        Long l = informationVolume.getValue();
        Long l2 = ((InformationVolume)object).getValue();
        if (l == 0L && l2 == 0L) {
            this.untilApCheckBox.setSelected((Boolean)this.item.get("untill_ap"));
            if (this.untilApCheckBox.isSelected()) {
                this.setEnabledStateForContainer(this.durationTimePanel, false);
            }
            int n3 = (Integer)this.item.get("duration");
            this.turboModeDaysSpinner.setValue(new Integer(n3 / 86400));
            this.turboModeHoursSpinner.setValue(new Integer((n3 %= 86400) / 3600));
            this.turboModeMinSpinner.setValue(new Integer((n3 %= 3600) / 60));
            this.durationRb.setSelected(true);
        } else {
            if (!this.incomingRateInactive) {
                this.incomingLimitTb.setText("" + informationVolume);
            }
            if (!this.outgoingRateInactive) {
                this.outgoingLimitTb.setText("" + object);
            }
            this.limitsRb.setSelected(true);
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (this.settingListeners) {
            return;
        }
        if (!this.IncomingRateUnlimitedCheckBox.isEnabled() && !this.OutgoingRateUnlimitedCheckBox.isEnabled()) {
            this.log.log(1, this.resource.getString("You must specify incoming or outgoing channel data in dynashape settings"));
            throw new IllegalArgumentException("You must specify incoming or outgoing channel data in dynashape settings");
        }
        if (!this.incomingRateValidator.check()) {
            this.log.log(1, this.resource.getString("Invalid incoming rate value"));
            throw new IllegalArgumentException("Invalid incoming rate value");
        }
        if (!this.outgoingRateValidator.check()) {
            this.log.log(1, this.resource.getString("Invalid outgoing rate value"));
            throw new IllegalArgumentException("Invalid outgoing rate value");
        }
        if (this.durationRb.isSelected()) {
            int n = (Integer)this.turboModeDaysSpinner.getValue();
            int n2 = (Integer)this.turboModeHoursSpinner.getValue();
            int n3 = (Integer)this.turboModeMinSpinner.getValue();
            if (n == 0 && n2 == 0 && n3 == 0 && !this.untilApCheckBox.isSelected()) {
                this.log.log(1, this.resource.getString("Invalid duration value"));
                throw new IllegalArgumentException("Invalid duration value");
            }
        }
        if (!this.incomingLimitValidator.check()) {
            this.log.log(1, this.resource.getString("Invalid incoming limit value"));
            throw new IllegalArgumentException("Invalid incoming limit value");
        }
        if (!this.outgoingLimitValidator.check()) {
            this.log.log(1, this.resource.getString("Invalid outgoing limit value"));
            throw new IllegalArgumentException("Invalid outgoing limit value");
        }
    }

    class ServiceDescription {
        private int id;
        private double cost;
        private String name;

        ServiceDescription(String string, int n, double d) {
            this.name = string;
            this.id = n;
            this.cost = d;
        }

        int getId() {
            return this.id;
        }

        double getCost() {
            return this.cost;
        }

        public String toString() {
            return this.name + "(" + this.id + ") " + Utils.getResource().getString("Price") + ": " + this.cost;
        }
    }
}

