/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteSupplier;
import biz.netup.control.transport.urfa.functions.UrfaDeleteTelSupplierService;
import biz.netup.control.transport.urfa.functions.UrfaGetServiceIdForSupplier;
import biz.netup.control.transport.urfa.functions.UrfaGetSuppliersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierFrame;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class TelOperatorsTab
extends TabPanelWithTable {
    public TelOperatorsTab() {
        this.setRefreshPermission(new int[]{32793, 32788});
        this.setAddPermission(new int[]{32838});
        this.setReadPermission(new int[]{32793, 32835});
        this.setEditPermission(new int[]{32837});
        this.setDeletePermission(new int[]{32791});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Telephone operators";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("balance", "Balance");
        return linkedHashMap;
    }

    private void CreateNewSupplierFrame(final int n) {
        final TelOperatorsTab telOperatorsTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + TelOperatorsTab.this.resource.getString("Supplier"));
                SupplierFrame supplierFrame = new SupplierFrame(n, telOperatorsTab, SupplierFrame.SupplierType.TelOperator);
                UTMTrayIcon.getInstance().removeProcess(this);
                supplierFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void edit() {
        int n = (Integer)this.getMainTablePanel().getSelectedTableRows()[0].get("id");
        this.CreateNewSupplierFrame(n);
    }

    @Override
    protected void add() {
        this.CreateNewSupplierFrame(-1);
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetSuppliersList urfaGetSuppliersList = new UrfaGetSuppliersList(UrfaManagerImpl.getInstance());
        try {
            urfaGetSuppliersList.call();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog(urfaException.getMessage());
            throw urfaException;
        }
        int n = urfaGetSuppliersList.getCount();
        for (int i = 0; i < n; ++i) {
            if (urfaGetSuppliersList.getType1()[i] != SupplierFrame.SupplierType.TelOperator.getValue()) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetSuppliersList.getId1()[i]);
            hashMap.put("name", urfaGetSuppliersList.getName1()[i]);
            hashMap.put("balance", urfaGetSuppliersList.getBalance1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        Object object;
        int n = (Integer)map.get("id");
        try {
            object = new UrfaDeleteSupplier(UrfaManagerImpl.getInstance());
            ((UrfaDeleteSupplier)object).setId(n);
            ((UrfaDeleteSupplier)object).call();
            if (((UrfaDeleteSupplier)object).getId() < 0) {
                switch (((UrfaDeleteSupplier)object).getId()) {
                    case -1: {
                        throw new UrfaException("Cannot delete supplier");
                    }
                    case -2: {
                        throw new UrfaException("Cannot delete supplier: is linked with users");
                    }
                }
            }
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString(urfaException.getMessage()), urfaException);
            return;
        }
        object = new UrfaGetServiceIdForSupplier(UrfaManagerImpl.getInstance());
        try {
            ((UrfaGetServiceIdForSupplier)object).setSupplierId(n);
            ((UrfaGetServiceIdForSupplier)object).call();
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot get service id for supplier"), urfaException);
            return;
        }
        int n2 = ((UrfaGetServiceIdForSupplier)object).getServiceId();
        if (n2 != 0) {
            try {
                UrfaDeleteTelSupplierService urfaDeleteTelSupplierService = new UrfaDeleteTelSupplierService(UrfaManagerImpl.getInstance());
                urfaDeleteTelSupplierService.setSupplierId(n);
                urfaDeleteTelSupplierService.call();
            }
            catch (UrfaException urfaException) {
                this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot delete supplier"), urfaException);
                return;
            }
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }
}

