/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaTelSupplierChargesReport;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SupplierChargesReport
extends ReportTab {
    private int supplierId;

    @Override
    public String getTabName() {
        return "Supplier charges report";
    }

    @Override
    public int getMode() {
        return 2;
    }

    public SupplierChargesReport(int n) {
        super(0);
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/general_report_24.png")));
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/report/general_report.png")));
        this.supplierId = n;
    }

    @Override
    protected void init() {
        super.init();
        this.getApPanel().setVisible(false);
        this.getGroupAndTypePanel().setVisible(false);
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("account id", "Account ID");
        linkedHashMap.put("user id", "User id");
        linkedHashMap.put("user login", "User login");
        linkedHashMap.put("session id", "Session id");
        linkedHashMap.put("customer cost", "Customer cost");
        linkedHashMap.put("customer cost_with_tax", "Customer cost with tax");
        linkedHashMap.put("supplier cost", "Supplier cost");
        linkedHashMap.put("supplier cost_with_tax", "Supplier cost with tax");
        linkedHashMap.put("calling station_id", "Calling number");
        linkedHashMap.put("called station_id", "Called number");
        linkedHashMap.put("duration", "Duration");
        linkedHashMap.put("charge date", "Charge date");
        linkedHashMap.put("charge duration", "Session time (rounded)");
        return linkedHashMap;
    }

    @Override
    public void setTableData() throws UrfaException {
        UrfaTelSupplierChargesReport urfaTelSupplierChargesReport = new UrfaTelSupplierChargesReport(UrfaManagerImpl.getInstance(), this);
        urfaTelSupplierChargesReport.setSupplierId(this.supplierId);
        urfaTelSupplierChargesReport.setStartDate(this.getStartTime());
        urfaTelSupplierChargesReport.setEndDate(this.getEndTime());
        urfaTelSupplierChargesReport.call();
    }

    @Override
    public void addSummaryRows() {
        Vector<String> vector = new Vector<String>();
        vector.add("customer cost");
        vector.add("customer cost_with_tax");
        vector.add("supplier cost");
        vector.add("supplier cost_with_tax");
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
        for (int i = 0; i < vector.size(); ++i) {
            hashMap.put(vector.get(i), 0.0);
        }
        Vector<Map<String, Object>> vector2 = this.getReportTablePanel().getTableModel().data;
        for (int i = 0; i < vector2.size(); ++i) {
            Map<String, Object> map = vector2.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.get(j);
                double d = (Double)hashMap.get(string);
                hashMap.put(string, d += ((Double)map.get(string)).doubleValue());
            }
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("account id", this.resource.getString("Summary"));
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            double d = (Double)hashMap.get(string);
            hashMap2.put(string, "" + new DecimalFormat("###.##").format(d));
        }
        hashMap2.put("X-SORT", "NO_SORT");
        this.getReportTablePanel().getTableModel().addRow(hashMap2);
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        hashMap3.put("account id", this.resource.getString("Total"));
        hashMap3.put("X-SORT", "NO_SORT");
        double d = (Double)hashMap.get("customer cost_with_tax") - (Double)hashMap.get("supplier cost_with_tax");
        hashMap3.put("customer cost_with_tax", "" + new DecimalFormat("###.##").format(d));
        this.getReportTablePanel().getTableModel().addRow(hashMap3);
    }
}

