/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDeleteSupplier;
import biz.netup.control.transport.urfa.functions.UrfaGetSuppliersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.provider.SupplierFrame;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class EntitiesTab
extends TabPanelWithTable {
    public EntitiesTab() {
        this.setRefreshPermission(new int[]{32788});
        this.setAddPermission(new int[]{32838});
        this.setReadPermission(new int[]{32835});
        this.setEditPermission(new int[]{32837});
        this.setDeletePermission(new int[]{32791});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Companies";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        return linkedHashMap;
    }

    private void CreateNewSupplierFrame(final int n) {
        final EntitiesTab entitiesTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + EntitiesTab.this.resource.getString("Supplier"));
                SupplierFrame supplierFrame = new SupplierFrame(n, entitiesTab, SupplierFrame.SupplierType.LegalEntity);
                UTMTrayIcon.getInstance().removeProcess(this);
                supplierFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void edit() {
        int n = (Integer)this.getMainTablePanel().getSelectedTableRows()[0].get("id");
        this.CreateNewSupplierFrame(n);
    }

    @Override
    protected void add() {
        this.CreateNewSupplierFrame(-1);
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaGetSuppliersList urfaGetSuppliersList = new UrfaGetSuppliersList(UrfaManagerImpl.getInstance());
        try {
            urfaGetSuppliersList.call();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog(urfaException.getMessage());
            throw urfaException;
        }
        int n = urfaGetSuppliersList.getCount();
        for (int i = 0; i < n; ++i) {
            if (urfaGetSuppliersList.getType1()[i] != SupplierFrame.SupplierType.LegalEntity.getValue()) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetSuppliersList.getId1()[i]);
            hashMap.put("name", urfaGetSuppliersList.getName1()[i]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        int n = (Integer)map.get("id");
        if (n == 1) {
            Dialogs.showErrorDialog(this.resource.getString("cant delete system supplier"));
            return;
        }
        try {
            UrfaDeleteSupplier urfaDeleteSupplier = new UrfaDeleteSupplier(UrfaManagerImpl.getInstance());
            urfaDeleteSupplier.setId(n);
            urfaDeleteSupplier.call();
            if (urfaDeleteSupplier.getId() < 0) {
                switch (urfaDeleteSupplier.getId()) {
                    case -1: {
                        throw new UrfaException("Cannot delete company");
                    }
                    case -2: {
                        throw new UrfaException("Cannot delete company: is linked with services");
                    }
                }
            }
        }
        catch (UrfaException urfaException) {
            this.log.log(1, this.resource.getString(urfaException.getMessage()));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }
}

