/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.firewalls;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaPutRouter;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RouterDialog
extends DialogModel {
    private JPanel mainPanel;
    private JTextField IDTextField;
    private JTextField nameTextField;
    private JTextField loginTextField;
    private JTextField commentsTextField;
    private JComboBox typeComboBox;
    private JLabel IDLabel;
    private JTextField ipTextField;
    private Map<String, Integer> types;

    public RouterDialog() {
        this.$$$setupUI$$$();
    }

    public RouterDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Firewall";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.loadTypes();
        if (!this.isAddMode()) {
            this.IDTextField.setText("" + this.item.get("id"));
            this.nameTextField.setText("" + this.item.get("name"));
            this.ipTextField.setText("" + this.item.get("ip"));
            this.loginTextField.setText("" + this.item.get("login"));
            this.commentsTextField.setText("" + this.item.get("comments"));
        } else {
            this.IDLabel.setVisible(false);
            this.IDTextField.setVisible(false);
        }
        for (String string : this.types.keySet()) {
            if (!this.types.get(string).equals(this.item.get("type_id"))) continue;
            this.typeComboBox.setSelectedItem(string);
        }
        Vector vector = new Vector();
        vector.add(this.ipTextField);
        this.SetIetAddressValidator(this.ipTextField, vector);
    }

    private void loadTypes() {
        this.types = new HashMap<String, Integer>();
        this.types.put(this.resource.getString("Local"), 0);
        this.types.put(this.resource.getString("Remote Cisco"), 2);
        for (String string : this.types.keySet()) {
            this.typeComboBox.addItem(string);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaPutRouter urfaPutRouter = new UrfaPutRouter(UrfaManagerImpl.getInstance());
        if (!this.isAddMode()) {
            urfaPutRouter.setRouterId((Integer)this.item.get("id"));
        }
        urfaPutRouter.setRouterIp(this.nameTextField.getText());
        InetAddress inetAddress = null;
        try {
            inetAddress = this.ipTextField.getText().isEmpty() ? InetAddress.getByName("0.0.0.0") : Resolve.getIpAddressWithMask((String)this.ipTextField.getText()).address;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        urfaPutRouter.setRouterBinIp(inetAddress);
        urfaPutRouter.setLogin(this.loginTextField.getText());
        urfaPutRouter.setPassword("");
        urfaPutRouter.setRouterComments(this.commentsTextField.getText());
        urfaPutRouter.setRouterType(this.types.get(this.typeComboBox.getSelectedItem()));
        urfaPutRouter.call();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameTextField, "Name");
        Resolve.getIpAddressWithMask(this.ipTextField.getText());
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setMinimumSize(new Dimension(280, 165));
        this.mainPanel.setPreferredSize(new Dimension(280, 165));
        this.IDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.IDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.IDLabel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel5, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.loginTextField, gridBagConstraints);
        this.commentsTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.commentsTextField, gridBagConstraints);
        this.typeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.typeComboBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        this.ipTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.ipTextField, gridBagConstraints);
        this.IDLabel.setLabelFor(this.IDTextField);
        jLabel.setLabelFor(this.commentsTextField);
        jLabel2.setLabelFor(this.loginTextField);
        jLabel4.setLabelFor(this.nameTextField);
        jLabel5.setLabelFor(this.typeComboBox);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

