/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.firewalls;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDelRouter;
import biz.netup.control.transport.urfa.functions.UrfaGetRoutersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.firewalls.RouterDialog;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Color;
import java.awt.Component;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class MainFirewallsTab
extends TabPanelWithTable {
    private boolean renderersSet;
    private Map<Integer, Integer> statuses;

    public MainFirewallsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/firewalls.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/firewalls_24.png")));
        this.setRefreshPermission(new int[]{20547});
        this.setAddPermission(new int[]{20509});
        this.setEditPermission(new int[]{20509});
        this.setDeletePermission(new int[]{20509});
        this.renderersSet = false;
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "Firewalls";
    }

    @Override
    public String getGroupName() {
        return "Options";
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("type", "Type");
        linkedHashMap.put("name", "Name");
        linkedHashMap.put("login", "Login");
        linkedHashMap.put("comments", "Comments");
        linkedHashMap.put("ip", "IP");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        this.statuses = new HashMap<Integer, Integer>();
        UrfaGetRoutersList urfaGetRoutersList = new UrfaGetRoutersList(UrfaManagerImpl.getInstance());
        urfaGetRoutersList.call();
        for (int i = 0; i < urfaGetRoutersList.getRoutersSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetRoutersList.getRouterId1()[i]);
            if (urfaGetRoutersList.getRouterType1()[i] == 0) {
                hashMap.put("type", this.resource.getString("Local"));
            } else {
                hashMap.put("type", this.resource.getString("Remote Cisco"));
            }
            InetAddress inetAddress = urfaGetRoutersList.getRouterBinIp1()[i];
            hashMap.put("type_id", urfaGetRoutersList.getRouterType1()[i]);
            hashMap.put("name", urfaGetRoutersList.getRouterIp1()[i]);
            hashMap.put("login", urfaGetRoutersList.getLogin1()[i]);
            hashMap.put("password", urfaGetRoutersList.getPassword1()[i]);
            hashMap.put("comments", urfaGetRoutersList.getRouterComments1()[i]);
            hashMap.put("ip_ip", urfaGetRoutersList.getRouterBinIp1()[i]);
            hashMap.put("ip", inetAddress != null ? inetAddress.getHostAddress() : "");
            this.statuses.put(urfaGetRoutersList.getRouterId1()[i], urfaGetRoutersList.getNetworkStatuses()[i]);
            vector.add(hashMap);
        }
        if (!this.renderersSet) {
            this.mainTablePanel.setCellRenderer("id", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("type", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("type_id", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("name", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("login", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("password", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("comments", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("ip_ip", new CustomCellRenderer());
            this.mainTablePanel.setCellRenderer("ip", new CustomCellRenderer());
            this.renderersSet = true;
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaDelRouter urfaDelRouter = new UrfaDelRouter(UrfaManagerImpl.getInstance());
        urfaDelRouter.setRouterId((Integer)map.get("id"));
        urfaDelRouter.call();
        if (urfaDelRouter.getRouterCode() == -1) {
            Dialogs.showErrorDialog(this.resource.getString("Router used by user"));
        } else if (urfaDelRouter.getRouterCode() == -2) {
            Dialogs.showErrorDialog(this.resource.getString("Router linked by rule"));
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new RouterDialog(map);
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Integer n3 = (Integer)MainFirewallsTab.this.mainTablePanel.getTableModel().getRow(n).get("id");
            super.setForeground(Color.BLACK);
            int n4 = (Integer)MainFirewallsTab.this.statuses.get(n3);
            if (n4 == 0) {
                super.setBackground(new Color(203, 203, 203));
            } else if (n4 == 1) {
                super.setBackground(new Color(153, 255, 153));
            } else if (n4 == 2) {
                super.setBackground(new Color(255, 204, 204));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    private static class NetworkState {
        public static final int NS_IDLE = 0;
        public static final int NS_CONNECTED = 1;
        public static final int NS_DISCONNECTED = 2;

        private NetworkState() {
        }
    }
}

