/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.collectors;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetRegistrySettingGroups;
import biz.netup.control.transport.urfa.functions.UrfaGetStats;
import biz.netup.control.transport.urfa.functions.UrfaPutTrafficCollector;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.registrysettings.RegistrySettingsDialog;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CollectorDialog
extends DialogModel {
    private JPanel mainPanel;
    private JLabel IDLabel;
    private JTextField IDTextField;
    private JTextField nameTextField;
    private JTextField commentsTextField;
    private JButton propertiesButton;
    private JTextField uptimeTextField;
    private JTextField netFlowRecordsSinceLastTextField;
    private JTextField netFlowErrorsSinceLastTextField;
    private JButton refreshButton;
    private JLabel uptimeLabel;
    private JLabel recordsLabel;
    private JLabel errorLabel;

    public CollectorDialog() {
        this.$$$setupUI$$$();
    }

    public CollectorDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "Traffic Collector";
    }

    public void onProperties() throws UrfaException {
        UrfaGetRegistrySettingGroups urfaGetRegistrySettingGroups = new UrfaGetRegistrySettingGroups(UrfaManagerImpl.getInstance());
        urfaGetRegistrySettingGroups.setComponentId(2);
        urfaGetRegistrySettingGroups.call();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ids", urfaGetRegistrySettingGroups.getGroupIdArray1());
        hashMap.put("description", "Traffic collector settings");
        hashMap.put("object_id", this.item.get("id"));
        RegistrySettingsDialog registrySettingsDialog = new RegistrySettingsDialog(hashMap);
        registrySettingsDialog.load();
    }

    @Override
    protected void loadInfo() throws UrfaException {
        int n = 180;
        if (!this.isAddMode()) {
            this.IDTextField.setText("" + this.item.get("id"));
            this.nameTextField.setText("" + this.item.get("name"));
            this.commentsTextField.setText("" + this.item.get("comments"));
            this.propertiesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        CollectorDialog.this.onProperties();
                    }
                    catch (UrfaException urfaException) {
                        urfaException.printStackTrace();
                    }
                }
            });
            if (this.item != null && 0 == (Integer)this.item.get("id")) {
                this.IDTextField.setEnabled(false);
                this.nameTextField.setEnabled(false);
                this.commentsTextField.setEnabled(false);
                this.buttonOK.setVisible(false);
                this.buttonCancel.setText(this.resource.getString("Close"));
            }
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        CollectorDialog.this.refreshStatistics();
                    }
                    catch (UrfaException urfaException) {
                        CollectorDialog.this.log.error("Cannot load data", urfaException);
                    }
                }
            });
            this.refreshStatistics();
            n = 340;
        } else {
            this.IDLabel.setVisible(false);
            this.IDTextField.setVisible(false);
            this.propertiesButton.setVisible(false);
            this.refreshButton.setVisible(false);
            this.uptimeTextField.setVisible(false);
            this.netFlowErrorsSinceLastTextField.setVisible(false);
            this.netFlowRecordsSinceLastTextField.setVisible(false);
            this.uptimeLabel.setVisible(false);
            this.recordsLabel.setVisible(false);
            this.errorLabel.setVisible(false);
        }
        this.setPreferredSize(new Dimension(400, n));
        this.setMinimumSize(new Dimension(400, n));
    }

    protected void refreshStatistics() throws UrfaException {
        UrfaGetStats urfaGetStats = new UrfaGetStats(UrfaManagerImpl.getInstance());
        urfaGetStats.setCollectorId((Integer)this.item.get("id"));
        urfaGetStats.call();
        this.netFlowRecordsSinceLastTextField.setText("" + ((long)urfaGetStats.getEventsLast() & 0xFFFFFFFFL));
        this.netFlowErrorsSinceLastTextField.setText("" + ((long)urfaGetStats.getErrorsLast() & 0xFFFFFFFFL));
        int n = urfaGetStats.getUptime();
        int n2 = (n - n % 3600) / 3600 / 24;
        int n3 = (n - n % 3600) / 3600 % 24;
        int n4 = n % 3600 % 60;
        int n5 = (n - n3 * 3600 - n2 * 3600 * 24 - n4) / 60;
        String string = n2 + " days, " + new Integer(n3).toString() + ":" + new Integer(n5).toString() + ":" + new Integer(n4).toString();
        this.uptimeTextField.setText(string);
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaPutTrafficCollector urfaPutTrafficCollector = new UrfaPutTrafficCollector(UrfaManagerImpl.getInstance());
        if (!this.isAddMode()) {
            urfaPutTrafficCollector.setId((Integer)this.item.get("id"));
        }
        urfaPutTrafficCollector.setName(this.nameTextField.getText());
        urfaPutTrafficCollector.setComments(this.commentsTextField.getText());
        urfaPutTrafficCollector.call();
        String string = urfaPutTrafficCollector.getErrorMessage();
        if (!string.isEmpty()) {
            Dialogs.showErrorDialog(this.resource.getString(string));
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkName(this.nameTextField, "Name");
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.IDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.IDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("ID"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.IDLabel, gridBagConstraints);
        this.IDTextField = new JTextField();
        this.IDTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.IDTextField, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.nameTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Comments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.commentsTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.commentsTextField, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        this.netFlowRecordsSinceLastTextField = new JTextField();
        this.netFlowRecordsSinceLastTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.netFlowRecordsSinceLastTextField, gridBagConstraints);
        this.netFlowErrorsSinceLastTextField = new JTextField();
        this.netFlowErrorsSinceLastTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.netFlowErrorsSinceLastTextField, gridBagConstraints);
        this.uptimeLabel = new JLabel();
        this.$$$loadLabelText$$$(this.uptimeLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Uptime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.uptimeLabel, gridBagConstraints);
        this.uptimeTextField = new JTextField();
        this.uptimeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.uptimeTextField, gridBagConstraints);
        this.recordsLabel = new JLabel();
        this.$$$loadLabelText$$$(this.recordsLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("NetFlow records"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.recordsLabel, gridBagConstraints);
        this.errorLabel = new JLabel();
        this.$$$loadLabelText$$$(this.errorLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("NetFlow errors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.errorLabel, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        this.refreshButton = new JButton();
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
        this.$$$loadButtonText$$$(this.refreshButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Refresh"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.refreshButton, gridBagConstraints);
        this.propertiesButton = new JButton();
        this.$$$loadButtonText$$$(this.propertiesButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Properties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.propertiesButton, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

