/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaRemoveHouse;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.gui.custom.PagesPanel;
import biz.netup.projects.utmadmin.gui.mainframe.forms.options.buildings.BuildingDialog;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.filter.FilterForm;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MainBuildingsTab
extends TabPanelWithTable {
    private PagesPanel pages;
    private Vector<Map<String, Object>> localData;

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    protected boolean useFilter() {
        return true;
    }

    @Override
    public String getTabName() {
        return "Buildings";
    }

    @Override
    public String getGroupName() {
        return "Reference book";
    }

    @Override
    public int getMode() {
        return 1;
    }

    public MainBuildingsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/buildings.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/buildings_24.png")));
        this.setRefreshPermission(new int[]{10256});
        this.setAddPermission(new int[]{10240, 10257});
        this.setReadPermission(new int[]{10258});
        this.setEditPermission(new int[]{10240, 10257});
        this.setDeletePermission(new int[]{10261});
        final MainBuildingsTab mainBuildingsTab = this;
        Integer n = 100;
        if (!Settings.getValueFromPerst("HousesPerPage").isEmpty()) {
            try {
                n = Integer.parseInt(Settings.getValueFromPerst("HousesPerPage"));
            }
            catch (NumberFormatException numberFormatException) {
                Settings.writeValueToPerst("HousesPerPage", "" + n);
            }
            if (n <= 0) {
                n = 100;
                Settings.writeValueToPerst("HousesPerPage", "" + n);
            }
        } else {
            Settings.writeValueToPerst("HousesPerPage", "" + n);
        }
        this.pages = new PagesPanel(n, "Houses per page");
        this.pages.addListener(new PagesPanel.PageChangeListener(){

            @Override
            public void onPageChange(int n) {
                Integer n2 = MainBuildingsTab.this.pages.getPerPageCount();
                Settings.writeValueToPerst("HousesPerPage", "" + n2);
                mainBuildingsTab.refresh();
            }
        });
        this.getPanel().add((Component)this.pages.getPanel(), "South");
        FilterForm filterForm = this.getFilterForm();
        if (filterForm != null) {
            filterForm.getClearButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mainBuildingsTab.refresh();
                }
            });
            filterForm.addListener(new FilterForm.FilterListener(){

                @Override
                public void onFilterBegin() {
                    MainBuildingsTab.this.localData = new Vector();
                }

                @Override
                public void onRowPass(Map<String, Object> map) {
                    MainBuildingsTab.this.localData.add(map);
                }

                @Override
                public void onRowFail(Map<String, Object> map) {
                }

                @Override
                public void onFilterEnd() {
                    MainBuildingsTab.this.pages.updateCount(MainBuildingsTab.this.localData.size());
                }
            });
        }
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("ip_zone_id", "IP zone ID");
        linkedHashMap.put("connected_on", "Connected on");
        linkedHashMap.put("zip_code", "ZIP code");
        linkedHashMap.put("country", "Country");
        linkedHashMap.put("province/state", "Province/State");
        linkedHashMap.put("city", "City");
        linkedHashMap.put("street", "Street");
        linkedHashMap.put("building_#", "Building #");
        linkedHashMap.put("constr.#", "Constr.#");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        this.localData = new Vector();
        for (Map<String, Object> map : HouseFunctions.getHousesList()) {
            this.localData.add(map);
        }
        if (this.pages.getCount() != this.localData.size()) {
            this.pages.updateCount(this.localData.size());
        }
        Vector vector = new Vector();
        int n = this.pages.getPerPageCount();
        int n2 = this.pages.getPage() * n;
        int n3 = this.localData.size() - n2;
        int n4 = n3 > n ? n : n3;
        for (int i = n2; i < n2 + n4; ++i) {
            vector.add(this.localData.get(i));
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        UrfaRemoveHouse urfaRemoveHouse = new UrfaRemoveHouse(UrfaManagerImpl.getInstance());
        urfaRemoveHouse.setHid((Integer)map.get("id"));
        urfaRemoveHouse.call();
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return new BuildingDialog(map);
    }
}

