/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.additional.MainRadiusSessionsTab;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaRadiusDisconnectSession;
import biz.netup.control.transport.urfa.functions.UrfaRadiusDropSession;
import biz.netup.control.transport.urfa.functions.UrfaRadiusGetActiveSessions;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.additional.MainRadiusSessionsTab.AdditionalButtons;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

public class MainRadiusSessionsTab
extends TabPanelWithTable {
    public MainRadiusSessionsTab() {
        this.setRefreshPermission(new int[]{4211});
    }

    @Override
    protected void init() {
        super.init();
        AdditionalButtons additionalButtons = new AdditionalButtons();
        this.getAdditionalButtonsPanel().add((Component)additionalButtons.getPanel1(), "Center");
        Permissions.apply((JComponent)additionalButtons.getDisconnectButton(), "radius_disconnect_session");
        additionalButtons.getDisconnectButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainRadiusSessionsTab.this.disconnect();
                }
                catch (UrfaException urfaException) {
                    // empty catch block
                }
            }
        });
        this.getMainTablePanel().registerMultiRowButton(additionalButtons.getDisconnectButton());
        Permissions.apply((JComponent)additionalButtons.getDropButton(), "radius_drop_session");
        additionalButtons.getDropButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainRadiusSessionsTab.this.drop();
                }
                catch (UrfaException urfaException) {
                    // empty catch block
                }
            }
        });
        this.getMainTablePanel().registerMultiRowButton(additionalButtons.getDropButton());
    }

    @Override
    public String getTabName() {
        return "RADIUS Sessions";
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public String getGroupName() {
        return "Additional features";
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "Session ID");
        linkedHashMap.put("acct_session_id", "NAS Session ID");
        linkedHashMap.put("user_name", "Username");
        linkedHashMap.put("nas_ip", "NAS IP");
        linkedHashMap.put("recv_date", "Start date");
        linkedHashMap.put("last_update_date", "Last update date");
        linkedHashMap.put("called_station_id", "Called station");
        linkedHashMap.put("calling_station_id", "Calling station");
        linkedHashMap.put("framed_ip4", "IP-address");
        linkedHashMap.put("framed_ip6", "IP-address v6");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        HashMap<String, Object> hashMap;
        int n;
        UrfaRadiusGetActiveSessions urfaRadiusGetActiveSessions = new UrfaRadiusGetActiveSessions(UrfaManagerImpl.getInstance());
        urfaRadiusGetActiveSessions.call();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        for (n = 0; n < urfaRadiusGetActiveSessions.getTelSessionsCount(); ++n) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaRadiusGetActiveSessions.getTelId1()[n]);
            hashMap.put("acct_session_id", urfaRadiusGetActiveSessions.getTelAcctSessionId1()[n]);
            hashMap.put("user_name", urfaRadiusGetActiveSessions.getTelUserName1()[n]);
            hashMap.put("nas_ip", Resolve.IpAddressToView(urfaRadiusGetActiveSessions.getTelNasIp1()[n]));
            hashMap.put("recv_date", new Date((long)urfaRadiusGetActiveSessions.getTelRecvDate1()[n] * 1000L));
            hashMap.put("last_update_date", new Date((long)urfaRadiusGetActiveSessions.getTelLastUpdateDate1()[n] * 1000L));
            hashMap.put("called_station_id", urfaRadiusGetActiveSessions.getCalledStationId1()[n]);
            hashMap.put("calling_station_id", urfaRadiusGetActiveSessions.getCallingStationId1()[n]);
            vector.add(hashMap);
        }
        for (n = 0; n < urfaRadiusGetActiveSessions.getTrafficSessionsCount(); ++n) {
            hashMap = new HashMap();
            hashMap.put("id", urfaRadiusGetActiveSessions.getTrafId1()[n]);
            hashMap.put("acct_session_id", urfaRadiusGetActiveSessions.getTrafAcctSessionId1()[n]);
            hashMap.put("user_name", urfaRadiusGetActiveSessions.getTrafUserName1()[n]);
            hashMap.put("nas_ip", Resolve.IpAddressToView(urfaRadiusGetActiveSessions.getTrafNasIp1()[n]));
            hashMap.put("recv_date", new Date((long)urfaRadiusGetActiveSessions.getTrafRecvDate1()[n] * 1000L));
            hashMap.put("last_update_date", new Date((long)urfaRadiusGetActiveSessions.getTrafLastUpdateDate1()[n] * 1000L));
            hashMap.put("framed_ip4", Resolve.IpAddressToView(urfaRadiusGetActiveSessions.getFramedIp41()[n]));
            hashMap.put("framed_ip6", Resolve.IpAddressToView(urfaRadiusGetActiveSessions.getFramedIp61()[n]));
            hashMap.put("called_station_id", urfaRadiusGetActiveSessions.getCalledStationId2()[n]);
            hashMap.put("calling_station_id", urfaRadiusGetActiveSessions.getCallingStationId2()[n]);
            vector.add(hashMap);
        }
        return vector;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    private void drop() throws UrfaException {
        for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
            UrfaRadiusDropSession urfaRadiusDropSession = new UrfaRadiusDropSession(UrfaManagerImpl.getInstance());
            urfaRadiusDropSession.setAcctSessionId((String)map.get("acct_session_id"));
            urfaRadiusDropSession.setNasIp(Resolve.IpAddressFromView((String)map.get("nas_ip")));
            urfaRadiusDropSession.call();
            urfaRadiusDropSession.getErrorCode();
        }
    }

    private void disconnect() throws UrfaException {
        for (Map<String, Object> map : this.mainTablePanel.getSelectedTableRows()) {
            UrfaRadiusDisconnectSession urfaRadiusDisconnectSession = new UrfaRadiusDisconnectSession(UrfaManagerImpl.getInstance());
            urfaRadiusDisconnectSession.setAcctSessionId((String)map.get("acct_session_id"));
            urfaRadiusDisconnectSession.setNasIp(Resolve.IpAddressFromView((String)map.get("nas_ip")));
            urfaRadiusDisconnectSession.call();
            urfaRadiusDisconnectSession.getErrorCode();
        }
    }
}

