/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddSwitch;
import biz.netup.control.transport.urfa.functions.UrfaEditSwitch;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitch;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchPortsUsage;
import biz.netup.control.transport.urfa.functions.UrfaGetSwitchTypesList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpOptionsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchAccessParametersTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchDeviceParametersTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchMainParametersTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchVisualInfo;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchesDhcpPoolLinks;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.SwitchesTab;
import biz.netup.projects.utmadmin.gui.serviceframe.BottomButtons;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.KeyStroke;

public class SwitchFrame
extends TabbedWindow {
    private SwitchMainParametersTab params;
    private SwitchDeviceParametersTab deviceParams;
    private SwitchAccessParametersTab accessParamsTab;
    private SwitchVisualInfo visualInfo;
    private DhcpOptionsTab dhcpOptions;
    private SwitchesDhcpPoolLinks switchDhcpPoolLinks;
    private BottomButtons bb;
    private int id;
    private SwitchesTab owner;

    @Override
    protected String getWindowTitle() {
        return "Switch";
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.params);
        vector.add(this.deviceParams);
        vector.add(this.accessParamsTab);
        vector.add(this.switchDhcpPoolLinks);
        this.dhcpOptions.addToTabPanels(vector);
        return vector;
    }

    public SwitchFrame(int n, SwitchesTab switchesTab) {
        Object object;
        this.id = n;
        this.owner = switchesTab;
        if (this.id != -1) {
            object = this.getTabPanels();
            ((Vector)object).add((TabPanel)this.visualInfo);
            this.setTabPanels((Vector<TabPanel>)object);
        }
        this.dhcpOptions.setId(this.id);
        this.dhcpOptions.setOwnerType(1);
        if (this.id != -1) {
            object = new UrfaGetSwitch(UrfaManagerImpl.getInstance());
            UrfaGetSwitchTypesList urfaGetSwitchTypesList = new UrfaGetSwitchTypesList(UrfaManagerImpl.getInstance());
            ((UrfaGetSwitch)object).setId(this.id);
            try {
                ((UrfaGetSwitch)object).call();
                if (this.id != ((UrfaGetSwitch)object).getId()) {
                    throw new UrfaException("cant load switch");
                }
                urfaGetSwitchTypesList.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant load switch");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
            this.params.setId(((UrfaGetSwitch)object).getId());
            this.params.setName(((UrfaGetSwitch)object).getName());
            this.params.setLocation(((UrfaGetSwitch)object).getLocation());
            this.deviceParams.setTypeId(((UrfaGetSwitch)object).getType());
            this.deviceParams.setPortsCount(((UrfaGetSwitch)object).getPortsCount());
            this.deviceParams.setRemodeId(((UrfaGetSwitch)object).getRemoteId());
            this.accessParamsTab.setAddress(((UrfaGetSwitch)object).getAddress());
            this.accessParamsTab.setLogin(((UrfaGetSwitch)object).getLogin());
            this.accessParamsTab.setPassword(((UrfaGetSwitch)object).getPassword());
            this.switchDhcpPoolLinks.setId(((UrfaGetSwitch)object).getId());
            this.switchDhcpPoolLinks.setName(((UrfaGetSwitch)object).getName());
            try {
                this.switchDhcpPoolLinks.load();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("Cant load switches dhcp pool links");
            }
            try {
                this.dhcpOptions.load();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant load dhcp options");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
            try {
                UrfaGetSwitchPortsUsage urfaGetSwitchPortsUsage = new UrfaGetSwitchPortsUsage(UrfaManagerImpl.getInstance());
                urfaGetSwitchPortsUsage.setSwitchId(this.id);
                urfaGetSwitchPortsUsage.call();
                HashMap<Integer, Vector<Map<String, Object>>> hashMap = new HashMap<Integer, Vector<Map<String, Object>>>();
                int n2 = urfaGetSwitchPortsUsage.getPortsSize();
                for (int i = 0; i < n2; ++i) {
                    Vector vector = new Vector();
                    int n3 = urfaGetSwitchPortsUsage.getUsersSize1()[i];
                    for (int j = 0; j < n3; ++j) {
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("login", urfaGetSwitchPortsUsage.getLogin2()[i][j]);
                        hashMap2.put("id", urfaGetSwitchPortsUsage.getUserId2()[i][j]);
                        vector.add(hashMap2);
                    }
                    hashMap.put(urfaGetSwitchPortsUsage.getPortId1()[i], vector);
                }
                this.visualInfo.setData(hashMap, this.deviceParams.getPortsCount());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Dialogs.showErrorDialog("invalid ports count");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant load port usage information");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
        }
        this.deviceParams.setDefaultType();
    }

    private void onOk() {
        boolean bl;
        try {
            this.params.checkData(this);
            this.deviceParams.checkData(this);
            this.accessParamsTab.checkData(this);
            this.dhcpOptions.checkData(this);
        }
        catch (IllegalStateException illegalStateException) {
            Dialogs.showErrorDialog(illegalStateException.getMessage());
            return;
        }
        boolean bl2 = bl = this.id == -1;
        if (bl) {
            UrfaAddSwitch urfaAddSwitch = new UrfaAddSwitch(UrfaManagerImpl.getInstance());
            urfaAddSwitch.setName(this.params.getName());
            urfaAddSwitch.setLocation(this.params.getLocation());
            urfaAddSwitch.setType(this.deviceParams.getTypeId());
            urfaAddSwitch.setPortsCount(this.deviceParams.getPortsCount());
            urfaAddSwitch.setRemoteId(this.deviceParams.getRemoteId());
            urfaAddSwitch.setAddress(this.accessParamsTab.getAddress());
            urfaAddSwitch.setLogin(this.accessParamsTab.getLogin());
            urfaAddSwitch.setPassword(this.accessParamsTab.getPassword());
            try {
                urfaAddSwitch.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant add switch");
                return;
            }
            if (urfaAddSwitch.getId() == 0) {
                Dialogs.showErrorDialog("cant add switch");
                return;
            }
            this.id = urfaAddSwitch.getId();
            this.dhcpOptions.setId(this.id);
        } else {
            UrfaEditSwitch urfaEditSwitch = new UrfaEditSwitch(UrfaManagerImpl.getInstance());
            urfaEditSwitch.setId(this.id);
            urfaEditSwitch.setName(this.params.getName());
            urfaEditSwitch.setLocation(this.params.getLocation());
            urfaEditSwitch.setType(this.deviceParams.getTypeId());
            urfaEditSwitch.setPortsCount(this.deviceParams.getPortsCount());
            urfaEditSwitch.setRemoteId(this.deviceParams.getRemoteId());
            urfaEditSwitch.setAddress(this.accessParamsTab.getAddress());
            urfaEditSwitch.setLogin(this.accessParamsTab.getLogin());
            urfaEditSwitch.setPassword(this.accessParamsTab.getPassword());
            try {
                urfaEditSwitch.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant edit switch");
                return;
            }
            if (urfaEditSwitch.getId() == 0) {
                Dialogs.showErrorDialog("cant edit switch");
                return;
            }
        }
        try {
            this.dhcpOptions.update();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant update switch DHCP options");
            return;
        }
        try {
            this.switchDhcpPoolLinks.setId(this.id);
            this.switchDhcpPoolLinks.update();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant update switch DHCP pool links");
            return;
        }
        this.dispose();
        if (this.owner != null) {
            this.owner.refresh();
            if (bl) {
                this.owner.addCount();
            }
        }
    }

    @Override
    protected void init() {
        this.bb = new BottomButtons();
        this.bb.getButtonOK().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchFrame.this.onOk();
            }
        });
        this.bb.getButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchFrame.this.dispose();
            }
        });
        this.visualInfo = new SwitchVisualInfo();
        this.deviceParams = new SwitchDeviceParametersTab(this.visualInfo);
        Vector<SwitchDeviceParametersTab.TypeParameters> vector = new Vector<SwitchDeviceParametersTab.TypeParameters>();
        UrfaGetSwitchTypesList urfaGetSwitchTypesList = new UrfaGetSwitchTypesList(UrfaManagerImpl.getInstance());
        try {
            urfaGetSwitchTypesList.call();
            for (int i = 0; i < urfaGetSwitchTypesList.getSize(); ++i) {
                SwitchDeviceParametersTab.RemoteIdValueType remoteIdValueType = SwitchDeviceParametersTab.RemoteIdValueType.String;
                int n = urfaGetSwitchTypesList.getTecIdType1()[i];
                switch (n) {
                    case 0: {
                        remoteIdValueType = SwitchDeviceParametersTab.RemoteIdValueType.NotSet;
                        break;
                    }
                    case 1: {
                        remoteIdValueType = SwitchDeviceParametersTab.RemoteIdValueType.String;
                        break;
                    }
                    case 2: {
                        remoteIdValueType = SwitchDeviceParametersTab.RemoteIdValueType.Binary;
                    }
                }
                String[] stringArray = urfaGetSwitchTypesList.getSuppVolumes1()[i].split("\\,");
                Vector<Integer> vector2 = new Vector<Integer>();
                if (urfaGetSwitchTypesList.getSuppVolumes1()[i].length() > 0) {
                    int n2 = stringArray.length;
                    for (int j = 0; j < n2; ++j) {
                        vector2.add(Integer.parseInt(stringArray[j]));
                    }
                }
                SwitchDeviceParametersTab.TypeParameters typeParameters = this.deviceParams.new SwitchDeviceParametersTab.TypeParameters();
                typeParameters.RemoteIdLength = urfaGetSwitchTypesList.getTecIdLen1()[i];
                typeParameters.RemoteIdType = remoteIdValueType;
                typeParameters.suppVolumes = vector2;
                typeParameters.portStartOffset = urfaGetSwitchTypesList.getPortStartOffset1()[i];
                typeParameters.name = urfaGetSwitchTypesList.getName1()[i];
                typeParameters.id = urfaGetSwitchTypesList.getId1()[i];
                vector.add(typeParameters);
            }
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant load device types");
            this.bb.getButtonOK().setEnabled(false);
            this.bb.getButtonCancel().setEnabled(false);
        }
        this.deviceParams.setTypesParameters(vector);
        this.params = new SwitchMainParametersTab();
        this.accessParamsTab = new SwitchAccessParametersTab();
        this.dhcpOptions = new DhcpOptionsTab("Switch");
        this.switchDhcpPoolLinks = new SwitchesDhcpPoolLinks("Switch");
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwitchFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }
}

