/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetDhcpPoolList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveDhcpPool;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.BlockedPoolIdParameters;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpPoolFrame;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanelWithTable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class DhcpPoolsTab
extends TabPanelWithTable {
    private Vector<Map<String, Object>> poolsData;

    public DhcpPoolsTab() {
        this.setBigIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/IP_pools.png")));
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/settings/IP_pools_24.png")));
        this.setRefreshPermission(new int[]{1796});
        this.setAddPermission(new int[]{1793});
        this.setReadPermission(new int[]{1792});
        this.setEditPermission(new int[]{1795});
        this.setDeletePermission(new int[]{1794});
    }

    @Override
    public int getTabType() {
        return 1;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public String getTabName() {
        return "DHCP pools";
    }

    @Override
    public String getGroupName() {
        return "Inventory";
    }

    @Override
    public Map<String, String> getColumnNames() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("id", "ID");
        linkedHashMap.put("name", "Name");
        return linkedHashMap;
    }

    @Override
    public Vector<Map<String, Object>> setTableData() throws UrfaException {
        this.poolsData = new Vector();
        UrfaGetDhcpPoolList urfaGetDhcpPoolList = new UrfaGetDhcpPoolList(UrfaManagerImpl.getInstance());
        urfaGetDhcpPoolList.call();
        int n = urfaGetDhcpPoolList.getSize();
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", urfaGetDhcpPoolList.getId1()[i]);
            hashMap.put("domain", urfaGetDhcpPoolList.getDomainName1()[i]);
            hashMap.put("flags", urfaGetDhcpPoolList.getFlags1()[i]);
            hashMap.put("blocked_pool_id", urfaGetDhcpPoolList.getBlockPoolId1()[i]);
            hashMap.put("gateway", urfaGetDhcpPoolList.getGateway1()[i]);
            hashMap.put("mask", urfaGetDhcpPoolList.getNetmask1()[i]);
            hashMap.put("name", Resolve.getDhcpPoolName(hashMap, false));
            this.poolsData.add(hashMap);
        }
        BlockedPoolIdParameters.setPoolsData(this.poolsData);
        return this.poolsData;
    }

    @Override
    public void removeItem(Map<String, Object> map) throws UrfaException {
        int n = 0;
        if (map.get("id") == null) {
            return;
        }
        n = (Integer)map.get("id");
        for (int i = 0; i < this.poolsData.size(); ++i) {
            Map<String, Object> map2 = this.poolsData.get(i);
            Integer n2 = (Integer)map2.get("blocked_pool_id");
            if (n2 != n) continue;
            String string = Utils.getResource().getString("Pool is used as blocked by pool <%pool_name%>");
            string = string.replaceAll("<%pool_name%>", Resolve.getDhcpPoolName(map2, true));
            Dialogs.showErrorDialog(string);
            return;
        }
        UrfaRemoveDhcpPool urfaRemoveDhcpPool = new UrfaRemoveDhcpPool(UrfaManagerImpl.getInstance());
        urfaRemoveDhcpPool.setId(n);
        urfaRemoveDhcpPool.call();
        if (urfaRemoveDhcpPool.getId() != n) {
            Dialogs.showErrorDialog("cant delete DHCP pool. Maybe it is used");
        }
    }

    @Override
    public DFModel getItemDialog(Map<String, Object> map) {
        return null;
    }

    @Override
    protected void edit() {
        final int n = (Integer)this.mainTablePanel.getSelectedTableRows()[0].get("id");
        final DhcpPoolsTab dhcpPoolsTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                DhcpPoolFrame dhcpPoolFrame = new DhcpPoolFrame(n, dhcpPoolsTab);
                UTMTrayIcon.getInstance().removeProcess(this);
                dhcpPoolFrame.setVisible(true);
            }
        };
        thread.start();
    }

    @Override
    protected void add() {
        final DhcpPoolsTab dhcpPoolsTab = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                UTMTrayIcon.getInstance().addProcess(this);
                DhcpPoolFrame dhcpPoolFrame = new DhcpPoolFrame(-1, dhcpPoolsTab);
                UTMTrayIcon.getInstance().removeProcess(this);
                dhcpPoolFrame.setVisible(true);
            }
        };
        thread.start();
    }
}

