/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class DhcpPoolRangesTab
extends TabPanel {
    private TablePanelImpl rangesTablePanel;
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private boolean validatorSet;

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return "DHCP pool";
    }

    @Override
    public String getTabName() {
        return "Dynamic ranges";
    }

    private void createUIComponents() {
        this.rangesTablePanel = new TablePanelImpl("DhcpPoolRangesTab", true);
        this.rangesTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.rangesTablePanel.setSortingEnabled(false);
        MapTableModel mapTableModel = this.rangesTablePanel.getTableModel();
        mapTableModel.addColumn("first_address", "First address", true, true);
        mapTableModel.addColumn("last_address", "Last address", true, true);
        this.rangesTablePanel.setEditable(true);
        this.rangesTablePanel.setAppendable(false);
        ValidateCellRenderer validateCellRenderer = new ValidateCellRenderer();
        this.rangesTablePanel.setCellRenderer("first_address", validateCellRenderer);
        this.rangesTablePanel.setCellRenderer("last_address", validateCellRenderer);
        this.rangesTablePanel.setColumnsMenuEnabled(false);
        this.rangesTablePanel.configureTable();
        this.rangesTablePanel.addCellEditListeners(new TablePanelImpl.CellEditingListener(){

            @Override
            public void BeginCellEditing(int n, int n2, TableCellEditor tableCellEditor) {
                if (!DhcpPoolRangesTab.this.validatorSet) {
                    JTextField jTextField = (JTextField)tableCellEditor.getTableCellEditorComponent(DhcpPoolRangesTab.this.rangesTablePanel.getTable(), null, true, n2, n);
                    jTextField.getDocument().addDocumentListener(new IpAddressValidator(jTextField, true, IpType.IPV4));
                    DhcpPoolRangesTab.this.validatorSet = true;
                }
            }

            @Override
            public void EndCellEditing(int n, int n2, Object object) {
            }
        });
    }

    public void load(Vector<Map<String, Object>> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            this.rangesTablePanel.getTableModel().addRow(map);
        }
    }

    public Vector<Map<String, Object>> getData() {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        Vector<Map<String, Object>> vector2 = this.rangesTablePanel.getTableModel().data;
        for (int i = 0; i < vector2.size(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : vector2.get(i).entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
            vector.add(hashMap);
        }
        return vector;
    }

    public void checkData(TabbedWindow tabbedWindow) throws IllegalStateException {
        Vector<Map<String, Object>> vector = this.rangesTablePanel.getTableModel().data;
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            String string = map.get("first_address").toString();
            String string2 = map.get("last_address").toString();
            if (string.isEmpty() || string2.isEmpty()) {
                tabbedWindow.setTab(this, this.getSideMenuItem());
                throw new IllegalStateException(this.resource.getString("DHCP pool ranges") + ": " + this.resource.getString("table data is invalid"));
            }
            try {
                InetAddress inetAddress = Resolve.getIpAddressWithMask((String)map.get((Object)"first_address").toString()).address;
                InetAddress inetAddress2 = Resolve.getIpAddressWithMask((String)map.get((Object)"last_address").toString()).address;
                if (!(inetAddress instanceof Inet6Address) && !(inetAddress2 instanceof Inet6Address)) continue;
                tabbedWindow.setTab(this, this.getSideMenuItem());
                throw new IllegalStateException(this.resource.getString("DHCP pool ranges") + ": " + this.resource.getString("table data is invalid"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                tabbedWindow.setTab(this, this.getSideMenuItem());
                throw new IllegalStateException(this.resource.getString("DHCP pool ranges") + ": " + this.resource.getString("table data is invalid"));
            }
        }
    }

    public Component getTab() {
        return this.mainPanel;
    }

    public DhcpPoolRangesTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/service/prepaid_traffic_24.png")));
        this.setBigIcon(null);
        this.$$$setupUI$$$();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("first_address", "");
                hashMap.put("last_address", "");
                DhcpPoolRangesTab.this.rangesTablePanel.getTableModel().addRow(hashMap);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : DhcpPoolRangesTab.this.rangesTablePanel.getSelectedTableRows()) {
                    DhcpPoolRangesTab.this.rangesTablePanel.getTableModel().removeRow(map);
                }
            }
        });
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.rangesTablePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel7, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class IpAddressValidator
    implements DocumentListener {
        private JTextField tf;
        private boolean isEmpty;
        private IpType ipType;

        public IpAddressValidator(JTextField jTextField, boolean bl, IpType ipType) {
            this.tf = jTextField;
            this.isEmpty = bl;
            if (this.isEmpty) {
                this.tf.setBackground(new Color(255, 204, 204));
            }
            this.ipType = ipType;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public boolean check() {
            this.tf.setBackground(Color.WHITE);
            if (this.tf.getText().isEmpty() && this.isEmpty) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            try {
                InetAddress inetAddress = Resolve.getIpAddressWithMask((String)this.tf.getText()).address;
                if (inetAddress instanceof Inet6Address && this.ipType == IpType.IPV4) {
                    this.tf.setBackground(new Color(255, 204, 204));
                    this.tf.requestFocus();
                    return false;
                }
                if (inetAddress instanceof Inet4Address && this.ipType == IpType.IPV6) {
                    this.tf.setBackground(new Color(255, 204, 204));
                    this.tf.requestFocus();
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            return true;
        }
    }

    public static enum IpType {
        IPV4,
        IPV6,
        BOTH;

    }

    class ValidateCellRenderer
    extends DefaultTableCellRenderer {
        ValidateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = Color.WHITE;
            boolean bl3 = true;
            if (object.toString().isEmpty()) {
                bl3 = false;
            } else {
                try {
                    Resolve.getIpAddressWithMask(object.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl3 = false;
                }
            }
            Color color2 = !bl3 ? new Color(255, 204, 204) : color;
            Color color3 = new Color(Math.min(255, (int)(1.05 * (double)color2.getRed())), Math.min(255, (int)(1.05 * (double)color2.getGreen())), Math.min(255, (int)(1.05 * (double)color2.getBlue())));
            super.setBackground(n % 2 == 1 ? color2 : color3);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }
}

