/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.BlockedPoolIdParameters;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DhcpPoolMainParametersTab
extends TabPanel {
    private JPanel mainPanel;
    private JTextField idTextField;
    private JTextField netmaskTextField;
    private JTextField dns1TextField;
    private JTextField dns2TextField;
    private JTextField ntpServerTextField;
    private JTextField domainNameTextField;
    private JComboBox blockActTypeComboBox;
    private JTextField gatewayTextField;
    private JTextField leaseTimeTextField;
    private JPanel poolSpacerPanel;
    private JComboBox poolIdCB;
    private JLabel poolIdLabel;
    private JPanel blockActionSpacerPanel;
    private JLabel blockActionLabel;
    private IpAddressValidator gatewayValidator;
    private IpAddressValidator dns1Validator;
    private IpAddressValidator dns2Validator;
    private IpAddressValidator ntpValidator;
    private NetmaskValidator netmaskValidator;
    private PositiveIntValidator leaseTimeValidator;
    private BlockedPoolIdParameters blkPool;

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("ID");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        this.idTextField = new JTextField();
        this.idTextField.setEditable(false);
        this.idTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.idTextField, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)jPanel4, gridBagConstraints);
        this.gatewayTextField = new JTextField();
        this.gatewayTextField.setEditable(true);
        this.gatewayTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.gatewayTextField, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel5, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Gateway"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.netmaskTextField = new JTextField();
        this.netmaskTextField.setEditable(true);
        this.netmaskTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.netmaskTextField, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel6, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Netmask"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        this.dns1TextField = new JTextField();
        this.dns1TextField.setEditable(true);
        this.dns1TextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.dns1TextField, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel7, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("DNS server 1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.dns2TextField = new JTextField();
        this.dns2TextField.setEditable(true);
        this.dns2TextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.dns2TextField, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel8, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("DNS server 2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel5, gridBagConstraints);
        this.ntpServerTextField = new JTextField();
        this.ntpServerTextField.setEditable(true);
        this.ntpServerTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.ntpServerTextField, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel9, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("NTP server"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel6, gridBagConstraints);
        this.domainNameTextField = new JTextField();
        this.domainNameTextField.setEditable(true);
        this.domainNameTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.domainNameTextField, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel10, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Domain"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel7, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 3;
        this.mainPanel.add((Component)jPanel11, gridBagConstraints);
        this.blockActionLabel = new JLabel();
        this.$$$loadLabelText$$$(this.blockActionLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Block action type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.blockActionLabel, gridBagConstraints);
        this.blockActTypeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.blockActTypeComboBox, gridBagConstraints);
        this.leaseTimeTextField = new JTextField();
        this.leaseTimeTextField.setEditable(true);
        this.leaseTimeTextField.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.leaseTimeTextField, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Lease time"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel8, gridBagConstraints);
        this.poolSpacerPanel = new JPanel();
        this.poolSpacerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.poolSpacerPanel, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.poolSpacerPanel.add((Component)jPanel12, gridBagConstraints);
        this.poolIdCB = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.poolIdCB, gridBagConstraints);
        this.poolIdLabel = new JLabel();
        this.$$$loadLabelText$$$(this.poolIdLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Pool ID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.poolIdLabel, gridBagConstraints);
        this.blockActionSpacerPanel = new JPanel();
        this.blockActionSpacerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.blockActionSpacerPanel, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.blockActionSpacerPanel.add((Component)jPanel13, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return "DHCP pool";
    }

    @Override
    public String getTabName() {
        return "Main parameters";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    public void checkData(TabbedWindow tabbedWindow) throws IllegalStateException {
        if (!this.gatewayValidator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("Gateway") + " " + this.resource.getString("field is invalid"));
        }
        if (!this.dns1Validator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("DNS server 1") + " " + this.resource.getString("field is invalid"));
        }
        if (!this.dns2Validator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("DNS server 2") + " " + this.resource.getString("field is invalid"));
        }
        if (!this.ntpValidator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("NTP server") + " " + this.resource.getString("field is invalid"));
        }
        if (!this.netmaskValidator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("Netmask") + " " + this.resource.getString("field is invalid"));
        }
        if (!this.leaseTimeValidator.check()) {
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("Lease time") + " " + this.resource.getString("field is invalid"));
        }
    }

    public DhcpPoolMainParametersTab() {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/service/main_24.png")));
        this.setBigIcon(null);
        this.$$$setupUI$$$();
        this.gatewayValidator = new IpAddressValidator(this.gatewayTextField, true, IpType.IPV4);
        this.dns1Validator = new IpAddressValidator(this.dns1TextField, true, IpType.IPV4);
        this.dns2Validator = new IpAddressValidator(this.dns2TextField, false, IpType.IPV4);
        this.ntpValidator = new IpAddressValidator(this.ntpServerTextField, false, IpType.IPV4);
        this.netmaskValidator = new NetmaskValidator(this.netmaskTextField, true);
        this.leaseTimeValidator = new PositiveIntValidator(this.leaseTimeTextField);
        this.gatewayTextField.getDocument().addDocumentListener(this.gatewayValidator);
        this.dns1TextField.getDocument().addDocumentListener(this.dns1Validator);
        this.dns2TextField.getDocument().addDocumentListener(this.dns2Validator);
        this.ntpServerTextField.getDocument().addDocumentListener(this.ntpValidator);
        this.netmaskTextField.getDocument().addDocumentListener(this.netmaskValidator);
        this.leaseTimeTextField.getDocument().addDocumentListener(this.leaseTimeValidator);
        this.leaseTimeTextField.setText("86400");
        this.blockActTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlockActionTypeItem blockActionTypeItem = (BlockActionTypeItem)DhcpPoolMainParametersTab.this.blockActTypeComboBox.getSelectedItem();
                boolean bl = blockActionTypeItem.type == BlockActionType.UsePoolForBlocked;
                DhcpPoolMainParametersTab.this.poolIdCB.setVisible(bl);
                DhcpPoolMainParametersTab.this.poolIdLabel.setVisible(bl);
                DhcpPoolMainParametersTab.this.poolSpacerPanel.setVisible(bl);
            }
        });
        this.blockActTypeComboBox.addItem(new BlockActionTypeItem(BlockActionType.Default, this.resource.getString("Not defined")));
        this.blockActTypeComboBox.addItem(new BlockActionTypeItem(BlockActionType.UsePoolForBlocked, this.resource.getString("Use blocked")));
        this.blockActTypeComboBox.addItem(new BlockActionTypeItem(BlockActionType.Reject, this.resource.getString("Ignore request")));
        this.blkPool = new BlockedPoolIdParameters();
        this.blkPool.attachToComboBox(this.poolIdCB);
    }

    public int getId() {
        return Integer.parseInt(this.idTextField.getText());
    }

    public void setId(Integer n) {
        this.idTextField.setText(n.toString());
        this.blkPool.filterData(n);
    }

    public InetAddress getGateway() {
        if (!this.gatewayTextField.getText().isEmpty()) {
            return Resolve.getIpAddressWithMask((String)this.gatewayTextField.getText()).address;
        }
        return Resolve.getIpAddressWithMask((String)"0.0.0.0").address;
    }

    public void setGateway(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress().toString();
        if (!string.equals("0.0.0.0")) {
            this.gatewayTextField.setText(inetAddress.getHostAddress().toString());
        }
    }

    public InetAddress getDns1() {
        if (!this.dns1TextField.getText().isEmpty()) {
            return Resolve.getIpAddressWithMask((String)this.dns1TextField.getText()).address;
        }
        return Resolve.getIpAddressWithMask((String)"0.0.0.0").address;
    }

    public void setDns1(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress().toString();
        if (!string.equals("0.0.0.0")) {
            this.dns1TextField.setText(inetAddress.getHostAddress().toString());
        }
    }

    public InetAddress getDns2() {
        if (!this.dns2TextField.getText().isEmpty()) {
            return Resolve.getIpAddressWithMask((String)this.dns2TextField.getText()).address;
        }
        return Resolve.getIpAddressWithMask((String)"0.0.0.0").address;
    }

    public void setDns2(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress().toString();
        if (!string.equals("0.0.0.0")) {
            this.dns2TextField.setText(inetAddress.getHostAddress().toString());
        }
    }

    public InetAddress getNtpServer() {
        if (!this.ntpServerTextField.getText().isEmpty()) {
            return Resolve.getIpAddressWithMask((String)this.ntpServerTextField.getText()).address;
        }
        return Resolve.getIpAddressWithMask((String)"0.0.0.0").address;
    }

    public void setNtpServer(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress().toString();
        if (!string.equals("0.0.0.0")) {
            this.ntpServerTextField.setText(inetAddress.getHostAddress().toString());
        }
    }

    public void setNetmask(InetAddress inetAddress) {
        this.netmaskTextField.setText(inetAddress.getHostAddress().toString());
    }

    public InetAddress getNetmask() {
        return Resolve.getIpAddressWithMask((String)this.netmaskTextField.getText()).address;
    }

    public void setDomainName(String string) {
        this.domainNameTextField.setText(string);
    }

    public String getDomainName() {
        return this.domainNameTextField.getText();
    }

    public void setFlags(int n) {
        BlockActionType blockActionType = BlockActionType.Default;
        int n2 = n & 0xF;
        if (n2 == BlockActionType.Reject.getValue()) {
            blockActionType = BlockActionType.Reject;
        } else if (n2 == BlockActionType.UsePoolForBlocked.getValue()) {
            blockActionType = BlockActionType.UsePoolForBlocked;
        }
        for (int i = 0; i < this.blockActTypeComboBox.getItemCount(); ++i) {
            if (((BlockActionTypeItem)this.blockActTypeComboBox.getItemAt((int)i)).type != blockActionType) continue;
            this.blockActTypeComboBox.setSelectedIndex(i);
        }
    }

    public int getFlags() {
        BlockActionTypeItem blockActionTypeItem = (BlockActionTypeItem)this.blockActTypeComboBox.getSelectedItem();
        int n = blockActionTypeItem.type.getValue();
        return n;
    }

    public void setBlockedPoolId(int n) {
        this.blkPool.setId(n);
    }

    public int getBlockedPoolId() {
        BlockActionType blockActionType = ((BlockActionTypeItem)this.blockActTypeComboBox.getSelectedItem()).type;
        return blockActionType == BlockActionType.UsePoolForBlocked ? this.blkPool.getId() : 0;
    }

    public void setLeaseTime(Integer n) {
        this.leaseTimeTextField.setText(n.toString());
    }

    public int getLeaseTime() {
        return Integer.parseInt(this.leaseTimeTextField.getText());
    }

    public void ConfigureBlockTypes() {
        if (this.blkPool.isEmpty()) {
            JComboBox jComboBox = this.blockActTypeComboBox;
            for (int i = 0; i < jComboBox.getItemCount(); ++i) {
                BlockActionTypeItem blockActionTypeItem = (BlockActionTypeItem)jComboBox.getItemAt(i);
                if (blockActionTypeItem.type != BlockActionType.UsePoolForBlocked) continue;
                this.blockActTypeComboBox.removeItemAt(i);
            }
        }
        if (this.blkPool.hasReferences()) {
            this.blockActionSpacerPanel.setVisible(false);
            this.blockActionLabel.setVisible(false);
            this.blockActTypeComboBox.setVisible(false);
        }
    }

    private class PositiveIntValidator
    implements DocumentListener {
        private JTextField tf;

        public PositiveIntValidator(JTextField jTextField) {
            this.tf = jTextField;
            this.tf.setBackground(new Color(255, 204, 204));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public boolean check() {
            this.tf.setBackground(Color.WHITE);
            int n = 0;
            try {
                n = Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            if (n < 0) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            return true;
        }
    }

    public class NetmaskValidator
    extends IpAddressValidator {
        public NetmaskValidator(JTextField jTextField, boolean bl) {
            super(jTextField, bl, IpType.IPV4);
        }

        @Override
        public boolean check() {
            int n;
            if (!super.check()) {
                return false;
            }
            String[] stringArray = this.tf.getText().split("\\.");
            if (stringArray.length < 4) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            int[] nArray = new int[4];
            for (n = 0; n < 4; ++n) {
                nArray[n] = Integer.parseInt(stringArray[n]);
            }
            n = (nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + nArray[3];
            int n2 = -1;
            for (int i = 0; i <= 32; ++i) {
                if (n == n2) {
                    return true;
                }
                n2 <<= 1;
            }
            this.tf.setBackground(new Color(255, 204, 204));
            this.tf.requestFocus();
            return false;
        }
    }

    private class IpAddressValidator
    implements DocumentListener {
        protected JTextField tf;
        private boolean isEmpty;
        private IpType ipType;

        public IpAddressValidator(JTextField jTextField, boolean bl, IpType ipType) {
            this.tf = jTextField;
            this.isEmpty = bl;
            if (this.isEmpty) {
                this.tf.setBackground(new Color(255, 204, 204));
            }
            this.ipType = ipType;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public boolean check() {
            this.tf.setBackground(Color.WHITE);
            if (this.tf.getText().isEmpty() && this.isEmpty) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            try {
                InetAddress inetAddress = Resolve.getIpAddressWithMask((String)this.tf.getText()).address;
                if (inetAddress instanceof Inet6Address && this.ipType == IpType.IPV4) {
                    this.tf.setBackground(new Color(255, 204, 204));
                    this.tf.requestFocus();
                    return false;
                }
                if (inetAddress instanceof Inet4Address && this.ipType == IpType.IPV6) {
                    this.tf.setBackground(new Color(255, 204, 204));
                    this.tf.requestFocus();
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.tf.setBackground(new Color(255, 204, 204));
                this.tf.requestFocus();
                return false;
            }
            return true;
        }
    }

    private class BlockActionTypeItem {
        public BlockActionType type;
        public String name;

        BlockActionTypeItem(BlockActionType blockActionType, String string) {
            this.type = blockActionType;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum IpType {
        IPV4,
        IPV6,
        BOTH;

    }

    public static enum BlockActionType {
        Default(1),
        UsePoolForBlocked(2),
        Reject(3);

        private final int value;

        private BlockActionType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

