/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddDhcpPool;
import biz.netup.control.transport.urfa.functions.UrfaEditDhcpPool;
import biz.netup.control.transport.urfa.functions.UrfaGetDhcpPool;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpOptionsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpPoolMainParametersTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpPoolRangesTab;
import biz.netup.projects.utmadmin.gui.serviceframe.BottomButtons;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DhcpPoolFrame
extends TabbedWindow {
    private BottomButtons bb;
    private int id;
    private TabPanel owner;
    private DhcpOptionsTab dhcpOptionsTab;
    private DhcpPoolMainParametersTab mainParamsTab;
    private DhcpPoolRangesTab rangesTab;

    @Override
    protected String getWindowTitle() {
        return "DHCP pool";
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.mainParamsTab);
        vector.add(this.rangesTab);
        vector.add(this.dhcpOptionsTab);
        return vector;
    }

    public DhcpPoolFrame(int n, TabPanel tabPanel) {
        this.id = n;
        this.owner = tabPanel;
        this.dhcpOptionsTab.setOwnerType(2);
        this.dhcpOptionsTab.setId(this.id);
        if (this.id != -1) {
            UrfaGetDhcpPool urfaGetDhcpPool = new UrfaGetDhcpPool(UrfaManagerImpl.getInstance());
            urfaGetDhcpPool.setId(this.id);
            try {
                urfaGetDhcpPool.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant load DHCP pool");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
            this.mainParamsTab.setId(urfaGetDhcpPool.getId());
            this.mainParamsTab.setGateway(urfaGetDhcpPool.getGateway());
            this.mainParamsTab.setNetmask(urfaGetDhcpPool.getNetmask());
            this.mainParamsTab.setDns1(urfaGetDhcpPool.getDns1Server());
            this.mainParamsTab.setDns2(urfaGetDhcpPool.getDns2Server());
            this.mainParamsTab.setNtpServer(urfaGetDhcpPool.getNtpServer());
            this.mainParamsTab.setDomainName(urfaGetDhcpPool.getDomainName());
            this.mainParamsTab.setBlockedPoolId(urfaGetDhcpPool.getBlockPoolId());
            this.mainParamsTab.setLeaseTime(urfaGetDhcpPool.getLeaseTime());
            this.mainParamsTab.setFlags(urfaGetDhcpPool.getFlags());
            Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
            int n2 = urfaGetDhcpPool.getRangesSize();
            for (int i = 0; i < n2; ++i) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("first_address", urfaGetDhcpPool.getFirstAddr()[i].getHostAddress().toString());
                hashMap.put("last_address", urfaGetDhcpPool.getLastAddr()[i].getHostAddress().toString());
                vector.add(hashMap);
            }
            this.rangesTab.load(vector);
            try {
                this.dhcpOptionsTab.load();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant load dhcp options");
                this.bb.getButtonOK().setEnabled(false);
                this.bb.getButtonCancel().setEnabled(false);
                return;
            }
        }
        this.mainParamsTab.ConfigureBlockTypes();
    }

    private void onOk() {
        try {
            this.rangesTab.checkData(this);
            this.mainParamsTab.checkData(this);
            this.dhcpOptionsTab.checkData(this);
        }
        catch (IllegalStateException illegalStateException) {
            Dialogs.showErrorDialog(illegalStateException.getMessage());
            return;
        }
        Vector<Map<String, Object>> vector = this.rangesTab.getData();
        InetAddress[] inetAddressArray = new InetAddress[vector.size()];
        InetAddress[] inetAddressArray2 = new InetAddress[vector.size()];
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            inetAddressArray[i] = Resolve.getIpAddressWithMask((String)((String)map.get((Object)"first_address"))).address;
            inetAddressArray2[i] = Resolve.getIpAddressWithMask((String)((String)map.get((Object)"last_address"))).address;
            nArray[i] = map.get("flags") != null ? (Integer)map.get("flags") : 0;
        }
        if (this.id == -1) {
            UrfaAddDhcpPool urfaAddDhcpPool = new UrfaAddDhcpPool(UrfaManagerImpl.getInstance());
            urfaAddDhcpPool.setGateway(this.mainParamsTab.getGateway());
            urfaAddDhcpPool.setNetmask(this.mainParamsTab.getNetmask());
            urfaAddDhcpPool.setDns1Server(this.mainParamsTab.getDns1());
            urfaAddDhcpPool.setDns2Server(this.mainParamsTab.getDns2());
            urfaAddDhcpPool.setNtpServer(this.mainParamsTab.getNtpServer());
            urfaAddDhcpPool.setDomainName(this.mainParamsTab.getDomainName());
            urfaAddDhcpPool.setBlockPoolId(this.mainParamsTab.getBlockedPoolId());
            urfaAddDhcpPool.setLeaseTime(this.mainParamsTab.getLeaseTime());
            urfaAddDhcpPool.setFlags(this.mainParamsTab.getFlags());
            urfaAddDhcpPool.setRangesSize(inetAddressArray.length);
            urfaAddDhcpPool.setFirstAddr(inetAddressArray);
            urfaAddDhcpPool.setLastAddr(inetAddressArray2);
            try {
                urfaAddDhcpPool.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant add DHCP pool");
                return;
            }
            if (urfaAddDhcpPool.getId() == 0) {
                Dialogs.showErrorDialog("cant add DHCP pool");
                return;
            }
            this.id = urfaAddDhcpPool.getId();
            this.dhcpOptionsTab.setId(this.id);
        } else {
            UrfaEditDhcpPool urfaEditDhcpPool = new UrfaEditDhcpPool(UrfaManagerImpl.getInstance());
            urfaEditDhcpPool.setId(this.id);
            urfaEditDhcpPool.setGateway(this.mainParamsTab.getGateway());
            urfaEditDhcpPool.setNetmask(this.mainParamsTab.getNetmask());
            urfaEditDhcpPool.setDns1Server(this.mainParamsTab.getDns1());
            urfaEditDhcpPool.setDns2Server(this.mainParamsTab.getDns2());
            urfaEditDhcpPool.setNtpServer(this.mainParamsTab.getNtpServer());
            urfaEditDhcpPool.setDomainName(this.mainParamsTab.getDomainName());
            urfaEditDhcpPool.setBlockPoolId(this.mainParamsTab.getBlockedPoolId());
            urfaEditDhcpPool.setLeaseTime(this.mainParamsTab.getLeaseTime());
            urfaEditDhcpPool.setFlags(this.mainParamsTab.getFlags());
            urfaEditDhcpPool.setRangesSize(inetAddressArray.length);
            urfaEditDhcpPool.setFirstAddr(inetAddressArray);
            urfaEditDhcpPool.setLastAddr(inetAddressArray2);
            try {
                urfaEditDhcpPool.call();
            }
            catch (UrfaException urfaException) {
                Dialogs.showErrorDialog("cant edit DHCP pool");
                return;
            }
            if (urfaEditDhcpPool.getId() == 0) {
                Dialogs.showErrorDialog("cant edit DHCP pool");
                return;
            }
        }
        try {
            this.dhcpOptionsTab.update();
        }
        catch (UrfaException urfaException) {
            Dialogs.showErrorDialog("cant update switch DHCP options");
            return;
        }
        this.dispose();
        if (this.owner != null) {
            this.owner.refresh();
        }
    }

    @Override
    protected void init() {
        this.bb = new BottomButtons();
        this.bb.getButtonOK().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DhcpPoolFrame.this.onOk();
            }
        });
        this.bb.getButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DhcpPoolFrame.this.dispose();
            }
        });
        this.dhcpOptionsTab = new DhcpOptionsTab("DHCP pool");
        this.mainParamsTab = new DhcpPoolMainParametersTab();
        this.rangesTab = new DhcpPoolRangesTab();
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }
}

