/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddDhcpOptions;
import biz.netup.control.transport.urfa.functions.UrfaGetObjectDhcpOptionsList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveObjectDhcpOptions;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class DhcpOptionsTab
extends TabPanel {
    public static CustomAttr[] customAttrs = new CustomAttr[]{new CustomAttr(1, "subnet-mask (derived)", 3), new CustomAttr(2, "time-offset", 1), new CustomAttr(3, "routers", 5), new CustomAttr(4, "time-servers", 5), new CustomAttr(5, "name-servers", 5), new CustomAttr(6, "domain-name-servers", 5), new CustomAttr(7, "log-servers", 5), new CustomAttr(8, "cookie-servers", 5), new CustomAttr(9, "lpr-servers", 5), new CustomAttr(10, "impress-servers", 5), new CustomAttr(11, "resource-location-servers", 5), new CustomAttr(12, "host-name", 2), new CustomAttr(13, "boot-size", 4), new CustomAttr(14, "merit-dump", 2), new CustomAttr(15, "domain-name", 2), new CustomAttr(16, "swap-server", 3), new CustomAttr(17, "root-path", 2), new CustomAttr(18, "extensions-path", 2), new CustomAttr(19, "ip-forwarding", 1), new CustomAttr(20, "non-local-source-routing", 1), new CustomAttr(21, "policy-filters", 5), new CustomAttr(22, "max-dgram-reassembly", 4), new CustomAttr(23, "default-ip-ttl", 4), new CustomAttr(24, "path-mtu-aging-timeout", 1), new CustomAttr(25, "path-mtu-plateau-tables", 4), new CustomAttr(26, "interface-mtu", 4), new CustomAttr(27, "all-subnets-local", 1), new CustomAttr(28, "broadcast-address", 3), new CustomAttr(29, "perform-mask-discovery", 1), new CustomAttr(30, "mask-supplier", 1), new CustomAttr(31, "router-discovery", 1), new CustomAttr(32, "router-solicitation-address", 3), new CustomAttr(33, "static-routes", 5), new CustomAttr(34, "trailer-encapsulation", 1), new CustomAttr(35, "arp-cache-timeout", 1), new CustomAttr(36, "ieee802.3-encapsulation", 1), new CustomAttr(37, "default-tcp-ttl", 4), new CustomAttr(38, "tcp-keepalive-interval", 1), new CustomAttr(39, "tcp-keepalive-garbage", 1), new CustomAttr(40, "nis-domain", 2), new CustomAttr(41, "nis-servers", 5), new CustomAttr(42, "ntp-servers", 5), new CustomAttr(43, "vendor-encapsulated-options", 4), new CustomAttr(44, "netbios-name-servers", 5), new CustomAttr(45, "netbios-dd-servers", 5), new CustomAttr(46, "netbios-node-type", 4), new CustomAttr(47, "netbios-scope", 2), new CustomAttr(48, "font-servers", 5), new CustomAttr(49, "x-display-managers", 5), new CustomAttr(50, "dhcp-requested-address (set by DHCP client)", 3), new CustomAttr(51, "dhcp-lease-time", 1), new CustomAttr(52, "dhcp-option-overload", 4), new CustomAttr(53, "dhcp-message-type (set by protocols)", 4), new CustomAttr(54, "dhcp-server-identifier (set by DHCP server)", 3), new CustomAttr(55, "dhcp-parameter-request-list", 4), new CustomAttr(56, "dhcp-message", 2), new CustomAttr(57, "dhcp-max-message-size (set by protocol)", 4), new CustomAttr(58, "dhcp-renewal-time", 1), new CustomAttr(59, "dhcp-rebinding-time", 1), new CustomAttr(60, "dhcp-class-identifier (set by DHCP client)", 2), new CustomAttr(61, "dhcp-client-identifier (set by DHCP client)", 4), new CustomAttr(62, "netwareip-domain", 2), new CustomAttr(63, "netwareip-information", 4), new CustomAttr(64, "nis+-domain", 2), new CustomAttr(65, "nis+-servers", 5), new CustomAttr(66, "tftp-server", 2), new CustomAttr(67, "boot-file", 2), new CustomAttr(68, "mobile-ip-home-agents", 5), new CustomAttr(69, "smtp-servers", 5), new CustomAttr(70, "pop3-servers", 5), new CustomAttr(71, "nntp-servers", 5), new CustomAttr(72, "www-servers", 5), new CustomAttr(73, "finger-servers", 5), new CustomAttr(74, "irc-servers", 5), new CustomAttr(75, "streettalk-servers", 5), new CustomAttr(76, "streettalk-directory-assistance-servers", 5), new CustomAttr(77, "dhcp-user-class-id (set by DHCP client)", 2), new CustomAttr(81, " client-fqdn", 4), new CustomAttr(82, "relay-agent-info", 4), new CustomAttr(85, "nds-servers", 5), new CustomAttr(86, "nds-tree", 2), new CustomAttr(87, "nds-context", 2), new CustomAttr(118, "subnet-selection", 3), new CustomAttr(121, "classless-route", 3), new CustomAttr(122, "cablelabs-client-configuration", 4), new CustomAttr(128, "mcns-security-server", 3), new CustomAttr(185, "vpn-id", 4), new CustomAttr(220, "cisco-subnet-allocation", 4), new CustomAttr(221, "cisco-vpn-id", 4), new CustomAttr(251, "auto-configure", 4)};
    private TablePanelImpl optionsTablePanel;
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    private static Map<String, Integer> localeData = new HashMap<String, Integer>();
    private static Map<Integer, String> inverceLocaleData;
    private ValidateCellRenderer validateCellRenderer;
    private TextFieldValidator valueValidator;
    private ComboBoxEditorKeyListener idValidator;
    private boolean valueValidatorSet;
    private boolean idValidatorSet;
    private int id;
    private boolean isPermitted;
    public static ComboBoxCellEditor typeCellEditor;
    public static ComboBoxCellEditor idCellEditor;
    public static DefaultCellEditor staticCellEditor;
    private String groupName;
    private int ownerType;

    private static boolean checkValue(String string, int n) {
        switch (n) {
            case 1: {
                if (string.isEmpty()) {
                    return false;
                }
                try {
                    Integer.parseInt(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case 3: {
                if (string.isEmpty()) {
                    return false;
                }
                try {
                    Resolve.getIpAddressWithMask(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            case 5: {
                if (string.isEmpty()) {
                    return false;
                }
                if (string.length() > 0 && string.charAt(string.length() - 1) == ';') {
                    return false;
                }
                String[] stringArray = string.split("\\;");
                if (stringArray == null) {
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        Resolve.getIpAddressWithMask(stringArray[i]);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                if (!string.isEmpty()) break;
                return false;
            }
            case 4: {
                if (string.length() % 2 == 0 && string.matches("\\p{XDigit}+")) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTabType() {
        return 4;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getTabName() {
        return "DHCP options";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.mainPanel;
    }

    public static Map<String, Integer> getLocaleData() {
        return localeData;
    }

    public static Map<Integer, String> getInverceLocaleData() {
        return inverceLocaleData;
    }

    public DhcpOptionsTab(String string) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/service/RADIUS_parameters_24.png")));
        this.setBigIcon(null);
        this.groupName = string;
        this.$$$setupUI$$$();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", "");
                hashMap.put("type", inverceLocaleData.get(1));
                hashMap.put("value", "");
                DhcpOptionsTab.this.optionsTablePanel.getTableModel().addRow(hashMap);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : DhcpOptionsTab.this.optionsTablePanel.getSelectedTableRows()) {
                    DhcpOptionsTab.this.optionsTablePanel.getTableModel().removeRow(map);
                }
            }
        });
        int[] nArray = new int[]{4353, 4359};
        this.isPermitted = UrfaManagerImpl.getInstance().isPermitted(nArray);
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setOwnerType(int n) {
        this.ownerType = n;
    }

    private void createUIComponents() {
        this.optionsTablePanel = new TablePanelImpl("DhcpOptionsTab", true);
        this.optionsTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.optionsTablePanel.setSortingEnabled(false);
        MapTableModel mapTableModel = this.optionsTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, true);
        mapTableModel.addColumn("type", "Type", true, true);
        mapTableModel.addColumn("value", "Value", true, true);
        this.optionsTablePanel.setEditable(true);
        this.optionsTablePanel.setAppendable(false);
        this.optionsTablePanel.setCellEditor("type", typeCellEditor);
        this.optionsTablePanel.setCellEditor("id", idCellEditor);
        this.validateCellRenderer = new ValidateCellRenderer();
        this.optionsTablePanel.setCellRenderer("value", this.validateCellRenderer);
        this.optionsTablePanel.setCellRenderer("id", this.validateCellRenderer);
        this.optionsTablePanel.setColumnsMenuEnabled(false);
        this.optionsTablePanel.configureTable();
        this.valueValidator = null;
        this.valueValidatorSet = false;
        this.idValidator = null;
        this.idValidatorSet = false;
        this.optionsTablePanel.addCellEditListeners(new TablePanelImpl.CellEditingListener(){

            @Override
            public void BeginCellEditing(int n, int n2, TableCellEditor tableCellEditor) {
                Object object;
                String string = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnName(n);
                if (string.equals(DhcpOptionsTab.this.resource.getString("Value"))) {
                    if (!DhcpOptionsTab.this.valueValidatorSet) {
                        object = (JTextField)tableCellEditor.getTableCellEditorComponent(DhcpOptionsTab.this.optionsTablePanel.getTable(), null, true, n2, n);
                        DhcpOptionsTab.this.valueValidator = new TextFieldValidator((JTextField)object);
                        ((JTextComponent)object).getDocument().addDocumentListener(DhcpOptionsTab.this.valueValidator);
                        DhcpOptionsTab.this.valueValidatorSet = true;
                    }
                    object = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getRow(n2).get("type").toString();
                    DhcpOptionsTab.this.valueValidator.setTextFieldType((Integer)localeData.get(object));
                }
                if (string.equals(DhcpOptionsTab.this.resource.getString("ID")) && !DhcpOptionsTab.this.idValidatorSet) {
                    object = (JComboBox)tableCellEditor.getTableCellEditorComponent(DhcpOptionsTab.this.optionsTablePanel.getTable(), null, true, n2, n);
                    JTextField jTextField = (JTextField)((JComboBox)object).getEditor().getEditorComponent();
                    DhcpOptionsTab.this.idValidator = new ComboBoxEditorKeyListener(jTextField, (JComboBox)object);
                    jTextField.getDocument().addDocumentListener(DhcpOptionsTab.this.idValidator);
                    DhcpOptionsTab.this.idValidatorSet = true;
                }
            }

            @Override
            public void EndCellEditing(int n, int n2, Object object) {
                String string = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnName(n);
                if (string.equals(DhcpOptionsTab.this.resource.getString("Type")) && DhcpOptionsTab.this.valueValidatorSet) {
                    DhcpOptionsTab.this.valueValidator.setTextFieldType((Integer)localeData.get(object.toString()));
                }
                if (string.equals(DhcpOptionsTab.this.resource.getString("ID"))) {
                    JTable jTable = DhcpOptionsTab.this.optionsTablePanel.getTable();
                    if (object instanceof CustomAttr) {
                        int n3 = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnIndex("id");
                        int n4 = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnIndex("type");
                        int n5 = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnIndex("value");
                        HashMap<String, TableCellEditor> hashMap = new HashMap<String, TableCellEditor>();
                        hashMap.put("id", jTable.getCellEditor(n2, n3));
                        hashMap.put("type", staticCellEditor);
                        hashMap.put("value", jTable.getCellEditor(n2, n5));
                        ((DhcpOptionsTab)DhcpOptionsTab.this).optionsTablePanel.getTableModel().data.get(n2).put("X-EDITORS", hashMap);
                        CustomAttr customAttr = (CustomAttr)object;
                        DhcpOptionsTab.this.optionsTablePanel.getTable().setValueAt(inverceLocaleData.get(customAttr.dataType), n2, n4);
                    } else {
                        ((DhcpOptionsTab)DhcpOptionsTab.this).optionsTablePanel.getTableModel().data.get(n2).put("X-EDITORS", null);
                    }
                }
            }
        });
    }

    public Component getTab() {
        return this.mainPanel;
    }

    public Vector<Map<String, Object>> getOptionsData() {
        return this.optionsTablePanel.getTableModel().data;
    }

    public void setOptionsData(Vector<Map<String, Object>> vector) {
        this.optionsTablePanel.getTableModel().data = vector;
    }

    public void addToTabPanels(Vector<TabPanel> vector) {
        if (this.isPermitted) {
            vector.add(this);
        }
    }

    public void checkData(TabbedWindow tabbedWindow) throws IllegalStateException {
        Vector<Map<String, Object>> vector = this.optionsTablePanel.getTableModel().data;
        for (int i = 0; i < vector.size(); ++i) {
            Map<String, Object> map = vector.get(i);
            int n = localeData.get(map.get("type"));
            if (!DhcpOptionsTab.checkValue(map.get("value").toString(), n)) {
                tabbedWindow.setTab(this, this.getSideMenuItem());
                throw new IllegalStateException(this.resource.getString("DHCP options") + ": " + this.resource.getString("table data is invalid"));
            }
            Object object = map.get("id");
            if (object instanceof CustomAttr || DhcpOptionsTab.checkValue(map.get("id").toString(), 1)) continue;
            tabbedWindow.setTab(this, this.getSideMenuItem());
            throw new IllegalStateException(this.resource.getString("DHCP options") + ": " + this.resource.getString("table data is invalid"));
        }
    }

    public void load() throws UrfaException {
        if (!this.isPermitted) {
            return;
        }
        UrfaGetObjectDhcpOptionsList urfaGetObjectDhcpOptionsList = new UrfaGetObjectDhcpOptionsList(UrfaManagerImpl.getInstance());
        urfaGetObjectDhcpOptionsList.setId(this.id);
        urfaGetObjectDhcpOptionsList.setType(this.ownerType);
        urfaGetObjectDhcpOptionsList.call();
        int n = urfaGetObjectDhcpOptionsList.getSize();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            boolean bl = false;
            int n3 = urfaGetObjectDhcpOptionsList.getOptionId1()[i];
            for (n2 = 0; n2 < customAttrs.length; ++n2) {
                if (n3 != DhcpOptionsTab.customAttrs[n2].number) continue;
                hashMap.put("id", customAttrs[n2]);
                object = new HashMap<String, ComboBoxCellEditor>();
                object.put("id", idCellEditor);
                object.put("type", staticCellEditor);
                hashMap.put("X-EDITORS", object);
                bl = true;
                break;
            }
            if (!bl) {
                hashMap.put("id", n3);
            }
            n2 = urfaGetObjectDhcpOptionsList.getDataType1()[i];
            hashMap.put("type", inverceLocaleData.get(n2));
            switch (n2) {
                case 1: {
                    hashMap.put("value", urfaGetObjectDhcpOptionsList.getAttrDataInt1()[i]);
                    break;
                }
                case 2: {
                    hashMap.put("value", urfaGetObjectDhcpOptionsList.getAttrDataString1()[i]);
                    break;
                }
                case 4: {
                    hashMap.put("value", urfaGetObjectDhcpOptionsList.getAttrDataHexBin1()[i]);
                    break;
                }
                case 3: {
                    hashMap.put("value", urfaGetObjectDhcpOptionsList.getAttrDataIp1()[i].getHostAddress().toString());
                    break;
                }
                case 5: {
                    object = "";
                    for (int j = 0; j < urfaGetObjectDhcpOptionsList.getAttrDataIpArray1()[i].length; ++j) {
                        object = (String)object + urfaGetObjectDhcpOptionsList.getAttrDataIpArray1()[i][j].getHostAddress().toString();
                        if (j >= urfaGetObjectDhcpOptionsList.getAttrDataIpArray1()[i].length - 1) continue;
                        object = (String)object + ";";
                    }
                    hashMap.put("value", object);
                }
            }
            this.optionsTablePanel.getTableModel().addRow(hashMap);
        }
    }

    public void update() throws UrfaException {
        int n;
        Object object;
        if (!this.isPermitted) {
            return;
        }
        if (this.id != -1) {
            object = new UrfaRemoveObjectDhcpOptions(UrfaManagerImpl.getInstance());
            ((UrfaRemoveObjectDhcpOptions)object).setId(this.id);
            ((UrfaRemoveObjectDhcpOptions)object).setType(this.ownerType);
            ((UrfaRemoveObjectDhcpOptions)object).call();
        }
        if ((n = ((Vector)(object = this.optionsTablePanel.getTableModel().data)).size()) == 0) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        String[] stringArray = new String[n];
        InetAddress[] inetAddressArray = new InetAddress[n];
        String[] stringArray2 = new String[n];
        int[] nArray4 = new int[n];
        InetAddress[][] inetAddressArray2 = new InetAddress[n][];
        block7: for (int i = 0; i < n; ++i) {
            Map map = (Map)((Vector)object).get(i);
            int n2 = 0;
            Object v = map.get("id");
            n2 = v instanceof CustomAttr ? ((CustomAttr)v).number : Integer.parseInt(v.toString());
            nArray[i] = n2;
            nArray2[i] = localeData.get(map.get("type"));
            String string = map.get("value").toString();
            switch (nArray2[i]) {
                case 1: {
                    nArray3[i] = Integer.parseInt(string);
                    continue block7;
                }
                case 2: {
                    stringArray[i] = string;
                    continue block7;
                }
                case 4: {
                    stringArray2[i] = string;
                    continue block7;
                }
                case 3: {
                    inetAddressArray[i] = Resolve.getIpAddressWithMask((String)string).address;
                    continue block7;
                }
                case 5: {
                    String[] stringArray3 = string.toString().split("\\;");
                    nArray4[i] = stringArray3.length;
                    inetAddressArray2[i] = new InetAddress[stringArray3.length];
                    for (int j = 0; j < stringArray3.length; ++j) {
                        inetAddressArray2[i][j] = Resolve.getIpAddressWithMask((String)stringArray3[j]).address;
                    }
                    continue block7;
                }
            }
        }
        UrfaAddDhcpOptions urfaAddDhcpOptions = new UrfaAddDhcpOptions(UrfaManagerImpl.getInstance());
        urfaAddDhcpOptions.setOwnerId(this.id);
        urfaAddDhcpOptions.setOwnerType(this.ownerType);
        urfaAddDhcpOptions.setSize(n);
        urfaAddDhcpOptions.setOptionId1(nArray);
        urfaAddDhcpOptions.setDataType1(nArray2);
        urfaAddDhcpOptions.setAttrDataInt1(nArray3);
        urfaAddDhcpOptions.setAttrDataString1(stringArray);
        urfaAddDhcpOptions.setAttrDataIp1(inetAddressArray);
        urfaAddDhcpOptions.setAttrDataHexBin1(stringArray2);
        urfaAddDhcpOptions.setIpArraySize(nArray4);
        urfaAddDhcpOptions.setAttrDataIp2(inetAddressArray2);
        urfaAddDhcpOptions.call();
        int n3 = urfaAddDhcpOptions.getResult();
        if (n3 == -1) {
            throw new UrfaException("cant add DHCP option");
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.optionsTablePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    static {
        localeData.put(Utils.getResource().getString("Number"), 1);
        localeData.put(Utils.getResource().getString("Binary"), 4);
        localeData.put(Utils.getResource().getString("String"), 2);
        localeData.put(Utils.getResource().getString("IP"), 3);
        localeData.put(Utils.getResource().getString("IP_array"), 5);
        inverceLocaleData = new HashMap<Integer, String>();
        inverceLocaleData.put(1, Utils.getResource().getString("Number"));
        inverceLocaleData.put(4, Utils.getResource().getString("Binary"));
        inverceLocaleData.put(2, Utils.getResource().getString("String"));
        inverceLocaleData.put(3, Utils.getResource().getString("IP"));
        inverceLocaleData.put(5, Utils.getResource().getString("IP_array"));
        JComponent jComponent = new JComboBox<CustomAttr>();
        for (int i = 0; i < customAttrs.length; ++i) {
            ((JComboBox)jComponent).addItem(customAttrs[i]);
        }
        idCellEditor = new ComboBoxCellEditor((JComboBox)jComponent, true, true);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(inverceLocaleData.get(1));
        jComboBox.addItem(inverceLocaleData.get(4));
        jComboBox.addItem(inverceLocaleData.get(2));
        jComboBox.addItem(inverceLocaleData.get(3));
        jComboBox.addItem(inverceLocaleData.get(5));
        typeCellEditor = new ComboBoxCellEditor(jComboBox, true, false);
        jComponent = new JTextField();
        jComponent.setEnabled(false);
        ((JTextComponent)jComponent).setEditable(false);
        staticCellEditor = new DefaultCellEditor((JTextField)jComponent);
    }

    private class ComboBoxEditorKeyListener
    implements DocumentListener {
        private JTextField tf;
        private JComboBox owner;

        public ComboBoxEditorKeyListener(JTextField jTextField, JComboBox jComboBox) {
            this.tf = jTextField;
            this.owner = jComboBox;
            this.tf.setBackground(new Color(255, 204, 204));
            this.owner.setBackground(new Color(255, 204, 204));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public void check() {
            this.tf.setBackground(Color.WHITE);
            this.owner.setBackground(Color.WHITE);
            try {
                Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                for (int i = 0; i < customAttrs.length; ++i) {
                    if (!this.tf.getText().equals(customAttrs[i].toString())) continue;
                    return;
                }
                this.tf.setBackground(new Color(255, 204, 204));
                this.owner.setBackground(new Color(255, 204, 204));
            }
        }
    }

    private class TextFieldValidator
    implements DocumentListener {
        private JTextField tf;
        private int fieldType;

        public TextFieldValidator(JTextField jTextField) {
            this.tf = jTextField;
            this.tf.setBackground(new Color(255, 204, 204));
        }

        private void setTextFieldType(int n) {
            this.fieldType = n;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public void check() {
            this.tf.setBackground(DhcpOptionsTab.checkValue(this.tf.getText(), this.fieldType) ? Color.WHITE : new Color(255, 204, 204));
        }
    }

    class ValidateCellRenderer
    extends DefaultTableCellRenderer {
        ValidateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getColumnName(n2);
            int n3 = 0;
            if (string.equals(Utils.getResource().getString("Value"))) {
                String string2 = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getRow(n).get("type").toString();
                n3 = (Integer)localeData.get(string2);
            } else if (string.equals(Utils.getResource().getString("ID"))) {
                Object object2 = DhcpOptionsTab.this.optionsTablePanel.getTableModel().getRow(n).get("id");
                if (object2 instanceof CustomAttr) {
                    super.setBackground(Color.WHITE);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                n3 = 1;
            }
            super.setBackground(!DhcpOptionsTab.checkValue(object.toString(), n3) ? new Color(255, 204, 204) : Color.WHITE);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    public static class CustomAttr {
        public int number;
        public int dataType;
        public String name;

        public CustomAttr(int n, String string, int n2) {
            this.number = n;
            this.name = string;
            this.dataType = n2;
        }

        public String toString() {
            return "" + this.number + " (" + this.name + ")";
        }
    }

    public static class OwnerType {
        public static final int IP_GROUP = 0;
        public static final int SWITCH = 1;
        public static final int DHCP_POOL = 2;
    }

    public static class DataType {
        public static final int INT = 1;
        public static final int STRING = 2;
        public static final int IP = 3;
        public static final int BINARY = 4;
        public static final int IP_ARRAY = 5;
    }
}

