/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory;

import biz.netup.projects.utmadmin.gui.mainframe.forms.Inventory.DhcpPoolMainParametersTab;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;

public class BlockedPoolIdParameters {
    private JComboBox comboBox;
    private static Vector<Map<String, Object>> poolsData;
    private boolean hasReferences;

    public static void setPoolsData(Vector<Map<String, Object>> vector) {
        poolsData = vector;
    }

    public void attachToComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        for (int i = 0; i < poolsData.size(); ++i) {
            Map<String, Object> map = poolsData.get(i);
            int n = (Integer)map.get("flags");
            int n2 = n & 0xF;
            if (n2 == DhcpPoolMainParametersTab.BlockActionType.UsePoolForBlocked.getValue()) continue;
            Integer n3 = (Integer)map.get("id");
            InetAddress inetAddress = (InetAddress)map.get("gateway");
            InetAddress inetAddress2 = (InetAddress)map.get("mask");
            this.comboBox.addItem(new BlockedPoolIdItem(n3, inetAddress, inetAddress2));
        }
    }

    public void filterData(int n) {
        Object object;
        int n2;
        this.hasReferences = false;
        for (n2 = 0; n2 < poolsData.size(); ++n2) {
            object = poolsData.get(n2);
            if ((Integer)object.get("blocked_pool_id") != n) continue;
            this.hasReferences = true;
            break;
        }
        if (this.hasReferences) {
            this.comboBox.removeAllItems();
            return;
        }
        for (n2 = 0; n2 < this.comboBox.getItemCount(); ++n2) {
            object = ((BlockedPoolIdItem)this.comboBox.getItemAt(n2)).id;
            if ((Integer)object != n) continue;
            this.comboBox.removeItemAt(n2);
        }
    }

    public boolean hasReferences() {
        return this.hasReferences;
    }

    public boolean isEmpty() {
        return this.comboBox.getItemCount() == 0;
    }

    public void setId(int n) {
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            Integer n2 = ((BlockedPoolIdItem)this.comboBox.getItemAt(i)).id;
            if (n2 != n) continue;
            this.comboBox.setSelectedIndex(i);
        }
    }

    public int getId() {
        BlockedPoolIdItem blockedPoolIdItem = (BlockedPoolIdItem)this.comboBox.getSelectedItem();
        return blockedPoolIdItem != null ? blockedPoolIdItem.id : 0;
    }

    private class BlockedPoolIdItem {
        private InetAddress gateway;
        private InetAddress netmask;
        private int id;

        BlockedPoolIdItem(int n, InetAddress inetAddress, InetAddress inetAddress2) {
            this.gateway = inetAddress;
            this.netmask = inetAddress2;
            this.id = n;
        }

        public String toString() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("gateway", this.gateway);
            hashMap.put("mask", this.netmask);
            hashMap.put("id", this.id);
            return Resolve.getDhcpPoolName(hashMap, true);
        }
    }
}

